/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.parser.util;

import java.util.Date;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.common.constants.PerModelConstants;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.sdk.hr.hpfs.common.constants.ChgConstants;
import kd.sdk.hr.hpfs.common.perchg.PerChgConstants;

public class ParserUtil
implements PerModelConstants,
PerChgConstants,
ChgConstants {
    private static ThreadLocal<String> userIdThredLocal = new ThreadLocal();
    private static final Log LOGGER = LogFactory.getLog(ParserUtil.class);
    private static final String END_DATE = "enddate";
    private static final String SYS_ENDDATE = "sysenddate";

    public static DynamicObject generateHisByFieldMapping(DynamicObjectCollection fieldEntry, DynamicObject sourseDy, DynamicObject targetDy, PerChgBizInfo bizInfo) {
        targetDy = ParserUtil.generateByFieldMapping(fieldEntry, sourseDy, targetDy, bizInfo);
        ParserUtil.setSysField(targetDy);
        return targetDy;
    }

    public static DynamicObject generateByFieldMapping(DynamicObjectCollection fieldEntry, DynamicObject sourceDy, DynamicObject targetDy, PerChgBizInfo bizInfo) {
        String entityNameTarget = targetDy.getDataEntityType().getName();
        for (DynamicObject dy : fieldEntry) {
            String sourceFiled = dy.getString("sourcefield");
            String targetField = dy.getString("targetfield");
            try {
                ParserUtil.setValue(sourceDy, sourceFiled, targetDy, targetField, entityNameTarget, bizInfo);
            }
            catch (Exception e) {
                String errorMsg = "ParserUtilError targetEntityName :" + entityNameTarget + "targetField:" + targetField + " sourceField:" + sourceFiled;
                LOGGER.error(errorMsg, (Throwable)e);
                throw new KDException((Throwable)e, new ErrorCode("ParserUtilError", errorMsg), new Object[0]);
            }
        }
        return targetDy;
    }

    public static void setValue(DynamicObject sourceDy, String sourceFiled, DynamicObject targetDy, String targetField, String entityNameTarget, PerChgBizInfo bizInfo) {
        DataEntityPropertyCollection properties = targetDy.getDynamicObjectType().getProperties();
        DataEntityPropertyCollection sourceProperties = sourceDy.getDynamicObjectType().getProperties();
        if (properties.get((Object)targetField) == null || sourceProperties.get((Object)sourceFiled) == null) {
            return;
        }
        Object sourceObject = sourceDy.get(sourceFiled);
        if (HRStringUtils.equals((String)entityNameTarget, (String)"hrpi_emporgrelall") && sourceObject instanceof DynamicObject) {
            if (HRStringUtils.equals((String)sourceFiled, (String)"affaction")) {
                DynamicObject actionType = ParserUtil.setChgCategory(bizInfo.getActionId());
                if (actionType != null) {
                    targetDy.set(targetField, actionType.get("name"));
                } else {
                    LOGGER.warn("CHG_HPFS_WARN PAGE_EMPORGRELALL ACTIONTYPE is null");
                }
            } else {
                targetDy.set(targetField, ((DynamicObject)sourceObject).get("name"));
            }
            return;
        }
        if (HRStringUtils.equals((String)sourceFiled, (String)"affaction")) {
            DynamicObject actionType = ParserUtil.setChgCategory(bizInfo.getActionId());
            if (actionType == null) {
                LOGGER.warn("CHG_HPFS_WARN ACTIONTYPE is null");
                return;
            }
            if (HRStringUtils.equals((String)entityNameTarget, (String)"hrpi_emporgrelall")) {
                targetDy.set(targetField, actionType.get("name"));
            } else {
                targetDy.set(targetField, (Object)actionType);
            }
            return;
        }
        if (sourceObject instanceof DynamicObject && targetDy.get(targetField) instanceof Long) {
            targetDy.set(targetField, (Object)((DynamicObject)sourceObject).getLong("id"));
            return;
        }
        DataEntityPropertyCollection targetProps = targetDy.getDataEntityType().getProperties();
        DynamicProperty targetProperty = (DynamicProperty)targetProps.get((Object)targetField);
        if (HRStringUtils.equals((String)ComboProp.class.getSimpleName(), (String)targetProperty.getClass().getSimpleName()) && sourceObject instanceof Boolean) {
            String val = (Boolean)sourceObject != false ? "1" : "0";
            targetDy.set(targetField, (Object)val);
            return;
        }
        if (sourceObject instanceof MulBasedataDynamicObjectCollection && ((MulBasedataDynamicObjectCollection)sourceObject).size() > 0) {
            DynamicObjectCollection formEntityDys = (DynamicObjectCollection)sourceObject;
            DynamicObjectCollection toEntityDys = targetDy.getDynamicObjectCollection(targetField);
            if (toEntityDys != null) {
                DynamicObjectType entityType = toEntityDys.getDynamicObjectType();
                formEntityDys.forEach(formEntity -> {
                    DynamicObject newEntry = new DynamicObject(entityType);
                    HRDynamicObjectUtils.copy((DynamicObject)formEntity, (DynamicObject)newEntry);
                    toEntityDys.add((Object)newEntry);
                });
                return;
            }
        }
        targetDy.set(targetField, sourceObject);
    }

    private static DynamicObject setChgCategory(Long actionId) {
        if (actionId == null || actionId == 0L) {
            LOGGER.warn("CHG_HPFS_WARN_CATEGORYTRANS action id is null or 0");
            return null;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hpfs_chgaction");
        DynamicObject chgAction = helper.loadDynamicObject(new QFilter("id", "=", (Object)actionId));
        if (chgAction != null) {
            return chgAction.getDynamicObject("chgcategory").getDynamicObject("actiontype");
        }
        LOGGER.warn("CHG_HPFS_WARN_CATEGORYTRANS action is null");
        return null;
    }

    public static void setSysField(DynamicObject hisDy) {
        ParserUtil.setCreateField(hisDy);
        ParserUtil.setModifyField(hisDy);
    }

    public static void setCreateField(DynamicObject hisDy) {
        long userId;
        long l = userId = hisDy.get("creator") instanceof DynamicObject ? hisDy.getDynamicObject("creator").getLong("id") : 0L;
        if (userId == 0L) {
            long userIdLong = RequestContext.get().getCurrUserId();
            hisDy.set("creator", (Object)userIdLong);
        }
        if (hisDy.getDate("createtime") == null) {
            hisDy.set("createtime", (Object)new Date());
        }
    }

    public static void setModifyField(DynamicObject hisDy) {
        hisDy.set("modifier", (Object)RequestContext.get().getCurrUserId());
        hisDy.set("modifytime", (Object)new Date());
    }

    public static void fixDate(DynamicObject hisDy, Date bsed) {
        DataEntityPropertyCollection depc = hisDy.getDataEntityType().getProperties();
        if (Objects.nonNull(depc.get((Object)"bsed"))) {
            hisDy.set("bsed", (Object)bsed);
        }
        if (Objects.nonNull(depc.get((Object)"startdate"))) {
            hisDy.set("startdate", (Object)bsed);
        }
        if (Objects.nonNull(depc.get((Object)"bsled")) && Objects.isNull(hisDy.get("bsled"))) {
            hisDy.set("bsled", (Object)HRBaseUtils.getMaxEndDate());
        }
        if (Objects.nonNull(depc.get((Object)END_DATE)) && Objects.isNull(hisDy.get(END_DATE))) {
            hisDy.set(END_DATE, (Object)HRBaseUtils.getMaxEndDate());
        }
        if (Objects.nonNull(depc.get((Object)SYS_ENDDATE)) && Objects.isNull(hisDy.get(SYS_ENDDATE))) {
            hisDy.set(SYS_ENDDATE, (Object)HRBaseUtils.getMaxEndDate());
        }
        if (Objects.nonNull(depc.get((Object)"lastworkdate")) && Objects.isNull(hisDy.get("lastworkdate"))) {
            hisDy.set("lastworkdate", (Object)HRBaseUtils.getMaxEndDate());
        }
        if (Objects.nonNull(depc.get((Object)"createtime")) && Objects.isNull(hisDy.get("createtime"))) {
            hisDy.set("createtime", (Object)new Date());
        }
    }

    public static void setInit(DynamicObject hisDy) {
        DataEntityPropertyCollection depc = hisDy.getDataEntityType().getProperties();
        if (Objects.nonNull(depc.get((Object)"initstatus"))) {
            hisDy.set("initstatus", (Object)"2");
        }
    }

    public static boolean filterEffectFromOrigin(DynamicObject row) {
        boolean result = false;
        try {
            result = ParserUtil.filterCurrentFromOrigin(row) && ParserUtil.filterDatastatusOrigin(row) && ParserUtil.filterEffectOrigin(row);
        }
        catch (Exception ex) {
            if (null == row) {
                LOGGER.error("filterEffectFromOrigin error, row is null {}", (Object)row);
            }
            LOGGER.error("filterEffectFromOrigin error, row  {}, getDynamicObjectType {}", (Object)row, (Object)row.getDynamicObjectType());
        }
        return result;
    }

    public static boolean filterCurrentAndDataEffectFromOrigin(DynamicObject row) {
        return ParserUtil.filterCurrentFromOrigin(row) && ParserUtil.filterDatastatusOrigin(row);
    }

    public static boolean filterCurrentFromOrigin(DynamicObject row) {
        return row.getDynamicObjectType().getProperties().get((Object)"iscurrentversion") == null || HRStringUtils.equals((String)row.getString("iscurrentversion"), (String)"1") || HRStringUtils.equals((String)row.getString("iscurrentversion"), (String)"true");
    }

    public static boolean filterDatastatusOrigin(DynamicObject row) {
        return row.getDynamicObjectType().getProperties().get((Object)"datastatus") == null || HRStringUtils.equals((String)row.getString("datastatus"), (String)"1") || HRStringUtils.equals((String)row.getString("datastatus"), (String)"true");
    }

    public static boolean filterEffectOrigin(DynamicObject row) {
        return row.getDynamicObjectType().getProperties().get((Object)"businessstatus") == null || HRStringUtils.equals((String)row.getString("businessstatus"), (String)"1") || HRStringUtils.equals((String)row.getString("businessstatus"), (String)"true");
    }
}

