/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.perchg.parser.ParserResult;
import kd.hr.hpfs.business.perchg.service.IAfterDataFormatPluginService;
import kd.hr.hpfs.common.constants.PerModelConstants;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;

public class HamAfterDataFormatPluginServiceImpl
implements IAfterDataFormatPluginService,
PerModelConstants {
    private final HashMap<String, String> depEmpMap = new HashMap<String, String>(){
        private static final long serialVersionUID = 439162995363475305L;
        {
            this.put("hrpi_depemp", "boid");
            this.put("hrpi_empposorgrel", "depemp.id");
            this.put("hrpi_emporgrelall", "depemp.id");
            this.put("hrpi_personrolerel", "depemp.id");
        }
    };

    @Override
    public void performParserResult(List<ParserResult> parserResults, PerChgBizInfo bizInfo, Map<String, List<DynamicObject>> sourceData, DynamicObject chgActionInfo, DynamicObject chgRuleInfo, Map<String, String> paramMap) {
        Long hamDepEmpId = bizInfo.getOldDepempId();
        if (hamDepEmpId == null) {
            return;
        }
        List<ParserResult> parserResultList = parserResults.stream().filter(row -> this.isMainInvalid((ParserResult)row, hamDepEmpId)).collect(Collectors.toList());
        parserResultList.forEach(parserResult -> {
            String entityName = (String)parserResult.getParserParam().get("entityName");
            DynamicObject dyn = (DynamicObject)parserResult.getParserParam().get("hisDy");
            ((List)bizInfo.getIdsRecord().get(entityName)).removeIf(row -> row.getVidAfter().longValue() == dyn.getLong("id"));
        });
        parserResults.removeAll(parserResultList);
    }

    private boolean isMainInvalid(ParserResult parserResult, Long hamDepEmpId) {
        String entityName = (String)parserResult.getParserParam().get("entityName");
        String field = this.depEmpMap.get(entityName);
        if (HRStringUtils.isEmpty((String)field)) {
            return false;
        }
        DynamicObject dyn = (DynamicObject)parserResult.getParserParam().get("hisDy");
        Long id = dyn.getLong(field);
        String businessStatus = dyn.getString("businessstatus");
        return hamDepEmpId.equals(id) && HRStringUtils.equals((String)businessStatus, (String)"1") || !hamDepEmpId.equals(id) && HRStringUtils.equals((String)businessStatus, (String)"2");
    }
}

