/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.service.impl;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.perchg.executor.util.PerChgUtils;
import kd.hr.hpfs.business.perchg.parser.ParserResult;
import kd.hr.hpfs.business.perchg.service.IAfterDataFormatPluginService;
import kd.hr.hpfs.business.service.repeatnumber.GenerateReplaceNumberHelper;
import kd.hr.hpfs.common.model.PreEmployeeModel;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.sdk.hr.hpfs.common.constants.PerModelConstants;

public class ReplacePreNumberAfterDataFormatServiceImpl
implements IAfterDataFormatPluginService,
PerModelConstants {
    private static final Log LOGGER = LogFactory.getLog(ReplacePreNumberAfterDataFormatServiceImpl.class);
    private static final String FIRST_START_DATE = "firststartdate";

    @Override
    public void performParserResult(List<ParserResult> parserResults, PerChgBizInfo bizInfo, Map<String, List<DynamicObject>> sourceData, DynamicObject chgActionInfo, DynamicObject chgRuleInfo, Map<String, String> paramMap) {
        String viewType;
        String empScheme;
        if (PerChgUtils.skipCreateNewPerson(bizInfo)) {
            LOGGER.info("ReplacePreNumberAfterDataFormatServiceImpl#performParserResult skipCreateNewPerson, the plugin execute end");
            return;
        }
        List<DynamicObject> onBrdBillDys = sourceData.get(bizInfo.getBillSource());
        if (CollectionUtils.isEmpty(onBrdBillDys)) {
            LOGGER.warn("ReplacePreNumberAfterDataFormatServiceImpl#performParserResult empty");
            return;
        }
        DynamicObject onBrdBillDy = onBrdBillDys.get(0);
        boolean replaceNumber = false;
        if (onBrdBillDy.getDataEntityType().getProperties().containsKey((Object)"isreplacenumber")) {
            replaceNumber = onBrdBillDy.getBoolean("isreplacenumber");
        }
        if (HRStringUtils.isEmpty((String)(empScheme = paramMap.get("employeenoscheme")))) {
            empScheme = "employeenoscheme";
        }
        String inheritNumber = onBrdBillDy.getString(empScheme);
        String viewTypeProp = paramMap.get("viewtype");
        if (HRStringUtils.isEmpty((String)viewTypeProp)) {
            viewTypeProp = "viewtype";
        }
        if ("2".equals(viewType = onBrdBillDy.getString(viewTypeProp))) {
            LOGGER.info("ReplacePreNumberAfterDataFormatServiceImpl#start");
            PreEmployeeModel preEmployeeInfo = GenerateReplaceNumberHelper.getInstance().getPreEmployeeInfo(parserResults, bizInfo, sourceData, chgActionInfo, chgRuleInfo, paramMap);
            if (preEmployeeInfo == null) {
                LOGGER.info("ReplacePreNumberAfterDataFormatServiceImpl#preEmployeeInfoEmpty");
                return;
            }
            Object[] emptrDys = this.findOldEmployeeById(preEmployeeInfo);
            Object emptrDy = null;
            if (HRArrayUtils.isNotEmpty((Object[])emptrDys)) {
                emptrDy = emptrDys[0];
            }
            this.getEachFindEmptrelDy(bizInfo, parserResults, preEmployeeInfo, (DynamicObject)emptrDy, !replaceNumber && "2".equals(inheritNumber));
        }
    }

    private DynamicObject[] findOldEmployeeById(PreEmployeeModel preEmployeeInfo) {
        Long oldEmployeeId = preEmployeeInfo.getOldEmployeeId();
        HRBaseServiceHelper service = new HRBaseServiceHelper("hrpi_empentrel");
        QFilter sFilter = GenerateReplaceNumberHelper.getInstance().getInitStatusFilter();
        QFilter cFilter = GenerateReplaceNumberHelper.getInstance().getCurrentVersionFilter();
        QFilter eFilter = new QFilter("employee", "=", (Object)oldEmployeeId);
        QFilter dFilter = GenerateReplaceNumberHelper.getInstance().getDataStatusFilter();
        return service.query("firststartdate,id", new QFilter[]{eFilter, cFilter, sFilter, dFilter});
    }

    private DynamicObject[] findEntrelEmployeeById(List<Long> emptrelIds) {
        HRBaseServiceHelper service = new HRBaseServiceHelper("hrpi_empentrel");
        QFilter sFilter = GenerateReplaceNumberHelper.getInstance().getInitStatusFilter();
        QFilter eFilter = new QFilter("boid", "in", emptrelIds);
        QFilter dFilter = GenerateReplaceNumberHelper.getInstance().getDataStatusFilter();
        QFilter cFilter = GenerateReplaceNumberHelper.getInstance().getCurrentVersionFilter();
        return service.query("boid", new QFilter[]{eFilter, cFilter, dFilter, sFilter});
    }

    private void getEachFindEmptrelDy(PerChgBizInfo bizInfo, List<ParserResult> parserResults, PreEmployeeModel preEmployeeInfo, DynamicObject emptrDy, boolean updatePreNumber) {
        List tmpEmptrelIds = parserResults.stream().filter(row -> HRStringUtils.equals((String)((String)row.getParserParam().get("entityName")), (String)"hrpi_empentrel")).map(row -> ((DynamicObject)row.getParserParam().get("hisDy")).getLong("boid")).collect(Collectors.toList());
        List<Long> emptrelIds = tmpEmptrelIds.stream().filter(empId -> empId != 0L).collect(Collectors.toList());
        Object[] entrelEmployeeByIds = this.findEntrelEmployeeById(emptrelIds);
        Set<Object> dbBoIdSet = new HashSet(16);
        if (HRArrayUtils.isNotEmpty((Object[])entrelEmployeeByIds)) {
            dbBoIdSet = Arrays.stream(entrelEmployeeByIds).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        }
        for (ParserResult parserResult : parserResults) {
            DynamicObject entDy;
            Object hisObj;
            String entityName;
            Map<String, Object> parserParam = parserResult.getParserParam();
            Object entObj = parserParam.get("entityName");
            if (entObj instanceof String && !"hrpi_empentrel".equals(entityName = (String)parserParam.get("entityName")) || !((hisObj = parserParam.get("hisDy")) instanceof DynamicObject) || dbBoIdSet.contains((entDy = (DynamicObject)hisObj).getLong("boid"))) continue;
            Long newPersonId = bizInfo.getNewPersonId();
            long personId = entDy.getLong("person_id");
            if (null != newPersonId && newPersonId != 0L && personId != 0L && personId != newPersonId) continue;
            String oldNumber = preEmployeeInfo.getOldNumber();
            if (updatePreNumber && HRStringUtils.isNotEmpty((String)oldNumber)) {
                entDy.set("oldempnumber", (Object)oldNumber);
            }
            if (emptrDy == null) continue;
            Date firstDate = emptrDy.getDate(FIRST_START_DATE);
            if (firstDate == null) {
                LOGGER.info("setFirstStartDateNull");
            }
            entDy.set(FIRST_START_DATE, (Object)firstDate);
        }
    }
}

