/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.service.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.perchg.common.ChgLogHelper;
import kd.hr.hpfs.business.perchg.executor.MserviceService;
import kd.hr.hpfs.business.perchg.executor.service.ChgRecordExecutorService;
import kd.hr.hpfs.business.perchg.service.IRetryService;

public class RetryServiceImpl
implements IRetryService {
    private static final Log LOGGER = LogFactory.getLog(RetryServiceImpl.class);

    @Override
    public void retryBatch(DynamicObject[] chgLogs) {
        LOGGER.warn(MessageFormat.format("start-batch-retry-chgLogs:{0}", Arrays.toString(chgLogs)));
        HashMap<String, List> retryMap = new HashMap<String, List>(8);
        for (DynamicObject chgLog : chgLogs) {
            if (!this.isCanRetry(chgLog)) continue;
            String consumer2 = chgLog.getString("consumer");
            List chgLogsClassified2 = retryMap.computeIfAbsent(consumer2, k -> new ArrayList(chgLogs.length));
            chgLogsClassified2.add(chgLog);
        }
        retryMap.forEach((consumer, chgLogsClassified) -> {
            switch (consumer) {
                case "HPFSPersonChgOnbrdConsumer": {
                    this.retryHPFSPersonChgOnbrdConsumer((List<DynamicObject>)chgLogsClassified);
                    break;
                }
                case "HPFSPersonChgConsumer": {
                    this.retryHPFSPersonChgConsumer((List<DynamicObject>)chgLogsClassified);
                    break;
                }
                case "HPFSChgRecordConsumer": {
                    this.retryHPFSChgRecordConsumer((List<DynamicObject>)chgLogsClassified);
                    break;
                }
                case "HPFSExternalRecordConsumer": {
                    this.retryHPFSExternalRecordConsumer((List<DynamicObject>)chgLogsClassified);
                    break;
                }
            }
        });
    }

    private void retryHPFSExternalRecordConsumer(List<DynamicObject> chgLogs) {
        chgLogs.forEach(chgLog -> {
            ChgLogHelper.writeLogBeforeRetry(chgLog);
            String msg = chgLog.getString("params");
            try {
                ChgRecordExecutorService.getInstance().executeExternalRecord(msg);
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
                ChgLogHelper.updateErrorLog(chgLog, e);
            }
        });
    }

    private void retryHPFSChgRecordConsumer(List<DynamicObject> chgLogs) {
        chgLogs.forEach(chgLog -> {
            ChgLogHelper.writeLogBeforeRetry(chgLog);
            String msg = chgLog.getString("params");
            try {
                ChgRecordExecutorService.getInstance().executeMsg(msg);
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
                ChgLogHelper.updateErrorLog(chgLog, e);
            }
        });
    }

    private void retryHPFSPersonChgConsumer(List<DynamicObject> chgLogs) {
        chgLogs.forEach(chgLog -> {
            ChgLogHelper.writeLogBeforeRetry(chgLog);
            String msg = chgLog.getString("params");
            try {
                MserviceService.getInstance().execute(msg);
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
                ChgLogHelper.updateErrorLog(chgLog, e);
            }
        });
    }

    private void retryHPFSPersonChgOnbrdConsumer(List<DynamicObject> chgLogs) {
        this.retryHPFSPersonChgConsumer(chgLogs);
    }

    @Override
    public boolean isCanRetry(DynamicObject chgLog) {
        IDataEntityType entityType = chgLog.getDataEntityType();
        if (!(entityType.getName().equals("hpfs_chglog") && entityType.getProperties().containsKey((Object)"consumer") && entityType.getProperties().containsKey((Object)"transactionstatus") && entityType.getProperties().containsKey((Object)"params"))) {
            LOGGER.warn(MessageFormat.format("EntityType error or field lost: {0}", chgLog.toString()));
            return false;
        }
        if (HRStringUtils.isEmpty((String)chgLog.getString("consumer"))) {
            LOGGER.warn(MessageFormat.format("Unknown consumer,skip. {0}", chgLog.toString()));
            return false;
        }
        if (!chgLog.getString("transactionstatus").equals("-1") && !chgLog.getString("transactionstatus").equals("3")) {
            LOGGER.warn(MessageFormat.format("Isn't failed message,skip. {0}", chgLog.toString()));
            return false;
        }
        return true;
    }
}

