/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.perchg.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.perchg.parser.ParserResult;
import kd.hr.hpfs.business.perchg.service.IAfterDataSavedPluginService;
import kd.hr.hpfs.common.perchg.PerChgBizOperateType;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizResult;

public class SyncPerson
implements IAfterDataSavedPluginService {
    private static final Log LOGGER = LogFactory.getLog(SyncPerson.class);

    @Override
    public void afterDataSaved(PerChgBizResult bizResult, PerChgBizInfo bizInfo, PerChgBizOperateType operateType, DynamicObject chgActionInfo, List<ParserResult> parserResults, Map<String, String> paramsMap) {
        Long chgActionId = chgActionInfo.getLong("id");
        String chgTypeProcessor = paramsMap.get("syncType");
        if (HRStringUtils.isEmpty((String)chgTypeProcessor)) {
            throw new KDException(new ErrorCode("IAfterDataSavedPluginService error", "syncType cannot be BLANK"), new Object[0]);
        }
        DynamicObject dynamicObject = parserResults.stream().filter(row -> HRStringUtils.equals((String)((String)row.getParserParam().get("entityName")), (String)"hspm_ermanfile")).map(row -> (DynamicObject)row.getParserParam().get("hisDy")).findAny().orElse(null);
        if (dynamicObject == null) {
            return;
        }
        ArrayList userList = new ArrayList();
        HashMap<String, Object> temp = new HashMap<String, Object>(2);
        String number = dynamicObject.getString("number");
        String name = dynamicObject.getString("name");
        Long personid = dynamicObject.getLong("person_id");
        temp.put("personid", personid);
        temp.put("number", number);
        temp.put("name", name);
        temp.put("synctype", chgTypeProcessor);
        userList.add(temp);
        Map res = new HashMap(2);
        try {
            res = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"syncPersonToSysUer", (Object[])new Object[]{userList});
        }
        catch (Exception e) {
            LOGGER.error("CHG_HPFS_ERROR syncPersonToSysUer person api error:", (Throwable)e);
            throw new KDException(new ErrorCode("IAfterDataSavedPluginService error", e.getMessage()), new Object[]{e});
        }
        if (!((Boolean)res.get("success")).booleanValue()) {
            String error = "";
            if (res.get("data") != null) {
                error = (String)((Map)res.get("data")).get(number);
            }
            String errorMsg = "CHG_HPFS_ERROR syncPersonToSysUer fail type:" + chgTypeProcessor + " number:" + number + " error:" + error;
            LOGGER.error(errorMsg);
            throw new KDException(new ErrorCode("IAfterDataSavedPluginService error", errorMsg), new Object[0]);
        }
        String successInfo = "CHG_HPFS syncPersonToSysUer success type:" + chgTypeProcessor + " number:" + number;
        LOGGER.info(successInfo);
    }
}

