/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.service;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.perchg.parser.ParserResult;
import kd.hr.hpfs.business.perchg.service.IAfterDataFormatPluginService;
import kd.hr.hpfs.business.perchg.service.impl.HdmAfterDataFormatPluginServiceImpl;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;

public class ChgPluginService {
    private static final Log LOGGER = LogFactory.getLog(ChgPluginService.class);
    private static final ChgPluginService CHG_PLUGIN_SERVICE = new ChgPluginService();

    public static ChgPluginService getInstance() {
        return CHG_PLUGIN_SERVICE;
    }

    public void performPlugin(List<ParserResult> parserResults, PerChgBizInfo bizInfo, Map<String, List<DynamicObject>> sourceData, DynamicObject chgActionInfo, DynamicObject chgRuleInfo, DynamicObject chgGuideBase, String occasion) {
        DynamicObjectCollection pluginCollection = chgGuideBase.getDynamicObjectCollection("entryentity");
        pluginCollection.stream().filter(row -> HRStringUtils.equals((String)occasion, (String)row.getString("plugin.occasion"))).sorted(Comparator.comparing(row -> row.getInt("seq"))).forEach(plugin -> {
            block2: {
                bizInfo.addPluginEntry(plugin);
                String className = plugin.getString("plugin.pluginpath");
                boolean interrupted = plugin.getBoolean("isinterrupted");
                String pluginNumber = plugin.getString("plugin.number");
                try {
                    Class<?> pluginClass = Class.forName(className);
                    DynamicObjectCollection collection = plugin.getDynamicObjectCollection("subentryentity");
                    HashMap<String, String> paramMap = new HashMap<String, String>();
                    collection.forEach(row -> paramMap.put(row.getString("param"), row.getString("value")));
                    IAfterDataFormatPluginService dataQueryPluginService = (IAfterDataFormatPluginService)pluginClass.newInstance();
                    dataQueryPluginService.performParserResult(parserResults, bizInfo, sourceData, chgActionInfo, chgRuleInfo, paramMap);
                    bizInfo.putPluginResMap(pluginNumber, "");
                }
                catch (Exception e) {
                    LOGGER.error("IAfterDataFormatPluginService plugin error", (Throwable)e);
                    bizInfo.putPluginResMap(pluginNumber, e.getMessage());
                    if (!interrupted) break block2;
                    throw new KDException(new ErrorCode("IAfterDataFormatPluginService error", e.getMessage()), new Object[]{e});
                }
            }
        });
        HdmAfterDataFormatPluginServiceImpl hdmAfterDataFormatPluginService = new HdmAfterDataFormatPluginServiceImpl();
        hdmAfterDataFormatPluginService.performParserResult(parserResults, bizInfo, sourceData, chgActionInfo, chgRuleInfo, null);
    }
}

