/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.ExceptionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.utils.ChgApiDataReturnUtils;

public class ChgRuleService {
    private static final ChgRuleService CHG_RULE_SERVICE = new ChgRuleService();
    private static final Log LOGGER = LogFactory.getLog(ChgRuleService.class);

    public static ChgRuleService getInstance() {
        return CHG_RULE_SERVICE;
    }

    public Map<String, Object> getChgRuleByActionIds(List<Long> actionIds) {
        if (actionIds == null || actionIds.isEmpty()) {
            String errorMsg = ResManager.loadKDString((String)"\u53d8\u52a8\u64cd\u4f5c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ChgRuleService_0", (String)"hr-hpfs-business", (Object[])new Object[0]);
            return ChgApiDataReturnUtils.formatDataReturned(Boolean.FALSE, errorMsg, null);
        }
        try {
            DynamicObject[] ruleDyns = this.getChgRuleByChgActionId(actionIds);
            Map<Long, String> errorMsg = this.formatErrorMsg(ruleDyns, actionIds);
            return ChgApiDataReturnUtils.formatDataReturned(Boolean.TRUE, errorMsg, this.executeChgRuleByActionIds(ruleDyns));
        }
        catch (Exception e) {
            String errorInfo = "CHG_HPFS_ERROR_getChgRuleByActionIds actionIds" + SerializationUtils.toJsonString(actionIds);
            LOGGER.error(errorInfo, (Throwable)e);
            return ChgApiDataReturnUtils.formatDataReturned(Boolean.FALSE, ExceptionUtils.getExceptionStackTraceMessage((Exception)e), null);
        }
    }

    private DynamicObject[] getChgRuleByChgActionId(List<Long> actionIds) {
        return new HRBaseServiceHelper("hpfs_chgrule").queryOriginalArray("id,chgaction", new QFilter[]{new QFilter("chgaction", "in", actionIds)});
    }

    private Map<Long, String> formatErrorMsg(DynamicObject[] ruleDyns, List<Long> actionIds) {
        List ruleActionIds = ruleDyns == null ? Collections.emptyList() : Arrays.stream(ruleDyns).map(row -> row.getLong("chgaction")).distinct().collect(Collectors.toList());
        List actionIdsWithoutRule = actionIds.stream().filter(row -> !ruleActionIds.contains(row)).collect(Collectors.toList());
        return actionIdsWithoutRule.isEmpty() ? null : actionIdsWithoutRule.stream().collect(Collectors.toMap(row -> row, row -> ResManager.loadKDString((String)"\u8be5\u53d8\u52a8\u64cd\u4f5c\u672a\u5173\u8054\u53d8\u52a8\u89c4\u5219\u3002", (String)"ChgRuleService_1", (String)"hr-hpfs-business", (Object[])new Object[0])));
    }

    private Map<Long, List<Map<String, DynamicObjectCollection>>> executeChgRuleByActionIds(DynamicObject[] ruleDyns) {
        Map<Long, Long> map = Arrays.stream(ruleDyns).collect(Collectors.toMap(row -> row.getLong("id"), row -> row.getLong("chgaction")));
        DynamicObject[] ruleConfigDyns = new HRBaseServiceHelper("hpfs_chgconfigentry").query("id, chgrule, chgtactic, chgfile, valuefixed, valrange, valrange_tag", this.formatQFilter(new ArrayList<Long>(map.keySet())));
        Map<Long, List<DynamicObject>> dataMap = Arrays.stream(ruleConfigDyns).collect(Collectors.groupingBy(row -> row.getLong("chgrule.id")));
        HashMap<Long, List<Map<String, DynamicObjectCollection>>> res = new HashMap<Long, List<Map<String, DynamicObjectCollection>>>(map.size());
        dataMap.forEach((k, v) -> {
            Long actionId = (Long)map.get(k);
            res.put(actionId, this.formatDataBySingleActionId((List<DynamicObject>)v));
        });
        return res;
    }

    private QFilter[] formatQFilter(List<Long> ruleIds) {
        QFilter ruleQFilter = new QFilter("chgrule", "in", ruleIds);
        QFilter limitTypeQFilter = new QFilter("limittype", "in", (Object)"0");
        QFilter chgFileQFilter = new QFilter("chgfile", "in", Arrays.asList("laborreltype", "laborrelstatus", "postype", "posstatus"));
        return new QFilter[]{ruleQFilter, limitTypeQFilter, chgFileQFilter};
    }

    private List<Map<String, DynamicObjectCollection>> formatDataBySingleActionId(List<DynamicObject> dyns) {
        ArrayList<Map<String, DynamicObjectCollection>> res = new ArrayList<Map<String, DynamicObjectCollection>>(2);
        List<DynamicObject> dynsBefore = dyns.stream().filter(row -> HRStringUtils.equals((String)row.getString("chgtactic.applicablestage"), (String)"0")).collect(Collectors.toList());
        res.add(this.formatChgRuleConfig(dynsBefore, "0"));
        List<DynamicObject> dynsAfter = dyns.stream().filter(row -> HRStringUtils.equals((String)row.getString("chgtactic.applicablestage"), (String)"1")).collect(Collectors.toList());
        res.add(this.formatChgRuleConfig(dynsAfter, "1"));
        return res;
    }

    private Map<String, DynamicObjectCollection> formatChgRuleConfig(List<DynamicObject> dyns, String applicableStage) {
        return dyns.stream().collect(Collectors.toMap(row -> this.getNameWithApplicable(row.getString("chgfile"), applicableStage), this::getConfigValueRange));
    }

    private DynamicObjectCollection getConfigValueRange(DynamicObject dyn) {
        String entityName = FieldEntityNameEnum.getEntityNameByField(dyn.getString("chgfile"));
        if (HRStringUtils.isNotEmpty((String)dyn.getString("valuefixed"))) {
            return this.queryData(Long.parseLong(dyn.getString("valuefixed")), entityName);
        }
        String valRange = dyn.getString("valrange_tag");
        if (HRStringUtils.isEmpty((String)valRange)) {
            return new DynamicObjectCollection();
        }
        QFilter qFilter = QFilter.fromSerializedString((String)valRange);
        return this.queryData((List)qFilter.getValue(), entityName);
    }

    private DynamicObjectCollection queryData(Long id, String entityName) {
        return this.queryData(Collections.singletonList(id), entityName);
    }

    private DynamicObjectCollection queryData(List<Long> ids, String entityName) {
        DynamicObject[] dyns = new HRBaseServiceHelper(entityName).query("id,name,number", new QFilter[]{new QFilter("id", "in", ids)});
        DynamicObjectCollection collection = new DynamicObjectCollection();
        collection.addAll(Arrays.asList(dyns));
        return collection;
    }

    private String getNameWithApplicable(String name, String applicableStage) {
        return HRStringUtils.equals((String)applicableStage, (String)"0") ? "before" + name : name;
    }

    static enum FieldEntityNameEnum {
        LABOR_REL_TYPE("laborreltype", "hbss_laborreltype"),
        LABOR_REL_STATUS("laborrelstatus", "hbss_laborrelstatus"),
        POS_TYPE("postype", "hbss_postype"),
        POS_STATUS("posstatus", "hbss_poststate");

        private String field;
        private String entityName;

        private FieldEntityNameEnum(String field, String entityName) {
            this.field = field;
            this.entityName = entityName;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public String getField() {
            return this.field;
        }

        public static String getEntityNameByField(String field) {
            return Arrays.stream(FieldEntityNameEnum.values()).filter(row -> HRStringUtils.equals((String)row.getField(), (String)field)).map(FieldEntityNameEnum::getEntityName).findFirst().orElse(null);
        }
    }
}

