/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.service;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class ChgStrategyService {
    private ChgStrategyService() {
    }

    public static ChgStrategyService getInstance() {
        return ChgStrategyServiceHolder.INSTANCE;
    }

    public QFilter queryRuleVarRangeByAction(Long actionId, String chgField) {
        HRBaseServiceHelper ruleHelper = new HRBaseServiceHelper("hpfs_chgrule");
        QFilter chgActionFilter = new QFilter("chgaction", "=", (Object)actionId);
        QFilter statusFilter = new QFilter("status", "=", (Object)"C");
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObject rule = ruleHelper.queryOne("id", new QFilter[]{chgActionFilter, statusFilter, enableFilter});
        if (Objects.isNull(rule)) {
            return null;
        }
        String sql = "select a.fvalrange,a.fvalrange_tag,a.ffixed from t_hpfs_chgruleentry a inner join t_hpfs_chgtactic b on a.fafftacticid = b.fid where a.fid = ? and A.fchgfile = ? and b.fdirection = ?";
        Object[] param = new Object[3];
        param[0] = rule.get("id");
        if (chgField.indexOf("before") == 0) {
            param[1] = chgField.substring(6);
            param[2] = "0";
        } else {
            param[1] = chgField;
            param[2] = "1";
        }
        return (QFilter)DB.query((DBRoute)new DBRoute("hr"), (String)sql, (Object[])param, resultSet -> {
            if (resultSet.next()) {
                String fixed = resultSet.getString("ffixed");
                if (HRStringUtils.isNotEmpty((String)fixed)) {
                    return new QFilter("id", "=", (Object)Long.parseLong(fixed));
                }
                String valRange = resultSet.getString("fvalrange_tag");
                return HRStringUtils.isNotEmpty((String)valRange) ? QFilter.fromSerializedString((String)valRange) : null;
            }
            return null;
        });
    }

    private static class ChgStrategyServiceHolder {
        private static final ChgStrategyService INSTANCE = new ChgStrategyService();

        private ChgStrategyServiceHolder() {
        }
    }
}

