/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.service.cert;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.bussiness.cert.HRBizCertSignHelper;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.hr.hpfs.business.domain.repository.hrpi.DepEmpRepository;

public class HPLicenseCertTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(HPLicenseCertTask.class);
    private static final String APPID = "1WXBPN7+OHJZ";
    private static final int PAGECOUNT = 2000;
    private static final String ENTITYNAME = "hspm_erfilequery";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("HPLicenseCertTask#execute_start");
        int count = ORM.create().count("BusinessDataServiceHelper_empcert_count", "hrpi_empposorgrel", this.getFilters());
        LOGGER.info("license cert count {}", (Object)count);
        int totalCount = HRCertCommonHelper.getTotalCount((String)APPID, (String)ENTITYNAME);
        LOGGER.info("license totalCount {}", (Object)totalCount);
        if (count > totalCount) {
            return;
        }
        this.saveLicenseDetails();
        LOGGER.info("HPLicenseCertTask#execute_end");
    }

    void saveLicenseDetails() {
        try {
            Long startId = 0L;
            while (true) {
                List<Map<String, Object>> personList = DepEmpRepository.queryPersonId(startId, 2000);
                DynamicObject[] dys = (DynamicObject[])personList.stream().filter(item -> Objects.nonNull(item.get("personId"))).map(item -> {
                    DynamicObject tmpPerson = BusinessDataServiceHelper.newDynamicObject((String)"hpfs_licensedetail");
                    tmpPerson.set("person", item.get("personId"));
                    tmpPerson.set("sign", (Object)HRBizCertSignHelper.getSignData((String)String.valueOf(item.get("personId")), (String)((String)item.get("number"))));
                    return tmpPerson;
                }).toArray(DynamicObject[]::new);
                SaveServiceHelper.save((DynamicObject[])dys);
                int size = personList.size();
                if (size >= 2000) {
                    startId = (Long)personList.get(size - 1).get("id");
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            LOGGER.error(" license cert error ", (Throwable)ex);
        }
    }

    QFilter[] getFilters() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
        filters.add(new QFilter("datastatus", "=", (Object)"1"));
        filters.add(new QFilter("businessstatus", "=", (Object)"1"));
        filters.add(new QFilter("isprimary", "=", (Object)"1"));
        filters.add(new QFilter("initstatus", "=", (Object)"2"));
        filters.add(new QFilter("employee.laborrelstatus.labrelstatusprd", "in", (Object)1010L));
        filters.add(new QFilter("employee.initstatus", "=", (Object)"2"));
        return filters.toArray(new QFilter[0]);
    }
}

