/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.service.cert;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.domain.repository.RepositoryUtils;
import kd.hr.hpfs.business.domain.repository.hrpi.PersonRepository;
import kd.hr.hpfs.business.domain.repository.license.LicenseRepository;
import kd.hr.hpfs.business.perchg.executor.util.PerChgUtils;
import kd.hr.hpfs.business.perchg.parser.ParserResult;
import kd.hr.hpfs.business.service.cert.HRLicenseRecordManager;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;

public final class HRCertServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(HRCertServiceHelper.class);
    public static final Set<Long> LICENSE_IN = Sets.newHashSet((Object[])new Long[]{1010L, 1060L, 1150L});
    public static final Set<Long> LICENSE_OUT = Sets.newHashSet((Object[])new Long[]{1070L, 1080L, 1150L});
    private static final Set<String> ALLOWEDCLASSNAMESET = Sets.newHashSet((Object[])new String[]{"kd.hr.hpfs.business.perchg.executor.ExecutorService", "kd.hr.hpfs.mservice.HPFSLicenseService", "kd.hr.hpfs.mservice.HPFSRollbackService"});
    private static final String SELPROP = "id, number, person.id";

    private HRCertServiceHelper() {
    }

    public static void licenseExcute(PerChgBizInfo bizInfo, List<ParserResult> parserResults, Map<String, List<DynamicObject>> sourceData) {
        DynamicObject personLicense;
        Long personId;
        LOGGER.info(" cert license {}", (Object)bizInfo);
        HRLicenseRecordManager.isAllowedClassName(ALLOWEDCLASSNAMESET);
        if (LICENSE_IN.contains(bizInfo.getChgEventId()) && Objects.nonNull(personId = PerChgUtils.skipCreateNewPerson(bizInfo) ? Long.valueOf(Objects.isNull(personLicense = HRLicenseRecordManager.getPersonLicense(bizInfo.getOldPersonId())) ? bizInfo.getOldPersonId() : 0L) : bizInfo.getNewPersonId()) && personId > 0L) {
            String number;
            DynamicObject personDy = PerChgUtils.skipCreateNewPerson(bizInfo) ? HRCertServiceHelper.getPersonDyByPersonId(bizInfo.getOldPersonId()) : HRCertServiceHelper.getPersonDyFromParseResult(parserResults);
            String string = number = personDy == null ? "" : personDy.getString("number");
            if (!HRStringUtils.isEmpty((String)number) && personId > 0L) {
                HRLicenseRecordManager.addLicenseRecord(personId, number);
            }
        }
        if (LICENSE_OUT.contains(bizInfo.getChgEventId())) {
            if (bizInfo.getChgEventId() == 1150L && PerChgUtils.skipCreateNewPerson(bizInfo)) {
                LOGGER.info("skip license out");
                return;
            }
            personId = bizInfo.getOldPersonId();
            if (personId > 0L) {
                HRLicenseRecordManager.delLicenseRecord(personId);
            }
        }
    }

    public static Map<String, Object> licenseExcuteNew(Map<String, Object> params) {
        LOGGER.info("==licenseExcuteNew.params:{}===", params);
        HashMap<String, Object> res = new HashMap<String, Object>(4);
        res.put("success", true);
        res.put("msg", "");
        try {
            DynamicObject personLicense;
            Long personId;
            LOGGER.info(" cert license {}", params);
            HRLicenseRecordManager.isAllowedClassName(ALLOWEDCLASSNAMESET);
            String number = (String)params.get("number");
            Long chgeventId = (Long)params.get("chgeventId");
            Long oldEmpId = (Long)params.get("oldEmpId");
            Long oldPersonId = (Long)params.get("oldPersonId");
            Long newPersonId = (Long)params.get("newPersonId");
            if (LICENSE_IN.contains(chgeventId) && Objects.nonNull(personId = PerChgUtils.skipCreateNewPerson(chgeventId, oldEmpId) ? Long.valueOf(Objects.isNull(personLicense = HRLicenseRecordManager.getPersonLicense(oldPersonId)) ? oldPersonId : 0L) : newPersonId) && personId > 0L) {
                DynamicObject personDy;
                DynamicObject dynamicObject = personDy = PerChgUtils.skipCreateNewPerson(chgeventId, oldEmpId) ? HRCertServiceHelper.getPersonDyByPersonId(oldPersonId) : null;
                if (personDy != null) {
                    personDy.getString("number");
                }
                if (!HRStringUtils.isEmpty((String)number) && personId > 0L) {
                    HRLicenseRecordManager.addLicenseRecord(personId, number);
                }
            }
            if (LICENSE_OUT.contains(chgeventId)) {
                if (chgeventId == 1150L && PerChgUtils.skipCreateNewPerson(chgeventId, oldEmpId)) {
                    LOGGER.info("skip license out");
                    return res;
                }
                if (oldPersonId > 0L) {
                    HRLicenseRecordManager.delLicenseRecord(oldPersonId);
                }
            }
            return res;
        }
        catch (Exception exp) {
            LOGGER.error("==licenseExcute exp==", (Throwable)exp);
            res.put("success", false);
            res.put("msg", ExceptionUtils.getStackTrace((Throwable)exp));
            return res;
        }
    }

    private static DynamicObject getPersonDyByPersonId(Long personId) {
        DynamicObject[] personArr = PersonRepository.queryByPersonId(Collections.singletonList(personId));
        return Objects.isNull(personArr) || personArr.length == 0 ? null : personArr[0];
    }

    private static DynamicObject getPersonDyFromParseResult(List<ParserResult> parserResults) {
        return parserResults.stream().filter(row -> HRStringUtils.equals((String)((String)row.getParserParam().get("entityName")), (String)"hrpi_person")).map(row -> (DynamicObject)row.getParserParam().get("hisDy")).findAny().orElse(null);
    }

    public static void rollbackLicenseExcute(Map<Long, DynamicObject> personMap, long eventId) {
        if (CollectionUtils.isEmpty(personMap)) {
            return;
        }
        LOGGER.info("== rollbackLicenseExcute personMap\uff1a{} eventId\uff1a{}", personMap, (Object)eventId);
        HRLicenseRecordManager.isAllowedClassName(ALLOWEDCLASSNAMESET);
        if (LICENSE_IN.contains(eventId)) {
            personMap.forEach((personId, dy) -> HRLicenseRecordManager.delLicenseRecord(personId));
        }
        if (LICENSE_OUT.contains(eventId)) {
            DynamicObject[] ermanFiles;
            for (DynamicObject dy2 : ermanFiles = RepositoryUtils.queryByIds("hspm_ermanfile", SELPROP, personMap.keySet())) {
                String number = dy2.getString("number");
                long personId2 = dy2.getLong("person.id");
                if (HRStringUtils.isEmpty((String)number) || personId2 <= 0L) continue;
                HRLicenseRecordManager.addLicenseRecord(personId2, number);
            }
        }
    }

    public static void updateLicenseDetailSign(DynamicObject[] details) {
        HRLicenseRecordManager.isAllowedClassName(ALLOWEDCLASSNAMESET);
        HashSet personIds = Sets.newHashSetWithExpectedSize((int)details.length);
        for (int i = 0; i < details.length; ++i) {
            DynamicObject item = details[i];
            personIds.add((Long)item.get("person"));
        }
        DynamicObject[] persons = PersonRepository.queryByPersonId(personIds);
        Map<Long, String> map = Arrays.stream(persons).collect(Collectors.toMap(person -> (Long)person.get("id"), person -> person.getString("number"), (v1, v2) -> v1));
        for (int k = 0; k < details.length; ++k) {
            DynamicObject tmpPerson = details[k];
            Long personId = (Long)tmpPerson.get("person");
            String number = map.get(personId);
            if (StringUtils.isBlank((CharSequence)number)) continue;
            tmpPerson.set("sign", (Object)HRLicenseRecordManager.getLicenseSign(personId, number));
            tmpPerson.set("modifytime", (Object)new Date());
            tmpPerson.set("modifier", (Object)RequestContext.get().getCurrUserId());
        }
        LicenseRepository.update(details);
    }
}

