/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.service.cert;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.bussiness.cert.HRBizCertSignHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hpfs.business.service.cert.PersonLicenseHelper;

final class HRLicenseRecordManager {
    private static final Log LOGGER = LogFactory.getLog(HRLicenseRecordManager.class);
    private static final Set<String> ALLOWEDCLASSNAMESET = Sets.newHashSet((Object[])new String[]{"kd.hr.hpfs.business.service.cert.HRCertServiceHelper", "kd.hr.hpfs.business.service.cert.HRCertValidateServiceHelper", "kd.hr.hpfs.business.service.cert.HRCertInitService"});

    private HRLicenseRecordManager() {
    }

    static DynamicObject getPersonLicense(Long personId) {
        return PersonLicenseHelper.getPersonLicenseByPersonId(personId);
    }

    static boolean addLicenseRecord(Long personId, String empNumber) {
        HRLicenseRecordManager.isAllowedClassName(ALLOWEDCLASSNAMESET);
        DynamicObject licenseRecord = BusinessDataServiceHelper.newDynamicObject((String)"hpfs_licensedetail");
        licenseRecord.set("person", (Object)personId);
        licenseRecord.set("sign", (Object)HRBizCertSignHelper.getSignData((String)personId.toString(), (String)empNumber));
        return PersonLicenseHelper.savePersonLicense(licenseRecord);
    }

    static int delLicenseRecord(Long personId) {
        HRLicenseRecordManager.isAllowedClassName(ALLOWEDCLASSNAMESET);
        LOGGER.info("delete license {}", (Object)personId);
        DynamicObject personDy = PersonLicenseHelper.getPerson(personId);
        if (null != personDy) {
            long signData = personDy.getLong("id");
            String salt = personDy.getString("number");
            return PersonLicenseHelper.delPersonLicense(signData, HRBizCertSignHelper.getSignData((String)String.valueOf(signData), (String)salt));
        }
        return 0;
    }

    static Map<Long, Map<String, Object>> checkPersonLicense(List<Long> personIds) {
        HRLicenseRecordManager.isAllowedClassName(ALLOWEDCLASSNAMESET);
        LOGGER.info("check license {}", personIds);
        HashMap<Long, Map<String, Object>> licenseResult = new HashMap<Long, Map<String, Object>>(personIds.size());
        Object[] personLicenseList = PersonLicenseHelper.listPersons(personIds);
        if (!HRArrayUtils.isEmpty((Object[])personLicenseList)) {
            try {
                ArrayList<String> signQueryList = new ArrayList<String>(personLicenseList.length);
                for (Object dy : personLicenseList) {
                    HRLicenseRecordManager.getInfoMap((DynamicObject)dy, licenseResult, signQueryList);
                }
                if (!licenseResult.isEmpty() && !signQueryList.isEmpty()) {
                    DynamicObject[] signList;
                    for (DynamicObject sign : signList = PersonLicenseHelper.listPersonLicense(licenseResult.keySet(), signQueryList)) {
                        long personId = Long.parseLong(sign.getString("person"));
                        Map stringObjectMap = (Map)licenseResult.get(personId);
                        if (stringObjectMap == null || stringObjectMap.isEmpty() || !signQueryList.contains(sign.getString("sign"))) continue;
                        stringObjectMap.put("status", Boolean.TRUE);
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.info("license check error", (Object)ex);
                throw new KDBizException("license check error.");
            }
        }
        return licenseResult;
    }

    private static void getInfoMap(DynamicObject personInfo, Map<Long, Map<String, Object>> queryMap, List<String> signQueryList) {
        long personId = personInfo.getLong("id");
        String empNumber = personInfo.getString("number");
        String personName = personInfo.getString("name");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("number", empNumber);
        map.put("name", personName);
        map.put("id", personId);
        map.put("status", Boolean.FALSE);
        signQueryList.add(HRBizCertSignHelper.getSignData((String)String.valueOf(personId), (String)empNumber));
        queryMap.put(personId, map);
    }

    static void isAllowedClassName(Set<String> allowedClass) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        boolean isAllowedClass = Arrays.stream(stackTraceElements).limit(10L).anyMatch(stackTraceElement -> allowedClass.contains(stackTraceElement.getClassName()));
        if (!isAllowedClass) {
            throw new KDBizException("HRLicenseManage error: current call is not allowed.");
        }
    }

    public static String getLicenseSign(Long personId, String empNumber) {
        HRLicenseRecordManager.isAllowedClassName(ALLOWEDCLASSNAMESET);
        return HRBizCertSignHelper.getSignData((String)String.valueOf(personId), (String)empNumber);
    }
}

