/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.service.fileMap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.domain.repository.RepositoryUtils;
import kd.hr.hpfs.business.domain.repository.perchg.ChgMappingRepository;
import kd.hr.hpfs.business.service.fileMap.IFileMapManagerService;
import kd.hr.hpfs.business.service.fileMap.vo.FileMapManagerVO;
import kd.hr.hpfs.business.service.fileMap.vo.FileMapVO;
import kd.hr.hpfs.common.fieldmap.constanst.FieldTypeEnum;
import kd.hr.hpfs.common.fieldmap.constanst.MultiLangEnumBridge;
import kd.hr.hpfs.common.utils.MetaUtils;
import kd.sdk.hr.common.constants.FileMapManagerConstants;

public class FileMapManagerService
implements IFileMapManagerService,
FileMapManagerConstants {
    private static final Log LOGGER = LogFactory.getLog(FileMapManagerService.class);
    private static final String SEQ = "seq";
    private static final String C_SUFFIX = "_c";
    private static final String LOCK_PREFIX = "hpfspersonfields";
    private static final Long LOCK_TIME_OUT = 10000L;

    @Override
    public void saveFileMapManager(List<String> sourceEntitys, List<FileMapManagerVO> fileMapManagerList, boolean isHcf) {
        DynamicObject[] array = this.getFileMapDys(sourceEntitys);
        if (array == null || array.length == 0) {
            return;
        }
        for (DynamicObject dy : array) {
            if (isHcf) {
                this.addOrUpdateEntryEntityForHcf(dy, fileMapManagerList);
                continue;
            }
            this.addOrUpdateEntryEntity(dy, fileMapManagerList);
        }
        String entityNumber = array[0].getDataEntityType().getName();
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", Boolean.TRUE.toString());
        OperationServiceHelper.executeOperate((String)"save", (String)entityNumber, (DynamicObject[])array, (OperateOption)option);
    }

    @Override
    public void setSubEntryEntity(DynamicObjectCollection scrSubEntryEntityDys, IFormView view) {
        DynamicObjectCollection tagSubEntryEntityDys = view.getModel().getEntryEntity("subentryentity");
        for (DynamicObject scrSubEntryEntityDy : scrSubEntryEntityDys) {
            DynamicObject tagSubEntryEntityDy = tagSubEntryEntityDys.addNew();
            tagSubEntryEntityDy.set("sourcefield", scrSubEntryEntityDy.get("sourcefield"));
            tagSubEntryEntityDy.set("sourcefieldtag", scrSubEntryEntityDy.get("sourcefieldtag"));
            tagSubEntryEntityDy.set("targetfieldnew", scrSubEntryEntityDy.get("targetfieldnew"));
            tagSubEntryEntityDy.set("loadpersoninfo", scrSubEntryEntityDy.get("loadpersoninfo"));
            tagSubEntryEntityDy.set("writepersoninfo", scrSubEntryEntityDy.get("writepersoninfo"));
            tagSubEntryEntityDy.set("ispkid", scrSubEntryEntityDy.get("ispkid"));
            tagSubEntryEntityDy.set("isedit", scrSubEntryEntityDy.get("isedit"));
        }
    }

    @Override
    public void setSubEntryEntityC(DynamicObjectCollection scrSubEntryEntityDys, IFormView view) {
        DynamicObjectCollection tagSubEntryEntityDys = view.getModel().getEntryEntity("subentryentity_c");
        for (DynamicObject scrSubEntryEntityDy : scrSubEntryEntityDys) {
            DynamicObject tagSubEntryEntityDy = tagSubEntryEntityDys.addNew();
            tagSubEntryEntityDy.set("sourcefield_c", scrSubEntryEntityDy.get("sourcefield_c"));
            tagSubEntryEntityDy.set("sourcefieldtag_c", scrSubEntryEntityDy.get("sourcefieldtag_c"));
            tagSubEntryEntityDy.set("targetfieldnew_c", scrSubEntryEntityDy.get("targetfieldnew_c"));
            tagSubEntryEntityDy.set("loadpersoninfo_c", scrSubEntryEntityDy.get("loadpersoninfo_c"));
            tagSubEntryEntityDy.set("writepersoninfo_c", scrSubEntryEntityDy.get("writepersoninfo_c"));
            tagSubEntryEntityDy.set("ispkid_c", scrSubEntryEntityDy.get("ispkid_c"));
            tagSubEntryEntityDy.set("isedit_c", scrSubEntryEntityDy.get("isedit_c"));
        }
    }

    @Override
    public MainEntityType getEntityNameByExtEntityName(String number) {
        return MetadataServiceHelper.getDataEntityType((String)MetaUtils.getSourceEntityNum((String)number));
    }

    @Override
    public void insertOrUpdatePersonfields(DynamicObject entryentityDy) {
        String targetEntity;
        DataEntityPropertyCollection properties = entryentityDy.getDynamicObjectType().getProperties();
        if (properties.containsKey((Object)"targetentity_c")) {
            targetEntity = entryentityDy.getString("targetentity_c.id");
            if (StringUtils.isEmpty((CharSequence)targetEntity)) {
                targetEntity = entryentityDy.getString("targetentity_c");
            }
        } else {
            targetEntity = entryentityDy.getString("targetentity.id");
            if (StringUtils.isEmpty((CharSequence)targetEntity)) {
                targetEntity = entryentityDy.getString("targetentity");
            }
        }
        if (targetEntity == null) {
            LOGGER.info("FileMapManagerService.insertOrUpdatePersonfields targetentity is empty");
            return;
        }
        String dlockKey = String.join((CharSequence)"_", LOCK_PREFIX, targetEntity);
        try (DLock dLock = DLock.create((String)dlockKey);){
            if (dLock.tryLock(LOCK_TIME_OUT.longValue())) {
                this.insertOrUpdatePersonfields(targetEntity);
            } else {
                LOGGER.warn("insertOrUpdatePersonfields#hpfspersonfields tryLock overTime");
            }
        }
    }

    public void insertOrUpdatePersonfields(String targetEntity) {
        MainEntityType targetDataEntityType = MetadataServiceHelper.getDataEntityType((String)targetEntity);
        Map allFields = targetDataEntityType.getAllFields();
        boolean hasId = targetDataEntityType.getProperties().containsKey((Object)"id");
        if (hasId) {
            allFields.put("id", targetDataEntityType.getProperties().get((Object)"id"));
        }
        DynamicObject[] personFieldsDys = this.getPersonFields(targetEntity);
        ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>(Arrays.asList(personFieldsDys));
        Map<String, DynamicObject> numberAndDynamicObject = Arrays.stream(personFieldsDys).collect(Collectors.toMap(data -> data.getString("number"), data -> data, (o1, o2) -> o1));
        for (Map.Entry entry : allFields.entrySet()) {
            String fieldType;
            String key = (String)entry.getKey();
            DynamicObject dynamicObject = numberAndDynamicObject.get(key);
            if (Objects.isNull(dynamicObject)) {
                dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hpfs_personfield"));
                arrayList.add(dynamicObject);
            }
            IDataEntityProperty value = (IDataEntityProperty)entry.getValue();
            dynamicObject.set("number", (Object)key);
            dynamicObject.set("name", (Object)(value.getDisplayName() == null ? new LocaleString("id") : value.getDisplayName()));
            FieldTypeEnum fieldTypeByClassName = FieldTypeEnum.getFieldTypeByClassName((String)value.getClass().getName());
            if (Objects.isNull(fieldTypeByClassName)) {
                fieldType = "";
            } else {
                MultiLangEnumBridge multiLangEnumBridge = fieldTypeByClassName.getMultiLangEnumBridge();
                fieldType = multiLangEnumBridge.loadKDString();
            }
            dynamicObject.set("fieldtype", (Object)fieldType);
            dynamicObject.set("targetentity", (Object)targetEntity);
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"hpfs_personfield", (DynamicObject[])arrayList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (!operationResult.isSuccess()) {
            LOGGER.error("####FieldRelationEdit.realTimeUpdatePersonFields", (Object)operationResult.getMessage());
        }
    }

    @Override
    public void insertOrUpdatePersonFieldsOfC(DynamicObject entryEntityDy) {
        String targetEntity = entryEntityDy.getString("targetentity_c.id");
        if (StringUtils.isEmpty((CharSequence)targetEntity)) {
            targetEntity = entryEntityDy.getString("targetentity_c");
        }
        MainEntityType targetDataEntityType = MetadataServiceHelper.getDataEntityType((String)targetEntity);
        Map allFields = targetDataEntityType.getAllFields();
        boolean hasId = targetDataEntityType.getProperties().containsKey((Object)"id");
        if (hasId) {
            allFields.put("id", targetDataEntityType.getProperties().get((Object)"id"));
        }
        DynamicObject[] personFieldsDys = this.getPersonFields(targetEntity);
        ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>(Arrays.asList(personFieldsDys));
        Map<String, DynamicObject> numberAndDynamicObject = Arrays.stream(personFieldsDys).collect(Collectors.toMap(data -> data.getString("number"), data -> data, (o1, o2) -> o1));
        for (Map.Entry entry : allFields.entrySet()) {
            String fieldType;
            String key = (String)entry.getKey();
            DynamicObject dynamicObject = numberAndDynamicObject.get(key);
            if (Objects.isNull(dynamicObject)) {
                dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hpfs_personfield"));
                arrayList.add(dynamicObject);
            }
            IDataEntityProperty value = (IDataEntityProperty)entry.getValue();
            dynamicObject.set("number", (Object)key);
            dynamicObject.set("name", (Object)(value.getDisplayName() == null ? new LocaleString("id") : value.getDisplayName()));
            FieldTypeEnum fieldTypeByClassName = FieldTypeEnum.getFieldTypeByClassName((String)value.getClass().getName());
            if (Objects.isNull(fieldTypeByClassName)) {
                fieldType = "";
            } else {
                MultiLangEnumBridge multiLangEnumBridge = fieldTypeByClassName.getMultiLangEnumBridge();
                fieldType = multiLangEnumBridge.loadKDString();
            }
            dynamicObject.set("fieldtype", (Object)fieldType);
            dynamicObject.set("targetentity", (Object)targetEntity);
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"hpfs_personfield", (DynamicObject[])arrayList.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        if (!operationResult.isSuccess()) {
            LOGGER.error("####FieldRelationEdit.insertOrUpdatePersonFieldsOfC", (Object)operationResult.getMessage());
        }
    }

    private void addOrUpdateEntryEntityForHcf(DynamicObject dy, List<FileMapManagerVO> fileMapManagerList) {
        Map<String, DynamicObject> entityobjectMap = this.getEntityobjectMap(fileMapManagerList);
        DynamicObjectCollection entryCol = dy.getDynamicObjectCollection("entryentity_c");
        if (entryCol == null) {
            entryCol = new DynamicObjectCollection();
        }
        Map<String, DynamicObject> entryNumberMap = entryCol.stream().collect(Collectors.toMap(entry -> this.append(entry.getString("sourceentity_c.number"), entry.getString("targetentity_c.id")), entry -> entry, (entry1, entry2) -> entry2));
        int seq = this.initSeq(entryCol);
        for (FileMapManagerVO fileMapManagerVO : fileMapManagerList) {
            String sourceEntryNumber = fileMapManagerVO.getSourceEntryNumber();
            String key = HRStringUtils.isEmpty((String)sourceEntryNumber) ? this.append("n_extinfo_fields", fileMapManagerVO.getTargetEntity()) : this.append(fileMapManagerVO.getSourceEntryNumber(), fileMapManagerVO.getTargetEntity());
            DynamicObject entryDy = entryNumberMap.get(key);
            if (entryDy == null) {
                entryDy = entryCol.addNew();
                entryDy.set("targetentity_c", (Object)entityobjectMap.get(fileMapManagerVO.getTargetEntity()));
                entryDy.set(SEQ, (Object)seq++);
                entryDy.set("srcentryissyspreset_c", (Object)"0");
                if (HRStringUtils.isEmpty((String)sourceEntryNumber)) {
                    entryDy.set("sourceentry_c", (Object)"n_extinfo_fields");
                    entryDy.set("billinfogroup_c", (Object)ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5b57\u6bb5\u5206\u7ec4", (String)"FileMapManagerService_0", (String)"hr-hpfs-business", (Object[])new Object[0]));
                } else {
                    entryDy.set("sourceentry_c", (Object)fileMapManagerVO.getSourceEntryNumber());
                }
                entryDy.set("sourceentity_c", (Object)sourceEntryNumber);
            }
            this.insertOrUpdatePersonfields(entryDy);
            this.addOrUpdateSubEntryEntityForHcf(entryDy, fileMapManagerVO.getFileMapVOList());
        }
    }

    private Map<String, DynamicObject> getEntityobjectMap(List<FileMapManagerVO> fileMapManagerList) {
        List targetEntityNumbers = fileMapManagerList.stream().map(fileMapManagerVO -> fileMapManagerVO.getTargetEntity()).distinct().collect(Collectors.toList());
        DynamicObject[] entityobjects = RepositoryUtils.queryDynamicObjects("bos_entityobject", null, new QFilter("id", "in", targetEntityNumbers));
        return Arrays.stream(entityobjects).collect(Collectors.toMap(entity -> entity.getString("id"), Function.identity()));
    }

    private void addOrUpdateEntryEntity(DynamicObject dy, List<FileMapManagerVO> fileMapManagerList) {
        Map<String, DynamicObject> entityobjectMap = this.getEntityobjectMap(fileMapManagerList);
        DynamicObjectCollection entryCol = dy.getDynamicObjectCollection("entryentity");
        Map<String, DynamicObject> entryNumberMap = entryCol.stream().collect(Collectors.toMap(entry -> this.append(entry.getString("sourceentry"), entry.getString("targetentity.id")), entry -> entry, (entry1, entry2) -> entry2));
        int seq = this.initSeq(entryCol);
        for (FileMapManagerVO fileMapManagerVO : fileMapManagerList) {
            String sourceEntryNumber = fileMapManagerVO.getSourceEntryNumber();
            String key = HRStringUtils.isEmpty((String)sourceEntryNumber) ? this.append("n_extinfo_fields", fileMapManagerVO.getTargetEntity()) : this.append(fileMapManagerVO.getSourceEntryNumber(), fileMapManagerVO.getTargetEntity());
            DynamicObject entryDy = entryNumberMap.get(key);
            if (entryDy == null) {
                entryDy = entryCol.addNew();
                entryDy.set("targetentity", (Object)entityobjectMap.get(fileMapManagerVO.getTargetEntity()));
                entryDy.set(SEQ, (Object)seq++);
                entryDy.set("srcentryissyspreset", (Object)"0");
                if (HRStringUtils.isEmpty((String)sourceEntryNumber)) {
                    entryDy.set("sourceentry", (Object)"n_extinfo_fields");
                    entryDy.set("billinfogroup", (Object)ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5b57\u6bb5\u5206\u7ec4", (String)"FileMapManagerService_0", (String)"hr-hpfs-business", (Object[])new Object[0]));
                } else {
                    entryDy.set("sourceentry", (Object)fileMapManagerVO.getSourceEntryNumber());
                }
                entryDy.set("sourceentity", (Object)dy.getDynamicObject("personnelbusinessbill"));
            }
            this.insertOrUpdatePersonfields(entryDy);
            this.addOrUpdateSubEntryEntity(entryDy, fileMapManagerVO.getFileMapVOList());
        }
    }

    private void addOrUpdateSubEntryEntityForHcf(DynamicObject entryDy, List<FileMapVO> fileMapVOList) {
        String targetEntity = entryDy.getString("targetentity_c.id");
        if (StringUtils.isEmpty((CharSequence)targetEntity)) {
            targetEntity = entryDy.getString("targetentity_c");
        }
        if (targetEntity == null) {
            LOGGER.error("FileMapManagerService.addOrUpdateSubEntryEntityForHcf targetentity is empty");
            return;
        }
        String sourceNumber = entryDy.getString("sourceentity_c.number");
        if (StringUtils.isEmpty((CharSequence)sourceNumber)) {
            sourceNumber = entryDy.getString("sourceentity_c");
        }
        if (sourceNumber == null) {
            LOGGER.error("FileMapManagerService.addOrUpdateSubEntryEntityForHcf sourceNumber is empty");
            return;
        }
        QFilter filter = new QFilter("targetentity", "=", (Object)targetEntity);
        DynamicObject[] personfields = RepositoryUtils.queryDynamicObjects("hpfs_personfield", "id, number", filter.toArray());
        Map personfieldMap = Arrays.stream(personfields).collect(Collectors.toMap(field -> field.getString("number"), Function.identity(), (oldV, newV) -> newV));
        DynamicObjectCollection subEntryCol = entryDy.getDynamicObjectCollection("subentryentity_c");
        Map subEntryColMap = subEntryCol.stream().collect(Collectors.toMap(subEntry -> subEntry.getString("sourcefieldtag_c") + ";" + subEntry.getString("targetfieldnew_c.number"), Function.identity()));
        int seq = this.initSeq(subEntryCol);
        MainEntityType targetDataEntityType = MetadataServiceHelper.getDataEntityType((String)sourceNumber);
        Map sourceEnttityAllFields = targetDataEntityType.getAllFields();
        for (FileMapVO fileMap : fileMapVOList) {
            IDataEntityProperty property;
            String fileKey = fileMap.getSourceField() + ";" + fileMap.getTargetField();
            if (subEntryColMap.containsKey(fileKey)) continue;
            DynamicObject fieldDy = (DynamicObject)personfieldMap.get(fileMap.getTargetField());
            if (fieldDy == null) {
                LOGGER.error("data ex:{}", (Object)fileMap);
                continue;
            }
            DynamicObject subEntryDy = subEntryCol.addNew();
            subEntryDy.set("sourcefieldtag_c", (Object)fileMap.getSourceField());
            if (sourceEnttityAllFields != null && (property = (IDataEntityProperty)sourceEnttityAllFields.get(fileMap.getSourceField())) != null && property.getDisplayName() != null) {
                subEntryDy.set("sourcefield_c", (Object)property.getDisplayName().getLocaleValue());
            }
            subEntryDy.set("targetfieldnew_c", (Object)fieldDy);
            subEntryDy.set("targetfieldnew_c_id", fieldDy.get("id"));
            subEntryDy.set("loadpersoninfo_c", (Object)fileMap.isLoadpersoninfo());
            subEntryDy.set("writepersoninfo_c", (Object)fileMap.isWritepersoninfo());
            subEntryDy.set("ispkid_c", (Object)"0");
            subEntryDy.set("isedit_c", (Object)true);
            subEntryDy.set(SEQ, (Object)seq++);
        }
    }

    private void addOrUpdateSubEntryEntity(DynamicObject entryDy, List<FileMapVO> fileMapVOList) {
        String targetEntity = entryDy.getString("targetentity.id");
        if (StringUtils.isEmpty((CharSequence)targetEntity)) {
            targetEntity = entryDy.getString("targetentity");
        }
        if (targetEntity == null) {
            LOGGER.error("FileMapManagerService.addOrUpdateSubEntryEntity targetentity is empty");
        }
        QFilter filter = new QFilter("targetentity", "=", (Object)targetEntity);
        DynamicObject[] personfields = RepositoryUtils.queryDynamicObjects("hpfs_personfield", "id, number", filter.toArray());
        Map personfieldMap = Arrays.stream(personfields).collect(Collectors.toMap(field -> field.getString("number"), Function.identity(), (oldV, newV) -> newV));
        DynamicObjectCollection subEntryCol = entryDy.getDynamicObjectCollection("subentryentity");
        Map subEntryColMap = subEntryCol.stream().collect(Collectors.toMap(subEntry -> subEntry.getString("sourcefieldtag") + ";" + subEntry.getString("targetfieldnew.number"), Function.identity()));
        int seq = this.initSeq(subEntryCol);
        for (FileMapVO fileMap : fileMapVOList) {
            String fileKey = fileMap.getSourceField() + ";" + fileMap.getTargetField();
            if (subEntryColMap.containsKey(fileKey)) continue;
            DynamicObject subEntryDy = subEntryCol.addNew();
            subEntryDy.set("sourcefieldtag", (Object)fileMap.getSourceField());
            subEntryDy.set("targetfieldnew", personfieldMap.get(fileMap.getTargetField()));
            if (personfieldMap.containsKey(fileMap.getTargetField())) {
                subEntryDy.set("targetfieldnew_id", ((DynamicObject)personfieldMap.get(fileMap.getTargetField())).get("id"));
            }
            subEntryDy.set("loadpersoninfo", (Object)fileMap.isLoadpersoninfo());
            subEntryDy.set("writepersoninfo", (Object)fileMap.isWritepersoninfo());
            subEntryDy.set("ispkid", (Object)"0");
            subEntryDy.set("isedit", (Object)true);
            subEntryDy.set(SEQ, (Object)seq++);
        }
    }

    private int initSeq(DynamicObjectCollection col) {
        Object seqObj;
        int seq = 1;
        if (col.size() > 0 && (seqObj = ((DynamicObject)col.get(col.size() - 1)).get(SEQ)) instanceof Integer) {
            seq = (Integer)seqObj + 1;
        }
        return seq;
    }

    private DynamicObject[] getFileMapDys(List<String> sourceEntitys) {
        return ChgMappingRepository.getInstance().loadDynamicObjectArray(new QFilter("personnelbusinessbill", "in", sourceEntitys).toArray());
    }

    private DynamicObject[] getPersonFields(String targetEntity) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hpfs_personfield");
        QFilter qFilter = new QFilter("targetentity", "=", (Object)targetEntity);
        return helper.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    private String append(String ... args) {
        StringBuilder sb = new StringBuilder();
        for (String arg : args) {
            sb.append(HRStringUtils.isEmpty((String)arg) ? "" : arg).append(";");
        }
        return sb.toString();
    }
}

