/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.service.hpfsrollback;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.extplugin.PluginCall;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.domain.repository.RepositoryUtils;
import kd.hr.hpfs.business.domain.repository.config.DevParamConfigRepository;
import kd.hr.hpfs.business.perchg.crossvalidate.enums.ValidateOrgEnum;
import kd.hr.hpfs.business.perchg.executor.enums.ChgRecordStatusEnum;
import kd.hr.hpfs.business.perchg.rollback.model.HrValidDto;
import kd.hr.hpfs.business.perchg.rollback.model.RollbackValidDto;
import kd.hr.hpfs.business.utils.ProxyUtils;
import kd.sdk.hr.hpfs.business.rollback.ICustomRollbackService;

public class HpfsRollbackValidHelper {
    private static final Log LOG = LogFactory.getLog(HpfsRollbackValidHelper.class);
    private static final String selectFields = "id,uncommittedtrans,committedtrans,condition,orgrelvalidtype,crossstatus,crossresult,crossnoti";

    public static void validParams(List<RollbackValidDto> validDtoList) {
        for (RollbackValidDto validDto : validDtoList) {
            String msg;
            StringBuilder sb = new StringBuilder();
            if (HRObjectUtils.isEmpty((Object)validDto.getBillId()) || validDto.getBillId() == 0L) {
                msg = ResManager.loadKDString((String)"\u201cbillID\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff1b", (String)"HpfsRollbackServiceHelper_2", (String)"hr-hpfs-business", (Object[])new Object[0]);
                sb.append(msg);
            }
            if (HRObjectUtils.isEmpty((Object)validDto.getChgaction()) || validDto.getChgaction() == 0L) {
                msg = ResManager.loadKDString((String)"\u201cchgaction\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff1b", (String)"HpfsRollbackServiceHelper_3", (String)"hr-hpfs-business", (Object[])new Object[0]);
                sb.append(msg);
            }
            if (HRStringUtils.isEmpty((String)validDto.getBillNo())) {
                msg = ResManager.loadKDString((String)"\u201cbillNo\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff1b", (String)"HpfsRollbackServiceHelper_5", (String)"hr-hpfs-business", (Object[])new Object[0]);
                sb.append(msg);
            }
            if (HRObjectUtils.isEmpty((Object)validDto.getEmployeeId()) || validDto.getEmployeeId() == 0L) {
                msg = ResManager.loadKDString((String)"\u201cemployeeID\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff1b", (String)"HpfsRollbackServiceHelper_7", (String)"hr-hpfs-business", (Object[])new Object[0]);
                sb.append(msg);
            }
            if (HRObjectUtils.isEmpty((Object)validDto.getDepempId()) || validDto.getDepempId() == 0L) {
                msg = ResManager.loadKDString((String)"\u201cdepempID\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff1b", (String)"HpfsRollbackServiceHelper_10", (String)"hr-hpfs-business", (Object[])new Object[0]);
                sb.append(msg);
            }
            if (HRStringUtils.isEmpty((String)sb.toString())) {
                validDto.setIsValid("1");
                validDto.setCode("200");
                validDto.setMsg("success");
                continue;
            }
            validDto.setIsValid("0");
            validDto.setIsValidMsg(sb.toString());
            validDto.setCode("500");
            validDto.setMsg(sb.toString());
        }
    }

    public static List<RollbackValidDto> rollbackValid(List<RollbackValidDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return new ArrayList<RollbackValidDto>(1);
        }
        HashSet billIdSet = new HashSet(dtoList.size());
        HashSet chgactionSet = new HashSet(dtoList.size());
        HashSet billNoSet = new HashSet(dtoList.size());
        dtoList.forEach(dto -> {
            billIdSet.add(dto.getBillId());
            chgactionSet.add(dto.getChgaction());
            billNoSet.add(dto.getBillNo());
        });
        QFilter filter = new QFilter("bill", "in", billIdSet).and("chgaction", "in", chgactionSet).and("billno", "in", billNoSet).and("datastatus", "=", (Object)ChgRecordStatusEnum.CHANGED.getCode());
        DynamicObject[] records = RepositoryUtils.queryDynamicObjects("hpfs_chgrecord", "", filter);
        if (records == null || records.length == 0) {
            return new ArrayList<RollbackValidDto>(1);
        }
        HashMap<Long, DynamicObject> billRecMap = new HashMap<Long, DynamicObject>(records.length);
        for (DynamicObject record : records) {
            billRecMap.put(record.getLong("bill"), record);
        }
        if (CollectionUtils.isEmpty(billRecMap)) {
            return new ArrayList<RollbackValidDto>(1);
        }
        Iterator<RollbackValidDto> iter = dtoList.iterator();
        while (iter.hasNext()) {
            RollbackValidDto dto2 = iter.next();
            DynamicObject recordTmp = (DynamicObject)billRecMap.get(dto2.getBillId());
            if (recordTmp != null) {
                long categoryId = recordTmp.getLong("chgcategory.id");
                if (categoryId == 0L) continue;
                dto2.setCategoryId(categoryId);
                continue;
            }
            iter.remove();
        }
        HpfsRollbackValidHelper.validSWC(dtoList);
        dtoList = HpfsRollbackValidHelper.validHR(dtoList);
        List paramList = (List)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(dtoList), List.class);
        List<Map<String, Object>> resList = ProxyUtils.rollBackWeakValid((PluginCall<ICustomRollbackService, List<Map<String, Object>>>)((PluginCall)iCustomService -> iCustomService.rollBackWeakValid(paramList)));
        ArrayList<RollbackValidDto> resRollbackList = new ArrayList<RollbackValidDto>(resList.size());
        for (Map<String, Object> dtoMap : resList) {
            resRollbackList.add((RollbackValidDto)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(dtoMap), RollbackValidDto.class));
        }
        return resRollbackList;
    }

    public static void validSWC(List<RollbackValidDto> dtoList) {
        Map invokeResult;
        LOG.info("===validSWC:{}", dtoList);
        HashMap paramsMap = new HashMap(2);
        List employees = dtoList.stream().map(RollbackValidDto::getEmployeeId).collect(Collectors.toList());
        paramsMap.put("status", Lists.newArrayList((Object[])new String[]{"A", "B", "C"}));
        paramsMap.put("employees", employees);
        try {
            LOG.info("==validSWC.paramsMap:{}==", paramsMap);
            invokeResult = (Map)HRMServiceHelper.invokeBizService((String)"swc", (String)"hsbs", (String)"IHSBSService", (String)"queryAllFileBoByEmp", (Object[])new Object[]{paramsMap});
        }
        catch (Exception e) {
            LOG.error("==HsbsExternalServiceImpl exception:", (Throwable)e);
            return;
        }
        LOG.info("===HsbsExternalServiceImpl.queryAllFileBoByEmp result:{}", (Object)invokeResult);
        if (CollectionUtils.isEmpty((Map)invokeResult) && Boolean.FALSE.equals(invokeResult.get("success"))) {
            return;
        }
        Map data = (Map)invokeResult.get("data");
        Map entityNameMap = (Map)data.get("entityName");
        List fileList = (List)data.get("file");
        HashMap empFileListMap = new HashMap(2);
        if (!CollectionUtils.isEmpty((Collection)fileList)) {
            for (Map map : fileList) {
                ArrayList fileInfoList = new ArrayList(2);
                for (Map.Entry entity : entityNameMap.entrySet()) {
                    List subFileInfoList = (List)map.get(entity.getKey());
                    if (CollectionUtils.isEmpty((Collection)subFileInfoList)) continue;
                    for (Map fileInfo : subFileInfoList) {
                        fileInfo.put("fileName", entity.getValue());
                        fileInfo.put("fileVal", entity.getKey());
                    }
                    fileInfoList.addAll(subFileInfoList);
                }
                empFileListMap.put((Long)map.get("employee_id"), fileInfoList);
            }
        }
        for (RollbackValidDto dto : dtoList) {
            if (CollectionUtils.isEmpty((Collection)((Collection)empFileListMap.get(dto.getEmployeeId())))) continue;
            dto.setSwcList((List)empFileListMap.get(dto.getEmployeeId()));
            dto.setIsValid("0");
            dto.setIsValidMsg(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u85aa\u916c\u76f8\u5173\u6863\u6848\u3002", (String)"HpfsRollbackServiceHelper_6", (String)"hr-hpfs-business", (Object[])new Object[0]));
        }
    }

    public static List<RollbackValidDto> validHR(List<RollbackValidDto> dtoList) {
        DynamicObject devConfig = DevParamConfigRepository.queryConfigByBusinessKey("hpfs_rollbackvalid_enable");
        if (devConfig == null || !devConfig.getBoolean("businessvalue")) {
            return dtoList;
        }
        ArrayList<RollbackValidDto> res = new ArrayList<RollbackValidDto>(dtoList.size());
        Map<Long, Long> billActionMap = HpfsRollbackValidHelper.formatEmployeeActionMap(dtoList);
        Map<Long, Map<Long, Map<Long, List<DynamicObject>>>> validationsMap = HpfsRollbackValidHelper.getCrossValidations(billActionMap);
        Set<Long> employIds = dtoList.stream().map(RollbackValidDto::getEmployeeId).collect(Collectors.toSet());
        Map<Long, List<DynamicObject>> employeeRecordMap = HpfsRollbackValidHelper.getRecordByEmpIds(employIds);
        dtoList.forEach(validDto -> HpfsRollbackValidHelper.crossValidateBatchExecuteSingle(validDto, employeeRecordMap, validationsMap, res));
        return res;
    }

    public static void crossValidateBatchExecuteSingle(RollbackValidDto validDto, Map<Long, List<DynamicObject>> employeeRecordMap, Map<Long, Map<Long, Map<Long, List<DynamicObject>>>> validationsMap, List<RollbackValidDto> res) {
        Long billId = validDto.getBillId();
        Long chgActionId = validDto.getChgaction();
        List<DynamicObject> records = employeeRecordMap.get(validDto.getEmployeeId());
        Map<Long, List<DynamicObject>> validations = validationsMap.get(billId).get(chgActionId);
        String validMsg = validDto.getIsValidMsg();
        if (CollectionUtils.isEmpty(records) || CollectionUtils.isEmpty(validations)) {
            validDto.setCode("200");
            validDto.setMsg("success");
            if (HRStringUtils.isEmpty((String)validMsg)) {
                validDto.setIsValidMsg("success");
            }
            validDto.setHrList(new ArrayList<HrValidDto>(1));
            res.add(validDto);
            return;
        }
        validDto.setIsValid("0");
        String msg = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4e8b\u52a1\u53d8\u52a8\u4ea4\u53c9\u914d\u7f6e\u3002", (String)"HpfsRollbackServiceHelper_9", (String)"hr-hpfs-business", (Object[])new Object[0]);
        validMsg = HRStringUtils.isEmpty((String)validMsg) ? msg : validMsg + ";" + msg;
        validDto.setIsValidMsg(validMsg);
        records.forEach(record -> HpfsRollbackValidHelper.crossValidateExecuteSingle(record, validations, validDto));
        res.add(validDto);
    }

    public static void crossValidateExecuteSingle(DynamicObject record, Map<Long, List<DynamicObject>> validationMap, RollbackValidDto validDto) {
        DynamicObject depEmpIdEntry;
        String dataStatus;
        Long committedActionId = record.getLong("chgaction.id");
        List<DynamicObject> valids = validationMap.get(committedActionId);
        if (CollectionUtils.isEmpty(valids)) {
            String warnInfo = String.format(Locale.ROOT, "CHG_WARN crossValidateExecuteSingle valid_without_rules crossValidateParam :%s", SerializationUtils.toJsonString((Object)validDto));
            LOG.warn(warnInfo);
            return;
        }
        DynamicObject validRule = valids.get(0);
        List<String> statusList = Arrays.asList(validRule.getString("crossstatus").split(","));
        if (!statusList.contains(dataStatus = record.getString("datastatus"))) {
            String warnInfo = String.format(Locale.ROOT, "CHG_WARN crossValidateExecuteSingle record_status %s not_existed_rule crossValidateParam :%s", dataStatus, SerializationUtils.toJsonString((Object)validDto));
            LOG.warn(warnInfo);
            return;
        }
        String orgValidType = validRule.getString("orgrelvalidtype");
        if (HRStringUtils.equals((String)orgValidType, (String)ValidateOrgEnum.VALIDATE_APPOINTED_ORG.getCode()) && (depEmpIdEntry = (DynamicObject)record.getDynamicObjectCollection("entryentity").stream().filter(row -> HRStringUtils.equals((String)row.getString("chgentity.number"), (String)"hrpi_depemp") && row.getLong("idbefore") == validDto.getDepempId().longValue()).findAny().orElse(null)) == null) {
            String warnInfo = String.format(Locale.ROOT, "CHG_WARN crossValidateExecuteSingle valid_on_org_without_equaled_depEmpId crossValidateParam : %s", SerializationUtils.toJsonString((Object)validDto));
            LOG.warn(warnInfo);
            return;
        }
        RollbackValidDto.format(record, validRule, validDto);
    }

    public static Map<Long, Map<Long, Map<Long, List<DynamicObject>>>> getCrossValidations(Map<Long, Long> billActionMap) {
        List actionIdsAll = billActionMap.values().stream().distinct().collect(Collectors.toList());
        QFilter uncommitted = new QFilter("uncommittedtrans", "in", actionIdsAll).and(new QFilter("enable", "=", (Object)"1"));
        DynamicObject[] validations = RepositoryUtils.queryDynamicObjects("hpfs_rollbackvalid", selectFields, uncommitted);
        Map<Long, Map> actionValidationMap = Arrays.stream(validations).collect(Collectors.groupingBy(row -> row.getLong("uncommittedtrans.id"))).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, row -> ((List)row.getValue()).stream().collect(Collectors.groupingBy(record -> record.getLong("committedtrans.id")))));
        ArrayList<Long> bills = new ArrayList<Long>(billActionMap.keySet());
        return bills.stream().collect(Collectors.toMap(row -> row, row -> {
            Long actionId = (Long)billActionMap.get(row);
            if (actionId == null || actionId == 0L) {
                return Collections.emptyMap();
            }
            HashMap<Long, Map> billAction = new HashMap<Long, Map>(actionValidationMap.size());
            billAction.put(actionId, actionValidationMap.get(actionId) == null ? Collections.emptyMap() : (Map)actionValidationMap.get(actionId));
            return billAction;
        }));
    }

    public static Map<Long, Long> formatEmployeeActionMap(List<RollbackValidDto> dtoList) {
        return dtoList.stream().collect(Collectors.toMap(RollbackValidDto::getBillId, RollbackValidDto::getChgaction, (oldVal, newVal) -> newVal));
    }

    public static Map<Long, List<Long>> getEmployeeIdsByMid(Set<Long> employeeIds) {
        HRBaseServiceHelper employeeHelper = new HRBaseServiceHelper("hrpi_employee");
        DynamicObject[] employees = employeeHelper.queryOriginalArray("id,mid", new QFilter[]{new QFilter("id", "in", employeeIds)});
        if (employees == null || employees.length == 0) {
            return employeeIds.stream().collect(Collectors.toMap(row -> row, Collections::singletonList));
        }
        Map<Long, Long> employeeMidMap = Arrays.stream(employees).collect(Collectors.toMap(row -> row.getLong("id"), row -> row.getLong("mid")));
        List mids = Arrays.stream(employees).map(row -> row.getLong("mid")).distinct().collect(Collectors.toList());
        DynamicObject[] employeeListByMid = employeeHelper.query("id,boid,mid", new QFilter[]{new QFilter("mid", "in", mids), new QFilter("iscurrentversion", "=", (Object)"1"), new QFilter("datastatus", "=", (Object)"1")});
        if (employeeListByMid == null || employeeListByMid.length == 0) {
            return employeeIds.stream().collect(Collectors.toMap(row -> row, Collections::singletonList));
        }
        Map<Long, List> midEmployeeIdsMap = Arrays.stream(employeeListByMid).collect(Collectors.groupingBy(row -> row.getLong("mid"))).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, row -> ((List)row.getValue()).stream().map(value -> value.getLong("boid")).collect(Collectors.toList())));
        return employeeIds.stream().collect(Collectors.toMap(row -> row, row -> {
            List<Long> employeeIdsByMid = (List<Long>)midEmployeeIdsMap.get(employeeMidMap.get(row));
            return CollectionUtils.isEmpty((Collection)employeeIdsByMid) ? Collections.singletonList(row) : employeeIdsByMid;
        }));
    }

    public static Map<Long, List<DynamicObject>> getRecordByEmpIds(Set<Long> employeeSet) {
        HRBaseServiceHelper recordHelper = new HRBaseServiceHelper("hpfs_chgrecord");
        Map<Long, List<Long>> empRecordId = HpfsRollbackValidHelper.getEmpRecordId(employeeSet);
        List recordIds = empRecordId.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
        DynamicObject[] records = recordHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", recordIds), new QFilter("datastatus", "in", Arrays.asList(ChgRecordStatusEnum.SUBMITTED.getCode(), ChgRecordStatusEnum.TO_EFFECT.getCode(), ChgRecordStatusEnum.CHANGED.getCode()))});
        if (records == null || records.length == 0) {
            return Collections.emptyMap();
        }
        Map<Long, DynamicObject> recordMap = Arrays.stream(records).collect(Collectors.toMap(row -> row.getLong("id"), row -> row));
        return empRecordId.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, row -> ((List)row.getValue()).stream().map(recordMap::get).filter(Objects::nonNull).collect(Collectors.toList())));
    }

    public static Map<Long, List<Long>> getEmpRecordId(Set<Long> employeeSet) {
        HRBaseServiceHelper recordEntryHelper = new HRBaseServiceHelper("hpfs_chgrecordentry");
        Map<Long, List<Long>> employeeIdsByMidMap = HpfsRollbackValidHelper.getEmployeeIdsByMid(employeeSet);
        List employeesByMid = employeeIdsByMidMap.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
        QFilter filter = new QFilter("chgentity", "=", (Object)"hrpi_employee").and(new QFilter("idbefore", "in", employeesByMid));
        DynamicObject[] recordEntry = recordEntryHelper.queryOriginalArray("chgrecord, idbefore", new QFilter[]{filter});
        if (recordEntry == null || recordEntry.length == 0) {
            return Collections.emptyMap();
        }
        Map<Long, List> recordEntryMap = Arrays.stream(recordEntry).collect(Collectors.groupingBy(row -> row.getLong("idbefore"))).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, row -> ((List)row.getValue()).stream().map(entry -> entry.getLong("chgrecord")).collect(Collectors.toList())));
        HashMap<Long, List<Long>> employeeRecordMap = new HashMap<Long, List<Long>>(employeeSet.size());
        employeeSet.forEach(row -> {
            List employeeIdsByMid = (List)employeeIdsByMidMap.get(row);
            if (employeeIdsByMid == null) {
                String warnInfo = String.format(Locale.ROOT, "CHG_WARN getRecordEntry employeeIdsByMid is null. employeeId : %s", row);
                LOG.warn(warnInfo);
                return;
            }
            ArrayList recordIds = new ArrayList(16);
            employeeIdsByMid.forEach(employeeId -> {
                if (recordEntryMap.get(employeeId) != null) {
                    recordIds.addAll((Collection)recordEntryMap.get(employeeId));
                }
            });
            if (!CollectionUtils.isEmpty(recordIds)) {
                employeeRecordMap.put((Long)row, recordIds);
            }
        });
        return employeeRecordMap;
    }

    public static Map<String, Object> buildRespon(String code, Object data) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("code", code);
        map.put("data", data);
        return map;
    }
}

