/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.service.personflow.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hpfs.business.domain.repository.perchg.ChgRecordRepository;
import kd.hr.hpfs.business.domain.repository.personflow.PersonFlowRepository;
import kd.hr.hpfs.business.service.personflow.IPersonFlowService;
import kd.hr.hpfs.common.enums.FlowTypeEnum;
import kd.hr.hpfs.common.utils.ObjectUtils;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgModeEnum;
import kd.sdk.hr.hpfs.business.personflow.ICustomPersonFlowService;

public class PersonFlowServiceImpl
implements IPersonFlowService {
    private static final Log LOG = LogFactory.getLog(PersonFlowServiceImpl.class);
    private static final ThreadPool THREAD_POOL = ThreadPools.newCachedThreadPool((String)"PersonFlowServiceImpl", (int)5, (int)1000);
    private static final Set<String> MUST_INPUT_SET;

    @Override
    public Tuple<Boolean, String> generatePersonFlow(Map<String, Object> params) {
        LOG.info(MessageFormat.format("PersonFlowServiceImpl.generatePersonFlow param:{0}", params));
        Tuple<Boolean, String> checkResult = this.checkParams(params);
        if (!((Boolean)checkResult.item1).booleanValue()) {
            LOG.info(MessageFormat.format("PersonFlowServiceImpl.generatePersonFlow param check fail,error:{0}", checkResult.item2));
            return checkResult;
        }
        DynamicObject recordDy = ChgRecordRepository.queryOneById("id,billsource,bill,entryentity.chgentity,entryentity.idbefore,entryentity.idafter,entryentity.chgmode,,entryentity.flowtype", HRJSONUtils.getLongValOfCustomParam((Object)params.get("chgRecord")));
        if (recordDy == null) {
            String errorMsg = "Can not found the chg record";
            LOG.info(MessageFormat.format("PersonFlowServiceImpl.generatePersonFlow param check fail,error:{0}", errorMsg));
            return Tuple.create((Object)Boolean.FALSE, (Object)errorMsg);
        }
        DynamicObjectCollection dyCols = this.createPersonFlow(params, recordDy);
        if (dyCols.size() == 0) {
            LOG.info("PersonFlowServiceImpl.generatePersonFlow dyCols size is zero, please check the flowtype, recordId is {}", (Object)recordDy.getString("id"));
        } else {
            THREAD_POOL.execute(() -> this.completePersonFlow((DynamicObject[])dyCols.toArray((Object[])new DynamicObject[dyCols.size()]), true), RequestContext.get());
        }
        return Tuple.create((Object)Boolean.TRUE, null);
    }

    @Override
    public void completePersonFlow() {
        DynamicObject[] dys = PersonFlowRepository.query("id,flowtype,flowtime,flowyear,flowmonth,flowquarter,flowweek,depemp,person,employee,cmpemp,managescope,adminorg,orglonghisid,adminorghis,orglongnumber,completionresult,enterprise,laborreltype,exceptionstatus,personname,personnumber", new QFilter[]{new QFilter("completionresult", "!=", (Object)"0")});
        if (dys.length < 1) {
            return;
        }
        this.completePersonFlow(dys, false);
    }

    private Tuple<Boolean, String> checkParams(Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return Tuple.create((Object)Boolean.FALSE, (Object)"The parameter is empty");
        }
        for (String field : MUST_INPUT_SET) {
            if (!ObjectUtils.isEmpty((Object)params.get(field))) continue;
            return Tuple.create((Object)Boolean.FALSE, (Object)MessageFormat.format("Can not found the parameter {0}", field));
        }
        Long recordId = HRJSONUtils.getLongValOfCustomParam((Object)params.get("chgRecord"));
        DynamicObject[] dys = PersonFlowRepository.query("id", new QFilter[]{new QFilter("chgRecord", "=", (Object)recordId)});
        if (dys != null && dys.length > 0) {
            return Tuple.create((Object)Boolean.FALSE, (Object)MessageFormat.format("Already exists the chgRecord:{0}", recordId));
        }
        return Tuple.create((Object)Boolean.TRUE, null);
    }

    private DynamicObjectCollection createPersonFlow(Map<String, Object> params, DynamicObject recordDy) {
        DynamicObjectCollection entry = recordDy.getDynamicObjectCollection("entryentity");
        Object flowTime = params.get("flowTime");
        Object chgAction = params.get("chgAction");
        Object chgCategory = params.get("chgCategory");
        Object chgRecord = params.get("chgRecord");
        DynamicObjectCollection personFlowCols = new DynamicObjectCollection();
        entry.stream().filter(item -> "hrpi_depemp".equals(item.getString("chgentity.number")) && !StringUtils.isEmpty((Object)item.getString("flowtype")) && !"0".equals(item.getString("flowtype"))).forEach(item -> {
            DynamicObject dy = PersonFlowRepository.generate();
            dy.set("creator", (Object)RequestContext.get().getCurrUserId());
            dy.set("flowtime", flowTime);
            dy.set("chgaction", chgAction);
            dy.set("chgcategory", chgCategory);
            dy.set("chgrecord", chgRecord);
            dy.set("depemp", (Object)this.getDepEmp((DynamicObject)item));
            dy.set("billsource", recordDy.get("billsource"));
            dy.set("bill", recordDy.get("bill"));
            dy.set("flowtype", item.get("flowtype"));
            personFlowCols.add((Object)dy);
        });
        if (personFlowCols.size() > 0) {
            HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, ICustomPersonFlowService.class, (String)"kd.sdk.hr.hpfs.business.personflow.ICustomPersonFlowService", null);
            hrPluginProxy.callReplace(hrPlugin -> {
                hrPlugin.setCustomField(personFlowCols, recordDy, params);
                return null;
            });
            PersonFlowRepository.save(personFlowCols);
        }
        return personFlowCols;
    }

    private Long getDepEmp(DynamicObject dy) {
        if (ChgModeEnum.ADD_NEW.getChgMode().equals(dy.getString("chgmode"))) {
            return dy.getLong("idafter");
        }
        return dy.getLong("idbefore");
    }

    private void completePersonFlow(DynamicObject[] dyCols, boolean isInit) {
        try {
            String depEmpKey = this.getDepEmpIdKey(isInit);
            ThreeTuple<List<Long>, Map<Long, Integer>, Map<Long, Integer>> countFlowRecord = this.countFlowRecord(dyCols, depEmpKey);
            List empList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIDepempService", (String)"listDataEmpOrgrelDys", (Object[])new Object[]{countFlowRecord.item1});
            HashMap empMap = Maps.newHashMapWithExpectedSize((int)empList.size());
            ArrayList employeeList = Lists.newArrayListWithExpectedSize((int)dyCols.length);
            empList.forEach(item -> {
                empMap.put(HRJSONUtils.getLongValOfCustomParam((Object)item.get("depemp.id")), item);
                employeeList.add(item.getLong("employee.id"));
            });
            List empentrelList = (List)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIEmployeeService", (String)"listBatchPropEmployeeAttachs", (Object[])new Object[]{employeeList, "employee,enterprise", "hrpi_empentrel"});
            HashMap empentrelMap = Maps.newHashMapWithExpectedSize((int)empentrelList.size());
            empentrelList.forEach(item -> empentrelMap.put(HRJSONUtils.getLongValOfCustomParam(item.get("employee")), item));
            for (DynamicObject dy : dyCols) {
                Map empentrelInfo;
                Date flowTime = dy.getDate("flowtime");
                dy.set("flowyear", (Object)HRDateTimeUtils.getYear((Date)flowTime));
                dy.set("flowquarter", (Object)HRDateTimeUtils.getQuarter((Date)flowTime));
                dy.set("flowmonth", (Object)HRDateTimeUtils.getMonth((Date)flowTime));
                dy.set("flowweek", (Object)HRDateTimeUtils.getWeek((Date)flowTime));
                Long demEmpId = dy.getLong(depEmpKey);
                DynamicObject empInfo = (DynamicObject)empMap.get(demEmpId);
                this.setPersonInfo(empInfo, dy);
                Map map = empentrelInfo = empInfo == null ? null : (Map)empentrelMap.get(empInfo.get("employee.id"));
                if (empentrelInfo != null) {
                    dy.set("enterprise", empentrelInfo.get("enterprise"));
                }
                this.setExceptionStatus((Map)countFlowRecord.item2, (Map)countFlowRecord.item3, dy, depEmpKey);
                dy.set("completionresult", (Object)"0");
            }
        }
        catch (Exception exception) {
            LOG.error("PersonFlowServiceImpl.completePersonFlow fail", (Throwable)exception);
            for (DynamicObject dy : dyCols) {
                dy.set("completionresult", (Object)"1");
            }
        }
        PersonFlowRepository.update(dyCols);
    }

    private void setPersonInfo(DynamicObject empInfo, DynamicObject dy) {
        if (empInfo == null) {
            return;
        }
        dy.set("person", empInfo.get("person.id"));
        dy.set("personname", empInfo.get("person.name"));
        dy.set("personnumber", empInfo.get("person.number"));
        dy.set("employee", empInfo.get("employee.id"));
        dy.set("cmpemp", empInfo.get("cmpemp.id"));
        dy.set("managescope", empInfo.get("cmpemp.managingscope.id"));
        dy.set("laborreltype", empInfo.get("employee.laborreltype.id"));
        this.setAdminOrgInfo(HRJSONUtils.getLongValOfCustomParam((Object)empInfo.get("adminorg.id")), dy);
    }

    private ThreeTuple<List<Long>, Map<Long, Integer>, Map<Long, Integer>> countFlowRecord(DynamicObject[] dyCols, String depEmpKey) {
        DynamicObject[] dys;
        ArrayList demEmpIds = Lists.newArrayListWithExpectedSize((int)dyCols.length);
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)dyCols.length);
        HashMap<Long, Integer> flowInCountMap = new HashMap<Long, Integer>(16);
        HashMap<Long, Integer> flowOutCountMap = new HashMap<Long, Integer>(16);
        Arrays.stream(dyCols).forEach(item -> {
            demEmpIds.add(item.getLong(depEmpKey));
            ids.add(item.getLong("id"));
        });
        for (DynamicObject dy : dys = PersonFlowRepository.query("id,flowtype,depemp", new QFilter[]{new QFilter("depemp", "in", (Object)demEmpIds).and(new QFilter("id", "not in", (Object)ids))})) {
            this.handleFlowCount(flowInCountMap, flowOutCountMap, dy, "depemp.id");
        }
        for (DynamicObject dy : dyCols) {
            if (!FlowTypeEnum.IN.getValue().equals(dy.getString("flowtype"))) continue;
            this.addCount(flowInCountMap, dy.getLong(depEmpKey));
        }
        return new ThreeTuple((Object)demEmpIds, flowInCountMap, flowOutCountMap);
    }

    private void handleFlowCount(Map<Long, Integer> flowInCountMap, Map<Long, Integer> flowOutCountMap, DynamicObject dy, String depEmpKey) {
        String type = dy.getString("flowtype");
        Long depEmpId = dy.getLong(depEmpKey);
        if (FlowTypeEnum.IN.getValue().equals(type)) {
            this.addCount(flowInCountMap, depEmpId);
        } else {
            this.addCount(flowOutCountMap, depEmpId);
        }
    }

    private void addCount(Map<Long, Integer> flowCountMap, Long depEmpId) {
        Integer count = flowCountMap.get(depEmpId);
        if (count == null) {
            flowCountMap.put(depEmpId, 1);
        } else {
            count = count + 1;
            flowCountMap.put(depEmpId, count);
        }
    }

    private void setExceptionStatus(Map<Long, Integer> flowInCountMap, Map<Long, Integer> flowOutCountMap, DynamicObject dy, String depEmpKey) {
        String type = dy.getString("flowtype");
        Long depEmpId = dy.getLong(depEmpKey);
        String exceptionStatus = "0";
        if (FlowTypeEnum.OUT.getValue().equals(type)) {
            this.addCount(flowOutCountMap, depEmpId);
            Integer inCount = flowInCountMap.get(depEmpId);
            Integer outCount = flowOutCountMap.get(depEmpId);
            if (inCount == null || inCount < outCount) {
                exceptionStatus = "1";
            }
        }
        dy.set("exceptionstatus", (Object)exceptionStatus);
    }

    private void setAdminOrgInfo(Long adminOrgId, DynamicObject dy) {
        dy.set("adminorg", (Object)adminOrgId);
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(adminOrgId);
        Map result = (Map)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSBatchAdminOrgStructQueryService", (String)"adminOrgStructQuery", (Object[])new Object[]{ids, dy.getDate("flowtime"), Boolean.TRUE});
        Map infoMap = (Map)result.get(String.valueOf(adminOrgId));
        if (infoMap != null) {
            dy.set("adminorghis", infoMap.get("id"));
            dy.set("orglonghisid", infoMap.get("adminorgstructvid"));
            dy.set("orglongnumber", infoMap.get("longnumber"));
        }
    }

    private String getDepEmpIdKey(boolean isInit) {
        if (isInit) {
            return "depemp";
        }
        return "depemp.id";
    }

    static {
        HashSet set = Sets.newHashSet();
        set.add("flowTime");
        set.add("chgAction");
        set.add("chgCategory");
        set.add("chgRecord");
        MUST_INPUT_SET = Collections.unmodifiableSet(set);
    }
}

