/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.service.relatiolservice;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.perchg.parser.ParserResult;
import kd.hr.hpfs.business.service.relatiolservice.inst.ReportRelationChangeService;
import kd.hr.hpfs.business.service.relatiolservice.inst.WorkRoleChangeService;
import kd.hr.hpfs.business.service.relatiolservice.repository.HelperRepository;
import kd.hr.hpfs.common.model.ChangeModel;

public class ChangePersonRelService {
    private static final Log logger = LogFactory.getLog(ChangePersonRelService.class);
    protected ChangeModel changeModel;

    private ChangePersonRelService() {
    }

    public static ChangePersonRelService getInstance() {
        return ChangePersonRelServiceHolder.INSTANCE;
    }

    public void setChangeModel(ChangeModel changeModel) {
        this.changeModel = changeModel;
    }

    public ChangePersonRelService(ChangeModel changeModel) {
        this.changeModel = changeModel;
    }

    public Map<String, DynamicObjectCollection> doChangePersonRelation(ChangeModel changeModel) {
        HashMap<String, DynamicObjectCollection> retMap = new HashMap<String, DynamicObjectCollection>(16);
        boolean special = changeModel.personSpecial();
        logger.info(MessageFormat.format("doChangePersonRelation->{0}->{1}", changeModel, special));
        DynamicObject empDy = changeModel.getEmpDy();
        if (empDy == null) {
            logger.info("doChangePersonRelationEmpty", (Object)changeModel);
            return null;
        }
        if (!"1".equals(changeModel.getOperationType())) {
            Long personId = empDy.getLong("person.id");
            DynamicObject[] superiorByPersonId = HelperRepository.getSuperiorByPersonId("person", personId);
            boolean bl = special = superiorByPersonId != null && superiorByPersonId.length != 0;
            if (!special) {
                DynamicObject[] superPerDy = HelperRepository.getSuperiorByPersonId("superior", personId);
                special = superPerDy != null && superPerDy.length != 0;
            }
            logger.info(MessageFormat.format("doChangePersonRelationLose->{0}->{1}", personId, special));
        }
        if (special) {
            return new ReportRelationChangeService().setEntityName("hrpi_empsuprel").chgLoseOrEffect(changeModel);
        }
        if (changeModel.getEmpDy() != null) {
            return new WorkRoleChangeService().setEntityName("hrpi_personrolerel").chgLoseOrEffect(changeModel);
        }
        return retMap;
    }

    public void doChangePositionByDarkPosition(List<ParserResult> parserResults) {
        DynamicObject depeRel = parserResults.stream().filter(row -> HRStringUtils.equals((String)((String)row.getParserParam().get("entityName")), (String)"hrpi_depemp")).map(row -> (DynamicObject)row.getParserParam().get("hisDy")).findFirst().orElse(null);
        DynamicObject empRel = parserResults.stream().filter(row -> HRStringUtils.equals((String)((String)row.getParserParam().get("entityName")), (String)"hrpi_empposorgrel")).map(row -> (DynamicObject)row.getParserParam().get("hisDy")).findFirst().orElse(null);
        if (!HRObjectUtils.isEmpty((Object)empRel) && !HRObjectUtils.isEmpty((Object)depeRel)) {
            this.setPositionId(empRel, depeRel);
        }
    }

    private void setPositionId(DynamicObject empDy, DynamicObject depempDy) {
        DynamicObject darkPositionDy = empDy.getDynamicObject("darkposition");
        DynamicObject positionDy = empDy.getDynamicObject("position");
        if (darkPositionDy != null && !HRObjectUtils.isEmpty((Object)darkPositionDy) && HRObjectUtils.isEmpty((Object)positionDy)) {
            empDy.set("position", (Object)darkPositionDy);
            depempDy.set("position", (Object)darkPositionDy);
        }
    }

    private static class ChangePersonRelServiceHolder {
        private static final ChangePersonRelService INSTANCE = new ChangePersonRelService();

        private ChangePersonRelServiceHolder() {
        }
    }
}

