/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.service.schedule;

import java.text.MessageFormat;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.BOSRuntime;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.RouteMode;
import kd.bos.schedule.api.ScheduleMsgInfo;
import kd.bos.schedule.dao.dbImpl.DbJobOperation;
import kd.bos.schedule.executor.JobClient;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hpfs.business.perchg.repository.ScheduleRepository;
import kd.hr.hpfs.business.perchg.repository.TaskLogRepository;

public class ScheduleExecutor {
    private static final Log LOGGER = LogFactory.getLog(ScheduleExecutor.class);

    public static void dispatch(String scheduleId) {
        ScheduleExecutor.dispatch(ScheduleRepository.getSchedule(scheduleId));
    }

    public static void dispatch(DynamicObject schedule) {
        if (null == schedule) {
            throw new RuntimeException("Schedule isn't exist");
        }
        String number = schedule.getString("number");
        LOGGER.info("Ready to schedule:{}. Thread:{}", (Object)number, (Object)Thread.currentThread().toString());
        DLock dlock = DLock.create((String)number);
        dlock.lock();
        try {
            if (!TaskLogRepository.isSchduled(schedule)) {
                ScheduleExecutor.dispatchLowConcurrent(schedule);
                return;
            }
            LOGGER.info("Schedule:{} is Scheduled. Thread:{}", (Object)number, (Object)Thread.currentThread().toString());
        }
        finally {
            dlock.unlock();
        }
    }

    public static void dispatchLowConcurrent(DynamicObject schedule) {
        DynamicObject scheduleJob = schedule.getDynamicObject("job");
        DynamicObjectCollection jobEntry = schedule.getDynamicObjectCollection("entryentity");
        String scheduleId = schedule.getPkValue().toString();
        ScheduleMsgInfo scheduleMsgInfo = ScheduleExecutor.buildScheduleMsgInfo(schedule);
        StringBuilder errMsgBuilder = new StringBuilder();
        if (jobEntry != null && jobEntry.size() > 0) {
            ScheduleExecutor.dispatchJobEntry(jobEntry, scheduleId, scheduleMsgInfo, errMsgBuilder);
        } else if (scheduleJob != null) {
            JobInfo jobInfo = ScheduleService.getInstance().getObjectFactory().getJobDao().get(String.valueOf(scheduleJob.getPkValue()));
            ScheduleExecutor.dispatchJob(scheduleId, scheduleMsgInfo, jobInfo);
        } else {
            throw new RuntimeException(MessageFormat.format("No schedule job in {0}", schedule.getString("number")));
        }
        if (StringUtils.isNotBlank((CharSequence)errMsgBuilder.toString())) {
            LOGGER.error(errMsgBuilder.toString());
        }
    }

    private static void dispatchJobEntry(DynamicObjectCollection jobEntry, String scheduleId, ScheduleMsgInfo scheduleMsgInfo, StringBuilder errMsgBuilder) {
        for (DynamicObject dynamicObject : jobEntry) {
            DynamicObject job = dynamicObject.getDynamicObject("jobnumber");
            if (job == null) continue;
            String jobId = (String)job.getPkValue();
            JobInfo jobInfo = ScheduleService.getInstance().getObjectFactory().getJobDao().get(jobId);
            String appId = jobInfo.getAppId();
            if (!ScheduleExecutor.isExistAppNum(appId)) {
                errMsgBuilder.append(MessageFormat.format("app {0} isn't exist", appId));
            }
            ScheduleExecutor.dispatchJob(scheduleId, scheduleMsgInfo, jobInfo);
        }
    }

    private static void dispatchJob(String scheduleId, ScheduleMsgInfo scheduleMsgInfo, JobInfo jobInfo) {
        jobInfo.setScheduleId(scheduleId);
        jobInfo.setScheduleMsgInfo(scheduleMsgInfo);
        ScheduleExecutor.dispatchJob(jobInfo);
    }

    private static ScheduleMsgInfo buildScheduleMsgInfo(DynamicObject schedule) {
        ScheduleMsgInfo msgInfo = new ScheduleMsgInfo();
        Object schprincipal = schedule.get("schprincipal");
        if (schprincipal == null) {
            msgInfo.setSchPrincipal(0L);
        } else {
            DynamicObject schp = (DynamicObject)schprincipal;
            msgInfo.setSchPrincipal(((Long)schp.getPkValue()).longValue());
        }
        Object msgreceiver = schedule.get("msgreceiver");
        if (msgreceiver == null) {
            msgInfo.setMsgreceiver(0L);
        } else {
            DynamicObject msgr = (DynamicObject)msgreceiver;
            msgInfo.setMsgreceiver(((Long)msgr.getPkValue()).longValue());
        }
        msgInfo.setFailNotify(schedule.getBoolean("sfailnotify"));
        msgInfo.setSuccessNotify(schedule.getBoolean("ssuccessnotify"));
        msgInfo.setNotifyType(schedule.getString("snotifytype"));
        msgInfo.setMsgContent(schedule.getString("smsgcontent"));
        msgInfo.setTimeOut(schedule.getBoolean("stimeout"));
        return msgInfo;
    }

    private static void dispatchJob(JobInfo jobInfo) {
        String appId;
        if (StringUtils.isBlank((CharSequence)jobInfo.getAppId())) {
            jobInfo.setAppId("bos");
        }
        if (!ScheduleExecutor.isExistAppNum(appId = jobInfo.getAppId())) {
            LOGGER.error(MessageFormat.format("app {0} isn't exist", appId));
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"bos", (CharSequence)appId) || BOSRuntime.isBOSApp((String)appId)) {
            jobInfo.setAppId("bos");
        }
        long groupId = 0L;
        jobInfo.setGroupId(groupId);
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setExecuteTime(1);
        if (jobInfo.getRetryTime() > 0 || !jobInfo.getRouteMode().equals((Object)RouteMode.RAMDOM)) {
            groupId = DbJobOperation.getGroupMax();
            jobInfo.setGroupId(groupId);
        }
        jobInfo.setFromScheduler(true);
        LOGGER.info("DispatchJob:{}", (Object)jobInfo);
        JobClient.dispatchToMaster((JobInfo)jobInfo);
    }

    private static boolean isExistAppNum(String appNum) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"bos", (CharSequence)appNum)) {
            return true;
        }
        return !BusinessDataServiceHelper.loadFromCache((String)"bos_devportal_bizapp", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)appNum)}).isEmpty();
    }
}

