/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.task;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hpfs.business.domain.repository.RepositoryUtils;

public class RepairBackActionTask
extends AbstractTask {
    private final String selProp = "id, name,description, chgcategory, backaction.id";
    private final String SCH_SCHEDULE = "sch_schedule";
    private final String SCH_SCHEDULE_ID = "3FEPGDJ0PZAV";
    private final Log LOG = LogFactory.getLog(RepairBackActionTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        QFilter filter = new QFilter("backaction.id", "=", (Object)0L);
        DynamicObject[] chgActions = RepositoryUtils.queryDynamicObjects("hpfs_chgaction", "id, name,description, chgcategory, backaction.id", filter);
        if (chgActions != null && chgActions.length > 0) {
            HRBaseServiceHelper actionHelper = new HRBaseServiceHelper("hbss_action");
            for (DynamicObject chgAction : chgActions) {
                DynamicObject category = chgAction.getDynamicObject("chgcategory");
                String name = chgAction.getString("name");
                String number = chgAction.getString("number");
                String desc = chgAction.getString("description");
                String backMsg = ResManager.loadKDString((String)"\u64a4\u56de", (String)"HpfsRollbackServiceHelper_8", (String)"hr-hpfs-business", (Object[])new Object[0]);
                DynamicObject backDy = actionHelper.generateEmptyDynamicObject();
                backDy.set("name", (Object)(name + "_" + backMsg));
                backDy.set("number", (Object)(number + "_BACK"));
                backDy.set("actiontype", (Object)category.getLong("actiontype_id"));
                if (!HRObjectUtils.isEmpty((Object)desc)) {
                    backDy.set("description", (Object)(desc + "_" + backMsg));
                }
                backDy.set("status", (Object)"C");
                backDy.set("enable", (Object)"1");
                try {
                    Long backId = (Long)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSMsgService", (String)"saveActionDy", (Object[])new Object[]{backDy});
                    chgAction.set("backaction", (Object)backId);
                }
                catch (Exception exp) {
                    this.LOG.error("==IHRCSMsgService.saveActionDy error ==", (Throwable)exp);
                }
            }
            RepositoryUtils.updDynamicObjects("hpfs_chgaction", chgActions);
        }
        RepositoryUtils.disableTask("sch_schedule", "3FEPGDJ0PZAV");
    }
}

