/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.business.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class PersonGenericUtil {
    private static String YYYY_MM_DD = "yyyy-MM-dd";
    private static final Log LOGGER = LogFactory.getLog(PersonGenericUtil.class);

    public static long dateDiff(Date date1, Date date2) {
        if (null == date1 || null == date2) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u5b58\u5728\u7a7a\u503c\uff0c\u5bfc\u81f4\u6bd4\u8f83\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PersonGenericUtil_0", (String)"hr-hpfs-business", (Object[])new Object[0]));
        }
        SimpleDateFormat df = new SimpleDateFormat(YYYY_MM_DD);
        try {
            long time1 = df.parse(df.format(date1)).getTime();
            long time2 = df.parse(df.format(date2)).getTime();
            return time1 - time2;
        }
        catch (ParseException ex) {
            LOGGER.error("PersonGenericUtil ==> dateDiff exception :{}");
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PersonGenericUtil_1", (String)"hr-hpfs-business", (Object[])new Object[0]));
        }
    }

    public static String getAllProps(String actionEntityName, Set<String> ignoreKey) {
        if (ignoreKey != null && ignoreKey.size() == 0) {
            List<String> ignoreList = Arrays.asList("masterid", "creator", "createtime", "modifier", "modifytime", "disabler", "disabledate");
            ignoreKey.addAll(ignoreList);
        }
        String propString = null;
        try {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)actionEntityName);
            if (null != dataEntityType) {
                DataEntityPropertyCollection properties = dataEntityType.getProperties();
                ArrayList<String> propList = new ArrayList<String>(properties.size());
                for (IDataEntityProperty property : dataEntityType.getProperties()) {
                    if (!PersonGenericUtil.checkFields(property.getName(), ignoreKey) || HRStringUtils.isEmpty((String)property.getAlias())) continue;
                    propList.add(property.getName());
                }
                propString = String.join((CharSequence)",", propList);
            }
        }
        catch (Exception ex) {
            LOGGER.error("getDynamicPropString entitName:{} error:{}", (Object)actionEntityName, (Object)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5c5e\u6027\u5931\u8d25\u3002", (String)"DynamicTransformUtil_1", (String)"hrmp-hrpi-business", (Object[])new Object[0]));
        }
        return propString == null ? "id" : propString;
    }

    private static boolean checkFields(String propName, Set<String> ignoreSet) {
        return !ignoreSet.contains(propName) && !propName.endsWith("_id") && !propName.equals("multilanguagetext");
    }
}

