/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.opplugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hpfs.business.perchg.common.ChgLogHelper;
import kd.hr.hpfs.business.service.schedule.ScheduleExecutor;
import kd.hr.hpfs.opplugin.validators.ChgRetrtValidator;

public class ChgRetryOp
extends HRDataBaseOp {
    private static final Log LOGGER = LogFactory.getLog(ChgRetryOp.class);
    private static final String RETRY_SCHEDULE_ID = "2J/7B32Z0WGS";

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new ChgRetrtValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs evt) {
        evt.getFieldKeys().add("transactionstatus");
        evt.getFieldKeys().add("consumer");
        evt.getFieldKeys().add("params");
        evt.getFieldKeys().add("billid");
        evt.getFieldKeys().add("billsource");
        evt.getFieldKeys().add("appid");
        evt.getFieldKeys().add("chgrecord");
        evt.getFieldKeys().add("event");
        evt.getFieldKeys().add("errorlog");
        evt.getFieldKeys().add("rtparams");
        evt.getFieldKeys().add("transactionstatus");
        evt.getFieldKeys().add("consumeexetime");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs evt) {
        DynamicObject[] chgLogs;
        super.beginOperationTransaction(evt);
        for (DynamicObject chgLog : chgLogs = evt.getDataEntities()) {
            chgLog.set("transactionstatus", (Object)"3");
        }
        ChgLogHelper.save((DynamicObject[])chgLogs);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs evt) {
        DynamicObject[] chgLogs;
        for (DynamicObject chgLog : chgLogs = evt.getDataEntities()) {
            if (!chgLog.getString("transactionstatus").equals("3")) continue;
            ScheduleExecutor.dispatch((String)RETRY_SCHEDULE_ID);
            return;
        }
        LOGGER.info("No-chgLog-need-to-retry.");
    }
}

