/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.opplugin.op.guide;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class ChgGuideEnableService {
    public static final ChgGuideEnableService CHG_GUIDE_ENABLE_SERVICE = new ChgGuideEnableService();
    private static final Log LOGGER = LogFactory.getLog(ChgGuideEnableService.class);

    public static ChgGuideEnableService getInstance() {
        return CHG_GUIDE_ENABLE_SERVICE;
    }

    public void execute(List<Long> guideBaseIds, String enableStatus) {
        DynamicObject[] guideBases = new HRBaseServiceHelper("hpfs_chgguidebase").queryOriginalArray("id,chgaction,chgrule,modifytime,modifier", new QFilter[]{new QFilter("id", "in", guideBaseIds)});
        List<Long> chgActionIds = Arrays.stream(guideBases).map(guideBase -> guideBase.getLong("chgaction")).collect(Collectors.toList());
        List<Long> chgRuleIds = Arrays.stream(guideBases).map(guideBase -> guideBase.getLong("chgrule")).collect(Collectors.toList());
        Date modifyTime = guideBases[0].getDate("modifytime");
        Object modifier = guideBases[0].get("modifier");
        this.enableData("hpfs_chgaction", chgActionIds, modifyTime, modifier, enableStatus);
        this.enableData("hpfs_chgrule", chgRuleIds, modifyTime, modifier, enableStatus);
    }

    private void enableData(String entityName, List<Long> ids, Date modifyTime, Object modifier, String enableStatus) {
        DynamicObject[] dyns;
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityName);
        for (DynamicObject dyn : dyns = helper.query("id, enable, modifytime, modifier", new QFilter[]{new QFilter("id", "in", ids)})) {
            dyn.set("enable", (Object)enableStatus);
            dyn.set("modifytime", (Object)modifyTime);
            dyn.set("modifier", modifier);
        }
        helper.save(dyns);
    }
}

