/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.opplugin.test;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgParam;

public class HRInternToFormalBillSubmitEffectOp
extends HRDataBaseOp {
    private static final String HDM_REG_PERCHG_RESULT_QUEUE = "hdm_reg_perchg_result_queue";
    private static final String HPFS_PERCHG_QUEUE = "hpfs_perchg_queue";
    private static final HRBaseServiceHelper HR_BASE_SERVICE_HELPER = new HRBaseServiceHelper("hom_interntoformalbill");

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] originBills = e.getDataEntities();
        List pkS = Arrays.stream(originBills).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        DynamicObject[] billObjs = HR_BASE_SERVICE_HELPER.query("id,billno,effectdate,ermanfile,affaction", new QFilter[]{new QFilter("id", "in", pkS)});
        this.effect(billObjs[0]);
    }

    public void effect(DynamicObject billObj) {
        Long billId = billObj.getLong("id");
        PerChgParam perChgParam = new PerChgParam();
        perChgParam.setAppId("hprd");
        perChgParam.setUserId(Long.valueOf(1L));
        ArrayList<PerChgBizInfo> bizInfoList = new ArrayList<PerChgBizInfo>();
        PerChgBizInfo perChgBizInfo = new PerChgBizInfo();
        perChgBizInfo.setActionId(Long.valueOf(billObj.getLong("affaction.id")));
        perChgBizInfo.setBillId(billId);
        perChgBizInfo.setBillNo(billObj.getString("billno"));
        perChgBizInfo.setBillSource("hom_interntoformalbill");
        Map erManFile = (Map)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getErmanfile", (Object[])new Object[]{billObj.getLong("ermanfile.id")});
        perChgBizInfo.setOldPersonId((Long)erManFile.get("person_id"));
        perChgBizInfo.setOldEmployeeId((Long)erManFile.get("employee_id"));
        perChgBizInfo.setOldComempId((Long)erManFile.get("cmpemp_id"));
        perChgBizInfo.setOldDepempId((Long)erManFile.get("depemp_id"));
        perChgBizInfo.setBsed(billObj.getDate("effectdate"));
        HashMap<String, List<Long>> dataRow = new HashMap<String, List<Long>>();
        QFilter personQFilter = new QFilter("person", "=", erManFile.get("person_id"));
        QFilter isCurrentQFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        dataRow.put("hom_interntoformalbill", Collections.singletonList(billObj.getLong("id")));
        DynamicObject managingScopes = new HRBaseServiceHelper("hrpi_managingscope").queryOne(new QFilter[]{personQFilter, isCurrentQFilter});
        DynamicObject percre = new HRBaseServiceHelper("hrpi_percre").queryOne(new QFilter[]{personQFilter, isCurrentQFilter});
        dataRow.put("hrpi_percre", Collections.singletonList((Long)percre.get("id")));
        DynamicObject workCalenrel = new HRBaseServiceHelper("hrpi_workcalenrel").queryOne(new QFilter[]{personQFilter, isCurrentQFilter});
        DynamicObject laborRelRecord = new HRBaseServiceHelper("hrpi_laborrelrecord").queryOne(new QFilter[]{personQFilter, isCurrentQFilter});
        DynamicObject[] peredueXp = new HRBaseServiceHelper("hrpi_pereduexp").query(new QFilter[]{personQFilter, isCurrentQFilter});
        ArrayList<Long> peredueXpIds = new ArrayList<Long>();
        if (peredueXp.length > 0) {
            for (DynamicObject dy : peredueXp) {
                peredueXpIds.add(dy.getLong("id"));
            }
        }
        dataRow.put("hrpi_pereduexp", peredueXpIds);
        DynamicObject pernontsprop = new HRBaseServiceHelper("hrpi_pernontsprop").queryOne(new QFilter[]{personQFilter, isCurrentQFilter});
        dataRow.put("hrpi_pernontsprop", Collections.singletonList((Long)pernontsprop.get("id")));
        perChgBizInfo.setDataRow(dataRow);
        bizInfoList.add(perChgBizInfo);
        perChgParam.setBizInfoList(bizInfoList);
        perChgParam.setResultCallBackQueue("htm_perchg_result_queue");
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("operatetype", 1020);
        params.put("billdata", (Integer)perChgParam);
        this.sendMQMessage(JSONObject.toJSONString(params));
    }

    private void sendMQMessage(String params) {
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("hr", HPFS_PERCHG_QUEUE);){
            pub.publish(params);
        }
    }
}

