/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.opplugin.validators;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgBizInfo;
import kd.sdk.hr.hpfs.business.perchg.bizentity.PerChgParam;

public class ChgRetrtValidator
extends AbstractValidator {
    private static final Log LOGGER = LogFactory.getLog(ChgRetrtValidator.class);
    List<String> canBeRetryStatus = Arrays.asList("0", "-1", "3", "4");

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        for (int index = 0; index < dataEntities.length; ++index) {
            DynamicObject logDy = dataEntities[index].getDataEntity();
            if (!this.fieldVlidate(logDy)) {
                this.addErrorMessage(dataEntities[index], String.format(Locale.ROOT, ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u7b2c%s\u884c\u65e5\u5fd7\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"ChgRetrtValidator_0", (String)"hr-hpfs-opplugin", (Object[])new Object[0]), index + 1));
                LOGGER.warn(MessageFormat.format("EntityType error or field lost: {0}", logDy.toString()));
                continue;
            }
            if (!this.canBeRetryStatus.contains(logDy.getString("transactionstatus"))) {
                this.addErrorMessage(dataEntities[index], String.format(Locale.ROOT, ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u7b2c%s\u884c\u65e5\u5fd7\u5bf9\u5e94\u7684\u4e8b\u52a1\u6267\u884c\u72b6\u6001\u4e0d\u5141\u8bb8\u91cd\u8bd5\u3002", (String)"ChgRetrtValidator_1", (String)"hr-hpfs-opplugin", (Object[])new Object[0]), index + 1));
                LOGGER.warn(MessageFormat.format("The current transaction status does not support retry", logDy.toString()));
                continue;
            }
            if (!HRStringUtils.equals((String)"4", (String)logDy.getString("transactionstatus"))) continue;
            try {
                String dlockKey = this.getDLockKey(logDy);
                LOGGER.info("ChgRetrtValidator#validate dlockKey is {}", (Object)dlockKey);
                try (DLock dLock = DLock.create((String)dlockKey);){
                    boolean getLock = dLock.tryLock();
                    if (getLock) continue;
                    this.addErrorMessage(dataEntities[index], String.format(Locale.ROOT, ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u7b2c%s\u884c\u4e8b\u52a1\u5206\u5e03\u5f0f\u9501\u672a\u91ca\u653e\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ChgRetrtValidator_2", (String)"hr-hpfs-opplugin", (Object[])new Object[0]), index + 1));
                }
                catch (Exception lockException) {
                    this.addErrorMessage(dataEntities[index], String.format(Locale.ROOT, ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u7b2c%s\u884c\u4e8b\u52a1\u5206\u5e03\u5f0f\u9501\u672a\u91ca\u653e\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ChgRetrtValidator_2", (String)"hr-hpfs-opplugin", (Object[])new Object[0]), index + 1));
                }
                continue;
            }
            catch (Exception ex) {
                LOGGER.error("ChgRetrtValidator#getDLockKey exception", (Throwable)ex);
                this.addErrorMessage(dataEntities[index], String.format(Locale.ROOT, ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u7b2c%s\u884c\u65e5\u5fd7\u6570\u636e\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u8be5\u65e5\u5fd7\u6570\u636e\u7684\u8bf7\u6c42\u53c2\u6570\u3002", (String)"ChgRetrtValidator_3", (String)"hr-hpfs-opplugin", (Object[])new Object[0]), index + 1));
            }
        }
    }

    private boolean fieldVlidate(DynamicObject chgLog) {
        IDataEntityType entityType = chgLog.getDataEntityType();
        return entityType.getName().equals("hpfs_chglog") && entityType.getProperties().containsKey((Object)"consumer") && entityType.getProperties().containsKey((Object)"transactionstatus") && entityType.getProperties().containsKey((Object)"params");
    }

    private String getDLockKey(DynamicObject chgLog) throws IOException {
        Object billSourceObj = chgLog.get("billsource");
        String billSource = null;
        if (Objects.nonNull(billSourceObj)) {
            billSource = billSourceObj instanceof DynamicObject ? ((DynamicObject)billSourceObj).getString("number") : billSourceObj.toString();
        }
        long billId = chgLog.getLong("billid");
        if (billSource != null && billSource.length() > 0 && billId > 0L) {
            return String.join((CharSequence)"_", billSource, String.valueOf(billId));
        }
        Map mqParam = (Map)SerializationUtils.fromJsonString((String)chgLog.getString("params"), Map.class);
        PerChgParam perChgParam = (PerChgParam)SerializationUtils.fromJsonString((String)HRJSONUtils.toString(mqParam.get("billdata")), PerChgParam.class);
        PerChgBizInfo bizInfo = (PerChgBizInfo)perChgParam.getBizInfoList().get(0);
        return String.join((CharSequence)"_", bizInfo.getBillSource(), String.valueOf(bizInfo.getBillId()));
    }
}

