/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.control.HRFieldAp;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.control.HRLabelAp;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hpfs.common.constants.ChgRuleConstants;
import kd.hr.hpfs.common.constants.ChgStrategyConstants;
import kd.hr.hpfs.formplugin.model.DrawFormFieldDto;
import kd.hr.hpfs.formplugin.service.ApControlService;
import kd.hr.hpfs.formplugin.service.ChgGuideBaseDrawControlService;
import kd.hr.hpfs.formplugin.service.ChgLocalValueService;
import kd.hr.hpfs.formplugin.util.ChgCommonUtils;
import kd.hr.hpfs.formplugin.util.DynamicPanelUtils;
import kd.hr.hpfs.formplugin.util.TemplateEditUtils;
import kd.sdk.hr.hpfs.common.constants.ChgConstants;

public class ChgRuleConfigEditPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener,
ChgRuleConstants,
ChgConstants,
ChgStrategyConstants {
    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        FlexPanelAp flexPanelAp = this.loadMetas(formShowParameter);
        if (flexPanelAp == null) {
            return;
        }
        HashMap<String, String> flexMap = new HashMap<String, String>(2);
        flexMap.put("id", "containerflex");
        flexMap.put("items", (String)flexPanelAp.createControl().get("items"));
        e.getItems().add(flexMap);
    }

    private FlexPanelAp loadMetas(FormShowParameter formShowParameter) {
        Map map = (Map)formShowParameter.getCustomParam("params");
        Long strategyId = Long.valueOf((String)map.get("chgstrategy"));
        Long tacticId = Long.valueOf((String)map.get("chgtactic"));
        HRBaseServiceHelper strategyConfigHelper = new HRBaseServiceHelper("hpfs_affstrategyentry");
        DynamicObject[] strategyConfig = strategyConfigHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("chgstrategy", "=", (Object)strategyId), new QFilter("chgtactic", "=", (Object)tacticId)});
        if (strategyConfig.length == 0) {
            return null;
        }
        String chgObject = strategyConfig[0].getDynamicObject("chgtactic").getString("chgobject_id");
        String applicableStage = strategyConfig[0].getDynamicObject("chgtactic").getString("applicablestage");
        formShowParameter.getCustomParams().put("chgObject", chgObject);
        formShowParameter.getCustomParams().put("applicableStage", applicableStage);
        ArrayList<DrawFormFieldDto> allFields = new ArrayList<DrawFormFieldDto>();
        ArrayList<Map<String, Object>> originFields = new ArrayList<Map<String, Object>>();
        HashMap<String, String> baseFields = new HashMap<String, String>();
        FlexPanelAp flexPanelAp = this.formatFlex(strategyConfig, allFields, chgObject, originFields, baseFields);
        formShowParameter.getCustomParams().put("allFields", SerializationUtils.toJsonString(allFields));
        formShowParameter.getCustomParams().put("originFields", SerializationUtils.toJsonString(originFields));
        formShowParameter.getCustomParams().put("baseFields", SerializationUtils.toJsonString(baseFields));
        return flexPanelAp;
    }

    private FlexPanelAp formatFlex(DynamicObject[] strategyConfig, List<DrawFormFieldDto> allFields, String chgObject, List<Map<String, Object>> originFields, Map<String, String> baseFields) {
        FlexPanelAp flexPanelAp = new HRFlexPanelAp.Builder("containerflex").setName(CHINESE_CONTAINER_FLEX).build();
        for (DynamicObject dynamicObject : strategyConfig) {
            flexPanelAp.getItems().add(this.formatFieldFlex(dynamicObject, allFields, chgObject, originFields, baseFields));
        }
        return flexPanelAp;
    }

    private FlexPanelAp formatFieldFlex(DynamicObject field, List<DrawFormFieldDto> allFields, String chgObject, List<Map<String, Object>> originFields, Map<String, String> baseFields) {
        String fieldNumber = field.getString("chgfile");
        FlexPanelAp flexPanelAp = new HRFlexPanelAp.Builder("fieldflex" + fieldNumber).setName(CHINESE_FIELD_FLEX + fieldNumber).build();
        String chgFiled = field.getString("chgfile");
        if (HRStringUtils.isEmpty((String)chgFiled)) {
            return flexPanelAp;
        }
        LabelAp labelAp = new HRLabelAp.Builder("label-" + fieldNumber).setName(this.getChgObjectFieldName(field.getString("chgfile"), chgObject)).build();
        FlexPanelAp labelFlexAp = new HRFlexPanelAp.Builder("fieldflex" + fieldNumber + "label").setName(CHINESE_FIELD_FLEX + fieldNumber + "label").build();
        labelFlexAp.getItems().add(labelAp);
        flexPanelAp.getItems().add(labelFlexAp);
        String limitType = field.getString("limittype");
        HashMap<String, Object> originField = new HashMap<String, Object>();
        originField.put("field", field.getString("chgfile"));
        originField.put("limitType", limitType);
        originField.put("editable", field.getBoolean("editable"));
        Boolean isMust = field.getBoolean("required");
        switch (limitType) {
            case "": {
                flexPanelAp.getItems().add(this.formatCustomControl(fieldNumber, allFields, isMust));
                break;
            }
            case "0": {
                flexPanelAp.getItems().addAll(this.formatValueRange(field, allFields, chgObject, originField, baseFields));
                break;
            }
            case "1": {
                originField.put("chgType", field.getString("chgtype"));
                flexPanelAp.getItems().addAll(this.formatChgType(field, allFields));
                break;
            }
        }
        originFields.add(originField);
        return flexPanelAp;
    }

    private ControlAp<?> formatCustomControl(String fieldNumber, List<DrawFormFieldDto> allFields, Boolean isMust) {
        FlexPanelAp flexPanelAp = new HRFlexPanelAp.Builder("fieldflex" + fieldNumber + "appointed").setName(CHINESE_FIELD_FLEX + fieldNumber + "appointed").setWidth("100%").build();
        FieldAp checkBoxAp = new HRFieldAp.Builder("checkboxap-" + fieldNumber).setName(CHINESE_CHECK_BOX).build();
        DrawFormFieldDto checkboxField = new DrawFormFieldDto().setField("checkboxap-" + fieldNumber).setName(CHINESE_CHECK_BOX).setClassSimpleName(BooleanProp.class.getSimpleName()).setDisplayStyle(2).setFireUptEvt(true);
        checkBoxAp.setField(new ApControlService().createField(checkboxField));
        checkBoxAp.setFireUpdEvt(true);
        checkBoxAp.setWidth(new LocaleString("120px"));
        checkBoxAp.setHeight(new LocaleString("100%"));
        allFields.add(checkboxField);
        flexPanelAp.getItems().add(checkBoxAp);
        FieldAp entityBaseAp = new HRFieldAp.Builder("baseentityap-" + fieldNumber).setName(ChgLocalValueService.getInstance().getAppointedEntity()).build();
        DrawFormFieldDto baseEntityField = new DrawFormFieldDto().setField("baseentityap-" + fieldNumber).setName(ChgLocalValueService.getInstance().getAppointedEntity()).setClassSimpleName(BasedataProp.class.getSimpleName()).setBaseEntityId("bos_objecttype").setMustInput(isMust);
        entityBaseAp.setField(new ApControlService().createField(baseEntityField));
        entityBaseAp.setFireUpdEvt(true);
        entityBaseAp.setWidth(new LocaleString("120px"));
        allFields.add(baseEntityField);
        flexPanelAp.getItems().add(entityBaseAp);
        FieldAp comboAp = new HRFieldAp.Builder("combo-" + fieldNumber).setName(ChgLocalValueService.CHG_LOCAL_VALUE_SERVICE.getAppointedField()).build();
        DrawFormFieldDto comboField = new DrawFormFieldDto().setField("combo-" + fieldNumber).setName(ChgLocalValueService.CHG_LOCAL_VALUE_SERVICE.getAppointedField()).setClassSimpleName(ComboProp.class.getSimpleName()).setComboItemList(new ArrayList<kd.bos.metadata.entity.commonfield.ComboItem>()).setMustInput(isMust);
        comboAp.setField(new ApControlService().createField(comboField));
        comboAp.setWidth(new LocaleString("120px"));
        allFields.add(comboField);
        flexPanelAp.getItems().add(comboAp);
        return flexPanelAp;
    }

    private List<ControlAp<?>> formatValueRange(DynamicObject field, List<DrawFormFieldDto> allFields, String chgObject, Map<String, Object> originField, Map<String, String> baseFields) {
        String val;
        String fieldNumber = field.getString("chgfile");
        ArrayList controlApList = new ArrayList();
        String valueRange = field.getString("valrange_tag");
        boolean isMust = field.getBoolean("required");
        boolean editable = field.getBoolean("editable");
        FlexPanelAp flexPanelAp = new HRFlexPanelAp.Builder("fieldflex" + fieldNumber + "fixes").setName(CHINESE_FIELD_FLEX + fieldNumber + "fixed").build();
        if (HRStringUtils.isNotEmpty((String)valueRange)) {
            FieldAp entityBaseAp = new HRFieldAp.Builder("val-" + fieldNumber).setName("").build();
            DrawFormFieldDto baseDataField = new DrawFormFieldDto().setField("val-" + fieldNumber).setName("").setClassSimpleName(MulBasedataProp.class.getSimpleName()).setBaseEntityId(this.getChgObjectBaseEntityId(fieldNumber, chgObject)).setMustInput(isMust).setLock(editable);
            entityBaseAp.setField(new ApControlService().createField(baseDataField));
            entityBaseAp.setLock(baseDataField.getLock());
            allFields.add(baseDataField);
            flexPanelAp.getItems().add(entityBaseAp);
            controlApList.add((ControlAp<?>)flexPanelAp);
            originField.put("class", BasedataProp.class.getSimpleName());
            baseFields.put("val-" + fieldNumber, valueRange);
        }
        if (HRStringUtils.isNotEmpty((String)(val = field.getString("val")))) {
            List<kd.bos.metadata.entity.commonfield.ComboItem> comboItemList = this.getChgObjectComboList(fieldNumber, chgObject, val);
            FieldAp comboAp = new HRFieldAp.Builder("val-" + fieldNumber).setName("").build();
            DrawFormFieldDto comboField = new DrawFormFieldDto().setField("val-" + fieldNumber).setName("").setClassSimpleName(MulComboProp.class.getSimpleName()).setComboItemList(comboItemList).setMustInput(isMust).setLock(editable);
            comboAp.setField(new ApControlService().createField(comboField));
            comboAp.setLock(comboField.getLock());
            allFields.add(comboField);
            flexPanelAp.getItems().add(comboAp);
            controlApList.add((ControlAp<?>)flexPanelAp);
            originField.put("class", ComboProp.class.getSimpleName());
        }
        controlApList.add(this.formatCustomControl(fieldNumber, allFields, isMust));
        return controlApList;
    }

    private String getChgObjectBaseEntityId(String field, String chgObject) {
        return ((BasedataProp)new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)chgObject)).getDataEntityType().getProperties().get((Object)field)).getBaseEntityId();
    }

    private String getChgObjectFieldName(String field, String chgObject) {
        IDataEntityProperty dataEntityProperty = (IDataEntityProperty)new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)chgObject)).getDataEntityType().getProperties().get((Object)field);
        if (dataEntityProperty == null) {
            return "";
        }
        return dataEntityProperty.getDisplayName().getLocaleValue();
    }

    private List<kd.bos.metadata.entity.commonfield.ComboItem> getChgObjectComboList(String field, String chgObject, String val) {
        List<String> values = Arrays.asList(val.split(","));
        IDataEntityProperty dataEntityProperty = (IDataEntityProperty)new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)chgObject)).getDataEntityType().getProperties().get((Object)field);
        if (dataEntityProperty instanceof ComboProp) {
            return ChgGuideBaseDrawControlService.getInstance().formatComboItemList(dataEntityProperty, values);
        }
        return this.formatComboListFromBoolean();
    }

    private List<kd.bos.metadata.entity.commonfield.ComboItem> formatComboListFromBoolean() {
        ArrayList<kd.bos.metadata.entity.commonfield.ComboItem> list = new ArrayList<kd.bos.metadata.entity.commonfield.ComboItem>();
        kd.bos.metadata.entity.commonfield.ComboItem trueItem = new kd.bos.metadata.entity.commonfield.ComboItem();
        trueItem.setCaption(new LocaleString(ChgLocalValueService.getInstance().getChineseShi()));
        trueItem.setValue("1");
        list.add(trueItem);
        kd.bos.metadata.entity.commonfield.ComboItem falseItem = new kd.bos.metadata.entity.commonfield.ComboItem();
        falseItem.setCaption(new LocaleString(ChgLocalValueService.getInstance().getChineseNo()));
        falseItem.setValue("0");
        list.add(falseItem);
        return list;
    }

    private List<ControlAp<?>> formatChgType(DynamicObject field, List<DrawFormFieldDto> allFields) {
        String fieldNumber = field.getString("chgfile");
        ArrayList controlApList = new ArrayList();
        FieldAp comboAp = new HRFieldAp.Builder("chgcombo" + fieldNumber).setName("").build();
        boolean isMust = field.getBoolean("required");
        boolean editable = field.getBoolean("editable");
        FlexPanelAp flexPanelAp = new HRFlexPanelAp.Builder("fieldflex" + fieldNumber + "chgtype").setName(CHINESE_FIELD_FLEX + fieldNumber + "chgtype").build();
        DrawFormFieldDto comboField = new DrawFormFieldDto().setField("chgcombo" + fieldNumber).setName("").setClassSimpleName(ComboProp.class.getSimpleName()).setComboItemList(ChgCommonUtils.formatChgTypeComboItems()).setMustInput(isMust).setLock(editable);
        comboAp.setField(new ApControlService().createField(comboField));
        comboAp.setLock(comboField.getLock());
        allFields.add(comboField);
        flexPanelAp.getItems().add(comboAp);
        controlApList.add((ControlAp<?>)flexPanelAp);
        controlApList.add(this.formatCustomControl(fieldNumber, allFields, isMust));
        return controlApList;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        super.getEntityType(e);
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode(((Object)((Object)this)).getClass().getSimpleName(), exp.getMessage()), new Object[0]);
        }
        List<DrawFormFieldDto> drawFormFields = this.getAllFields();
        DynamicPanelUtils.registDynamicProps(newMainType, drawFormFields);
        e.setNewEntityType(newMainType);
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        List<DrawFormFieldDto> fields = this.getAllFields();
        fields.stream().filter(field -> HRStringUtils.equals((String)field.getField(), (String)e.getKey())).forEach(field -> {
            TemplateEditUtils.addGetControl(field, e, this);
            if (HRStringUtils.equals((String)field.getClassSimpleName(), (String)MulBasedataProp.class.getSimpleName())) {
                MulBasedataEdit basedataEdit = (MulBasedataEdit)e.getControl();
                basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
        });
    }

    private List<DrawFormFieldDto> getAllFields() {
        String fieldList = (String)this.getView().getFormShowParameter().getCustomParam("allFields");
        List listMap = (List)SerializationUtils.fromJsonString((String)fieldList, List.class);
        return listMap.stream().map(map -> new DrawFormFieldDto().setField((String)map.get("field")).setName((String)map.get("name")).setClassSimpleName((String)map.get("classSimpleName")).setComboItemList((List)map.get("comboItemList")).setBaseEntityId((String)map.get("baseEntityId")).setLock((String)map.get("lock")).setMustInput((Boolean)map.get("mustInput"))).collect(Collectors.toList());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FlexPanelAp flexPanelAp = this.loadMetas(this.getView().getFormShowParameter());
        if (flexPanelAp == null) {
            return;
        }
        Container fldPanel = (Container)this.getView().getControl("containerflex");
        fldPanel.getItems().addAll(((Container)flexPanelAp.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(fldPanel.getItems());
        this.showDataFromCache();
    }

    private void showDataFromCache() {
        Map map = (Map)this.getView().getFormShowParameter().getCustomParam("params");
        this.getModel().setValue("chgtactic", (Object)Long.parseLong((String)map.get("chgtactic")));
        if (map.get("data") == null) {
            this.showDataFromStrategy();
            return;
        }
        List fields = (List)((Map)map.get("data")).get("fields");
        this.getModel().setValue("filemapping", ((Map)map.get("data")).get("mapping"));
        this.setValueByCacheMap(fields);
    }

    private void showDataFromStrategy() {
        Map paramMap = (Map)this.getView().getFormShowParameter().getCustomParam("params");
        Long strategyId = Long.parseLong((String)paramMap.get("chgstrategy"));
        Long tacticId = Long.parseLong((String)paramMap.get("chgtactic"));
        HRBaseServiceHelper strategyConfigHelper = new HRBaseServiceHelper("hpfs_affstrategyentry");
        DynamicObject[] strategyConfig = strategyConfigHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("chgstrategy", "=", (Object)strategyId), new QFilter("chgtactic", "=", (Object)tacticId)});
        if (strategyConfig.length == 0) {
            return;
        }
        Arrays.stream(strategyConfig).forEach(con -> {
            String fieldNumber = con.getString("chgfile");
            this.setEnableByCheckBox(Boolean.FALSE, fieldNumber);
            this.setEnableByStrategyConfig(fieldNumber, con.getBoolean("editable"));
            String limitType = con.getString("limittype");
            if (HRStringUtils.isEmpty((String)limitType)) {
                return;
            }
            String val = (String)con.get("val");
            if (HRStringUtils.equals((String)limitType, (String)"0") && HRStringUtils.isNotEmpty((String)val)) {
                String valField = "val-" + fieldNumber;
                this.getModel().setValue(valField, (Object)val);
            } else if (HRStringUtils.equals((String)limitType, (String)"1")) {
                this.getModel().setValue("chgcombo" + fieldNumber, con.get("chgtype"));
            }
        });
    }

    private void setEnableByStrategyConfig(String fieldNumber, Boolean editable) {
        String field = "val-" + fieldNumber;
        if (this.getModel().getProperty(field) != null) {
            this.getView().setEnable(editable, new String[]{field});
        }
    }

    private void setValueByCacheMap(List<Map<String, Object>> fields) {
        fields.forEach(field -> {
            String fieldNumber = (String)field.get("field");
            if (HRStringUtils.isEmpty((String)fieldNumber)) {
                return;
            }
            String checkboxValue = (String)field.get("checkbox");
            this.getModel().setValue("checkboxap-" + fieldNumber, (Object)checkboxValue);
            if (HRStringUtils.isNotEmpty((String)((String)field.get("chgType")))) {
                this.getModel().setValue("chgcombo" + fieldNumber, field.get("chgType"));
            } else {
                this.setValueRangeOrVal((Map<String, Object>)field);
            }
            if (HRStringUtils.equals((String)checkboxValue, (String)"0")) {
                this.setEnableByCheckBox(Boolean.FALSE, fieldNumber);
            }
            if (HRStringUtils.equals((String)checkboxValue, (String)"1")) {
                this.getModel().setValue("baseentityap-" + fieldNumber, field.get("entitySource"));
                this.getModel().setValue("combo-" + fieldNumber, field.get("fieldSource"));
                if (HRStringUtils.isNotEmpty((String)((String)field.get("entitySource")))) {
                    this.setFieldListByEntity((String)field.get("entitySource"), "combo-" + fieldNumber);
                }
            }
        });
    }

    private void setValueRangeOrVal(Map<String, Object> field) {
        String fieldNumber = (String)field.get("field");
        String number = "val-" + fieldNumber;
        if (HRStringUtils.isNotEmpty((String)((String)field.get("valrange")))) {
            DynamicObject[] dynamicObjects;
            DynamicObjectCollection collection = this.getModel().getEntryEntity(number);
            QFilter qFilter = QFilter.fromSerializedString((String)((String)field.get("valrange")));
            String entityName = ((MulBasedataProp)this.getModel().getDataEntityType().getProperties().get((Object)number)).getBaseEntityId();
            for (DynamicObject row : dynamicObjects = new HRBaseServiceHelper(entityName).loadDynamicObjectArray(new QFilter[]{qFilter})) {
                DynamicObject dyNew = collection.addNew();
                dyNew.set("fbasedataid", (Object)row);
                dyNew.set("fbasedataid_id", (Object)row.getLong("id"));
            }
            this.getModel().setValue(number, (Object)collection);
        }
        if (HRStringUtils.isNotEmpty((String)((String)field.get("val")))) {
            this.getModel().setValue(number, field.get("val"));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String field = e.getProperty().getName();
        if (field.replace("baseentityap", "").length() != field.length()) {
            DynamicObject dataNew = (DynamicObject)e.getChangeSet()[0].getNewValue();
            this.getModel().setValue(field, (Object)dataNew);
            if (dataNew != null) {
                this.setFieldListByEntity(dataNew.getString("id"), field.replace("baseentityap", "combo"));
            }
        }
        if (field.replace("checkboxap", "").length() != field.length()) {
            Boolean res = (Boolean)e.getChangeSet()[0].getNewValue();
            this.setEnableByCheckBox(res, field.split("-")[1]);
        }
        this.getModel().updateCache();
    }

    private void setFieldListByEntity(String entitySource, String comboNumber) {
        List list = MetadataServiceHelper.getDataEntityType((String)entitySource).getAllFields().entrySet().stream().filter(Objects::nonNull).filter(arg -> StringUtils.isNotEmpty((String)((IDataEntityProperty)arg.getValue()).getAlias())).map(arg -> new ComboItem(((IDataEntityProperty)arg.getValue()).getDisplayName(), (String)arg.getKey())).distinct().collect(Collectors.toList());
        ComboEdit comboEdit = (ComboEdit)this.getControl(comboNumber);
        comboEdit.setComboItems(list);
    }

    private void setEnableByCheckBox(Boolean res, String fieldNumber) {
        String entityField = "baseentityap-" + fieldNumber;
        String comboField = "combo-" + fieldNumber;
        if (res.booleanValue()) {
            this.getView().setEnable(Boolean.TRUE, new String[]{entityField, comboField});
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{entityField, comboField});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        if (HRStringUtils.equals((String)key, (String)"do_save")) {
            String originFieldsStr = (String)this.getView().getFormShowParameter().getCustomParam("originFields");
            List originFields = (List)SerializationUtils.fromJsonString((String)originFieldsStr, List.class);
            ArrayList dataReturned = new ArrayList();
            originFields.forEach(originField -> {
                Map<String, Object> fieldData = this.formatDataReturned((Map<String, Object>)originField);
                dataReturned.add(fieldData);
            });
            HashMap<String, Object> map = new HashMap<String, Object>();
            Map paramMap = (Map)this.getView().getFormShowParameter().getCustomParam("params");
            Long tacticId = Long.parseLong((String)paramMap.get("chgtactic"));
            map.put("tactic", tacticId);
            map.put("fields", dataReturned);
            if (this.getModel().getValue("filemapping") != null) {
                map.put("mapping", ((DynamicObject)this.getModel().getValue("filemapping")).get("id"));
            }
            this.getView().returnDataToParent(map);
            this.getModel().setDataChanged(false);
        }
    }

    private Map<String, Object> formatDataReturned(Map<String, Object> originField) {
        String limitType = (String)originField.get("limitType");
        HashMap<String, Object> fieldData = new HashMap<String, Object>();
        String fieldNumber = (String)originField.get("field");
        fieldData.put("field", fieldNumber);
        if (HRStringUtils.equals((String)limitType, (String)"1")) {
            this.getSourceData(fieldData);
            fieldData.put("chgType", this.getModel().getValue("chgcombo" + fieldNumber));
        } else {
            String className = (String)originField.get("class");
            fieldData.put("class", className);
            this.getSourceData(fieldData);
            if (HRStringUtils.isEmpty((String)className)) {
                return fieldData;
            }
            String fixedField = "val-" + fieldNumber;
            if (HRStringUtils.equals((String)className, (String)ComboProp.class.getSimpleName())) {
                fieldData.put("val", this.getModel().getValue(fixedField));
            } else {
                MulBasedataDynamicObjectCollection collection = (MulBasedataDynamicObjectCollection)this.getModel().getValue(fixedField);
                List ids = collection.stream().map(row -> row.getLong("fbasedataid_id")).collect(Collectors.toList());
                QFilter qFilter = new QFilter("id", "in", ids);
                fieldData.put("valrange", qFilter.toSerializedString());
            }
        }
        return fieldData;
    }

    private void getSourceData(Map<String, Object> dataMap) {
        String fieldNumber = (String)dataMap.get("field");
        String checkBox = "checkboxap-" + fieldNumber;
        Boolean checkBoxValue = (Boolean)this.getModel().getValue(checkBox);
        dataMap.put("checkbox", checkBoxValue != false ? "1" : "0");
        dataMap.put("entitySource", checkBoxValue != false ? ((DynamicObject)this.getModel().getValue("baseentityap-" + fieldNumber)).get("id") : "");
        dataMap.put("fieldSource", checkBoxValue != false ? this.getModel().getValue("combo-" + fieldNumber) : "");
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        BasedataEdit basedataEdit = (BasedataEdit)beforeF7SelectEvent.getSource();
        String key = basedataEdit.getKey();
        Map baseFields = (Map)SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParam("baseFields")), Map.class);
        String valueRange = (String)baseFields.get(key);
        if (valueRange != null) {
            QFilter qFilter = QFilter.fromSerializedString((String)valueRange);
            beforeF7SelectEvent.setCustomQFilters(Arrays.asList(qFilter.toArray()));
        }
    }
}

