/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.form.container.FieldsetPanelAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hpfs.common.constants.ChgStrategyConstants;
import kd.hr.hpfs.formplugin.model.DrawFormFieldDto;
import kd.hr.hpfs.formplugin.util.ApCreateUtils;
import kd.hr.hpfs.formplugin.util.DynamicPanelUtils;
import kd.hr.hpfs.formplugin.util.TemplateEditUtils;
import kd.sdk.hr.hpfs.common.constants.ChgConstants;

public class ChgStrategyConfigEditPlugin
extends HRDataBaseEdit
implements ChgConstants,
ChgStrategyConstants {
    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        FlexPanelAp flexPanelAp = this.loadMeta(formShowParameter);
        HashMap<String, String> flexMap = new HashMap<String, String>(2);
        flexMap.put("id", "containerflex");
        flexMap.put("items", (String)flexPanelAp.createControl().get("items"));
        e.getItems().add(flexMap);
    }

    private FlexPanelAp loadMeta(FormShowParameter formShowParameter) {
        String param = (String)formShowParameter.getCustomParam("param");
        return this.formatFlex(param);
    }

    private FlexPanelAp formatFlex(String param) {
        FlexPanelAp fieldsContainerFlexAp = new HRFlexPanelAp.Builder("containerflex").setName(CHINESE_CONTAINER_FLEX).build();
        List<DrawFormFieldDto> drawFormFieldDtoList = this.getAllFields(param);
        if (drawFormFieldDtoList.size() == 1) {
            FieldsetPanelAp fieldsetPanelAp = ApCreateUtils.createFieldPanelAp("containerflex");
            FieldAp fieldAp = ApCreateUtils.createFieldAp(drawFormFieldDtoList.get(0));
            fieldAp.setShowTitle(false);
            fieldsetPanelAp.getItems().add(fieldAp);
            fieldsContainerFlexAp.getItems().add(fieldsetPanelAp);
            return fieldsContainerFlexAp;
        }
        Map<String, List<DrawFormFieldDto>> flexFieldsMap = this.getFlexFields(param);
        flexFieldsMap.forEach((flex, fields) -> {
            FlexPanelAp flexPanelAp = new HRFlexPanelAp.Builder(flex).build();
            List list = flexPanelAp.getItems();
            for (DrawFormFieldDto drawFormField : fields) {
                FieldAp fieldAp = ApCreateUtils.createFieldAp(drawFormField);
                fieldAp.setWidth(new LocaleString("100px"));
                list.add(fieldAp);
            }
            fieldsContainerFlexAp.getItems().add(flexPanelAp);
        });
        return fieldsContainerFlexAp;
    }

    private Map<String, List<DrawFormFieldDto>> getFlexFields(String param) {
        List<DrawFormFieldDto> origin = this.getOriginFields(param);
        HashMap<String, List<DrawFormFieldDto>> flexFieldsMap = new HashMap<String, List<DrawFormFieldDto>>(origin.size());
        for (int index = 0; index < origin.size(); ++index) {
            DrawFormFieldDto field = origin.get(index);
            List<DrawFormFieldDto> groupAps = this.formatGroupAp(field);
            flexFieldsMap.put("containerflex" + index, groupAps);
        }
        return flexFieldsMap;
    }

    private List<DrawFormFieldDto> getOriginFields(String param) {
        Map map = (Map)SerializationUtils.fromJsonString((String)param, Map.class);
        if (HRStringUtils.equals((String)((String)map.get("class")), (String)ComboProp.class.getSimpleName())) {
            return new ArrayList<DrawFormFieldDto>();
        }
        return MetadataServiceHelper.getDataEntityType((String)((String)map.get("baseEntityId"))).getAllFields().entrySet().stream().filter(Objects::nonNull).filter(arg -> StringUtils.isNotEmpty((String)((IDataEntityProperty)arg.getValue()).getAlias())).map(arg -> new DrawFormFieldDto().setField((String)arg.getKey()).setName(((IDataEntityProperty)arg.getValue()).getDisplayName().getLocaleValue()).setClassSimpleName(((IDataEntityProperty)arg.getValue()).getClass().getSimpleName()).setComboItemList(arg.getValue() instanceof ComboProp ? (ComboProp)arg.getValue() : null).setBaseEntityId(this.getBaseEntityId((IDataEntityProperty)arg.getValue()))).distinct().collect(Collectors.toList());
    }

    private String getBaseEntityId(IDataEntityProperty argValue) {
        if (argValue instanceof BasedataProp) {
            return ((BasedataProp)argValue).getBaseEntityId();
        }
        if (argValue instanceof MulBasedataProp) {
            return ((MulBasedataProp)argValue).getBaseEntityId();
        }
        return "";
    }

    private List<DrawFormFieldDto> getAllFields(String param) {
        Map map = (Map)SerializationUtils.fromJsonString((String)param, Map.class);
        if (HRStringUtils.equals((String)((String)map.get("class")), (String)ComboProp.class.getSimpleName())) {
            List comboList = (List)map.get("combo");
            List<ComboItem> comboItemList = comboList.stream().map(row -> {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString((String)row.get("name")));
                comboItem.setValue((String)row.get("value"));
                return comboItem;
            }).collect(Collectors.toList());
            return Collections.singletonList(new DrawFormFieldDto().setField("combo").setName("").setClassSimpleName(MulComboProp.class.getSimpleName()).setComboItemList(comboItemList));
        }
        ArrayList<DrawFormFieldDto> allFields = new ArrayList<DrawFormFieldDto>();
        Map<String, List<DrawFormFieldDto>> flexFieldsMap = this.getFlexFields(param);
        flexFieldsMap.forEach((flex, fields) -> allFields.addAll((Collection<DrawFormFieldDto>)fields));
        return allFields;
    }

    private List<DrawFormFieldDto> formatGroupAp(DrawFormFieldDto field) {
        ArrayList<DrawFormFieldDto> list = new ArrayList<DrawFormFieldDto>();
        list.add(new DrawFormFieldDto().setField(field.getField() + "text").setName("").setClassSimpleName(TextProp.class.getSimpleName()).setLock(false));
        list.add(new DrawFormFieldDto().setField(field.getField() + "combo").setName("").setClassSimpleName(ComboProp.class.getSimpleName()).setComboItemList(this.formatLambdaCombo()));
        list.add(new DrawFormFieldDto().setField(field.getField() + "value").setName("").setClassSimpleName(this.getFieldClass(field.getClassSimpleName())).setBaseEntityId(field.getBaseEntityId()).setComboItemList(field.getComboItemList()));
        return list;
    }

    private List<ComboItem> formatLambdaCombo() {
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>();
        ComboItem include = new ComboItem();
        include.setValue("in");
        include.setCaption(new LocaleString(CHINESE_INCLUDE));
        comboItemList.add(include);
        ComboItem exclude = new ComboItem();
        exclude.setValue("not in");
        exclude.setCaption(new LocaleString(CHINESE_EXCLUDE));
        comboItemList.add(exclude);
        return comboItemList;
    }

    private String getFieldClass(String origin) {
        switch (origin) {
            case "BasedataProp": 
            case "UserProp": 
            case "CreaterProp": 
            case "ModifierProp": 
            case "OrgProp": 
            case "MainOrgProp": {
                return MulBasedataProp.class.getSimpleName();
            }
            case "ComboProp": 
            case "BillStatusProp": {
                return MulComboProp.class.getSimpleName();
            }
            case "DateTimeProp": 
            case "ModifyDateProp": 
            case "CreateDateProp": {
                return DateProp.class.getSimpleName();
            }
        }
        return origin;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FlexPanelAp flexPanelAp = this.loadMeta(this.getView().getFormShowParameter());
        Container container = (Container)this.getView().getControl("containerflex");
        container.getItems().addAll(((Container)flexPanelAp.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(container.getItems());
        this.getView().updateControlMetadata("containerflex", flexPanelAp.createControl());
        String param = (String)this.getView().getFormShowParameter().getCustomParam("param");
        Map map = (Map)SerializationUtils.fromJsonString((String)param, Map.class);
        this.getModel().setValue("chgtactic", map.get("chgtactic"));
        this.getModel().setValue("field", map.get("field"));
        Map data = (Map)map.get("data");
        List<DrawFormFieldDto> origin = this.getOriginFields(param);
        if (!origin.isEmpty()) {
            origin.forEach(field -> this.getModel().setValue(field.getField() + "text", (Object)field.getName()));
        }
        if (data == null) {
            return;
        }
        this.initBasic(data);
        List<DrawFormFieldDto> allFields = this.getAllFields(param);
        if (allFields.size() == 1) {
            this.getModel().setValue("combo", data.get("val"));
        } else {
            this.initValRange(data);
        }
    }

    private void initBasic(Map<String, Object> data) {
        this.getModel().setValue("radiogroupfield", data.get("limittype"));
        if (HRStringUtils.equals((String)((String)data.get("limittype")), (String)"0")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"chgtypeflex"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"valuerangeflex"});
        }
        this.getModel().setValue("radiogroupfield1", data.get("chgtype"));
    }

    private void initValRange(Map<String, Object> data) {
        if (data.get("valrange") == null) {
            return;
        }
        QFilter qFilter = QFilter.fromSerializedString((String)((String)data.get("valrange")));
        List<List> valRangeList = Arrays.stream(qFilter.recombine()).map(row -> {
            ArrayList<Object> vals = new ArrayList<Object>();
            vals.add(row.getProperty().split("\\.")[0]);
            vals.add(row.getCP());
            vals.add(row.getValue());
            return vals;
        }).collect(Collectors.toList());
        valRangeList.forEach(this::formatValRange);
    }

    private void formatValRange(List<Object> field) {
        this.getModel().setValue(field.get(0) + "combo", field.get(1));
        Control control = this.getControl(field.get(0) + "value");
        if (control instanceof MulBasedataEdit) {
            DynamicObjectCollection collection = this.getModel().getEntryEntity(field.get(0) + "value");
            List values = (List)field.get(2);
            String entityName = ((MulBasedataProp)this.getModel().getDataEntityType().getProperties().get((Object)(field.get(0) + "value"))).getBaseEntityId();
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(entityName);
            DynamicObject[] dynamicObjects = hrBaseServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", (Object)values)});
            Arrays.stream(dynamicObjects).forEach(row -> {
                DynamicObject dyNew = collection.addNew();
                dyNew.set("fbasedataid", row);
                dyNew.set("fbasedataid_id", (Object)row.getLong("id"));
            });
            this.getModel().setValue(field.get(0) + "value", (Object)collection);
        } else {
            this.getModel().setValue(field.get(0) + "value", field.get(2));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        if ("radiogroupfield".equals(fieldKey)) {
            this.changeLimitType(e);
        }
    }

    private void changeLimitType(PropertyChangedArgs e) {
        String newValue = (String)e.getChangeSet()[0].getNewValue();
        if (HRStringUtils.equals((String)newValue, (String)"0")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"valuerangeflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"chgtypeflex"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"chgtypeflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"valuerangeflex"});
        }
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        super.getEntityType(e);
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode(((Object)((Object)this)).getClass().getSimpleName(), exp.getMessage()), new Object[0]);
        }
        String param = (String)this.getView().getFormShowParameter().getCustomParam("param");
        List<DrawFormFieldDto> drawFormFields = this.getAllFields(param);
        DynamicPanelUtils.registDynamicProps(newMainType, drawFormFields);
        e.setNewEntityType(newMainType);
    }

    public void onGetControl(OnGetControlArgs e) {
        String param = (String)this.getView().getFormShowParameter().getCustomParam("param");
        List<DrawFormFieldDto> fields = this.getAllFields(param);
        fields.stream().filter(field -> HRStringUtils.equals((String)field.getField(), (String)e.getKey())).forEach(field -> TemplateEditUtils.addGetControl(field, e, this));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String key = formOperate.getOperateKey();
        String param = (String)this.getView().getFormShowParameter().getCustomParam("param");
        Map map = (Map)SerializationUtils.fromJsonString((String)param, Map.class);
        String classSimpleName = (String)map.get("class");
        if (HRStringUtils.equals((String)key, (String)"do_save")) {
            HashMap<String, Object> dataReturn = new HashMap<String, Object>(3);
            dataReturn.put("limittype", this.getModel().getValue("radiogroupfield"));
            dataReturn.put("chgtype", this.getModel().getValue("radiogroupfield1"));
            if (HRStringUtils.equals((String)classSimpleName, (String)ComboProp.class.getSimpleName())) {
                dataReturn.put("val", this.getModel().getValue("combo"));
            } else {
                Map<String, List<DrawFormFieldDto>> fieldMap = this.getFlexFields(param);
                String valRangeQFilterString = this.formatValRangeReturned(fieldMap);
                dataReturn.put("valrange", valRangeQFilterString);
            }
            this.getView().returnDataToParent(dataReturn);
            this.getModel().setDataChanged(false);
        }
    }

    private String formatValRangeReturned(Map<String, List<DrawFormFieldDto>> fieldMap) {
        ArrayList data = new ArrayList();
        fieldMap.values().forEach(fieldList -> {
            String field = ((DrawFormFieldDto)fieldList.get(0)).getField().substring(0, ((DrawFormFieldDto)fieldList.get(0)).getField().length() - 4);
            String comboValue = (String)this.getModel().getValue(((DrawFormFieldDto)fieldList.get(1)).getField());
            if (HRStringUtils.isEmpty((String)comboValue)) {
                return;
            }
            Object value = this.getModel().getValue(((DrawFormFieldDto)fieldList.get(2)).getField());
            if (value == null) {
                return;
            }
            field = this.formatField(field);
            Control control = this.getControl(((DrawFormFieldDto)fieldList.get(2)).getField());
            Object qFilterValue = this.parseControl(control, value);
            QFilter qFilter = new QFilter(field, comboValue, qFilterValue);
            data.add(qFilter);
        });
        if (CollectionUtils.isEmpty(data)) {
            return null;
        }
        QFilter qFilter = (QFilter)data.get(0);
        for (int i = 1; i < data.size(); ++i) {
            qFilter.and((QFilter)data.get(i));
        }
        return qFilter.toSerializedString();
    }

    private String formatField(String field) {
        String param = (String)this.getView().getFormShowParameter().getCustomParam("param");
        List<DrawFormFieldDto> originFields = this.getOriginFields(param);
        DrawFormFieldDto origin = originFields.stream().filter(row -> HRStringUtils.equals((String)row.getClassSimpleName(), (String)MulBasedataProp.class.getSimpleName()) && HRStringUtils.equals((String)row.getField(), (String)field)).findAny().orElse(null);
        return origin == null ? field : field + ".fbasedataid";
    }

    private Object parseControl(Control control, Object value) {
        if (control instanceof MulComboEdit) {
            return Arrays.stream(((String)value).split(",")).filter(HRStringUtils::isNotEmpty).collect(Collectors.toList());
        }
        if (control instanceof MulBasedataEdit) {
            DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)value;
            return dynamicObjectCollection.stream().map(row -> row.get("fbasedataid_id")).collect(Collectors.toList());
        }
        if (control instanceof TextEdit && value instanceof OrmLocaleValue) {
            return ((OrmLocaleValue)value).getLocaleValue();
        }
        return value;
    }
}

