/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.formplugin;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.cache.HRPageCache;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.hr.common.bean.ChgActionMappedBean;
import kd.sdk.hr.common.helper.HpfsMetaDataServiceHelper;
import kd.sdk.hr.hpfs.business.mservice.helper.HPFSNewChgHelper;
import kd.sdk.hr.hpfs.business.perchg.executor.enums.ChgModeEnum;
import kd.sdk.hr.hpfs.common.constants.PerChgNewBillTplConstants;
import kd.sdk.hr.hpfs.common.enums.PerChgStatusEnum;
import kd.sdk.hr.hpfs.utils.PerChgNewBillUtils;
import kd.sdk.hr.hpfs.utils.RepositoryUtils;

public class PerChgNewBillTplEdit
extends AbstractBillPlugIn
implements PerChgNewBillTplConstants,
BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(PerChgNewBillTplEdit.class);
    protected static final String BUSINESS_VALUE = "businessvalue";
    private static final String FIELD_LABORREL_TYPE = "laborreltype";
    private static final String FIELD_LABORREL_STATUS = "laborrelstatus";
    private final Set<String> f7SelectSet = new HashSet<String>();

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        this.getModel().getDataEntityType();
        String id = MetadataDao.getIdByNumber((String)this.getView().getEntityId(), (MetaCategory)MetaCategory.Form);
        AbstractMetadata abstractMetadata = MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        if (abstractMetadata instanceof FormMetadata) {
            FormMetadata formMetadata = (FormMetadata)abstractMetadata;
            List items = formMetadata.getItems();
            if (CollectionUtils.isNotEmpty((Collection)items)) {
                Set extSet = items.stream().filter(AbstractElement::isExt).map(AbstractElement::getKey).collect(Collectors.toSet());
                this.getView().getPageCache().put("extField", SerializationUtils.toJsonString(extSet));
            }
            if (formMetadata.getItem("FNbzgJR332H0GgVACi") instanceof ContainerAp) {
                ContainerAp nExtinfoFieldsAp = (ContainerAp)formMetadata.getItem("FNbzgJR332H0GgVACi");
                List collect = nExtinfoFieldsAp.getItems().stream().filter(data -> !data.isInvisible()).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(collect)) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"n_extinfo_fields"});
                } else {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"n_extinfo_fields"});
                }
            }
            if (formMetadata.getItem("Hfc3G2IeNkbv0Q81Sp") instanceof ContainerAp) {
                ContainerAp nExtinfoFieldsAp1 = (ContainerAp)formMetadata.getItem("Hfc3G2IeNkbv0Q81Sp");
                List collect1 = nExtinfoFieldsAp1.getItems().stream().filter(data -> !data.isInvisible()).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(collect1)) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"n_extinfo"});
                } else {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"n_extinfo"});
                }
            }
        }
    }

    public PerChgNewBillTplEdit() {
        this.f7SelectSet.add("affaction");
        this.f7SelectSet.add(FIELD_LABORREL_TYPE);
        this.f7SelectSet.add(FIELD_LABORREL_STATUS);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        for (String number : this.f7SelectSet) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(number);
            if (!Objects.nonNull(basedataEdit)) continue;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit bErmanfileControl = (BasedataEdit)this.getControl("b_ermanfile");
        if (Objects.nonNull(bErmanfileControl)) {
            bErmanfileControl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String fieldName = args.getProperty().getName();
        ChangeData[] changeSet = args.getChangeSet();
        if (changeSet == null || changeSet.length == 0) {
            return;
        }
        if (Objects.nonNull(changeSet[0].getNewValue()) && changeSet[0].getNewValue().equals(changeSet[0].getOldValue())) {
            return;
        }
        HashMap params = Maps.newHashMapWithExpectedSize((int)1);
        params.put("b_ermanfile", () -> this.changeErManFile(changeSet));
        params.put("b_effectivedate", this::changeEffectiveDate);
        params.put("affaction", () -> this.changeAffaction(changeSet));
        params.put("bb_e_enddate", () -> this.mainBillSetSysEndDate(args));
        params.put("ba_e_enddate", () -> this.mainBillSetSysEndDate(args));
        params.put("bb_d_enddate", () -> this.mainBillSetSysEndDate(args));
        params.put("ba_d_enddate", () -> this.mainBillSetSysEndDate(args));
        params.getOrDefault(fieldName, () -> this.changeDefault(args)).run();
    }

    private void mainBillSetSysEndDate(PropertyChangedArgs args) {
        ChangeData[] changeSet = args.getChangeSet();
        if (Objects.isNull(changeSet[0].getNewValue())) {
            return;
        }
        String fieldName = args.getProperty().getName();
        String sysEndDate = fieldName.replace("_enddate", "_sysenddate");
        DynamicObject mainBillDy = this.getModel().getDataEntity();
        if (mainBillDy.getDynamicObjectType().getProperties().containsKey((Object)sysEndDate)) {
            Date endDate = mainBillDy.getDate(fieldName);
            String chgType = sysEndDate.substring(0, sysEndDate.lastIndexOf(95)) + "_chgtype";
            String chgTypeValue = "";
            if (mainBillDy.getDynamicObjectType().getProperties().containsKey((Object)chgType)) {
                chgTypeValue = mainBillDy.getString(chgType);
            }
            mainBillDy.set(sysEndDate, (Object)this.getSysEndDate(chgTypeValue, endDate));
            this.getView().updateView(sysEndDate);
        }
    }

    private void changeDefault(PropertyChangedArgs args) {
        String fieldName = args.getProperty().getName();
        ChangeData changeData = args.getChangeSet()[0];
        int entryCurrentRowIndex = changeData.getRowIndex();
        String entryId = changeData.getDataEntity().getDynamicObjectType().getName();
        if (entryId.startsWith("entry_") && !fieldName.endsWith("_chgtype")) {
            if (this.setChgType(entryCurrentRowIndex, entryId, ChgModeEnum.MODIFY)) {
                return;
            }
            if (fieldName.endsWith("_enddate")) {
                this.setSysEndDate(entryCurrentRowIndex, entryId, fieldName);
            }
            this.getView().updateView(entryId);
        }
    }

    private void setSysEndDate(int entryCurrentRowIndex, String entryId, String fieldName) {
        DynamicObject entryEntityDy = this.getModel().getEntryRowEntity(entryId, entryCurrentRowIndex);
        if (Objects.isNull(entryEntityDy)) {
            return;
        }
        DataEntityPropertyCollection entryEntityProperties = entryEntityDy.getDataEntityType().getProperties();
        List sysEndDates = entryEntityProperties.stream().filter(data -> data.getName().endsWith("_sysenddate")).map(IMetadata::getName).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(sysEndDates)) {
            return;
        }
        String sysEndDate = (String)sysEndDates.get(0);
        Date endDate = entryEntityDy.getDate(fieldName);
        List chgTypes = entryEntityProperties.stream().filter(data -> data.getName().endsWith("_chgtype")).map(IMetadata::getName).collect(Collectors.toList());
        String chgType = (String)chgTypes.get(0);
        String chgTypeValue = entryEntityDy.getString(chgType);
        entryEntityDy.set(sysEndDate, (Object)this.getSysEndDate(chgTypeValue, endDate));
    }

    private Date getSysEndDate(String chgTypeValue, Date endDate) {
        if (Objects.isNull(endDate)) {
            return null;
        }
        if (ChgModeEnum.ADD_NEW.getChgMode().equals(chgTypeValue)) {
            return endDate;
        }
        if (endDate.getTime() != HRBaseUtils.getMaxEndDate().getTime()) {
            return HRDateTimeUtils.addDay((Date)endDate, (long)1L);
        }
        return endDate;
    }

    private boolean setChgType(int entryCurrentRowIndex, String entryId, ChgModeEnum chgModeEnum) {
        DynamicObject entryEntityDy = this.getModel().getEntryRowEntity(entryId, entryCurrentRowIndex);
        if (Objects.isNull(entryEntityDy)) {
            return true;
        }
        DataEntityPropertyCollection entryEntityProperties = entryEntityDy.getDataEntityType().getProperties();
        List chgTypes = entryEntityProperties.stream().filter(data -> data.getName().endsWith("_chgtype")).map(IMetadata::getName).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(chgTypes)) {
            return true;
        }
        String chgType = (String)chgTypes.get(0);
        if (ChgModeEnum.MODIFY.equals((Object)chgModeEnum) && (ChgModeEnum.ADD_NEW.getChgMode().equals(entryEntityDy.get(chgType)) || ChgModeEnum.INVALID.getChgMode().equals(entryEntityDy.get(chgType)))) {
            return false;
        }
        entryEntityDy.set(chgType, (Object)chgModeEnum.getChgMode());
        return false;
    }

    private void changeAffaction(ChangeData[] changeSet) {
        DynamicObject affactionNewDy = (DynamicObject)changeSet[0].getNewValue();
        DynamicObject mainBillDy = this.getModel().getDataEntity();
        this.clearEntity(mainBillDy, false);
        if (Objects.nonNull(affactionNewDy) && affactionNewDy.getBoolean("isnewchgaction")) {
            this.clearMainField(mainBillDy);
            DynamicObject erManFileDy = mainBillDy.getDynamicObject("b_ermanfile");
            if (Objects.nonNull(erManFileDy)) {
                this.changeErManFile(erManFileDy, null);
            }
        }
    }

    private void clearEntity(DynamicObject mainBillDy, boolean clearMainField) {
        DataEntityPropertyCollection properties = mainBillDy.getDataEntityType().getProperties();
        List entryList = PerChgNewBillUtils.getEntryList((DataEntityPropertyCollection)properties, (String)"entry_");
        entryList.forEach(data -> this.getModel().deleteEntryData(data));
        if (!clearMainField) {
            return;
        }
        this.clearMainField(mainBillDy);
    }

    private void clearMainField(DynamicObject mainBillDy) {
        DataEntityPropertyCollection properties = mainBillDy.getDataEntityType().getProperties();
        List fields = properties.stream().filter(data -> data.getName().startsWith("bb_") || data.getName().startsWith("ba_")).map(IMetadata::getName).collect(Collectors.toList());
        fields.addAll(BILL_FIELDS);
        Set<String> extSet = this.getExtField(mainBillDy);
        for (String field : fields) {
            if (extSet.contains(field) || !properties.containsKey((Object)field)) continue;
            mainBillDy.set(field, null);
            if (this.getView() == null) continue;
            this.getView().getModel().setValue(field, null);
            this.getView().updateView(field);
        }
    }

    private Set<String> getExtField(DynamicObject mainBillDy) {
        Set<String> extSet = new HashSet<String>(16);
        if (this.getView() == null) {
            FormMetadata formMetadata;
            List items;
            String name = mainBillDy.getDataEntityType().getName();
            String id = MetadataDao.getIdByNumber((String)name, (MetaCategory)MetaCategory.Form);
            AbstractMetadata abstractMetadata = MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
            if (abstractMetadata instanceof FormMetadata && CollectionUtils.isNotEmpty((Collection)(items = (formMetadata = (FormMetadata)abstractMetadata).getItems()))) {
                extSet = items.stream().filter(AbstractElement::isExt).map(AbstractElement::getKey).collect(Collectors.toSet());
            }
        } else {
            String extField = this.getView().getPageCache().get("extField");
            if (HRStringUtils.isNotEmpty((String)extField)) {
                extSet = (Set)SerializationUtils.fromJsonString((String)extField, Set.class);
            }
        }
        return extSet;
    }

    private boolean ermanfileChange(DynamicObject affactionNewDy, DynamicObject mainBillDy) {
        DynamicObject bErmanfileDy = mainBillDy.getDynamicObject("b_ermanfile");
        if (Objects.nonNull(bErmanfileDy) && bErmanfileDy.getLong("id") > 0L) {
            boolean laborrelstatusFlag;
            long ermanfileId = bErmanfileDy.getLong("id");
            DynamicObject ermanfileDy = HRBaseDaoFactory.getInstance((String)"hspm_ermanfile").queryOriginalOne("employee.laborreltype,employee.laborrelstatus", new QFilter[]{new QFilter("id", "=", (Object)ermanfileId)});
            long laborreltypeId = ermanfileDy.getLong("employee.laborreltype");
            long laborrelstatusId = ermanfileDy.getLong("employee.laborrelstatus");
            DynamicObjectCollection mulpersonlaborreltypeDyColl = affactionNewDy.getDynamicObjectCollection("mulpersonlaborreltype");
            Set laborreltypeIdSet = mulpersonlaborreltypeDyColl.stream().map(mulpersonlaborreltypeDy -> mulpersonlaborreltypeDy.getLong("fbasedataid_id")).collect(Collectors.toSet());
            DynamicObjectCollection mulpersonlaborrelstatusDyColl = affactionNewDy.getDynamicObjectCollection("mulpersonlaborrelstatus");
            Set laborrelstatusIdSet = mulpersonlaborrelstatusDyColl.stream().map(mulpersonlaborrelstatusDy -> mulpersonlaborrelstatusDy.getLong("fbasedataid_id")).collect(Collectors.toSet());
            boolean laborreltypeFlag = !laborreltypeIdSet.isEmpty() && !laborreltypeIdSet.contains(laborreltypeId);
            boolean bl = laborrelstatusFlag = !laborrelstatusIdSet.isEmpty() && !laborrelstatusIdSet.contains(laborrelstatusId);
            if (laborreltypeFlag || laborrelstatusFlag) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u9009\u4eba\u5458\u53d8\u52a8\u64cd\u4f5c\u4e0d\u9002\u7528\u3002", (String)"PerChgNewBillTplEdit_1", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
                return true;
            }
        }
        return false;
    }

    private void setAfterPersonChgType(DynamicObject mainBillDy) {
        PerChgNewBillUtils.setChgTypeDefaultValue((DynamicObject)mainBillDy, Collections.singletonList("entry_a_person"), (IFormView)this.getView());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String status;
        String[] split;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        DynamicObject mainBillDy = this.getModel().getDataEntity();
        if (operateKey.endsWith("_newentry") && (Objects.isNull(mainBillDy.get("b_ermanfile")) || Objects.isNull(mainBillDy.get("affaction")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4eba\u4e8b\u4e1a\u52a1\u6863\u6848\u548c\u53d8\u52a8\u64cd\u4f5c\u3002", (String)"PerChgNewBillTplEdit_2", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
        if (operateKey.equals("donothing_retry") && Arrays.stream(split = (status = mainBillDy.getString("perchgstatus")).split(",")).anyMatch(arg -> HRStringUtils.equals((String)arg, (String)PerChgStatusEnum.UNEXECUTED.getCode()) || HRStringUtils.equals((String)arg, (String)PerChgStatusEnum.PROGRESS.getCode()) || HRStringUtils.equals((String)arg, (String)PerChgStatusEnum.SUCCESS.getCode()))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5931\u8d25\u72b6\u6001\u7684\u5355\u636e\u53ef\u4ee5\u91cd\u8bd5\u3002", (String)"PerChgNewBillTplEdit_3", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (operateKey.endsWith("_newentry")) {
            String entryId = (String)((NewEntry)args.getSource()).getParameter().get("entryId");
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(entryId);
            if (this.setChgType(entryCurrentRowIndex, entryId, ChgModeEnum.ADD_NEW)) {
                return;
            }
            DynamicObject mainBillDy = this.getModel().getDataEntity();
            if (this.setThreePersonId(entryId, entryCurrentRowIndex, mainBillDy)) {
                return;
            }
            PerChgNewBillUtils.setBusinessStatusByChgType((DynamicObject)mainBillDy, null, (IFormView)this.getView());
            PerChgNewBillUtils.setEffectiveDateByChgType((DynamicObject)mainBillDy, null, (IFormView)this.getView());
            this.getView().updateView(entryId);
        }
    }

    private boolean setThreePersonId(String entryId, int entryCurrentRowIndex, DynamicObject mainBillDy) {
        long did;
        long eid;
        long pid;
        Map threePersonId = PerChgNewBillUtils.getThreePersonId((DynamicObject)mainBillDy, (IFormView)this.getView());
        if (entryId.startsWith("entry_b_")) {
            pid = threePersonId.getOrDefault("bb_p_tid", 0L);
            eid = threePersonId.getOrDefault("bb_e_tid", 0L);
            did = threePersonId.getOrDefault("bb_d_tid", 0L);
        } else {
            pid = threePersonId.getOrDefault("ba_p_tid", 0L);
            eid = threePersonId.getOrDefault("ba_e_tid", 0L);
            did = threePersonId.getOrDefault("ba_d_tid", 0L);
        }
        DynamicObject entryEntityDy = this.getModel().getEntryRowEntity(entryId, entryCurrentRowIndex);
        List pidList = entryEntityDy.getDynamicObjectType().getProperties().stream().filter(data -> data.getName().endsWith("_pid")).map(IMetadata::getName).collect(Collectors.toList());
        List eidList = entryEntityDy.getDynamicObjectType().getProperties().stream().filter(data -> data.getName().endsWith("_eid")).map(IMetadata::getName).collect(Collectors.toList());
        List didList = entryEntityDy.getDynamicObjectType().getProperties().stream().filter(data -> data.getName().endsWith("_did")).map(IMetadata::getName).collect(Collectors.toList());
        List tidList = entryEntityDy.getDynamicObjectType().getProperties().stream().filter(data -> data.getName().endsWith("_tid")).map(IMetadata::getName).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(pidList) || CollectionUtils.isEmpty(eidList) || CollectionUtils.isEmpty(didList) || CollectionUtils.isEmpty(tidList)) {
            return true;
        }
        HRPageCache hrPageCache = new HRPageCache(this.getView());
        String entityName = (String)hrPageCache.get(entryId, String.class);
        if (StringUtils.isBlank((CharSequence)entityName)) {
            Map<String, String> sourceEntryAndTargetEntry = this.getTid(mainBillDy);
            entityName = sourceEntryAndTargetEntry.getOrDefault(entryId, "");
        }
        if (StringUtils.isNotBlank((CharSequence)entityName)) {
            long id = ORM.create().genLongId(entityName);
            entryEntityDy.set((String)tidList.get(0), (Object)id);
        }
        entryEntityDy.set((String)pidList.get(0), (Object)pid);
        entryEntityDy.set((String)eidList.get(0), (Object)eid);
        entryEntityDy.set((String)didList.get(0), (Object)did);
        return false;
    }

    private Map<String, String> getTid(DynamicObject mainBillDy) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        long chgActionId = mainBillDy.getLong("affaction.id");
        if (chgActionId == 0L) {
            return resultMap;
        }
        List chgActionMappedBeans = HPFSNewChgHelper.queryMapped(Collections.singleton(chgActionId));
        for (ChgActionMappedBean chgActionMappedBean : chgActionMappedBeans) {
            if (Objects.isNull(chgActionMappedBean)) {
                return resultMap;
            }
            LOGGER.info("###PerChgNewBillUtil.setExtUtilsEntryInfoByMappedInfo-chgActionMappedBean {}", (Object)chgActionMappedBean.toString());
            if (!chgActionMappedBean.isSuccess()) {
                String errMsg = chgActionMappedBean.getErrMsg();
                LOGGER.warn("###PerChgNewBillUtil.setExtUtilsEntryInfoByMappedInfo-errMsg {}", (Object)errMsg);
                return resultMap;
            }
            DynamicObject mappedDy = chgActionMappedBean.getMappedDy();
            if (Objects.isNull(mappedDy)) {
                LOGGER.warn("###PerChgNewBillUtil.setExtUtilsEntryInfoByMappedInfo-mappedDy is null");
                continue;
            }
            LOGGER.info("###PerChgNewBillUtil.setExtUtilsEntryInfoByMappedInfo-mappedDy {}", (Object)mappedDy);
            DynamicObjectCollection entryEntityDys = mappedDy.getDynamicObjectCollection("entryentity");
            String name = mainBillDy.getDynamicObjectType().getName();
            Set allParentAndSelfEntityNames = HpfsMetaDataServiceHelper.getAllParentAndSelfEntityName((String)name, null);
            List entryEntityDyList = entryEntityDys.stream().filter(data -> allParentAndSelfEntityNames.contains(data.getString("sourceentity.number")) && data.getString("pairtype").contains(",2,") && data.getString("sourceentry").startsWith("entry_") && !THREE_PERSON_ORDERS.contains(data.getString("sourceentry"))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(entryEntityDyList)) {
                LOGGER.warn("###PerChgNewBillUtil.setExtUtilsEntryInfoByMappedInfo-entryEntityDyList is null");
                return resultMap;
            }
            for (DynamicObject entryEntityDy : entryEntityDyList) {
                String sourceEntry = entryEntityDy.getString("sourceentry");
                String targetEntity = entryEntityDy.getString("targetentity.number");
                resultMap.put(sourceEntry, targetEntity);
            }
        }
        return resultMap;
    }

    private void changeEffectiveDate() {
        DynamicObject mainBillDy = this.getModel().getDataEntity();
        PerChgNewBillUtils.setEffectiveDateByChgType((DynamicObject)mainBillDy, null, (IFormView)this.getView());
    }

    private void setExtUtilsEntryData() {
        DynamicObject mainBillDy = this.getModel().getDataEntity();
        if (Objects.isNull(mainBillDy.get("b_ermanfile")) && !PerChgNewBillUtils.threePersonIsEmpty((IFormView)this.getView(), (DynamicObject)mainBillDy)) {
            PerChgNewBillUtils.setBillFieldByEntryField((DynamicObject)mainBillDy, (IFormView)this.getView());
            long mid = this.getManFileByDepEmpIds();
            if (mid != 0L) {
                this.getModel().setValue("b_ermanfile", (Object)mid);
                mainBillDy.set("b_ermanfile", (Object)mid);
            }
        }
        PerChgNewBillUtils.setExtUtilsEntryData((DynamicObject)mainBillDy, (IFormView)this.getView());
    }

    private long getManFileByDepEmpIds() {
        QFilter qFilter;
        HRBaseServiceHelper helper;
        DynamicObject[] dys;
        LOGGER.info("###PerChgNewBillTplEdit.getManFileByDepEmpIds-start");
        Object didObj = this.getModel().getValue("bb_d_tid");
        LOGGER.info("###PerChgNewBillTplEdit.getManFileByDepEmpIds-did {}", didObj);
        long did = 0L;
        if (didObj instanceof Long) {
            did = (Long)didObj;
        } else if (didObj instanceof Integer) {
            did = ((Integer)didObj).longValue();
        }
        long mid = 0L;
        if (did != 0L && Objects.nonNull(dys = (helper = new HRBaseServiceHelper("hspm_ermanfile")).query("id", new QFilter[]{qFilter = new QFilter("depemp.id", "in", (Object)did), RepositoryUtils.isCurrentVersion(), RepositoryUtils.isDataStatus(), RepositoryUtils.isBusinessStatusEffect()})) && dys.length != 0) {
            mid = dys[0].getLong("id");
        }
        LOGGER.info("###PerChgNewBillTplEdit.getManFileByDepEmpIds-end mid {}", (Object)mid);
        return mid;
    }

    private void changeErManFile(ChangeData[] changeSet) {
        DynamicObject erManFileDy = (DynamicObject)changeSet[0].getNewValue();
        DynamicObject mainBillDy = this.getModel().getDataEntity();
        DynamicObject affactionNewDy = mainBillDy.getDynamicObject("affaction");
        if (Objects.nonNull(affactionNewDy) && affactionNewDy.getBoolean("isnewchgaction")) {
            if (Objects.nonNull(changeSet[0].getOldValue())) {
                if (Objects.nonNull(erManFileDy)) {
                    this.changeErManFile(erManFileDy, changeSet[0].getOldValue());
                } else {
                    this.clearEntity(mainBillDy, true);
                }
                return;
            }
            this.changeErManFile(erManFileDy, null);
        }
    }

    private void changeErManFile(DynamicObject erManFileDy, Object oldErManFileDy) {
        DynamicObject mainBillDy = this.getModel().getDataEntity();
        PerChgNewBillUtils.changeErManFile((DynamicObject)mainBillDy, (IFormView)this.getView(), (DynamicObject)erManFileDy, (Object)oldErManFileDy);
    }

    private boolean threePersonIsEmpty() {
        List threePersons = BEFORE_THREE_PERSON.stream().filter(data -> this.getModel().getEntryEntity(data).isEmpty()).collect(Collectors.toList());
        return threePersons.size() == 3;
    }

    public void afterLoadData(EventObject args) {
        DynamicObject mainBillDy = this.getModel().getDataEntity();
        PerChgNewBillUtils.setBillFieldByEntryField((DynamicObject)mainBillDy, (IFormView)this.getView());
        if (Objects.isNull(mainBillDy.get("b_ermanfile")) && !PerChgNewBillUtils.threePersonIsEmpty((IFormView)this.getView(), (DynamicObject)mainBillDy)) {
            PerChgNewBillUtils.setBillFieldByEntryField((DynamicObject)mainBillDy, (IFormView)this.getView());
            long mid = this.getManFileByDepEmpIds();
            if (mid != 0L) {
                this.getModel().setValue("b_ermanfile", (Object)mid);
                mainBillDy.set("b_ermanfile", (Object)mid);
            }
        }
        if (this.getModel().getDataChanged()) {
            this.getModel().setDataChanged(false);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObjectCollection mulemplaborrelstatusDyColl;
        List laborrelstatusIdList;
        DynamicObject affactionDy;
        String entityId = this.getView().getEntityId();
        String name = beforeF7SelectEvent.getProperty().getName();
        String billIsnewchgaction = this.getBusinessValue();
        beforeF7SelectEvent.getFormShowParameter().setCustomParam(BUSINESS_VALUE, (Object)billIsnewchgaction);
        if (HRStringUtils.equals((String)billIsnewchgaction, (String)"0")) {
            LOGGER.info("{} use old isnewchgaction.", (Object)entityId);
            return;
        }
        if (HRStringUtils.equals((String)name, (String)"affaction")) {
            QFilter qFilter = new QFilter("mulbillsource.fbasedataid", "=", (Object)entityId);
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            beforeF7SelectEvent.addCustomQFilter(qFilter);
        } else if (HRStringUtils.equals((String)name, (String)FIELD_LABORREL_TYPE)) {
            DynamicObjectCollection mulemplaborreltypeDyColl;
            List laborreltypeIdList;
            DynamicObject affactionDy2 = this.getModel().getDataEntity().getDynamicObject("affaction");
            if (Objects.nonNull(affactionDy2) && affactionDy2.getBoolean("isnewchgaction") && !(laborreltypeIdList = (mulemplaborreltypeDyColl = affactionDy2.getDynamicObjectCollection("mulemplaborreltype")).stream().map(mulemplaborreltypeDy -> mulemplaborreltypeDy.getLong("fbasedataid_id")).collect(Collectors.toList())).isEmpty()) {
                beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", laborreltypeIdList));
            }
        } else if (HRStringUtils.equals((String)name, (String)FIELD_LABORREL_STATUS) && Objects.nonNull(affactionDy = this.getModel().getDataEntity().getDynamicObject("affaction")) && affactionDy.getBoolean("isnewchgaction") && !(laborrelstatusIdList = (mulemplaborrelstatusDyColl = affactionDy.getDynamicObjectCollection("mulemplaborrelstatus")).stream().map(mulemplaborrelstatusDy -> mulemplaborrelstatusDy.getLong("fbasedataid_id")).collect(Collectors.toList())).isEmpty()) {
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "in", laborrelstatusIdList));
        }
    }

    private String getBusinessValue() {
        String billIsnewchgaction = this.getPageCache().get(BUSINESS_VALUE);
        if (HRStringUtils.isEmpty((String)billIsnewchgaction)) {
            billIsnewchgaction = "1";
            this.getPageCache().put(BUSINESS_VALUE, billIsnewchgaction);
        }
        return billIsnewchgaction;
    }

    public void afterImportData(ImportDataEventArgs args) {
        DynamicObject billFileDy;
        super.afterImportData(args);
        DynamicObject dy = this.getModel().getDataEntity();
        Object oFileObj = args.getOption().get("b_ermanfile");
        DataEntityPropertyCollection properties = dy.getDataEntityType().getProperties();
        if (Objects.isNull(oFileObj) && properties.containsKey((Object)"partperson")) {
            this.setFileData(dy, "partperson");
        } else if (Objects.isNull(oFileObj) && properties.containsKey((Object)"ermanfile")) {
            this.setFileData(dy, "ermanfile");
        } else if (oFileObj instanceof String && properties.containsKey((Object)((String)oFileObj))) {
            this.setFileData(dy, (String)oFileObj);
        } else if (properties.containsKey((Object)"b_ermanfile") && (billFileDy = dy.getDynamicObject("b_ermanfile")) != null) {
            this.changeErManFile(billFileDy, null);
        }
    }

    private void setFileData(DynamicObject dy, String file) {
        DynamicObject billFileDy = dy.getDynamicObject(file);
        if (billFileDy != null) {
            dy.set("b_ermanfile", (Object)billFileDy);
            this.changeErManFile(billFileDy, null);
        }
    }
}

