/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hpfs.common.constants.ChgRuleConstants;
import kd.hr.hpfs.common.constants.ChgStrategyConstants;
import kd.sdk.hr.hpfs.common.constants.ChgConstants;

public class RuleEditPlugin
extends HRDataBaseEdit
implements ChgConstants,
ChgRuleConstants,
ChgStrategyConstants {
    private static final Log LOGGER = LogFactory.getLog(RuleEditPlugin.class);

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        if (HRStringUtils.equals((String)fieldKey, (String)"chgaction")) {
            this.changeAction(e);
        }
    }

    private void changeAction(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        DynamicObject billObj = this.getModel().getDataEntity(true);
        EntryProp entryProp = (EntryProp)this.getModel().getDataEntityType().getProperties().get((Object)"entryentity");
        DynamicObjectCollection rows = (DynamicObjectCollection)entryProp.getValue((Object)billObj);
        rows.clear();
        this.getView().updateView("entryentity");
        if (newValue == null) {
            this.getModel().setValue("chgstrategy", null);
            return;
        }
        this.updateTacticCollByAction(newValue, rows);
    }

    private void updateTacticCollByAction(Object newValue, DynamicObjectCollection rows) {
        Long category = ((DynamicObject)newValue).getDynamicObject("chgcategory").getLong("id");
        HRBaseServiceHelper strategyHelper = new HRBaseServiceHelper("hpfs_chgstrategy");
        DynamicObject strategy = strategyHelper.loadDynamicObject(new QFilter[]{new QFilter("chgcategory", "=", (Object)category)});
        this.getModel().setValue("chgstrategy", (Object)strategy);
        HRBaseServiceHelper strategyConfigHelper = new HRBaseServiceHelper("hpfs_affstrategyentry");
        DynamicObject[] strategyConfig = strategyConfigHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("chgstrategy", "=", strategy.get("id"))});
        List<DynamicObject> tacticList = Arrays.stream(strategyConfig).map(row -> row.getDynamicObject("chgtactic")).distinct().collect(Collectors.toList());
        DynamicObjectCollection originCollection = this.getModel().getEntryEntity("entryentity");
        DynamicObjectCollection collection = new DynamicObjectCollection();
        tacticList.forEach(row -> {
            DynamicObject dynamicObject = originCollection.addNew();
            dynamicObject.set("tactic", row);
            collection.add((Object)dynamicObject);
        });
        rows.clear();
        rows.addAll((Collection)collection);
        this.getView().updateView("entryentity");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "activeconfig": {
                this.activeConfig();
                break;
            }
            case "save": {
                this.saveRuleConfig();
                break;
            }
            case "tacticdel": {
                this.delRuleTactic();
                break;
            }
        }
    }

    private void activeConfig() {
        this.getModel().setValue("status", (Object)this.getView().getFormShowParameter().getStatus().getValue());
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        baseShowParameter.setFormId("hpfs_chgruleconfig");
        baseShowParameter.setBillStatus(BillOperationStatus.EDIT);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("chgstrategy", ((DynamicObject)this.getModel().getValue("chgstrategy")).getLong("id") + "");
        Long tacticId = ((DynamicObject)this.getEntitySelectedData().get("tactic")).getLong("id");
        map.put("chgtactic", tacticId + "");
        if (this.getPageCache().get("data") != null) {
            Map tacticDataMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("data"), Map.class);
            map.put("data", (String)tacticDataMap.get(tacticId + ""));
        }
        baseShowParameter.setCustomParam("params", map);
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "callback"));
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private void delRuleTactic() {
        int index = this.getEntitySelectedNumber();
        DynamicObjectCollection originCollection = this.getModel().getEntryEntity("entryentity");
        DynamicObject entry = (DynamicObject)originCollection.get(this.getEntitySelectedNumber().intValue());
        boolean isCoreRule = entry.getBoolean("iscorerule");
        if (isCoreRule) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u5fc3\u89c4\u5219\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"RuleEditPlugin_0", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
        }
        originCollection.remove(index);
        this.getModel().setValue("entryentity", (Object)originCollection);
        this.getModel().updateCache();
    }

    private void saveRuleConfig() {
        Long ruleId = (Long)this.getModel().getValue("id");
        if (ruleId == 0L) {
            Long newRuleId;
            ruleId = newRuleId = Long.valueOf(ORM.create().genLongId("hpfs_chgrule"));
            this.getModel().setValue("id", (Object)newRuleId);
        }
        DynamicObjectCollection tactics = this.getModel().getEntryEntity("entryentity");
        HRBaseServiceHelper ruleConfigHelper = new HRBaseServiceHelper("hpfs_chgconfigentry");
        List<DynamicObject> ruleConfigs = this.formatDyn2Save(tactics, ruleConfigHelper, ruleId);
        try (TXHandle h = TX.requiresNew();){
            try {
                ruleConfigHelper.deleteByFilter(new QFilter[]{new QFilter("chgrule", "=", (Object)ruleId)});
                ruleConfigHelper.save(ruleConfigs.toArray(new DynamicObject[0]));
            }
            catch (RuntimeException e) {
                LOGGER.error("*****PerChg Found Error***** : ", (Throwable)e);
                h.markRollback();
                throw new KDException((Throwable)e, new ErrorCode("RuleEditPlugin", e.getMessage()), new Object[0]);
            }
        }
        this.getModel().setValue("status", (Object)"C");
    }

    private List<DynamicObject> formatDyn2Save(DynamicObjectCollection tactics, HRBaseServiceHelper ruleConfigHelper, Long ruleId) {
        ArrayList<DynamicObject> ruleConfigs = new ArrayList<DynamicObject>();
        String data = this.getPageCache().get("data");
        if (data == null) {
            return Collections.emptyList();
        }
        Map tacticMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
        tactics.forEach(tactic -> {
            String tacticId = tactic.getDynamicObject("tactic").getLong("id") + "";
            if (!tacticMap.containsKey(tacticId)) {
                return;
            }
            Map ruleConfigMap = (Map)tacticMap.get(tacticId);
            List fields = (List)ruleConfigMap.get("fields");
            if (CollectionUtils.isEmpty((Collection)fields)) {
                DynamicObject ruleConfig = this.formatRuleConfigDyn(ruleConfigHelper, ruleId, ruleConfigMap, Collections.emptyMap());
                ruleConfigs.add(ruleConfig);
                return;
            }
            fields.forEach(field -> {
                DynamicObject ruleConfig = this.formatRuleConfigDyn(ruleConfigHelper, ruleId, ruleConfigMap, (Map<String, Object>)field);
                ruleConfigs.add(ruleConfig);
            });
        });
        return ruleConfigs;
    }

    private DynamicObject formatRuleConfigDyn(HRBaseServiceHelper ruleConfigHelper, Long ruleId, Map<String, Object> ruleConfigMap, Map<String, Object> field) {
        DynamicObject ruleConfig = ruleConfigHelper.generateEmptyDynamicObject();
        ruleConfig.set("chgrule", (Object)ruleId);
        ruleConfig.set("chgtactic", ruleConfigMap.get("tactic"));
        ruleConfig.set("filemapping", ruleConfigMap.get("mapping"));
        if (CollectionUtils.isEmpty(field)) {
            return ruleConfig;
        }
        ruleConfig.set("chgfile", field.get("field"));
        ruleConfig.set("chgtype", field.get("chgType"));
        ruleConfig.set("entitysource", field.get("entitySource"));
        ruleConfig.set("fieldsource", field.get("fieldSource"));
        ruleConfig.set("valrange_tag", field.get("valrange"));
        ruleConfig.set("val", field.get("val"));
        return ruleConfig;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object dataReturned = closedCallBackEvent.getReturnData();
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"callback") && dataReturned != null) {
            Map dataReturnedMap = (Map)dataReturned;
            Long tacticId = (Long)dataReturnedMap.get("tactic");
            Map tacticDataMap = new HashMap<Long, Map>();
            if (this.getPageCache().get("data") != null) {
                tacticDataMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("data"), Map.class);
            }
            tacticDataMap.put(tacticId, dataReturnedMap);
            this.getPageCache().put("data", SerializationUtils.toJsonString(tacticDataMap));
        }
    }

    private DynamicObject getEntitySelectedData() {
        DynamicObjectCollection originCollection = this.getModel().getEntryEntity("entryentity");
        return (DynamicObject)originCollection.get(this.getEntitySelectedNumber().intValue());
    }

    private Integer getEntitySelectedNumber() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        IClientViewProxy clientViewProxy = (IClientViewProxy)entryGrid.getView().getService(IClientViewProxy.class);
        return (Integer)((Map)clientViewProxy.getViewState("entryentity")).get("row");
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("customentryentity");
        DynamicObjectCollection custom = new DynamicObjectCollection();
        DynamicObjectCollection config = this.getModel().getEntryEntity("entryentity");
        ArrayList tacticList = new ArrayList();
        dynamicObjectCollection.forEach(row -> {
            if (HRStringUtils.equals((String)row.getString("isconfigured"), (String)"1")) {
                custom.add(row);
            } else {
                tacticList.add(row.getDynamicObject("chgtactic"));
            }
        });
        tacticList.stream().distinct().forEach(row -> {
            DynamicObject newDy = config.addNew();
            newDy.set("tactic", row);
        });
        this.getModel().setValue("customentryentity", (Object)custom);
        this.cacheRuleConfigData(dynamicObjectCollection);
        this.getModel().setDataChanged(false);
    }

    private void cacheRuleConfigData(DynamicObjectCollection dynamicObjectCollection) {
        if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
            return;
        }
        Map<Long, List<DynamicObject>> configMapByTactic = dynamicObjectCollection.stream().collect(Collectors.groupingBy(row -> row.getLong("chgtactic_id")));
        Map<String, Map> tacticDataMap = configMapByTactic.entrySet().stream().collect(Collectors.toMap(row -> row.getKey() + "", entry -> {
            HashMap<String, Object> data = new HashMap<String, Object>(3);
            data.put("tactic", entry.getKey());
            Object mappingPlan = ((DynamicObject)((List)entry.getValue()).get(0)).get("filemapping_id");
            if (mappingPlan != null) {
                data.put("mapping", mappingPlan);
            }
            List fields = ((List)entry.getValue()).stream().map(this::formatFieldDataMap).collect(Collectors.toList());
            data.put("fields", fields);
            return data;
        }));
        this.getPageCache().put("data", SerializationUtils.toJsonString(tacticDataMap));
    }

    private Map<String, Object> formatFieldDataMap(DynamicObject config) {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        fieldMap.put("field", config.getString("chgfile"));
        fieldMap.put("chgType", config.getString("chgtype"));
        fieldMap.put("entitySource", config.get("entitysource"));
        fieldMap.put("fieldSource", config.get("fieldsource"));
        fieldMap.put("valrange", config.get("valrange_tag"));
        fieldMap.put("val", config.get("val"));
        fieldMap.put("iscorerule", config.get("iscorerule"));
        if (HRStringUtils.isNotEmpty((String)config.getString("entitysource"))) {
            fieldMap.put("checkbox", "1");
        } else {
            fieldMap.put("checkbox", "0");
        }
        return fieldMap;
    }
}

