/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hpfs.business.domain.repository.perchg.ChgStrategyConfigRepository;
import kd.hr.hpfs.common.constants.ChgStrategyConstants;
import kd.hr.hpfs.formplugin.service.ChgLocalValueService;
import kd.sdk.hr.hpfs.common.constants.ChgConstants;

public class StrategyEditPlugin
extends HRDataBaseEdit
implements ListboxClickListener,
BeforeF7SelectListener,
ChgConstants,
ChgStrategyConstants {
    private static final Log LOGGER = LogFactory.getLog(StrategyEditPlugin.class);
    private static final String TATIC_FLOW_TYPE = "taticflowtype";
    private static final String[] LIST_BOX_FIELD = new String[]{"chgobject", "applicablestage", "chgtactic", "iscorerule", "entryentity", "taticflowtype"};

    public void registerListener(EventObject event) {
        super.registerListener(event);
        Listbox box = (Listbox)this.getView().getControl("listboxap");
        box.addListboxClickListener((ListboxClickListener)this);
        BasedataEdit fieldEdit = (BasedataEdit)this.getView().getControl("chgtactic");
        fieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Button button = (Button)this.getView().getControl("btnnew");
        Button buttonDel = (Button)this.getView().getControl("btndel");
        button.addClickListener((ClickListener)this);
        buttonDel.addClickListener((ClickListener)this);
    }

    public void listboxClick(ListboxEvent listboxEvent) {
        String itemId = listboxEvent.getItemId();
        Map map = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("listboxdata"), Map.class);
        this.cacheListBoxData();
        this.setPageData(map, itemId);
        this.getPageCache().put("listboxindex", itemId);
    }

    private void setPageData(Map<String, Map<String, Object>> map, String itemId) {
        if (map.get(itemId) == null) {
            return;
        }
        Map<String, Object> dataNew = map.get(itemId);
        Arrays.asList(LIST_BOX_FIELD).forEach(field -> {
            Object data = dataNew.get(field);
            if (data == null) {
                this.getModel().setValue(field, null);
                return;
            }
            if (data instanceof Map) {
                if ("chgobject".equals(field) && !"hrpi_empposorgrel".equals(((Map)data).get("number"))) {
                    this.getView().setVisible(Boolean.FALSE, new String[]{TATIC_FLOW_TYPE});
                } else if ("chgobject".equals(field) && "hrpi_empposorgrel".equals(((Map)data).get("number"))) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{TATIC_FLOW_TYPE});
                }
                this.getModel().setValue(field, ((Map)data).get("id"));
            } else if (data instanceof List) {
                this.setEntryEntityData(data);
            } else if (data instanceof Boolean) {
                this.getModel().setValue(field, (Object)((Boolean)data != false ? "1" : "0"));
            } else {
                this.getModel().setValue(field, data);
            }
        });
    }

    private void setEntryEntityData(Object data) {
        List list = (List)data;
        DynamicObjectCollection originCollection = this.getModel().getEntryEntity("entryentity");
        DynamicObjectCollection collection = new DynamicObjectCollection();
        list.forEach(row -> {
            DynamicObject dynamicObject = originCollection.addNew();
            row.forEach((arg_0, arg_1) -> ((DynamicObject)dynamicObject).set(arg_0, arg_1));
            collection.add((Object)dynamicObject);
        });
        DynamicObject billObj = this.getModel().getDataEntity(true);
        EntryProp entryProp = (EntryProp)this.getModel().getDataEntityType().getProperties().get((Object)"entryentity");
        DynamicObjectCollection rows = (DynamicObjectCollection)entryProp.getValue((Object)billObj);
        rows.clear();
        rows.addAll((Collection)collection);
        this.getView().updateView("entryentity");
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btnnew": {
                this.addListBox();
                break;
            }
            case "btndel": {
                this.delListBox();
                break;
            }
        }
    }

    private void addListBox() {
        this.cacheListBoxData();
        Listbox listbox = (Listbox)this.getControl("listboxap");
        String listStr = this.getPageCache().get("listboxap");
        List list = (List)SerializationUtils.fromJsonString((String)listStr, List.class);
        int index = Integer.parseInt(((Map)list.get(list.size() - 1)).get("id").toString()) + 1;
        List boxItemList = list.stream().map(map -> new ListboxItem((String)map.get("id"), (String)map.get("content"))).collect(Collectors.toList());
        boxItemList.add(new ListboxItem(index + "", CHINESE_TACTIC + index));
        listbox.addItems(boxItemList);
        this.getPageCache().put("listboxap", SerializationUtils.toJsonString(boxItemList));
        this.getPageCache().put("listboxindex", index + "");
        listbox.activeItem(index + "");
        this.getModel().setValue("chgobject", (Object)"");
        this.getModel().setValue("applicablestage", (Object)"");
        this.getModel().setValue("chgtactic", (Object)"");
        DynamicObject billObj = this.getModel().getDataEntity(true);
        EntryProp entryProp = (EntryProp)this.getModel().getDataEntityType().getProperties().get((Object)"entryentity");
        DynamicObjectCollection rows = (DynamicObjectCollection)entryProp.getValue((Object)billObj);
        rows.clear();
        this.getView().updateView("entryentity");
    }

    private void delListBox() {
        Listbox listbox = (Listbox)this.getControl("listboxap");
        int index = Integer.parseInt(this.getPageCache().get("listboxindex"));
        String listStr = this.getPageCache().get("listboxap");
        List list = (List)SerializationUtils.fromJsonString((String)listStr, List.class);
        if (list.size() == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u540e\u4e00\u4e2a\u83dc\u5355\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"StrategyEditPlugin_0", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
        }
        Map dataMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("listboxdata"), Map.class);
        dataMap.remove(index + "");
        List boxItemList = list.stream().filter(map -> !HRStringUtils.equals((String)((String)map.get("id")), (String)(index + ""))).map(map -> new ListboxItem((String)map.get("id"), (String)map.get("content"))).collect(Collectors.toList());
        listbox.addItems(boxItemList);
        this.getPageCache().put("listboxap", SerializationUtils.toJsonString(boxItemList));
        this.getPageCache().put("listboxindex", ((ListboxItem)boxItemList.get(0)).getId());
        this.getPageCache().put("listboxdata", SerializationUtils.toJsonString((Object)dataMap));
        String indexNew = ((ListboxItem)boxItemList.get(0)).getId();
        this.setPageData(dataMap, indexNew);
        this.getPageCache().put("listboxindex", indexNew);
        listbox.activeItem(indexNew);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "config_strategy": {
                this.beforeActiveConfig();
                break;
            }
            case "save": {
                this.beforeActiveSave();
                break;
            }
        }
    }

    private void beforeActiveConfig() {
        DynamicObject rowData = this.getEntitySelectedData();
        String fieldNumber = rowData.getString("field");
        this.getModel().setValue("status", (Object)this.getView().getFormShowParameter().getStatus().getValue());
        if (HRStringUtils.isEmpty((String)fieldNumber)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u5b57\u6bb5\u3002", (String)"StrategyEditPlugin_1", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject tactic = (DynamicObject)this.getModel().getValue("chgtactic");
        if (tactic == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u53d8\u52a8\u6d3b\u52a8\u3002", (String)"StrategyEditPlugin_2", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
            return;
        }
        this.cacheListBoxData();
        String chgChangeObjectNumber = ((DynamicObject)this.getModel().getValue("chgobject")).getString("number");
        Object fieldObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)chgChangeObjectNumber)).getDataEntityType().getProperties().get((Object)fieldNumber);
        String classSimpleName = fieldObject.getClass().getSimpleName();
        List<String> showFormList = Arrays.asList(BasedataProp.class.getSimpleName(), MulBasedataProp.class.getSimpleName(), ComboProp.class.getSimpleName(), BooleanProp.class.getSimpleName());
        if (!showFormList.contains(classSimpleName)) {
            return;
        }
        String tacticName = tactic.getString("name");
        this.showConfigPage(tacticName, chgChangeObjectNumber, fieldNumber, classSimpleName, fieldObject);
    }

    private void showConfigPage(String tacticName, String chgChangeObjectNumber, String fieldNumber, String classSimpleName, Object fieldObject) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("hpfs_chgstrategyconfig");
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        baseShowParameter.setBillStatus(BillOperationStatus.EDIT);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("chgtactic", tacticName);
        map.put("field", this.getComboItemNameByValue(chgChangeObjectNumber, fieldNumber));
        map.put("class", classSimpleName.equals(BooleanProp.class.getSimpleName()) ? ComboProp.class.getSimpleName() : classSimpleName);
        if (HRStringUtils.equals((String)classSimpleName, (String)ComboProp.class.getSimpleName())) {
            map.put("combo", this.formatComboList(fieldObject));
        } else if (HRStringUtils.equals((String)classSimpleName, (String)BooleanProp.class.getSimpleName())) {
            map.put("combo", this.formatComboListFromBoolean());
        } else {
            BasedataProp basedataProp = (BasedataProp)fieldObject;
            map.put("baseEntityId", basedataProp.getBaseEntityId());
        }
        String listBoxData = this.getPageCache().get("listboxdata");
        Map listBoxDataMap = (Map)SerializationUtils.fromJsonString((String)listBoxData, Map.class);
        map.put("data", ((Map)listBoxDataMap.get(this.getPageCache().get("listboxindex"))).get(fieldNumber));
        baseShowParameter.setCustomParam("param", (Object)SerializationUtils.toJsonString(map));
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "callback"));
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private String getComboItemNameByValue(String entityName, String value) {
        return MetadataServiceHelper.getDataEntityType((String)entityName).getAllFields().entrySet().stream().filter(Objects::nonNull).filter(arg -> HRStringUtils.equals((String)value, (String)((String)arg.getKey()))).findFirst().map(arg -> ((IDataEntityProperty)arg.getValue()).getDisplayName().getLocaleValue()).orElse(null);
    }

    private List<Map<String, String>> formatComboList(Object fieldObject) {
        ComboProp comboProp = (ComboProp)fieldObject;
        return comboProp.getComboItems().stream().map(row -> {
            HashMap<String, String> valueMap = new HashMap<String, String>();
            valueMap.put("name", row.getName().getLocaleValue());
            valueMap.put("value", row.getValue());
            return valueMap;
        }).collect(Collectors.toList());
    }

    private List<Map<String, String>> formatComboListFromBoolean() {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        HashMap<String, String> trueMap = new HashMap<String, String>();
        trueMap.put("name", ChgLocalValueService.CHG_LOCAL_VALUE_SERVICE.getChineseShi());
        trueMap.put("value", "1");
        list.add(trueMap);
        HashMap<String, String> falseMap = new HashMap<String, String>();
        falseMap.put("name", ChgLocalValueService.CHG_LOCAL_VALUE_SERVICE.getChineseNo());
        falseMap.put("value", "0");
        list.add(falseMap);
        return list;
    }

    private void beforeActiveSave() {
        this.cacheListBoxData();
        this.saveStrategyConfig();
    }

    private void cacheListBoxData() {
        String oleTeamId = this.getPageCache().get("listboxindex");
        Map map = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("listboxdata"), Map.class);
        map.computeIfAbsent(oleTeamId, mapNew -> new HashMap()).put("chgobject", this.getModel().getValue("chgobject"));
        map.computeIfAbsent(oleTeamId, mapNew -> new HashMap()).put("applicablestage", this.getModel().getValue("applicablestage"));
        map.computeIfAbsent(oleTeamId, mapNew -> new HashMap()).put("chgtactic", this.getModel().getValue("chgtactic"));
        map.computeIfAbsent(oleTeamId, mapNew -> new HashMap()).put("iscorerule", this.getModel().getValue("iscorerule"));
        DynamicObject changeObject = (DynamicObject)this.getModel().getValue("chgobject");
        if (changeObject != null && "hrpi_empposorgrel".equals(changeObject.getString("number"))) {
            map.computeIfAbsent(oleTeamId, mapNew -> new HashMap()).put(TATIC_FLOW_TYPE, this.getModel().getValue(TATIC_FLOW_TYPE));
        }
        map.computeIfAbsent(oleTeamId, mapNew -> new HashMap()).put("entryentity", this.getModel().getEntryEntity("entryentity"));
        this.getPageCache().put("listboxdata", SerializationUtils.toJsonString((Object)map));
    }

    private void saveStrategyConfig() {
        Long strategyId = this.getStrategyId();
        String listBoxData = this.getPageCache().get("listboxdata");
        Map dataMap = (Map)SerializationUtils.fromJsonString((String)listBoxData, Map.class);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hpfs_affstrategyentry");
        ArrayList dynamicObjects = new ArrayList();
        Map<Long, Map<String, Long>> chgFileIdMap = this.getStrategyConfigCollection(strategyId);
        dataMap.forEach((item, data) -> {
            List list = (List)data.get("entryentity");
            if (CollectionUtils.isEmpty((Collection)list)) {
                DynamicObject dyn = serviceHelper.generateEmptyDynamicObject();
                this.formatStrategyConfig(dyn, (Map<String, Object>)data, Collections.emptyMap(), strategyId, chgFileIdMap);
                dynamicObjects.add(dyn);
            }
            list.forEach(field -> {
                DynamicObject dyn = serviceHelper.generateEmptyDynamicObject();
                this.formatStrategyConfig(dyn, (Map<String, Object>)data, (Map<String, Object>)field, strategyId, chgFileIdMap);
                dynamicObjects.add(dyn);
            });
        });
        try (TXHandle h = TX.requiresNew();){
            try {
                serviceHelper.deleteByFilter(new QFilter[]{new QFilter("chgstrategy", "=", (Object)strategyId)});
                serviceHelper.save(dynamicObjects.toArray(new DynamicObject[0]));
            }
            catch (RuntimeException e) {
                LOGGER.error("*****PerChg Found Error***** : ", (Throwable)e);
                h.markRollback();
                throw new KDException((Throwable)e, new ErrorCode("StrategyEditPlugin", e.getMessage()), new Object[0]);
            }
        }
        this.getModel().setValue("status", (Object)"C");
    }

    private Long getStrategyId() {
        Long strategyId = (Long)this.getModel().getValue("id");
        if (strategyId == 0L) {
            Long newStrategyId;
            strategyId = newStrategyId = Long.valueOf(ORM.create().genLongId("hpfs_chgstrategy"));
            this.getModel().setValue("id", (Object)newStrategyId);
        }
        return strategyId;
    }

    private void formatStrategyConfig(DynamicObject dynamicObject, Map<String, Object> data, Map<String, Object> field, Long strategyId, Map<Long, Map<String, Long>> chgFileIdMap) {
        dynamicObject.set("chgstrategy", (Object)strategyId);
        dynamicObject.set("chgtactic", ((Map)data.get("chgtactic")).get("id"));
        dynamicObject.set("iscorerule", data.get("iscorerule"));
        if (CollectionUtils.isEmpty(field)) {
            return;
        }
        dynamicObject.set("chgfile", field.get("field"));
        dynamicObject.set("required", field.get("ismust"));
        dynamicObject.set("editable", field.get("isedit"));
        dynamicObject.set("flowtype", field.get("flowtype"));
        LinkedHashMap chgObj = (LinkedHashMap)data.get("chgobject");
        if (chgObj != null && "hrpi_empposorgrel".equals(chgObj.get("number"))) {
            dynamicObject.set("flowtype", data.get(TATIC_FLOW_TYPE));
        }
        if (data.get((String)field.get("field")) != null) {
            Map config = (Map)data.get((String)field.get("field"));
            dynamicObject.set("limittype", config.get("limittype"));
            dynamicObject.set("valrange_tag", config.get("valrange"));
            dynamicObject.set("chgtype", config.get("chgtype"));
            dynamicObject.set("val", config.get("val"));
        }
        long tacticId = dynamicObject.getLong("chgtactic");
        String chgFile = dynamicObject.getString("chgfile");
        if (chgFileIdMap.get(tacticId) != null && chgFileIdMap.get(tacticId).get(chgFile) != null) {
            dynamicObject.set("id", (Object)chgFileIdMap.get(tacticId).get(chgFile));
        }
    }

    private Map<Long, Map<String, Long>> getStrategyConfigCollection(Long strategyId) {
        DynamicObject[] configs = ChgStrategyConfigRepository.getInstance().getByStrategyId(strategyId.longValue());
        if (configs.length == 0) {
            return Collections.emptyMap();
        }
        Map<Long, List<DynamicObject>> map = Arrays.stream(configs).collect(Collectors.groupingBy(row -> row.getLong("chgtactic")));
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, row -> ((List)row.getValue()).stream().collect(Collectors.toMap(p -> p.getString("chgfile"), p -> p.getLong("id")))));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Object data = closedCallBackEvent.getReturnData();
        if (data == null) {
            return;
        }
        if (HRStringUtils.equals((String)closedCallBackEvent.getActionId(), (String)"callback")) {
            Map dataReturnMap = (Map)data;
            Map map = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("listboxdata"), Map.class);
            String indexCurr = this.getPageCache().get("listboxindex");
            DynamicObject rowData = this.getEntitySelectedData();
            String fieldNumber = rowData.getString("field");
            ((Map)map.get(indexCurr)).put(fieldNumber, dataReturnMap);
            this.getPageCache().put("listboxdata", SerializationUtils.toJsonString((Object)map));
            this.getView().setStatus(OperationStatus.EDIT);
        }
    }

    private Integer getEntitySelectedNumber() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        IClientViewProxy clientViewProxy = (IClientViewProxy)entryGrid.getView().getService(IClientViewProxy.class);
        return (Integer)((Map)clientViewProxy.getViewState("entryentity")).get("row");
    }

    private DynamicObject getEntitySelectedData() {
        DynamicObjectCollection originCollection = this.getModel().getEntryEntity("entryentity");
        return (DynamicObject)originCollection.get(this.getEntitySelectedNumber().intValue());
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Listbox listbox = (Listbox)this.getControl("listboxap");
        ListboxItem listboxItem = new ListboxItem("1", CHINESE_TACTIC_ONE);
        ArrayList<ListboxItem> itemList = new ArrayList<ListboxItem>();
        itemList.add(listboxItem);
        listbox.addItems(itemList);
        HashMap map = new HashMap();
        itemList.forEach(item -> {
            HashMap dataMap = new HashMap();
            Arrays.stream(LIST_BOX_FIELD).forEach(field -> dataMap.put(field, HRStringUtils.equals((String)field, (String)"entryentity") ? new DynamicObjectCollection() : null));
            map.put(item.getId(), dataMap);
        });
        this.getPageCache().put("listboxap", SerializationUtils.toJsonString(itemList));
        this.getPageCache().put("listboxdata", SerializationUtils.toJsonString(map));
        this.getPageCache().put("listboxindex", ((ListboxItem)itemList.get(0)).getId());
        this.getView().setVisible(Boolean.FALSE, new String[]{TATIC_FLOW_TYPE});
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        BasedataEdit basedataEdit = (BasedataEdit)beforeF7SelectEvent.getSource();
        String key = basedataEdit.getKey();
        if (HRStringUtils.equals((String)key, (String)"chgtactic")) {
            String applicableStage;
            ArrayList<QFilter> qFilter = new ArrayList<QFilter>();
            Object changeObject = this.getModel().getValue("chgobject");
            if (changeObject != null) {
                qFilter.add(new QFilter("chgobject.number", "=", (Object)((DynamicObject)changeObject).getString("number")));
            }
            if (HRStringUtils.isNotEmpty((String)(applicableStage = (String)this.getModel().getValue("applicablestage")))) {
                qFilter.add(new QFilter("applicablestage", "=", (Object)applicableStage));
            }
            if (!CollectionUtils.isEmpty(qFilter)) {
                beforeF7SelectEvent.setCustomQFilters(qFilter);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey;
        super.propertyChanged(e);
        switch (fieldKey = e.getProperty().getName()) {
            case "chgobject": {
                this.changeObjectChange(e);
                break;
            }
            case "applicablestage": {
                String stageOld = (String)e.getChangeSet()[0].getOldValue();
                if (!HRStringUtils.isNotEmpty((String)stageOld)) break;
                this.getModel().setValue("chgtactic", null);
                break;
            }
            case "chgtactic": {
                this.tacticChange(e);
                break;
            }
            case "taticflowtype": {
                this.taticFlowTypeChange(e);
                break;
            }
        }
    }

    private void changeObjectChange(PropertyChangedArgs e) {
        DynamicObject dataOld = (DynamicObject)e.getChangeSet()[0].getOldValue();
        DynamicObject dataNew = (DynamicObject)e.getChangeSet()[0].getNewValue();
        if (dataOld != null) {
            this.getModel().setValue("chgtactic", null);
        }
        if (dataNew != null) {
            this.setFieldComboList(dataNew.getString("id"));
        }
        if (dataNew != null && "hrpi_empposorgrel".equals(dataNew.getString("number"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{TATIC_FLOW_TYPE});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{TATIC_FLOW_TYPE});
        }
    }

    private void setFieldComboList(String entityName) {
        List list = MetadataServiceHelper.getDataEntityType((String)entityName).getAllFields().entrySet().stream().filter(Objects::nonNull).map(arg -> new ComboItem(((IDataEntityProperty)arg.getValue()).getDisplayName(), (String)arg.getKey())).distinct().collect(Collectors.toList());
        ComboEdit comboEdit = (ComboEdit)this.getControl("field");
        comboEdit.setComboItems(list);
    }

    private void taticFlowTypeChange(PropertyChangedArgs e) {
        DynamicObjectCollection entryEntity;
        Object taticFLowTypeNew = e.getChangeSet()[0].getNewValue();
        DynamicObject changeObject = (DynamicObject)this.getModel().getValue("chgobject");
        if (changeObject != null && "hrpi_empposorgrel".equals(changeObject.getString("number")) && (entryEntity = this.getModel().getEntryEntity("entryentity")) != null && entryEntity.size() > 0) {
            this.getModel().setValue("flowtype", taticFLowTypeNew);
        }
    }

    private void tacticChange(PropertyChangedArgs e) {
        DynamicObject tacticNew = (DynamicObject)e.getChangeSet()[0].getNewValue();
        DynamicObject tacticOld = (DynamicObject)e.getChangeSet()[0].getOldValue();
        if (HRObjectUtils.isEmpty((Object)tacticOld)) {
            String stage;
            DynamicObject changeObject = (DynamicObject)this.getModel().getValue("chgobject");
            if (changeObject == null) {
                this.getModel().setValue("chgobject", (Object)tacticNew.getDynamicObject("chgobject"));
            }
            if (HRStringUtils.isEmpty((String)(stage = (String)this.getModel().getValue("applicablestage")))) {
                this.getModel().setValue("applicablestage", tacticNew.get("applicablestage"));
            }
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        Long strategyId = (Long)this.getModel().getValue("id");
        HRBaseServiceHelper strategyConfigHelper = new HRBaseServiceHelper("hpfs_affstrategyentry");
        DynamicObject[] configList = strategyConfigHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("chgstrategy", "=", (Object)strategyId)});
        Map<DynamicObject, List<DynamicObject>> tacticConfigMap = Arrays.stream(configList).collect(Collectors.groupingBy(row -> row.getDynamicObject("chgtactic")));
        ArrayList<DynamicObject> tacticList = new ArrayList<DynamicObject>(tacticConfigMap.keySet());
        tacticList.sort(Comparator.comparingInt(o -> o.getInt("index")));
        Listbox listbox = (Listbox)this.getControl("listboxap");
        ArrayList<ListboxItem> itemList = new ArrayList<ListboxItem>();
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>();
        for (int i = 0; i < tacticList.size(); ++i) {
            DynamicObject tactic = (DynamicObject)tacticList.get(i);
            List<DynamicObject> strategyConfigList = tacticConfigMap.get(tactic);
            this.formatRelatedTactic(tactic, strategyConfigList, i, itemList, map);
        }
        listbox.addItems(itemList);
        this.getPageCache().put("listboxap", SerializationUtils.toJsonString(itemList));
        this.getPageCache().put("listboxdata", SerializationUtils.toJsonString(map));
        this.getPageCache().put("listboxindex", ((ListboxItem)itemList.get(0)).getId());
        this.setPageData((Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("listboxdata"), Map.class), ((ListboxItem)itemList.get(0)).getId());
        if (this.getModel().getValue("chgobject") != null) {
            this.setFieldComboList(((DynamicObject)this.getModel().getValue("chgobject")).getString("id"));
        }
        this.getView().setStatus(OperationStatus.EDIT);
    }

    private void formatRelatedTactic(DynamicObject tactic, List<DynamicObject> strategyConfigList, int index, List<ListboxItem> itemList, Map<String, Map<String, Object>> map) {
        ListboxItem listboxItem = new ListboxItem(index + 1 + "", tactic.getString("name"));
        itemList.add(listboxItem);
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("chgobject", tactic.get("chgobject"));
        dataMap.put("applicablestage", tactic.get("applicablestage"));
        dataMap.put("chgtactic", tactic);
        dataMap.put("iscorerule", strategyConfigList.get(0).getBoolean("iscorerule"));
        DynamicObjectType dynamicObjectType = this.getModel().getEntryEntity("entryentity").getDynamicObjectType();
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
        Object[] flowType = new Object[1];
        List fieldDistinctList = strategyConfigList.stream().map(config -> {
            DynamicObject dyNew = new DynamicObject(dynamicObjectType);
            dyNew.set("field", config.get("chgfile"));
            dyNew.set("ismust", config.get("required"));
            dyNew.set("isedit", config.get("editable"));
            dyNew.set("flowtype", config.get("flowtype"));
            if (flowType[0] == null) {
                flowType[0] = config.get("flowtype");
            }
            return dyNew;
        }).distinct().collect(Collectors.toList());
        DynamicObject chgObj = (DynamicObject)tactic.get("chgobject");
        if (chgObj != null && "hrpi_empposorgrel".equals(chgObj.getString("number"))) {
            dataMap.put(TATIC_FLOW_TYPE, flowType[0]);
        }
        dynamicObjectCollection.addAll(fieldDistinctList);
        strategyConfigList.forEach(config -> {
            HashMap<String, Object> fieldConfigMap = new HashMap<String, Object>();
            fieldConfigMap.put("limittype", config.get("limittype"));
            fieldConfigMap.put("chgtype", config.get("chgtype"));
            fieldConfigMap.put("val", config.get("val"));
            if (HRStringUtils.isNotEmpty((String)config.getString("valrange_tag"))) {
                fieldConfigMap.put("valrange", config.getString("valrange_tag"));
            }
            dataMap.put(config.getString("chgfile"), fieldConfigMap);
        });
        dataMap.put("entryentity", dynamicObjectCollection);
        map.put(listboxItem.getId(), dataMap);
    }
}

