/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.formplugin.appconfig;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IParameterModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.param.ParamPublishObject;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.utils.LocalCacheUtils;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.param.ParameterReader;
import kd.bos.param.ParameterWriter;
import kd.bos.parameter.ParameterShowParameter;
import kd.bos.permission.model.AdminType;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hpfs.business.service.PermissionService;
import kd.hr.hpfs.common.enums.AppParamEnum;

public class HpfsAppParamConfigPlugin
extends HRDynamicFormBasePlugin
implements TreeNodeClickListener {
    private static final Log LOG = LogFactory.getLog(HpfsAppParamConfigPlugin.class);
    private static final String VIEW_TYPE_HR = "15";
    private static final Long VIEW_ID_HR = 25L;

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        List orgIds = OrgUnitServiceHelper.filterOrg(Collections.singletonList(RequestContext.get().getOrgId()), (long)VIEW_ID_HR, (boolean)true, (boolean)true);
        if (!CollectionUtils.isEmpty((Collection)orgIds)) {
            this.getModel().setValue("orgfield", orgIds.get(0));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        treeView.setMulti(false);
        TreeNode rootNode = new TreeNode("", "root", ResManager.loadKDString((String)"\u6838\u5fc3\u4eba\u529b\u4e91", (String)"HpfsAppParamConfigPlugin_0", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
        treeView.addNode(rootNode);
        treeView.setRootVisible(true);
        for (AppParamEnum value : AppParamEnum.values()) {
            TreeNode childNode = new TreeNode("root", value.getKey(), value.getDesc());
            if (AppParamEnum.PERSON.getKey().equals(value.getKey())) continue;
            rootNode.addChild(value.getIndex(), childNode);
        }
        this.checkOrgFieldIsContains();
        this.getView().setVisible(Boolean.FALSE, new String[]{"edit"});
        this.getView().setEnable(Boolean.TRUE, new String[]{"appparamflex"});
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Object nodeId = evt.getNodeId();
        AppParamEnum appParamEnum = AppParamEnum.valueByKey((String)nodeId.toString());
        if (HRObjectUtils.isEmpty((Object)appParamEnum)) {
            return;
        }
        this.showAppParamView(appParamEnum);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("orgfield".equals(name)) {
            TreeView treeView;
            TreeView.TreeState treeState;
            Map focusNode;
            String id;
            AppParamEnum appParamEnum;
            Object newValue;
            ChangeData[] changeSet = e.getChangeSet();
            if (changeSet != null && changeSet.length > 0 && (newValue = e.getChangeSet()[0].getNewValue()) == null) {
                this.getModel().setValue("orgfield", e.getChangeSet()[0].getOldValue());
            }
            if (HRObjectUtils.isEmpty((Object)(appParamEnum = AppParamEnum.valueByKey((String)(id = (focusNode = (treeState = (treeView = (TreeView)this.getControl("treeviewap")).getTreeState()).getFocusNode()).getOrDefault("id", AppParamEnum.COMMON.getKey())).toString())))) {
                return;
            }
            this.checkOrgFieldIsContains();
            this.showAppParamView(appParamEnum);
        }
    }

    private void showAppParamView(AppParamEnum appParamEnum) {
        if (HRObjectUtils.isEmpty((Object)appParamEnum) || HRStringUtils.isEmpty((String)appParamEnum.getFormId())) {
            return;
        }
        DynamicObject orgfield = (DynamicObject)this.getModel().getValue("orgfield");
        if (orgfield == null) {
            return;
        }
        ParameterShowParameter showParameter = new ParameterShowParameter();
        showParameter.setFormId(appParamEnum.getFormId());
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("appparamflex");
        Object acctBookNumber = null;
        acctBookNumber = ParameterReader.queryAcctBookId((String)"", (String)appParamEnum.getAppId(), (String)VIEW_TYPE_HR, (long)orgfield.getLong("id"));
        long accountBookId = acctBookNumber == null ? 0L : (Long)acctBookNumber;
        showParameter.setCustomParam("orgid", (Object)orgfield.getLong("id"));
        showParameter.setCustomParam("acctbookid", (Object)accountBookId);
        showParameter.setCustomParam("paramcloudid", (Object)"");
        showParameter.setCustomParam("paramappid", (Object)appParamEnum.getAppId());
        showParameter.setCustomParam("viewtype", (Object)VIEW_TYPE_HR);
        long userId = RequestContext.get().getCurrUserId();
        if (PermissionServiceHelper.isAdminUser((long)userId, (AdminType)AdminType.Administrator)) {
            showParameter.setHasRight(true);
        }
        this.getView().showForm((FormShowParameter)showParameter);
        this.getPageCache().put("paramviewid", showParameter.getPageId());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        treeView.focusNode(new TreeNode("root", AppParamEnum.COMMON.getKey(), AppParamEnum.COMMON.getDesc()));
        this.showAppParamView(AppParamEnum.COMMON);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getControl("treeviewap");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("save".equals(itemKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"save"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"edit"});
            this.getView().setEnable(Boolean.FALSE, new String[]{"appparamflex"});
        } else if ("edit".equals(itemKey)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"save"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"edit"});
            this.getView().setEnable(Boolean.TRUE, new String[]{"appparamflex"});
            this.checkOrgFieldIsContains();
        }
    }

    private void checkOrgFieldIsContains() {
        long currUserId = RequestContext.get().getCurrUserId();
        List orgs = PermissionService.getUserHasPermOrgs((Long)currUserId, (boolean)false);
        DynamicObject orgfield = (DynamicObject)this.getModel().getValue("orgfield");
        if (orgfield != null) {
            long orgId = orgfield.getLong("id");
            if (orgs == null) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"save"});
            } else if (!CollectionUtils.isEmpty((Collection)orgs)) {
                if (orgs.contains(orgId)) {
                    this.getView().setEnable(Boolean.TRUE, new String[]{"save"});
                } else {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"save"});
                }
            }
        }
    }

    private boolean enableAcctBook(String cloudId, String appId) {
        ParamPublishObject publishObject = ParameterReader.getParameterObject((String)cloudId, (String)appId);
        return publishObject.isActBookEnable();
    }

    protected OpLogAppInfo buildLogInfo(String msg, Long orgId) {
        OpLogAppInfo logInfo = new OpLogAppInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getUserId()));
        String bizApppnumber = this.getView().getFormShowParameter().getAppId();
        String bizAppid = BizAppServiceHelp.getAppIdByAppNumber((String)bizApppnumber);
        logInfo.setBizAppID(bizAppid);
        logInfo.setBizObjID(this.getView().getEntityId());
        logInfo.setOrgID(orgId);
        logInfo.setOpTime(new Date());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName(ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"ParameterConsolePlugin_10", (String)"bos-parameter", (Object[])new Object[0]));
        logInfo.setOpDescription(msg);
        return logInfo;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("donothing_saveparam".equals(operateKey)) {
            String pageId = this.getPageCache().get("paramviewid");
            IFormView parameterView = this.getView().getView(pageId);
            ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
            String msg = "";
            if (pageId != null && parameterView != null) {
                String appId;
                IDataModel parameterModel = (IDataModel)parameterView.getService(IDataModel.class);
                DynamicObject dataEntity = parameterModel.getDataEntity();
                DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder(dataEntity.getDynamicObjectType());
                binder.setOnlyDbProperty(false);
                DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
                jser.setSerializeComplexProperty(false);
                String jsonString = jser.serializeToString((Object)dataEntity, null);
                Map jsonStringMap = (Map)SerializationUtils.fromJsonString((String)jsonString, Map.class);
                DataEntityPropertyCollection properties = dataEntity.getDynamicObjectType().getProperties();
                for (IDataEntityProperty p : properties) {
                    if (!(p instanceof BooleanProp) || ((BooleanProp)p).getDefValue() == null || jsonStringMap.get(p.getName()) != null) continue;
                    if (((Boolean)((BooleanProp)p).getDefValue()).booleanValue()) {
                        jsonStringMap.put(p.getName(), Boolean.TRUE);
                        continue;
                    }
                    jsonStringMap.put(p.getName(), Boolean.FALSE);
                }
                jsonString = SerializationUtils.toJsonString((Object)jsonStringMap);
                IParameterModel model = (IParameterModel)parameterModel;
                String cloudId = model.getParamCloudId();
                long acctBookId = !this.enableAcctBook(cloudId, appId = model.getParamAppId()) ? 0L : model.getAcctBookId();
                DynamicObject orgfield = (DynamicObject)this.getModel().getValue("orgfield");
                ParameterWriter.saveSystemParameter((String)cloudId, (String)appId, (String)VIEW_TYPE_HR, (long)orgfield.getLong("id"), (long)acctBookId, (String)jsonString);
                if (null != model.getOrgId() && model.getOrgId().equals(100000L)) {
                    LocalCacheUtils.remove((String)(RequestContext.get().getAccountId() + "_commonparameters"));
                }
                msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ParameterConsolePlugin_2", (String)"bos-parameter", (Object[])new Object[0]);
                this.getView().showSuccessNotification(msg);
                this.sendSysParamMq(jsonString, jsonStringMap, model, cloudId, appId, acctBookId);
                OpLogAppInfo logInfo = this.buildLogInfo(msg, orgfield.getLong("id"));
                logService.addLog((AppLogInfo)logInfo);
            }
        }
    }

    private void sendSysParamMq(String jsonString, Map<String, Object> jsonStringMap, IParameterModel model, String cloudId, String appId, long acctBookId) {
        try {
            Object region = jsonStringMap.get("kdsysparametermqregion");
            Object queue = jsonStringMap.get("kdsysparametermqqueue");
            if (region != null && queue != null) {
                MessagePublisher mq = MQFactory.get().createSimplePublisher(region.toString(), queue.toString());
                HashMap<String, Object> systemParameter = new HashMap<String, Object>();
                systemParameter.put("cloudId", cloudId);
                systemParameter.put("appId", appId);
                systemParameter.put("viewType", model.getViewType());
                systemParameter.put("orgId", model.getOrgId());
                systemParameter.put("acctBookId", acctBookId);
                systemParameter.put("data", jsonString);
                mq.publish(systemParameter);
                LOG.info("MQ\u53d1\u9001\u7cfb\u7edf\u53c2\u6570\u6d88\u606f\uff1a" + SerializationUtils.toJsonString(systemParameter));
            }
        }
        catch (Exception exception) {
            LOG.error((Throwable)exception);
        }
    }
}

