/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.formplugin.blacklist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hpfs.business.utils.BlacklistUtils;
import kd.hr.hpfs.common.constants.HPFSBlackListConstants;

public class BlackListFormPlugin
extends HRDataBaseEdit {
    private static final Log LOGGER = LogFactory.getLog(BlackListFormPlugin.class);
    private static volatile Boolean isPropertyChanged = Boolean.TRUE;
    private static final HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hpfs_blacklist");
    private static DynamicObject sourceDy = serviceHelper.generateEmptyDynamicObject();
    private static String OPERATATION_TYPE = "edit";
    private static volatile Boolean isPropertyChangedForModify = Boolean.TRUE;

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        isPropertyChanged = Boolean.TRUE;
        isPropertyChangedForModify = Boolean.TRUE;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object source = e.getSource();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        Boolean issysperson = dataEntity.getBoolean("issysperson");
        if (issysperson.booleanValue() || OperationStatus.VIEW.equals((Object)status)) {
            this.showPersonCard(this.getView(), this.dyTransferMap(dataEntity));
            this.getModel().setValue("toreasonview", (Object)dataEntity.getDynamicObject("toreason"));
            this.getModel().setValue("reasondetailview", (Object)dataEntity.getString("reasondetail"));
            this.getModel().setDataChanged(false);
        }
        if (OperationStatus.EDIT.equals((Object)status) && !issysperson.booleanValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tippanel"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"cardpanel"});
        }
        if (issysperson.booleanValue() && OperationStatus.EDIT.equals((Object)status)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"name", "adminororg", "phone", "email", "gender", "nation", "entryentity"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"newentryitem", "deleteentryitem"});
        }
        if (OperationStatus.ADDNEW.equals((Object)status) || !issysperson.booleanValue()) {
            this.getView().setFormTitle(new LocaleString(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6dfb\u52a0\u5916\u90e8\u4eba\u5458", (String)"BlackListFormPlugin_9", (String)"hr-hpfs-formplugin", (Object[])new Object[0]), new Object[0])));
        }
    }

    private Map<String, Object> dyTransferMap(DynamicObject dy) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("name", dy.getString("name"));
        resultMap.put("empnumber", dy.getString("empnumber"));
        resultMap.put("issysperson", dy.getBoolean("issysperson"));
        resultMap.put("gender", dy.getString("gender.name"));
        resultMap.put("nation", dy.getString("nation.name"));
        resultMap.put("emppicture", dy.getString("emppicture"));
        return resultMap;
    }

    public void showPersonCard(IFormView view, Map<String, Object> paramMap) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(6);
        customParams.put("name", paramMap.get("name"));
        customParams.put("empnumber", paramMap.get("empnumber"));
        customParams.put("issysperson", paramMap.get("issysperson"));
        customParams.put("gender", paramMap.get("gender"));
        customParams.put("nation", paramMap.get("nation"));
        customParams.put("emppicture", paramMap.get("emppicture"));
        FormShowParameter formShowParameter = BlacklistUtils.showFormParam((ShowType)ShowType.InContainer, (String)"hpfs_simplecard", customParams, (String)"cardpanel");
        formShowParameter.setStatus(OperationStatus.VIEW);
        view.showForm(formShowParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            OPERATATION_TYPE = "addnew";
        }
        if (OperationStatus.EDIT.equals((Object)status)) {
            OPERATATION_TYPE = "edit";
            HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper("hpfs_blacklist");
            Object pkValue = dataEntity.getPkValue();
            sourceDy = baseServiceHelper.queryOne(pkValue);
            DataEntityState dataEntityState = this.getModel().getDataEntity().getDataEntityState();
            Iterable bizChangedProperties = dataEntityState.getBizChangedProperties();
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            isPropertyChangedForModify = !bizChangedProperties.iterator().hasNext() ? Boolean.FALSE : Boolean.TRUE;
            for (DynamicObject dynamicObject : entryentity) {
                Iterable entryChangedProperties = dynamicObject.getDataEntityState().getBizChangedProperties();
                if (!entryChangedProperties.iterator().hasNext()) continue;
                isPropertyChangedForModify = Boolean.TRUE;
            }
            DynamicObjectCollection oriEntryEntity = sourceDy.getDynamicObjectCollection("entryentity");
            if (oriEntryEntity.size() != entryentity.size()) {
                isPropertyChangedForModify = Boolean.TRUE;
            }
        }
        if ("modify".equals(operateKey) && OperationStatus.VIEW.equals((Object)status)) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.EDIT);
            this.getView().sendFormAction(this.getView());
            this.getView().invokeOperation("refresh");
        }
        if ("save".equals(operateKey)) {
            DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
            if (!CollectionUtils.isEmpty((Collection)entryentity)) {
                boolean phoneCheckResult;
                ArrayList<DynamicObject> mainCardList = new ArrayList<DynamicObject>();
                HashSet<String> duplicateCardSet = new HashSet<String>();
                for (DynamicObject dy : entryentity) {
                    boolean ismaincard;
                    if (HRObjectUtils.isEmpty((Object)dy.getDynamicObject("cardtype")) || HRStringUtils.isEmpty((String)dy.getString("cardnumber"))) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b8c\u6574\u7684\u8bc1\u4ef6\u7c7b\u578b\u548c\u8bc1\u4ef6\u53f7\u7801\u3002", (String)"BlackListFormPlugin_0", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                    }
                    if (!args.cancel && !duplicateCardSet.add(dy.getString("cardtype.name"))) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bc1\u4ef6\u7c7b\u578b\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"BlackListFormPlugin_1", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                    }
                    if (ismaincard = dy.getBoolean("ismaincard")) {
                        mainCardList.add(dy);
                    }
                    if (args.cancel || !HPFSBlackListConstants.CARD_TYPE_1010.equals(dy.getLong("cardtype.id")) || BlacklistUtils.validateIdentityCardNo(null, (String)"CN01", (String)dy.getString("cardnumber")).booleanValue()) continue;
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8eab\u4efd\u8bc1\u8bc1\u4ef6\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BlackListFormPlugin_2", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                if (!args.cancel && mainCardList.size() == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5fc5\u987b\u6709\u4e00\u4e2a\u4e3b\u8bc1\u4ef6\u3002", (String)"BlackListFormPlugin_3", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                if (!args.cancel && mainCardList.size() > 1) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u6709\u4e00\u4e2a\u4e3b\u8bc1\u4ef6\u3002", (String)"BlackListFormPlugin_4", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
                if (!(phoneCheckResult = BlacklistUtils.validatePhoneFormate((String)dataEntity.getString("phone")).booleanValue())) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8054\u7cfb\u7535\u8bdd\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BlackListFormPlugin_5", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
            if (OperationStatus.ADDNEW.equals((Object)status)) {
                Boolean issysperson = dataEntity.getBoolean("issysperson");
                if (issysperson.booleanValue()) {
                    List emailResultList;
                    List phoneResultList;
                    String name = dataEntity.getString("name");
                    String email = dataEntity.getString("email");
                    String phone = dataEntity.getString("phone");
                    for (int i = 0; i < entryentity.size(); ++i) {
                        DynamicObject dynamicObject;
                        dynamicObject = (DynamicObject)entryentity.get(i);
                        long cardId = dynamicObject.getLong("cardtype.id");
                        String cardnumber = dynamicObject.getString("cardnumber");
                        List dyLists = BlacklistUtils.queryBlackListByCardInfo((String)name, (Long)cardId, (String)cardnumber);
                        if (CollectionUtils.isEmpty((Collection)dyLists)) continue;
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6839\u636e\u60a8\u8f93\u5165\u7684\u59d3\u540d\u548c\u7b2c%s\u884c\u7684\u8bc1\u4ef6\u4fe1\u606f\uff0c\u7cfb\u7edf\u8bc6\u522b\u51fa\u8be5\u4eba\u5458\u5df2\u7ecf\u5728\u9ed1\u540d\u5355\u4e2d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"BlackListFormPlugin_6", (String)"hr-hpfs-formplugin", (Object[])new Object[]{i + 1}));
                        args.setCancel(true);
                        break;
                    }
                    if (!CollectionUtils.isEmpty((Collection)(phoneResultList = BlacklistUtils.queryBlackListByContactNum((String)name, (String)"phone", (String)phone)))) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6839\u636e\u60a8\u8f93\u5165\u7684\u59d3\u540d\u548c\u7535\u8bdd\u53f7\u7801\uff0c\u7cfb\u7edf\u8bc6\u522b\u51fa\u6539\u4eba\u5458\u5df2\u7ecf\u5728\u9ed1\u540d\u5355\u4e2d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"BlackListFormPlugin_7", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                    }
                    if (HRStringUtils.isNotEmpty((String)email) && !CollectionUtils.isEmpty((Collection)(emailResultList = BlacklistUtils.queryBlackListByContactNum((String)name, (String)"email", (String)email)))) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6839\u636e\u60a8\u8f93\u5165\u7684\u59d3\u540d\u548c\u90ae\u7bb1\uff0c\u7cfb\u7edf\u8bc6\u522b\u51fa\u8be5\u4eba\u5458\u5df2\u7ecf\u5728\u9ed1\u540d\u5355\u4e2d\uff0c\u8bf7\u786e\u8ba4\u3002", (String)"BlackListFormPlugin_8", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
                        args.setCancel(true);
                    }
                }
                this.getModel().setValue("datasource", (Object)"1");
                if (HRObjectUtils.isEmpty((Object)this.getModel().getDataEntity().getDynamicObject("employee"))) {
                    this.getModel().setValue("issysperson", (Object)Boolean.FALSE);
                } else {
                    this.getModel().setValue("issysperson", (Object)Boolean.TRUE);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        Map map;
        DynamicObject dataEntity;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("modify".equals(operateKey)) {
            // empty if block
        }
        if ("save".equals(operateKey) && "addnew".equals(OPERATATION_TYPE)) {
            dataEntity = this.getModel().getDataEntity();
            map = BlacklistUtils.saveBlacklistOperationLog((String)"1", (DynamicObject)dataEntity, null);
        }
        if ("save".equals(operateKey) && "edit".equals(OPERATATION_TYPE) && isPropertyChangedForModify.booleanValue()) {
            dataEntity = this.getModel().getDataEntity();
            map = BlacklistUtils.saveBlacklistOperationLog((String)"3", (DynamicObject)dataEntity, (DynamicObject)sourceDy);
        }
    }
}

