/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.formplugin.blacklist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hpfs.business.utils.BlacklistUtils;

public class ConfirmAddSysPersonFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(ConfirmAddSysPersonFormPlugin.class);
    private static volatile List<Long> passList = new CopyOnWriteArrayList<Long>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit sysPerson = (BasedataEdit)this.getControl("sysperson");
        if (Objects.nonNull(sysPerson)) {
            sysPerson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection syspersonList = dataEntity.getDynamicObjectCollection("sysperson");
        Map<Long, String> empNameMap = syspersonList.stream().collect(Collectors.toMap(person -> person.getDynamicObject("fbasedataid").getLong("employee.id"), person -> person.getDynamicObject("fbasedataid").getString("name"), (oldValue, newValue) -> newValue));
        List empIds = syspersonList.stream().map(person -> person.getDynamicObject("fbasedataid").getLong("employee.id")).collect(Collectors.toList());
        Map<Long, Boolean> isExistMap = empIds.stream().collect(Collectors.toMap(empId -> empId, empId -> Boolean.FALSE));
        HRBaseServiceHelper blacklistHelper = new HRBaseServiceHelper("hrpi_blacklist");
        QFilter empIdFilter = new QFilter("employee", "in", empIds);
        QFilter isSysFilter = new QFilter("issysperson", "=", (Object)Boolean.TRUE);
        DynamicObject[] blackLists = blacklistHelper.query("employee,issysperson,number", new QFilter[]{isSysFilter, empIdFilter});
        Arrays.stream(blackLists).forEach(blackList -> isExistMap.put(blackList.getLong("employee.id"), Boolean.TRUE));
        HashMap<Long, String> failMap = new HashMap<Long, String>();
        for (Long empId2 : empIds) {
            if (isExistMap.get(empId2).booleanValue()) {
                failMap.put(empId2, empNameMap.get(empId2));
                continue;
            }
            passList.add(empId2);
        }
        if (empIds.size() != 0 && failMap.size() == empIds.size()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u4eba\u5458\u90fd\u5df2\u5b58\u5728\u9ed1\u540d\u5355\u7cfb\u7edf\u4e2d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ConfirmAddSysPersonFormPlugin_0", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (!CollectionUtils.isEmpty(failMap)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ee5\u4e0b\u4eba\u5458\u5df2\u5b58\u5728\u9ed1\u540d\u5355\u4e2d\uff1a%s\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ConfirmAddSysPersonFormPlugin_1", (String)"hr-hpfs-formplugin", (Object[])new Object[]{failMap.values().toString()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (operationResult.isSuccess() && "addconfirm".equals(operateKey)) {
            TXHandle required = TX.requiresNew();
            try {
                DynamicObject dataEntity = this.getModel().getDataEntity();
                DynamicObjectCollection syspersonList = dataEntity.getDynamicObjectCollection("sysperson");
                DynamicObject toreason = dataEntity.getDynamicObject("toreason");
                String toreasondetail = dataEntity.getString("toreasondetail");
                List empIds = syspersonList.stream().map(person -> person.getDynamicObject("fbasedataid").getLong("employee.id")).collect(Collectors.toList());
                HashMap failMap = new HashMap();
                HashMap passMap = new HashMap();
                Map map = BlacklistUtils.queryOutEmpInfoByEmpId(passList);
                Collection values = map.values();
                values.stream().forEach(value -> {
                    if (value instanceof Map) {
                        Map valueMap = (Map)value;
                        valueMap.put("toreason", toreason);
                        valueMap.put("reasondetail", toreasondetail);
                        valueMap.put("datasource", "1");
                        valueMap.put("issysperson", "1");
                    }
                });
                List blackListDys = new ArrayList(map.size());
                if (CollectionUtils.isEmpty((Map)map)) {
                    LOGGER.error(ResManager.loadKDString((String)"\u52a0\u5165\u9ed1\u540d\u5355\u5931\u8d25\u3002", (String)"ConfirmAddSysPersonFormPlugin_2", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u52a0\u5165\u9ed1\u540d\u5355\u5931\u8d25\u3002", (String)"ConfirmAddSysPersonFormPlugin_2", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
                    return;
                }
                ArrayList mapList = new ArrayList(map.size());
                passList.forEach(empId -> {
                    Object obj = map.get(String.valueOf(empId));
                    if (HRObjectUtils.isEmpty(obj)) {
                        failMap.put(empId, "can not find person message");
                    } else if (obj instanceof Map) {
                        Map objDy = (Map)obj;
                        mapList.add(objDy);
                        passMap.put(empId, "success");
                    }
                });
                blackListDys = BlacklistUtils.assembleBlackListDy(mapList);
                BlacklistUtils.saveBlackList((DynamicObject[])blackListDys.toArray(new DynamicObject[0]));
                blackListDys.stream().forEach(dy -> {
                    Map logResult = BlacklistUtils.saveBlacklistOperationLog((String)"1", (DynamicObject)dy, null);
                    if (logResult.get("success") instanceof Boolean && !((Boolean)logResult.get("success")).booleanValue()) {
                        LOGGER.error("fail.to.record.blacklistlog={}={}", (Object)dy.getString("name"), (Object)dy.getLong("employee.id"));
                    }
                });
            }
            catch (Exception ex) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u52a0\u5165\u9ed1\u540d\u5355\u5931\u8d25\u3002", (String)"ConfirmAddSysPersonFormPlugin_2", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
                LOGGER.error("fail.to.add.blacklist==", (Throwable)ex);
                required.markRollback();
            }
            finally {
                passList.clear();
                required.close();
            }
            this.getView().returnDataToParent((Object)operateKey);
            this.getView().close();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListFilterParameter listFilterParameter = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter();
        long userId = RequestContext.get().getCurrUserId();
        AuthorizedOrgResult result = (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getUserAdminOrgsF7", (Object[])new Object[]{userId, "hpfs", "hpfs_blacklist", "47150e89000000ac", "adminororg", new HashMap()});
        if (!result.isHasAllOrgPerm()) {
            List hasPermOrgs = result.getHasPermOrgs();
            List qFilters = listFilterParameter.getQFilters();
            qFilters.add(new QFilter("affiliateadminorg.id", "in", (Object)hasPermOrgs));
            QFilter qFilter = new QFilter("adminorg.id", "in", (Object)hasPermOrgs);
            FormShowParameter formShowParameter = beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.getCustomParams().put("bizQFilterKey", qFilter.toSerializedString());
        }
    }
}

