/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.formplugin.cross;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hpfs.business.domain.repository.perchg.ChgRollbackRepository;
import kd.hr.hpfs.common.constants.ChgRollBackValidConstant;

public class HpfsRollbackValidPlugin
extends HRDataBaseEdit
implements ChgRollBackValidConstant {
    private static final String[] ALL_FIELD_ARR = new String[]{"orgrelvalidtype", "crossstatus", "crossresult", "crossnoti", "description"};
    private static final String SELECT_FIELD = "id,uncommittedtrans,committedtrans,crossstatus,crossresult,crossnoti";
    private static final String BTNSAVE = "btnsave";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        if (operationStatus.getValue() == OperationStatus.ADDNEW.getValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"uncommittedtrans", "committedtrans"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"muluncommitted", "mulcommitted"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "muluncommitted": 
            case "mulcommitted": {
                this.validTransCross();
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "btnsave": {
                this.valid(args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess() && BTNSAVE.equals(operateKey)) {
            this.saveBatch();
        }
    }

    private void valid(BeforeDoOperationEventArgs args) {
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        if (operationStatus.getValue() == OperationStatus.ADDNEW.getValue()) {
            List<Long> committedIds;
            boolean res = this.validTransCross();
            if (!res) {
                args.setCancel(true);
                return;
            }
            DynamicObjectCollection uncommittedCollection = (DynamicObjectCollection)this.getModel().getValue("muluncommitted");
            DynamicObjectCollection committedCollection = (DynamicObjectCollection)this.getModel().getValue("mulcommitted");
            List<Long> uncommittedIds = uncommittedCollection.stream().map(row -> row.getLong("fbasedataid.id")).collect(Collectors.toList());
            DynamicObject[] dynArr = this.queryDyn(uncommittedIds, committedIds = committedCollection.stream().map(row -> row.getLong("fbasedataid.id")).collect(Collectors.toList()));
            if (dynArr.length != 0) {
                String errorMsg = ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7684\u53d1\u8d77\u4eba\u4e8b\u4e8b\u52a1\u548c\u6821\u9a8c\u4eba\u4e8b\u4e8b\u52a1\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"HpfsRollbackValidPlugin_0", (String)"hr-hpfs-formplugin", (Object[])new Object[0]);
                this.getView().showErrorNotification(errorMsg);
                args.setCancel(true);
            }
        } else {
            String errorMsg = this.validateSingle();
            if (HRStringUtils.isNotEmpty((String)errorMsg)) {
                this.getView().showErrorNotification(errorMsg);
                args.setCancel(true);
            }
        }
    }

    private void saveBatch() {
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        if (operationStatus.getValue() == OperationStatus.ADDNEW.getValue()) {
            DynamicObjectCollection uncommittedCollection = (DynamicObjectCollection)this.getModel().getValue("muluncommitted");
            DynamicObjectCollection committedCollection = (DynamicObjectCollection)this.getModel().getValue("mulcommitted");
            List<DynamicObject> dynList = this.formatDynList(uncommittedCollection, committedCollection);
            ChgRollbackRepository.save((DynamicObject[])dynList.toArray(new DynamicObject[0]));
        } else {
            ChgRollbackRepository.save((DynamicObject[])new DynamicObject[]{this.getModel().getDataEntity()});
        }
        this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"CrossValidationEditPlugin_0", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
        this.getView().sendFormAction(this.getView().getParentView());
        this.getModel().setDataChanged(false);
        if (this.getView().getParentView() != null) {
            this.getView().getParentView().invokeOperation("refresh");
        }
        this.getView().close();
    }

    private List<DynamicObject> formatDynList(DynamicObjectCollection uncommittedCollection, DynamicObjectCollection committedCollection) {
        ArrayList<DynamicObject> dynList = new ArrayList<DynamicObject>(uncommittedCollection.size() * committedCollection.size());
        for (DynamicObject unCommit : uncommittedCollection) {
            for (DynamicObject commit : committedCollection) {
                DynamicObject dyn = ChgRollbackRepository.generateEmptyDynamicObject();
                dyn.set("uncommittedtrans", (Object)unCommit.getLong("fbasedataid.id"));
                dyn.set("committedtrans", (Object)commit.getLong("fbasedataid.id"));
                for (String field : ALL_FIELD_ARR) {
                    dyn.set(field, this.getModel().getValue(field));
                }
                dyn.set("enable", (Object)"1");
                dyn.set("status", (Object)"C");
                dyn.set("creator", (Object)RequestContext.get().getCurrUserId());
                String number = CodeRuleServiceHelper.getNumber((String)"hpfs_rollbackvalid", (DynamicObject)dyn, null);
                dyn.set("number", (Object)number);
                dynList.add(dyn);
            }
        }
        return dynList;
    }

    private DynamicObject[] queryDyn(List<Long> uncommittedIds, List<Long> committedIds) {
        QFilter[] qFilters = new QFilter[]{new QFilter("uncommittedtrans", "in", uncommittedIds), new QFilter("committedtrans", "in", committedIds)};
        return ChgRollbackRepository.queryOriginalArray((String)SELECT_FIELD, (QFilter[])qFilters);
    }

    private String validateSingle() {
        DynamicObject[] dyns = this.queryUpdDys();
        if (dyns.length == 0) {
            return "";
        }
        if (dyns[0].getLong("id") != ((Long)this.getModel().getValue("id")).longValue()) {
            return ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7684\u53d1\u8d77\u4eba\u4e8b\u4e8b\u52a1\u548c\u6821\u9a8c\u4eba\u4e8b\u4e8b\u52a1\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"HpfsRollbackValidPlugin_0", (String)"hr-hpfs-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private DynamicObject[] queryUpdDys() {
        long unCommitId = ((DynamicObject)this.getModel().getValue("uncommittedtrans")).getLong("id");
        long commitId = ((DynamicObject)this.getModel().getValue("committedtrans")).getLong("id");
        return this.queryDyn(Collections.singletonList(unCommitId), Collections.singletonList(commitId));
    }

    private boolean validTransCross() {
        DynamicObjectCollection uncommittedCollection = (DynamicObjectCollection)this.getModel().getValue("muluncommitted");
        if (uncommittedCollection.isEmpty()) {
            return true;
        }
        DynamicObjectCollection committedCollection = (DynamicObjectCollection)this.getModel().getValue("mulcommitted");
        if (committedCollection.isEmpty()) {
            return true;
        }
        List uncommittedIds = uncommittedCollection.stream().map(row -> row.getLong("fbasedataid.id")).collect(Collectors.toList());
        List committedIds = committedCollection.stream().map(row -> row.getLong("fbasedataid.id")).collect(Collectors.toList());
        uncommittedIds.retainAll(committedIds);
        if (uncommittedIds.isEmpty()) {
            return true;
        }
        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u6709\u53d1\u8d77\u7684\u4eba\u4e8b\u4e8b\u52a1\uff0c\u8bf7\u4fee\u6539\u3002", (String)"CrossValidationEditPlugin_5", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
        return false;
    }
}

