/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.formplugin.guide;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.domain.repository.perchg.ChgActionRepository;
import kd.hr.hpfs.business.domain.repository.perchg.ChgCategoryRepository;
import kd.hr.hpfs.business.domain.repository.perchg.ChgGuideBaseRepository;
import kd.hr.hpfs.business.domain.repository.perchg.ChgRuleRepository;
import kd.hr.hpfs.business.domain.repository.perchg.ChgStrategyConfigRepository;
import kd.hr.hpfs.common.enums.ChgCarrierEnum;
import kd.sdk.hr.hpfs.common.InsertTableInfo;
import kd.sdk.hr.hpfs.common.constants.ChgConstants;
import kd.sdk.hr.hpfs.utils.GenerateInsertKSQLUtils;

public class ChgGuideBaseListPlugin
extends AbstractListPlugin
implements ChgConstants {
    private static final Log LOGGER = LogFactory.getLog(ChgGuideBaseListPlugin.class);
    final HRBaseServiceHelper configServiceHelper = new HRBaseServiceHelper("hpfs_chgguidebase");
    static final List<String> GUIDE_BASE_FIELD = Arrays.asList("chgevent", "chgcategory", "chgaction", "chgrule");

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (key = formOperate.getOperateKey()) {
            case "addnew": {
                this.add();
                break;
            }
            case "modify": {
                this.modify(args);
                args.setCancel(true);
                break;
            }
            case "view": {
                this.view(args);
                args.setCancel(true);
                break;
            }
            case "duplicate": {
                this.duplicate(args);
                break;
            }
            case "onekeyexport": {
                this.onkeyexport(args);
            }
        }
    }

    private void onkeyexport(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectId = ((FormOperate)args.getSource()).getListSelectedData();
        if (selectId.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u5bfc\u51fa\u9884\u7f6e\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ChgGuideBaseListPlugin_1", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject[] selectConfig = ChgGuideBaseRepository.getInstance().loadDynamicObjectArray(selectId.getPrimaryKeyValues());
        if (Objects.isNull(selectConfig) || selectConfig.length == 0) {
            LOGGER.error("onkeyexport selectConfig is empty");
            return;
        }
        ArrayList<String> configEntryidStrs = new ArrayList<String>();
        Map<String, List<Long>> relateEntityMap = this.getConfigRelateEntityMap(selectConfig, configEntryidStrs);
        String[] idsStr = (String[])Arrays.stream(selectId.toArray()).map(id -> id.toString()).toArray(String[]::new);
        InsertTableInfo insertTableInfo = new InsertTableInfo(idsStr, configEntryidStrs.toArray(new String[configEntryidStrs.size()]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"hpfs_chgguidebase"));
        relateEntityMap.forEach((key, dyList) -> {
            String[] tmpIds = (String[])dyList.stream().map(id -> id.toString()).toArray(String[]::new);
            InsertTableInfo tmpTableInfo = new InsertTableInfo(tmpIds, null, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)key));
            insertTableInfo.addToAllInseartTableInfos(tmpTableInfo.getAllInseartTableInfos());
        });
        Map<String, List<InsertTableInfo>> insertTableInfoByDBRoute = insertTableInfo.getAllInseartTableInfos().stream().collect(Collectors.groupingBy(InsertTableInfo::getRoute));
        insertTableInfoByDBRoute.forEach((dbroute, insertTableInfos) -> {
            try {
                String sqlFileName = String.format("%s_%s_%s.sql", dbroute, "hpfs_chgguidebase", new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
                GenerateInsertKSQLUtils.exportFile((IFormView)this.getView(), (String)GenerateInsertKSQLUtils.generateInsertKsql((List)insertTableInfos), (String)sqlFileName);
            }
            catch (Exception ex) {
                LOGGER.error("export error, the exception is ", (Throwable)ex);
            }
        });
    }

    private Map<String, List<Long>> getConfigRelateEntityMap(DynamicObject[] selectConfig, List<String> configEntryidStrs) {
        List chgActionIds;
        List chgruleIds;
        HashMap<String, List<Long>> relateEntityMap = new HashMap<String, List<Long>>();
        DataEntityPropertyCollection properties = selectConfig[0].getDynamicObjectType().getProperties();
        for (DynamicObject config : selectConfig) {
            DynamicObjectCollection entryenties = config.getDynamicObjectCollection("entryentity");
            if (!Objects.isNull(entryenties) && entryenties.size() > 0) {
                entryenties.stream().forEach(entryentity -> configEntryidStrs.add(entryentity.getString("id")));
                List plugins = entryenties.stream().map(entryentity -> entryentity.getLong("plugin_id")).collect(Collectors.toList());
                relateEntityMap.put("hpfs_chgplugin", plugins);
            }
            GUIDE_BASE_FIELD.stream().filter(field -> properties.containsKey(field)).forEach(field -> this.add2RelateMap(relateEntityMap, config.getDynamicObject(field)));
        }
        List chgCategoryIds = (List)relateEntityMap.get("hpfs_chgcategory");
        if (!Objects.isNull(chgCategoryIds) && chgCategoryIds.size() > 0) {
            DynamicObject[] chgStrategyDys = ChgStrategyConfigRepository.getInstance().getByChgCategoryIds(chgCategoryIds);
            List strategyIds = Arrays.stream(chgStrategyDys).map(chgstrategy -> chgstrategy.getLong("id")).collect(Collectors.toList());
            relateEntityMap.put("hpfs_chgstrategy", strategyIds);
            relateEntityMap.put("hpfs_affstrategyentry", strategyIds);
            DynamicObject[] categoryDys = ChgCategoryRepository.getInstance().loadDynamicObjectArray(chgCategoryIds.toArray());
            List actionTypeIds = Arrays.stream(categoryDys).map(categoryDy -> categoryDy.getLong("actiontype_id")).collect(Collectors.toList());
            relateEntityMap.put("hbss_actiontype", actionTypeIds);
        }
        if (!Objects.isNull(chgruleIds = (List)relateEntityMap.get("hpfs_chgrule")) && chgruleIds.size() > 0) {
            DynamicObject[] ruleDys = ChgRuleRepository.getInstance().loadDynamicObjectArray(chgruleIds.toArray());
            Set chgtacticIds = Arrays.asList(ruleDys).stream().flatMap(rule -> rule.getDynamicObjectCollection("customentryentity").stream().map(entry -> entry.getLong("chgtactic_id"))).collect(Collectors.toSet());
            relateEntityMap.put("hpfs_chgtactic", new ArrayList(chgtacticIds));
        }
        if (!Objects.isNull(chgActionIds = (List)relateEntityMap.get("hpfs_chgaction")) && chgActionIds.size() > 0) {
            DynamicObject[] actionDys = ChgActionRepository.getInstance().loadDynamicObjectArray(chgActionIds.toArray());
            List actionIds = Arrays.stream(actionDys).map(actionDy -> actionDy.getLong("action_id")).collect(Collectors.toList());
            relateEntityMap.put("hbss_action", new ArrayList(actionIds));
        }
        return relateEntityMap;
    }

    private void add2RelateMap(Map<String, List<Long>> relateEntityMap, DynamicObject dy) {
        String entityName = dy.getDynamicObjectType().getName();
        List<Long> dyList = relateEntityMap.get(entityName);
        if (Objects.isNull(dyList)) {
            dyList = new ArrayList<Long>();
            relateEntityMap.put(entityName, dyList);
        }
        dyList.add(dy.getLong("id"));
    }

    private void add() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("hpfs_chgguideconfig");
        showParameter.setCustomParam("index", (Object)"1");
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addnew"));
        showParameter.setCaption(new LocaleString(this.getAddNewStatusTiltle()).toString());
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object dataReturn = closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "addnew": 
            case "modify": {
                String data = (String)dataReturn;
                if (!HRStringUtils.equals((String)data, (String)"1")) break;
                ((ListView)this.getView()).refresh();
                break;
            }
        }
    }

    private void modify(BeforeDoOperationEventArgs args) {
        this.showChgGuideRule(args, OperationStatus.EDIT, false);
    }

    private void view(BeforeDoOperationEventArgs args) {
        this.showChgGuideRule(args, OperationStatus.VIEW, false);
    }

    private void duplicate(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection collection = ((FormOperate)args.getSource()).getListSelectedData();
        if (collection.size() > 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u590d\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"ChgGuideBaseListPlugin_0", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
            return;
        }
        this.showChgGuideRule(args, OperationStatus.ADDNEW, true);
    }

    private void showChgGuideRule(BeforeDoOperationEventArgs args, OperationStatus status, boolean isDuplicate) {
        Long basicConfigRuleId = (Long)((FormOperate)args.getSource()).getListFocusRow().getPrimaryKeyValue();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("hpfs_chgguideconfig");
        showParameter.setCustomParam("guideBaseId", (Object)basicConfigRuleId);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hpfs_chgguidebase");
        DynamicObject dyn = serviceHelper.loadSingle((Object)basicConfigRuleId);
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("chgCategoryId", dyn.getLong("chgcategory.id"));
        map.put("chgRuleId", dyn.getLong("chgrule.id"));
        map.put("billSource", dyn.getString("billsource.id"));
        map.put("chgActionId", dyn.getLong("chgaction.id"));
        DynamicObjectCollection pluginCollection = dyn.getDynamicObjectCollection("entryentity");
        pluginCollection.forEach(row -> row.set("plugin", (Object)row.getLong("plugin.id")));
        map.put("pluginCollection", pluginCollection);
        map.put("chgGuideBaseId", basicConfigRuleId);
        String carrier = dyn.getString("carrier");
        map.put("carrier", HRStringUtils.isEmpty((String)carrier) ? ChgCarrierEnum.CARRIER_BILL.getCode() : carrier);
        map.put("number", dyn.getString("number"));
        if (!isDuplicate) {
            map.put("name", dyn.get("name"));
        } else {
            map.put("isDuplicate", "1");
        }
        showParameter.setCustomParam("params", map);
        boolean issys = dyn.getBoolean("issyspreset");
        if (issys && !isDuplicate) {
            showParameter.setStatus(OperationStatus.VIEW);
        } else {
            showParameter.setStatus(status);
        }
        if (status == OperationStatus.ADDNEW) {
            showParameter.setCaption(new LocaleString(this.getAddNewStatusTiltle()).toString());
        } else if (!StringUtils.isEmpty((Object)dyn.getString("name"))) {
            String title = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e8b\u52a1\u53d8\u52a8\u914d\u7f6e-%s", (String)"ChgGuideBaseListPlugin_3", (String)"hr-hpfs-formplugin", (Object[])new Object[0]), dyn.getString("name"));
            showParameter.setCaption(new LocaleString(title).toString());
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "modify"));
        this.getView().showForm(showParameter);
    }

    private String getAddNewStatusTiltle() {
        return String.format(ResManager.loadKDString((String)"\u65b0\u589e\u4e8b\u52a1\u53d8\u52a8\u914d\u7f6e", (String)"ChgGuideBaseListPlugin_2", (String)"hr-hpfs-formplugin", (Object[])new Object[0]), new Object[0]);
    }
}

