/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.formplugin.guide;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hpfs.business.domain.repository.RepositoryUtils;
import kd.hr.hpfs.business.domain.repository.perchg.ChgMappingRepository;
import kd.hr.hpfs.business.domain.repository.perchg.ChgTacticRepository;
import kd.hr.hpfs.common.constants.ChgGuideConstants;
import kd.hr.hpfs.common.enums.ChgCarrierEnum;
import kd.hr.hpfs.common.enums.ChgPluginOccasionEnum;
import kd.hr.hpfs.common.enums.ChgTacticApplicableStageEnum;
import kd.hr.hpfs.formplugin.service.ChgNameValidateService;

public class ChgGuideConfigEditPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener,
ChgGuideConstants {
    static final String[] basciFieldArr = new String[]{"ispreset", "isinterrupted", "seq", "id"};
    private static final Log LOGGER = LogFactory.getLog(ChgGuideConfigEditPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"deltacticbefore", "deltacticafter"});
        BasedataEdit billSource = (BasedataEdit)this.getControl("billsource");
        billSource.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit category = (BasedataEdit)this.getControl("chgcategory");
        category.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit plugin = (BasedataEdit)this.getControl("plugin");
        plugin.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.replace("del", "").length() != key.length()) {
            this.delTactic(evt);
            this.getView().updateView();
            this.setPanel();
            this.getPageCache().remove("step3");
            this.getModel().setDataChanged(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (key = afterDoOperationEventArgs.getOperateKey()) {
            case "step1to2": {
                this.step1to2();
                break;
            }
            case "step2to3": {
                this.step2to3();
                break;
            }
            case "step1to3": {
                this.step1to3();
                break;
            }
            case "step2to1": {
                this.step2to1();
                break;
            }
            case "step3to2": {
                this.step3to2();
                break;
            }
            case "step3to1": {
                this.step3to1();
                break;
            }
            case "addtactic": {
                this.addTactic();
                break;
            }
            case "finishadd": 
            case "finishupdate": {
                this.finish();
                break;
            }
            case "apiinfo": {
                this.showApiInfo();
                break;
            }
            case "pluginparam": {
                this.showPluginParam();
                break;
            }
        }
    }

    private void showPluginParam() {
        int row = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObjectCollection pluginEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObject plugin = (DynamicObject)pluginEntity.get(row);
        DynamicObject pluginDyn = plugin.getDynamicObject("plugin");
        if (pluginDyn == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u63d2\u4ef6\u518d\u586b\u5199\u63d2\u4ef6\u53c2\u6570\u914d\u7f6e\u3002", (String)"ChgGuideConfigEditPlugin_15", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
            return;
        }
        String pluginNumber = plugin.getString("plugin.number");
        String pluginParamStr = this.getPageCache().get("pluginParam");
        HashMap pluginParamMap = HRStringUtils.isEmpty((String)pluginParamStr) ? new HashMap(16) : (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("pluginParam"), Map.class);
        List pluginParams = (List)pluginParamMap.get(pluginNumber);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hpfs_chgguidepluginparam");
        formShowParameter.setSendToClient(true);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pluginParam"));
        formShowParameter.setCustomParam("params", (Object)pluginParams);
        formShowParameter.setCustomParam("pluginNumber", (Object)pluginNumber);
        formShowParameter.setStatus(this.getView().getFormShowParameter().getStatus());
        this.getView().showForm(formShowParameter);
    }

    private void showApiInfo() {
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        Map params = (Map)this.getView().getFormShowParameter().getCustomParam("params");
        Long chgActionId = params == null || operationStatus.getValue() == OperationStatus.ADDNEW.getValue() ? null : Long.valueOf(params.get("chgActionId") + "");
        String ruleConfigs = this.getPageCache().get("ruleConfigs");
        List ruleConfigMap = (List)SerializationUtils.fromJsonString((String)ruleConfigs, List.class);
        Map<String, Object> valueMap = ruleConfigMap.stream().filter(row -> HRStringUtils.isNotEmpty((String)((String)row.get("rpcparam")))).collect(Collectors.toMap(row -> (String)row.get("rpcparam"), row -> "value from api"));
        HashMap<String, Object> chgActionExecuteMap = new HashMap<String, Object>();
        chgActionExecuteMap.put("personId", ResManager.loadKDString((String)"\u81ea\u7136\u4ebaid", (String)"ChgGuideConfigEditPlugin_9", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
        chgActionExecuteMap.put("employeeId", ResManager.loadKDString((String)"\u4f01\u4e1a\u4ebaid", (String)"ChgGuideConfigEditPlugin_10", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
        chgActionExecuteMap.put("cmpEmpId", ResManager.loadKDString((String)"\u6240\u5c5e\u7ba1\u7406\u8303\u56f4(\u516c\u53f8\u4eba)id", (String)"ChgGuideConfigEditPlugin_11", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
        chgActionExecuteMap.put("depEmpId", ResManager.loadKDString((String)"\u7ec4\u7ec7\u4eba(\u90e8\u95e8\u4eba)id", (String)"ChgGuideConfigEditPlugin_12", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
        chgActionExecuteMap.put("erManFileId", ResManager.loadKDString((String)"\u6863\u6848id", (String)"ChgGuideConfigEditPlugin_13", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
        chgActionExecuteMap.put("chgActionId", chgActionId);
        chgActionExecuteMap.put("effectTime", ResManager.loadKDString((String)"\u4e1a\u52a1\u751f\u6548\u65f6\u95f4", (String)"ChgGuideConfigEditPlugin_14", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
        chgActionExecuteMap.put("valueMap", valueMap);
        HashMap<String, List> scheduleIdsMap = new HashMap<String, List>();
        scheduleIdsMap.computeIfAbsent("hrpi_example", list -> new ArrayList()).add(1010L);
        chgActionExecuteMap.put("scheduleIdsMap", scheduleIdsMap);
        String apiInfo = SerializationUtils.toJsonString(chgActionExecuteMap);
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hpfs_chgguideapiinfo");
        formShowParameter.setSendToClient(true);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("apiinfo", (Object)apiInfo);
        formShowParameter.setStatus(this.getView().getFormShowParameter().getStatus());
        this.getView().showForm(formShowParameter);
    }

    private void step2to1() {
        this.setStepVisible(Boolean.FALSE, "2");
        this.setStepVisible(Boolean.TRUE, "1");
    }

    private void step3to2() {
        this.setStepVisible(Boolean.FALSE, "3");
        this.setStepVisible(Boolean.TRUE, "2");
    }

    private void step3to1() {
        this.step3to2();
        this.step2to1();
    }

    private void delTactic(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        IClientViewProxy clientViewProxy = (IClientViewProxy)control.getView().getService(IClientViewProxy.class);
        List tactic = (List)((List)((Map)clientViewProxy.getViewState(key.replace("del", "bill"))).get("selDatas")).get(0);
        String tacticId = (String)tactic.get(0);
        String strategyTacticIds = this.getPageCache().get("strategyTacticIds");
        List strategyTacticIdList = (List)SerializationUtils.fromJsonString((String)strategyTacticIds, List.class);
        if (strategyTacticIdList.contains(tacticId)) {
            strategyTacticIdList.remove(tacticId);
            this.getPageCache().put("strategyTacticIds", SerializationUtils.toJsonString((Object)strategyTacticIdList));
            String strategyTacticExcludeIds = this.getPageCache().get("strategyTacticExcludeIds");
            if (strategyTacticExcludeIds == null) {
                this.getPageCache().put("strategyTacticExcludeIds", SerializationUtils.toJsonString(Collections.singletonList(tacticId)));
                return;
            }
            List strategyTacticExcludeIdList = (List)SerializationUtils.fromJsonString((String)strategyTacticExcludeIds, List.class);
            strategyTacticExcludeIdList.add(tacticId);
            this.getPageCache().put("strategyTacticExcludeIds", SerializationUtils.toJsonString((Object)strategyTacticExcludeIdList));
            return;
        }
        String addTacticIds = this.getPageCache().get("addTacticIds");
        if (addTacticIds == null) {
            return;
        }
        List addTacticIdList = (List)SerializationUtils.fromJsonString((String)addTacticIds, List.class);
        if (!addTacticIdList.contains(tacticId)) {
            return;
        }
        addTacticIdList.remove(tacticId);
        this.getPageCache().put("addTacticIds", SerializationUtils.toJsonString((Object)addTacticIdList));
    }

    private void step1to3() {
        String errorMsg = this.step1to2Validate();
        if (HRStringUtils.isNotEmpty((String)errorMsg)) {
            this.getView().showErrorNotification(errorMsg);
            return;
        }
        this.step1to2();
        this.step2to3();
        this.getView().updateView();
    }

    private void addTactic() {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setBillFormId("hpfs_chgtactic");
        showParameter.setFormId("bos_listf7");
        showParameter.setLookUp(true);
        showParameter.setMultiSelect(true);
        showParameter.setShowApproved(true);
        OpenStyle style = new OpenStyle();
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("880px");
        cssValue.setHeight("600px");
        style.setInlineStyleCss(cssValue);
        style.setShowType(ShowType.Modal);
        showParameter.setOpenStyle(style);
        showParameter.setShowTitle(false);
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        this.addTacticIdNotInQFilter(qFilter, this.getPageCache().get("strategyTacticExcludeIds"), this.getPageCache().get("addTacticIds"), this.getPageCache().get("strategyTacticIds"));
        showParameter.getListFilterParameter().setQFilters(Collections.singletonList(qFilter));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "addtactic"));
        this.getPageCache().remove("step3");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void addTacticIdNotInQFilter(QFilter qFilter, String ... idsStrArr) {
        Arrays.stream(idsStrArr).filter(Objects::nonNull).forEach(idsStr -> {
            List ids = (List)SerializationUtils.fromJsonString((String)idsStr, List.class);
            List idLong = ids.stream().map(Long::parseLong).collect(Collectors.toList());
            QFilter idFilter = new QFilter("id", "not in", idLong);
            qFilter.and(idFilter);
        });
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        Object dataReturned = closedCallBackEvent.getReturnData();
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "addtactic": {
                this.cacheAdditionalTactic(closedCallBackEvent.getReturnData());
                this.setPanel();
                this.getPageCache().remove("step3");
                break;
            }
            case "config": {
                String dataReturn = (String)closedCallBackEvent.getReturnData();
                if (HRStringUtils.equals((String)dataReturn, (String)"1")) {
                    this.getPageCache().put("step3Unchanged", "1");
                    this.getModel().setDataChanged(false);
                    this.getView().close();
                    break;
                }
                if (!HRStringUtils.equals((String)dataReturn, (String)"2")) break;
                this.getPageCache().put("step3error", "1");
                break;
            }
            case "pluginParam": {
                this.pluginParamCallBack(dataReturned);
                break;
            }
        }
    }

    private void pluginParamCallBack(Object dataReturned) {
        Map map = (Map)dataReturned;
        if (CollectionUtils.isEmpty((Map)map)) {
            return;
        }
        String pluginNumber = (String)map.get("pluginNumber");
        List valueList = (List)map.get("value");
        String pluginParam = this.getPageCache().get("pluginParam");
        Map pluginMap = HRStringUtils.isEmpty((String)pluginParam) ? new HashMap(16) : (Map)SerializationUtils.fromJsonString((String)pluginParam, Map.class);
        pluginMap.put(pluginNumber, valueList);
        this.getPageCache().put("pluginParam", SerializationUtils.toJsonString(pluginMap));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getModel().getDataChanged()) {
            String step3;
            this.getView().getPageCache().put("changed", String.valueOf(this.getModel().getDataChanged()));
            if (this.getPageCache().get("step3Unchanged") == null && (step3 = this.getView().getPageCache().get("step3")) != null) {
                this.getView().getView(this.getPageCache().get("childPageId")).invokeOperation("close");
                e.setCancel(true);
                return;
            }
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"ChgGuideConfigEditPlugin_5", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"ChgGuideConfigEditPlugin_6", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u76f4\u63a5\u9000\u51fa\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"ChgGuideConfigEditPlugin_7", (String)"hr-hpfs-formplugin", (Object[])new Object[0]);
            String changeDesc = this.getModel().getChangeDesc();
            this.getView().showConfirm(msg, changeDesc, MessageBoxOptions.OKCancel, ConfirmTypes.Save, new ConfirmCallBackListener("savechange", (IFormPlugin)this), btnNameMaps);
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"savechange") && messageBoxClosedEvent.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
            this.getPageCache().put("saveSuccess", "1");
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    private void cacheAdditionalTactic(Object returnData) {
        ListSelectedRowCollection collection = (ListSelectedRowCollection)returnData;
        if (collection == null) {
            return;
        }
        List webParams = collection.createWebParams();
        List idList = webParams.stream().map(row -> (Long)row.get("fid")).distinct().collect(Collectors.toList());
        QFilter qFilter = new QFilter("id", "in", idList);
        DynamicObject[] dyns = ChgTacticRepository.query((String)"id", (QFilter[])new QFilter[]{qFilter});
        List dynMap = (List)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)dyns), List.class);
        List ids2add = Arrays.stream(dyns).map(row -> row.getLong("id") + "").distinct().collect(Collectors.toList());
        String addTactics = this.getPageCache().get("addTactics");
        if (addTactics != null) {
            List dataBefore = (List)SerializationUtils.fromJsonString((String)addTactics, List.class);
            List data = dataBefore.stream().filter(row -> {
                String id = row.get("id") == null ? row.get("fid") + "" : row.get("id") + "";
                return !ids2add.contains(id);
            }).distinct().collect(Collectors.toList());
            String addTacticIds = this.getPageCache().get("addTacticIds");
            dynMap.addAll(data);
            List addTacticIdList = (List)SerializationUtils.fromJsonString((String)addTacticIds, List.class);
            ids2add.addAll(addTacticIdList);
        }
        this.getPageCache().put("addTacticIds", SerializationUtils.toJsonString(ids2add));
        this.getPageCache().put("addTactics", SerializationUtils.toJsonString((Object)dynMap));
        this.getView().updateView();
    }

    private void step1to2() {
        String errorMsg = this.step1to2Validate();
        if (HRStringUtils.isNotEmpty((String)errorMsg)) {
            this.getView().showErrorNotification(errorMsg);
            return;
        }
        this.cacheTacticByCategory();
        this.cacheConfigInfo();
        this.cacheAddTactic();
        this.setStepVisible(Boolean.FALSE, "1");
        this.setStepVisible(Boolean.TRUE, "2");
        this.setLabelValue();
        this.setSourceLabelVisible("step2source");
        String carrier = (String)this.getModel().getValue("carrier");
        if (HRStringUtils.equals((String)carrier, (String)ChgCarrierEnum.CARRIER_ACTION.getCode())) {
            this.getPageCache().put("carrier", carrier);
        }
        this.getView().updateView();
    }

    private void setLabelValue() {
        DynamicObject chgCategory = (DynamicObject)this.getModel().getValue("chgcategory");
        DynamicObject billSource = (DynamicObject)this.getModel().getValue("billsource");
        String name = ((OrmLocaleValue)this.getModel().getValue("name")).getLocaleValue();
        ((Label)this.getControl("step2category")).setText(chgCategory.getString("name"));
        ((Label)this.getControl("step3category")).setText(chgCategory.getString("name"));
        if (billSource != null) {
            ((Label)this.getControl("step2source")).setText(billSource.getString("name"));
            ((Label)this.getControl("step3source")).setText(billSource.getString("name"));
        }
        ((Label)this.getControl("step2name")).setText(name);
        ((Label)this.getControl("step3name")).setText(name);
        this.setPanel();
    }

    private String step1to2Validate() {
        DynamicObject category;
        StringBuilder stringBuilder = new StringBuilder();
        String carrier = (String)this.getModel().getValue("carrier");
        if (null == carrier) {
            stringBuilder.append(ResManager.loadKDString((String)"\u53d8\u52a8\u8f7d\u4f53\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ChgGuideConfigEditPlugin_3", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
        }
        if (!HRStringUtils.equals((String)carrier, (String)ChgCarrierEnum.CARRIER_ACTION.getCode()) && this.getModel().getValue("billsource") == null) {
            stringBuilder.append(ResManager.loadKDString((String)"\u4eba\u4e8b\u4e1a\u52a1\u5355\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ChgGuideConfigEditPlugin_0", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
        }
        if ((category = (DynamicObject)this.getModel().getValue("chgcategory")) == null) {
            stringBuilder.append(ResManager.loadKDString((String)"\u4eba\u4e8b\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ChgGuideConfigEditPlugin_1", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
        }
        if (this.getModel().getValue("name") == null || HRStringUtils.isEmpty((String)((OrmLocaleValue)this.getModel().getValue("name")).getLocaleValue())) {
            stringBuilder.append(ResManager.loadKDString((String)"\u65b9\u6848\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ChgGuideConfigEditPlugin_2", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
        } else {
            stringBuilder.append(this.validateName());
        }
        return stringBuilder.toString();
    }

    private void step2to3() {
        this.setStepVisible(Boolean.FALSE, "2");
        this.setStepVisible(Boolean.TRUE, "3");
        this.setSourceLabelVisible("step3source");
        this.showRuleConfigs();
    }

    private void showRuleConfigs() {
        if (this.getPageCache().get("step3") != null) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setTargetKey("ruleconfig");
        formShowParameter.setFormId("hpfs_chgguidelefttree");
        formShowParameter.setSendToClient(true);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        HashMap<String, Object> params = new HashMap<String, Object>(8);
        this.setStrategyConfig2Rule(params);
        this.setAddConfig2Rule(params);
        this.setTacticMaps(params);
        this.setChgPluginConfig2Rule(params);
        String ruleConfigs = this.getPageCache().get("ruleConfigs");
        HashMap ruleConfigMaps = new HashMap();
        if (ruleConfigs != null) {
            List ruleConfigList = (List)SerializationUtils.fromJsonString((String)ruleConfigs, List.class);
            ruleConfigList.forEach(row -> {
                if (row.get("chgtactic") == null) {
                    return;
                }
                String number = ("left_tactic_" + ((Map)row.get("chgtactic")).get("number")).toLowerCase(Locale.ROOT);
                String field = (String)row.get("chgfile");
                ruleConfigMaps.computeIfAbsent(number, map -> new HashMap()).put(field, row);
            });
            params.put("ruleConfigs", ruleConfigList);
        }
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "config"));
        params.put("ruleConfigMaps", ruleConfigMaps);
        formShowParameter.setCustomParam("params", params);
        HashMap<String, Long> map = (HashMap<String, Long>)this.getView().getFormShowParameter().getCustomParam("params");
        if (map == null) {
            map = new HashMap<String, Long>(4);
        }
        map.put("actiontype", Long.valueOf(this.getPageCache().get("actiontype")));
        formShowParameter.setCustomParam("ids", map);
        formShowParameter.setCustomParam("nameOrmValue", SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)this.getModel().getValue("name")), Map.class));
        formShowParameter.setCustomParam("name", this.getModel().getValue("name"));
        formShowParameter.setCustomParam("carrier", this.getModel().getValue("carrier"));
        formShowParameter.setStatus(this.getView().getFormShowParameter().getStatus());
        this.getView().showForm(formShowParameter);
        this.getPageCache().put("childPageId", formShowParameter.getPageId());
        this.getPageCache().put("step3", "1");
    }

    private void setTacticMaps(Map<String, Object> params) {
        List strategyTactics = (List)params.get("strategyTactics");
        List extraTactics = (List)params.get("addTactics");
        Map<String, Map> tacticMaps = extraTactics.stream().filter(row -> row.get("chgobject") != null).collect(Collectors.toMap(row -> ("left_tactic_" + row.get("number")).toLowerCase(Locale.ROOT), row -> row));
        strategyTactics.forEach(row -> {
            Map tactic = (Map)((Map)row.get(0)).get("chgtactic");
            if (tactic.get("chgobject") != null) {
                tacticMaps.putIfAbsent(("left_tactic_" + tactic.get("number")).toLowerCase(Locale.ROOT), tactic);
            }
        });
        params.put("tacticMaps", tacticMaps);
    }

    private void setChgPluginConfig2Rule(Map<String, Object> params) {
        DynamicObjectCollection pluginCollection = (DynamicObjectCollection)this.getModel().getValue("entryentity");
        params.put("pluginCollection", pluginCollection);
        params.put("pluginParam", this.getPageCache().get("pluginParam"));
    }

    private void setStrategyConfig2Rule(Map<String, Object> params) {
        String strategyTactic = this.getPageCache().get("strategyTactics");
        String strategyTacticIds = this.getPageCache().get("strategyTacticIds");
        if (strategyTactic == null) {
            return;
        }
        List strategyTacticIdList = (List)SerializationUtils.fromJsonString((String)strategyTacticIds, List.class);
        Map strategyMap = (Map)SerializationUtils.fromJsonString((String)strategyTactic, Map.class);
        ArrayList<List> strategyConfigList = new ArrayList<List>(strategyMap.size());
        ArrayList strategyBeforeTactics = new ArrayList(strategyMap.size());
        ArrayList strategyAfterTactics = new ArrayList(strategyMap.size());
        strategyTacticIdList.forEach(row -> {
            List strategyConfigListByTactic = (List)strategyMap.get(row);
            if (strategyConfigListByTactic != null) {
                strategyConfigList.add(strategyConfigListByTactic);
                String applicableStage = (String)((Map)((Map)strategyConfigListByTactic.get(0)).get("chgtactic")).get("applicablestage");
                String tacticNumber = (String)((Map)((Map)strategyConfigListByTactic.get(0)).get("chgtactic")).get("number");
                String tacticName = (String)((Map)((Map)((Map)strategyConfigListByTactic.get(0)).get("chgtactic")).get("name")).get("zh_CN");
                HashMap<String, String> tacticMap = new HashMap<String, String>();
                tacticMap.put("number", tacticNumber);
                tacticMap.put("name", tacticName);
                if (HRStringUtils.equals((String)applicableStage, (String)ChgTacticApplicableStageEnum.APPLICABLE_STAGE_BEFORE.getCode())) {
                    strategyBeforeTactics.add(tacticMap);
                } else {
                    strategyAfterTactics.add(tacticMap);
                }
            }
        });
        strategyConfigList.sort(Comparator.comparingInt(before -> (Integer)((Map)((Map)before.get(0)).get("chgtactic")).get("index")));
        params.put("strategyTacticIds", strategyTacticIdList);
        params.put("strategyTactics", strategyConfigList);
        params.put("strategyBeforeTactics", strategyBeforeTactics);
        params.put("strategyAfterTactics", strategyAfterTactics);
    }

    private void setAddConfig2Rule(Map<String, Object> params) {
        String addTactics = this.getPageCache().get("addTactics");
        String addTacticIds = this.getPageCache().get("addTacticIds");
        ArrayList extraBeforeTactics = new ArrayList();
        ArrayList extraAfterTactics = new ArrayList();
        if (addTactics != null) {
            List tactics = (List)SerializationUtils.fromJsonString((String)addTactics, List.class);
            List addTacticIdList = (List)SerializationUtils.fromJsonString((String)addTacticIds, List.class);
            params.put("addTacticIds", addTacticIdList);
            List<Map> tacticConfig = tactics.stream().filter(row -> {
                String tacticId = row.get("fid") == null ? row.get("id") + "" : row.get("fid") + "";
                return addTacticIdList.contains(tacticId);
            }).distinct().collect(Collectors.toList());
            tacticConfig.forEach(extraTactic -> {
                String applicableStage = (String)extraTactic.get("applicablestage");
                String tacticNumber = (String)extraTactic.get("number");
                String langTag = Lang.defaultLang().getLangTag().replace("-", "_");
                Object name = extraTactic.get("name");
                String tacticName = name instanceof String ? (String)extraTactic.get("name") : (String)((Map)extraTactic.get("name")).get(langTag);
                HashMap<String, String> tacticMap = new HashMap<String, String>();
                tacticMap.put("number", tacticNumber);
                tacticMap.put("name", tacticName);
                if (HRStringUtils.equals((String)applicableStage, (String)ChgTacticApplicableStageEnum.APPLICABLE_STAGE_BEFORE.getCode())) {
                    extraBeforeTactics.add(tacticMap);
                } else {
                    extraAfterTactics.add(tacticMap);
                }
            });
            params.put("addTactics", tacticConfig);
            params.put("extraBeforeTactics", extraBeforeTactics);
            params.put("extraAfterTactics", extraAfterTactics);
        } else {
            params.put("addTactics", new ArrayList(16));
            params.put("extraBeforeTactics", new ArrayList(16));
            params.put("extraAfterTactics", new ArrayList(16));
        }
        String extraTacticMappingStr = this.getPageCache().get("extraTacticMapping");
        params.put("extraTacticMapping", HRStringUtils.isEmpty((String)extraTacticMappingStr) ? Collections.emptyMap() : SerializationUtils.fromJsonString((String)extraTacticMappingStr, Map.class));
    }

    private void registerAskList() {
        String addTacticIds;
        ArrayList<Long> tacticIds = new ArrayList<Long>(16);
        String strategyTacticIds = this.getPageCache().get("strategyTacticIds");
        if (strategyTacticIds != null) {
            List strs = (List)SerializationUtils.fromJsonString((String)strategyTacticIds, List.class);
            tacticIds.addAll(strs.stream().map(Long::parseLong).collect(Collectors.toList()));
        }
        if ((addTacticIds = this.getPageCache().get("addTacticIds")) != null) {
            List strs = (List)SerializationUtils.fromJsonString((String)addTacticIds, List.class);
            tacticIds.addAll(strs.stream().map(Long::parseLong).collect(Collectors.toList()));
        }
        String strategyTactic = this.getPageCache().get("strategyTactics");
        Map<String, List<Map<String, Object>>> tacticMap = new HashMap<String, List<Map<String, Object>>>(tacticIds.size());
        if (strategyTactic != null) {
            tacticMap = (Map)SerializationUtils.fromJsonString((String)strategyTactic, Map.class);
        }
        this.formatDataRow(tacticIds, tacticMap);
    }

    private void setPanel() {
        String strategyTacticIds = this.getPageCache().get("strategyTacticIds");
        String addTacticIds = this.getPageCache().get("addTacticIds");
        ArrayList ids = new ArrayList(16);
        if (strategyTacticIds != null) {
            List strategyTacticIdList = (List)SerializationUtils.fromJsonString((String)strategyTacticIds, List.class);
            ids.addAll(strategyTacticIdList.stream().map(Long::parseLong).collect(Collectors.toList()));
        }
        if (addTacticIds != null) {
            List addTacticIdList = (List)SerializationUtils.fromJsonString((String)addTacticIds, List.class);
            ids.addAll(addTacticIdList.stream().map(Long::parseLong).collect(Collectors.toList()));
        }
        if (ids.size() == 0) {
            this.setFlexVisible(false, false);
            return;
        }
        HRBaseServiceHelper tacticHelper = new HRBaseServiceHelper("hpfs_chgtactic");
        DynamicObject[] dyns = tacticHelper.query("id,applicablestage,chgobject", new QFilter[]{new QFilter("id", "in", ids)});
        if (dyns == null || dyns.length == 0) {
            this.setFlexVisible(false, false);
            return;
        }
        List beforeDyns = Arrays.stream(dyns).filter(row -> HRStringUtils.equals((String)row.getString("applicablestage"), (String)"0")).collect(Collectors.toList());
        boolean beforeFlexShow = beforeDyns.size() != 0;
        List afterDyns = Arrays.stream(dyns).filter(row -> HRStringUtils.equals((String)row.getString("applicablestage"), (String)"1")).collect(Collectors.toList());
        boolean afterFlexShow = afterDyns.size() != 0;
        this.setFlexVisible(beforeFlexShow, afterFlexShow);
    }

    private void setFlexVisible(boolean beforeFlexShow, boolean afterFlexShow) {
        this.getView().setVisible(Boolean.valueOf(beforeFlexShow), new String[]{"flexbefore", "flexbeforeinfo"});
        this.getView().setVisible(Boolean.valueOf(afterFlexShow), new String[]{"flexafter", "flexafterinfo"});
    }

    private void formatDataRow(List<Long> tacticIds, Map<String, List<Map<String, Object>>> tacticMap) {
        Arrays.stream(GUIDE_CARD_SHOW_BILL).forEach(row -> {
            BillList askBillList = (BillList)this.getView().getControl(row);
            askBillList.addSetFilterListener(setFilterEvent -> {
                QFilter idFilter = new QFilter("id", "in", (Object)tacticIds);
                setFilterEvent.getQFilters().add(idFilter);
            });
            askBillList.addPackageDataListener(packageDataEvent -> {
                String key = ((AbstractColumnDesc)packageDataEvent.getSource()).getKey();
                if (HRStringUtils.equals((String)key, (String)"ismust")) {
                    DynamicObject dyn = packageDataEvent.getRowData();
                    Long tacticId = dyn.getLong("id");
                    if (tacticMap.get(tacticId + "") == null) {
                        packageDataEvent.setFormatValue((Object)"1");
                        return;
                    }
                    Boolean isMust = (Boolean)((Map)((List)tacticMap.get(tacticId + "")).get(0)).get("iscorerule");
                    packageDataEvent.setFormatValue((Object)(isMust != false ? "1" : "0"));
                }
            });
        });
    }

    private void setStepVisible(Boolean visible, String stepNum) {
        this.getView().setVisible(visible, new String[]{"step" + stepNum + "head"});
        this.getView().setVisible(visible, new String[]{"step" + stepNum + "body"});
        this.getView().setVisible(visible, new String[]{"step" + stepNum + "tail"});
    }

    private void setSourceLabelVisible(String sourceLabel) {
        String carrier = (String)this.getModel().getValue("carrier");
        boolean visible = HRStringUtils.equals((String)carrier, (String)ChgCarrierEnum.CARRIER_BILL.getCode());
        this.getView().setVisible(Boolean.valueOf(visible), new String[]{sourceLabel});
        this.getView().setVisible(Boolean.valueOf(!visible), new String[]{"apiinfo"});
    }

    private void finish() {
        String childPageId = this.getPageCache().get("childPageId");
        if (HRStringUtils.isEmpty((String)childPageId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u5b50\u754c\u9762ID\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ChgGuideConfigEditPlugin_16", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
            return;
        }
        OperationResult result = this.getView().getView(childPageId).invokeOperation("save");
        if (result.isSuccess()) {
            LOGGER.info("ChgGuideConfigEditPlugin#finish save success");
            this.getModel().setDataChanged(false);
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff01", (String)"ChgGuideConfigEditPlugin_8", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
            this.getView().sendFormAction(this.getView().getParentView());
            this.getView().returnDataToParent((Object)"1");
            this.getView().close();
        } else if (Objects.nonNull(result.getMessage()) && result.getMessage().length() > 0) {
            LOGGER.info("ChgGuideConfigEditPlugin#finish save fail");
            this.getView().showTipNotification(result.getMessage());
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key;
        BasedataEdit basedataEdit = (BasedataEdit)beforeF7SelectEvent.getSource();
        switch (key = basedataEdit.getKey()) {
            case "billsource": {
                QFilter billFilter = new QFilter("modeltype", "=", (Object)"BillFormModel");
                QFilter appFilter = new QFilter("bizappid.bizcloud.number", "=", (Object)"HR");
                beforeF7SelectEvent.setCustomQFilters(Arrays.asList(billFilter, appFilter));
                break;
            }
            case "chgcategory": {
                this.filterCategoryWithoutStrategy(beforeF7SelectEvent);
                break;
            }
            case "plugin": {
                this.filterPlugin(beforeF7SelectEvent);
                break;
            }
        }
    }

    private void filterPlugin(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        Set plugins = entryEntity.stream().map(row -> row.getLong("plugin.id")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("id", "not in", plugins);
        beforeF7SelectEvent.addCustomQFilter(qFilter);
    }

    private void filterCategoryWithoutStrategy(BeforeF7SelectEvent beforeF7SelectEvent) {
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        HRBaseServiceHelper strategyHelper = new HRBaseServiceHelper("hpfs_chgstrategy");
        DynamicObject[] dyns = strategyHelper.query("chgcategory", new QFilter[]{enable});
        List categoryIds = Arrays.stream(dyns).map(row -> row.getLong("chgcategory.id")).collect(Collectors.toList());
        QFilter id = new QFilter("id", "in", categoryIds);
        beforeF7SelectEvent.setCustomQFilters(Arrays.asList(enable, id));
    }

    public void beforeBindData(EventObject e) {
        Map map;
        super.beforeBindData(e);
        if (this.getPageCache().get("index") == null) {
            this.setStepVisible(Boolean.FALSE, "2");
            this.setStepVisible(Boolean.FALSE, "3");
            this.getPageCache().put("index", "1");
        }
        if ((map = (Map)this.getView().getFormShowParameter().getCustomParam("params")) != null && map.get("isDuplicate") != null) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"chgcategory"});
        }
        DynamicObjectCollection collection = this.getModel().getEntryEntity("entryentity");
        collection.forEach(row -> {
            int seq = row.getInt("seq");
            String occasion = row.getString("plugin.occasion");
            if (HRStringUtils.equals((String)ChgPluginOccasionEnum.AFTER_DATA_SAVED.getCode(), (String)occasion)) {
                this.getView().setEnable(Boolean.FALSE, seq - 1, new String[]{"isinterrupted"});
            }
        });
        this.registerAskList();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initModifyData();
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        this.initModifyData();
    }

    private void initModifyData() {
        Map map = (Map)this.getView().getFormShowParameter().getCustomParam("params");
        if (map != null) {
            this.getModel().setValue("chgcategory", map.get("chgCategoryId"));
            this.getModel().setValue("billsource", map.get("billSource"));
            this.getModel().setValue("name", map.get("name"));
            this.getModel().setValue("carrier", map.get("carrier"));
            this.carrierChanged();
            this.initPluginCollection(map);
            this.getModel().setDataChanged(false);
        }
    }

    private void initPluginCollection(Map<String, Object> map) {
        List collection = (List)map.get("pluginCollection");
        DynamicObjectCollection pluginCollection = (DynamicObjectCollection)this.getModel().getValue("entryentity");
        HashMap pluginParamMap = new HashMap();
        List ids = collection.stream().map(row -> row.get("plugin")).collect(Collectors.toList());
        QFilter idFilter = new QFilter("id", "in", ids);
        DynamicObject[] dynamicObjectArray = new HRBaseServiceHelper("hpfs_chgplugin").loadDynamicObjectArray(new QFilter[]{idFilter});
        Map<Long, DynamicObject> pluginMap = Arrays.stream(dynamicObjectArray).collect(Collectors.toMap(row -> row.getLong("id"), row -> row));
        collection.forEach(plugin -> {
            DynamicObject dyn = pluginCollection.addNew();
            Arrays.stream(basciFieldArr).forEach(field -> dyn.set(field, plugin.get(field)));
            dyn.set("plugin_id", plugin.get("plugin"));
            DynamicObject pluginDyn = (DynamicObject)pluginMap.get(Long.parseLong(plugin.get("plugin") + ""));
            List subEntryEntity = (List)plugin.get("subentryentity");
            List pluginParamList = subEntryEntity.stream().map(row -> {
                HashMap pluginParamValueMap = new HashMap();
                pluginParamValueMap.put("paramnumber", row.get("param"));
                pluginParamValueMap.put("paramvalue", row.get("value"));
                return pluginParamValueMap;
            }).collect(Collectors.toList());
            if (pluginDyn != null) {
                pluginParamMap.put(pluginDyn.getString("number"), pluginParamList);
            }
        });
        this.getModel().setValue("entryentity", (Object)pluginCollection);
        this.getPageCache().put("pluginParam", SerializationUtils.toJsonString(pluginParamMap));
    }

    private void cacheAddTactic() {
        Map map = (Map)this.getView().getFormShowParameter().getCustomParam("params");
        if (map == null) {
            return;
        }
        long chgRuleId = Long.parseLong(map.get("chgRuleId") + "");
        if (chgRuleId == 0L) {
            return;
        }
        this.getPageCache().put("chgRuleId", chgRuleId + "");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hpfs_chgconfigentry");
        DynamicObject[] dynamicObjects = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("chgrule", "=", (Object)chgRuleId)});
        List strategyTacticIds = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("strategyTacticIds"), List.class);
        List<DynamicObject> addTacticsFromConfig = Arrays.stream(dynamicObjects).filter(row -> !strategyTacticIds.contains(row.getString("chgtactic.id")) && HRStringUtils.isNotEmpty((String)row.getString("chgtactic.chgobject"))).map(row -> row.getDynamicObject("chgtactic")).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        Map<String, Map<String, Map<String, Map<String, String>>>> mappingMap = this.formatMapping(dynamicObjects);
        List<DynamicObject> extraTacticFromRuleConfig = this.getTacticByMappingTable(mappingMap);
        Set extraTacticFromRuleConfigIds = extraTacticFromRuleConfig.stream().map(row -> row.getLong("id") + "").collect(Collectors.toSet());
        List strategyTacticList = Arrays.stream(dynamicObjects).filter(row -> strategyTacticIds.contains(row.getString("chgtactic.id")) && !extraTacticFromRuleConfigIds.contains(row.getString("chgtactic.id"))).map(row -> row.getString("chgtactic.id")).distinct().collect(Collectors.toList());
        strategyTacticList.addAll(extraTacticFromRuleConfigIds);
        strategyTacticIds.removeAll(strategyTacticList);
        this.filterExtraTacticFromRuleConfig(extraTacticFromRuleConfig, addTacticsFromConfig);
        addTacticsFromConfig.addAll(extraTacticFromRuleConfig);
        List addTacticsIds = addTacticsFromConfig.stream().map(row -> row.getString("id")).distinct().collect(Collectors.toList());
        if (this.getPageCache().get("addTactics") != null) {
            List addTactics = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("addTactics"), List.class);
            addTactics.addAll((Collection)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(addTacticsFromConfig), List.class));
            this.getPageCache().put("addTactics", SerializationUtils.toJsonString((Object)addTactics));
        } else {
            this.getPageCache().put("addTactics", SerializationUtils.toJsonString(addTacticsFromConfig));
        }
        if (this.getPageCache().get("addTacticIds") != null) {
            List addTacticId = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("addTacticIds"), List.class);
            addTacticId.addAll((Collection)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(addTacticsIds), List.class));
            this.getPageCache().put("addTacticIds", SerializationUtils.toJsonString((Object)addTacticId));
        } else {
            this.getPageCache().put("addTacticIds", SerializationUtils.toJsonString(addTacticsIds));
        }
        this.getPageCache().put("ruleConfigs", SerializationUtils.toJsonString(Arrays.asList(dynamicObjects)));
        this.getPageCache().put("strategyTacticIds", SerializationUtils.toJsonString(strategyTacticList));
        this.getPageCache().put("strategyTacticExcludeIds", SerializationUtils.toJsonString((Object)strategyTacticIds));
    }

    private void filterExtraTacticFromRuleConfig(List<DynamicObject> extraTacticFromRuleConfig, List<DynamicObject> addTacticsFromConfig) {
        Map tacticMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("strategyTactics"), Map.class);
        HashMap map = new HashMap(16);
        tacticMap.values().forEach(row -> row.forEach(dyn -> {
            Map tactic = (Map)dyn.get("chgtactic");
            if (tactic == null) {
                return;
            }
            Map chgObject = (Map)tactic.get("chgobject");
            if (chgObject == null) {
                return;
            }
            String entityName = (String)chgObject.get("number");
            String chgMode = (String)tactic.get("chgmode");
            map.computeIfAbsent(entityName, set -> new HashSet()).add(chgMode);
        }));
        List exitNumber = addTacticsFromConfig.stream().map(dy -> dy.getString("number")).collect(Collectors.toList());
        extraTacticFromRuleConfig.removeIf(row -> {
            String entityName = row.getString("chgobject.number");
            String chgMode = row.getString("chgmode");
            return map.get(entityName) != null && ((Set)map.get(entityName)).contains(chgMode) || exitNumber.contains(row.getString("number"));
        });
    }

    private List<DynamicObject> getTacticByMappingTable(Map<String, Map<String, Map<String, Map<String, String>>>> mappingMap) {
        Set<String> tables = mappingMap.keySet();
        QFilter chgObjectQFilter = new QFilter("chgobject", "in", tables);
        String selectFields = "id, chgobject, chgmode";
        DynamicObject[] dyns = ChgTacticRepository.query((String)selectFields, (QFilter[])new QFilter[]{chgObjectQFilter, RepositoryUtils.isEnable()});
        HashMap map = new HashMap();
        List<DynamicObject> extraTactics = Arrays.stream(dyns).filter(row -> {
            boolean res;
            boolean bl = res = mappingMap.get(row.getString("chgobject.number")) != null && ((Map)mappingMap.get(row.getString("chgobject.number"))).get(row.getString("chgmode")) != null;
            if (res) {
                Map fields = (Map)((Map)mappingMap.get(row.getString("chgobject.number"))).get(row.getString("chgmode"));
                map.put(("left_tactic_" + row.getString("number")).toLowerCase(Locale.ROOT), fields);
            }
            return res;
        }).collect(Collectors.toList());
        this.getPageCache().put("extraTacticMapping", SerializationUtils.toJsonString(map));
        return extraTactics;
    }

    private Map<String, Map<String, Map<String, Map<String, String>>>> formatMapping(DynamicObject[] dynamicObjects) {
        HashMap<Long, String> mappingChgMode = new HashMap<Long, String>(16);
        for (DynamicObject row : dynamicObjects) {
            if (row.getLong("filemapping.id") == 0L) continue;
            mappingChgMode.putIfAbsent(row.getLong("filemapping.id"), row.getString("chgtactic.chgmode"));
        }
        Set mappingIds = mappingChgMode.keySet();
        QFilter qFilter = new QFilter("id", "in", mappingIds);
        DynamicObject[] fileDyns = ChgMappingRepository.getInstance().loadDynamicObjectArray(new QFilter[]{qFilter});
        HashMap<String, Map<String, Map<String, Map<String, String>>>> res = new HashMap<String, Map<String, Map<String, Map<String, String>>>>(16);
        for (DynamicObject mappingFile : fileDyns) {
            Long mappingId = mappingFile.getLong("id");
            String chgMode = (String)mappingChgMode.get(mappingId);
            DynamicObjectCollection tableMapping = mappingFile.getDynamicObjectCollection("entryentity");
            for (DynamicObject mappedTable : tableMapping) {
                String targetTable = mappedTable.getString("targetentity.number");
                String sourceTable = mappedTable.getString("sourceentity.number");
                DynamicObjectCollection fieldMapping = mappedTable.getDynamicObjectCollection("subentryentity");
                for (DynamicObject mappedField : fieldMapping) {
                    String targetField = mappedField.getString("targetfield").toLowerCase(Locale.ROOT);
                    String sourceField = mappedField.getString("sourcefield").toLowerCase(Locale.ROOT);
                    HashMap<String, String> field = new HashMap<String, String>();
                    field.put("chgfile", targetField);
                    field.put("limittype", "");
                    field.put("entitysource", sourceTable);
                    field.put("fieldsource", sourceField);
                    res.computeIfAbsent(targetTable, map -> new HashMap()).computeIfAbsent(chgMode, map -> new HashMap()).putIfAbsent(targetField, field);
                }
            }
        }
        this.processMergedTactic(res);
        return res;
    }

    private void processMergedTactic(Map<String, Map<String, Map<String, Map<String, String>>>> mappingMap) {
        HashMap<String, String> tacticMergedCombination = new HashMap<String, String>(16);
        tacticMergedCombination.put("hrpi_employee", "hrpi_empentrel");
        tacticMergedCombination.put("hrpi_cmpemp", "hrpi_managingscope");
        tacticMergedCombination.put("hrpi_depemp", "hrpi_empposorgrel");
        tacticMergedCombination.put("hrpi_emporgrelall", "hrpi_empposorgrel");
        tacticMergedCombination.forEach((mergeFrom, mergeTo) -> {
            Map mergeFromMap = (Map)mappingMap.remove(mergeFrom);
            if (null != mergeFromMap) {
                mergeFromMap.forEach((chgMode, fieldMap) -> fieldMap.forEach((field, fields) -> mappingMap.computeIfAbsent((String)mergeTo, map -> new HashMap()).computeIfAbsent(chgMode, map -> new HashMap()).putIfAbsent(field, fields)));
            }
        });
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String key;
        super.propertyChanged(args);
        switch (key = args.getProperty().getName()) {
            case "chgcategory": {
                this.chgCategoryChanged(args);
                break;
            }
            case "billsource": {
                this.billSourceChanged(args);
                break;
            }
            case "carrier": {
                this.carrierChanged();
                break;
            }
            case "plugin": {
                this.cachePluginParam(args);
                break;
            }
        }
    }

    private void cachePluginParam(PropertyChangedArgs args) {
        ChangeData[] changeData = args.getChangeSet();
        DynamicObject newPlugin = (DynamicObject)changeData[0].getNewValue();
        if (newPlugin == null) {
            return;
        }
        DynamicObjectCollection collection = newPlugin.getDynamicObjectCollection("entryentity");
        String number = newPlugin.getString("number");
        List paramMapList = collection.stream().map(row -> {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("paramname", row.getString("paramname"));
            paramMap.put("paramnumber", row.getString("paramnumber"));
            return paramMap;
        }).collect(Collectors.toList());
        String pluginParam = this.getPageCache().get("pluginParam");
        Map map = HRStringUtils.isEmpty((String)pluginParam) ? new HashMap(16) : (Map)SerializationUtils.fromJsonString((String)pluginParam, Map.class);
        map.put(number, paramMapList);
        this.getPageCache().put("pluginParam", SerializationUtils.toJsonString(map));
        String occasion = newPlugin.getString("occasion");
        this.pluginOccasionChanged(args, occasion);
    }

    private void pluginOccasionChanged(PropertyChangedArgs args, String occasion) {
        ChangeData[] changeData = args.getChangeSet();
        int sec = changeData[0].getRowIndex();
        if (HRStringUtils.equals((String)ChgPluginOccasionEnum.AFTER_DATA_SAVED.getCode(), (String)occasion)) {
            DynamicObjectCollection pluginCollection = this.getModel().getEntryEntity("entryentity");
            ((DynamicObject)pluginCollection.get(sec)).set("isinterrupted", (Object)Boolean.FALSE);
            this.getView().setEnable(Boolean.FALSE, sec, new String[]{"isinterrupted"});
            this.getView().updateView();
        } else {
            this.getView().setEnable(Boolean.TRUE, sec, new String[]{"isinterrupted"});
        }
    }

    private String validateName() {
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.VIEW.equals((Object)operationStatus)) {
            return "";
        }
        OrmLocaleValue localeValue = (OrmLocaleValue)this.getModel().getValue("name");
        String name = localeValue.getLocaleValue() == null ? localeValue.get((Object)"GLang") : localeValue.getLocaleValue();
        Map map = (Map)this.getView().getFormShowParameter().getCustomParam("params");
        Long chgActionId = map == null || operationStatus.getValue() == OperationStatus.ADDNEW.getValue() ? null : Long.valueOf(map.get("chgActionId") + "");
        DynamicObject category = (DynamicObject)this.getModel().getValue("chgcategory");
        Long hbssActionTypeId = null;
        if (category != null) {
            hbssActionTypeId = category.getLong("actiontype_id");
        }
        Long ruleId = map == null || operationStatus.getValue() == OperationStatus.ADDNEW.getValue() ? null : Long.valueOf(Long.parseLong(map.get("chgRuleId") + ""));
        Long guideBaseId = map == null || operationStatus.getValue() == OperationStatus.ADDNEW.getValue() ? null : Long.valueOf(Long.parseLong(map.get("chgGuideBaseId") + ""));
        String number = map == null || operationStatus.getValue() == OperationStatus.ADDNEW.getValue() ? "" : (String)map.get("number");
        return ChgNameValidateService.getInstance().validateName(name, chgActionId, hbssActionTypeId, ruleId, guideBaseId, number);
    }

    private void carrierChanged() {
        String carrier = (String)this.getModel().getValue("carrier");
        if (HRStringUtils.isEmpty((String)carrier)) {
            return;
        }
        this.getPageCache().remove("step3");
        if (HRStringUtils.equals((String)carrier, (String)ChgCarrierEnum.CARRIER_BILL.getCode())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"billsource"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"billsource"});
            this.getModel().setValue("billsource", null);
        }
    }

    private void billSourceChanged(PropertyChangedArgs args) {
        DynamicObject billSource = (DynamicObject)args.getChangeSet()[0].getNewValue();
        if (billSource == null) {
            return;
        }
        String billSourceName = billSource.getString("id");
        this.getPageCache().put("billsource", billSourceName);
    }

    private void cacheConfigInfo() {
        String carrier = (String)this.getModel().getValue("carrier");
        this.getPageCache().put("carrier", carrier);
        if (HRStringUtils.equals((String)carrier, (String)ChgCarrierEnum.CARRIER_BILL.getCode())) {
            DynamicObject source = (DynamicObject)this.getModel().getValue("billsource");
            this.getPageCache().put("billsource", source.getString("id"));
        }
        String name = ((OrmLocaleValue)this.getModel().getValue("name")).getLocaleValue();
        this.getPageCache().put("name", name);
    }

    private void chgCategoryChanged(PropertyChangedArgs args) {
        DynamicObject categoryNew = (DynamicObject)args.getChangeSet()[0].getNewValue();
        if (categoryNew == null) {
            return;
        }
        this.setPanel();
        this.getPageCache().remove("step3");
        this.getPageCache().remove("addTactics");
        this.getPageCache().remove("addTacticIds");
        this.getPageCache().remove("strategyTacticExcludeIds");
    }

    private void cacheTacticByCategory() {
        DynamicObject category = (DynamicObject)this.getModel().getValue("chgcategory");
        Long categoryId = category.getLong("id");
        this.getPageCache().put("chgcategory", categoryId + "");
        this.getPageCache().put("chgevent", category.getLong("chgevent.id") + "");
        this.getPageCache().put("actiontype", category.getLong("actiontype.id") + "");
        HRBaseServiceHelper strategyHelper = new HRBaseServiceHelper("hpfs_chgstrategy");
        DynamicObject strategy = strategyHelper.loadDynamicObject(new QFilter[]{new QFilter("chgcategory", "=", (Object)categoryId)});
        this.getPageCache().put("chgstrategy", strategy.getLong("id") + "");
        HRBaseServiceHelper strategyConfigHelper = new HRBaseServiceHelper("hpfs_affstrategyentry");
        DynamicObject[] strategyConfig = strategyConfigHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("chgstrategy", "=", (Object)strategy.getLong("id"))});
        List tacticList = Arrays.stream(strategyConfig).filter(row -> HRStringUtils.isNotEmpty((String)row.getString("chgtactic.chgobject"))).map(row -> row.getDynamicObject("chgtactic")).distinct().collect(Collectors.toList());
        Map<Long, List<DynamicObject>> tacticMap = Arrays.stream(strategyConfig).filter(row -> HRStringUtils.isNotEmpty((String)row.getString("chgtactic.chgobject"))).collect(Collectors.groupingBy(row -> row.getLong("chgtactic.id")));
        List tacticIds = tacticList.stream().map(row -> String.valueOf(row.getLong("id"))).collect(Collectors.toList());
        this.getPageCache().put("strategyTactics", SerializationUtils.toJsonString(tacticMap));
        this.getPageCache().put("strategyTacticIds", SerializationUtils.toJsonString(tacticIds));
    }
}

