/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.formplugin.guide;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.metadata.form.control.VectorAp;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.control.HRLabelAp;
import kd.hr.hbp.common.control.HRVectorAp;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hr.hpfs.common.constants.ChgConstants;
import kd.hr.hpfs.common.constants.ChgGuideConstants;
import kd.hr.hpfs.common.constants.ChgRuleConstants;
import kd.hr.hpfs.common.constants.ChgStrategyConstants;
import kd.hr.hpfs.common.enums.ChgCarrierEnum;
import kd.hr.hpfs.formplugin.model.DrawFormFieldDto;
import kd.hr.hpfs.formplugin.service.ChgGuideBaseDrawControlService;
import kd.hr.hpfs.formplugin.util.ChgCommonUtils;
import kd.hr.hpfs.formplugin.util.ChgStyleUtils;
import kd.hr.hpfs.formplugin.util.DynamicPanelUtils;
import kd.hr.hpfs.formplugin.util.PageDrawerUtils;
import kd.hr.hpfs.formplugin.util.TemplateEditUtils;

public class ChgGuideFieldEditPlugin
extends HRDataBaseEdit
implements ChgConstants,
ChgStrategyConstants,
ChgRuleConstants,
ChgGuideConstants,
BeforeF7SelectListener {
    private static final Log LOGGER = LogFactory.getLog(ChgGuideFieldEditPlugin.class);

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        FormShowParameter formShowParameter = (FormShowParameter)e.getSource();
        FlexPanelAp flexPanelAp = this.loadMetas(formShowParameter);
        HashMap<String, String> flexMap = new HashMap<String, String>(4);
        flexMap.put("id", "containerflex");
        flexMap.put("items", (String)flexPanelAp.createControl().get("items"));
        e.getItems().add(flexMap);
    }

    private FlexPanelAp loadMetas(FormShowParameter formShowParameter) {
        Map map = (Map)formShowParameter.getCustomParam("params");
        ArrayList<DrawFormFieldDto> allFields = new ArrayList<DrawFormFieldDto>();
        HashMap<String, String> baseFields = new HashMap<String, String>(16);
        HashMap<String, String> originFields = new HashMap<String, String>(16);
        FlexPanelAp flexPanelAp = new HRFlexPanelAp.Builder("containerflex").setName(CHINESE_CONTAINER_FLEX).build();
        List tacticConfig = (List)map.get("tacticConfig");
        Map tacticMap = (Map)map.get("tacticMap");
        String carrier = (String)map.get("carrier");
        flexPanelAp.getItems().add(this.formatEntityFlexAp(tacticConfig, allFields, baseFields, originFields, tacticMap, carrier, formShowParameter));
        formShowParameter.getCustomParams().put("allFields", SerializationUtils.toJsonString(allFields));
        formShowParameter.getCustomParams().put("baseFields", SerializationUtils.toJsonString(baseFields));
        formShowParameter.getCustomParams().put("originFields", SerializationUtils.toJsonString(originFields));
        return flexPanelAp;
    }

    private FlexPanelAp formatEntityFlexAp(List<Map<String, Object>> tactic, List<DrawFormFieldDto> allFields, Map<String, String> baseFields, Map<String, String> originFields, Map<String, Object> tacticMap, String carrier, FormShowParameter formShowParameter) {
        String tacticName = PageDrawerUtils.getNameLocalValue((Map)tacticMap.get("name"));
        String tacticNumber = (String)tacticMap.get("number");
        Map changeObject = (Map)tacticMap.get("chgobject");
        if (CollectionUtils.isEmpty((Map)changeObject)) {
            return this.formatAllScheduleTable(tacticNumber, tacticName, allFields, originFields);
        }
        String chgObject = (String)changeObject.get("id");
        formShowParameter.setCustomParam("chgObject", (Object)chgObject);
        Map<String, Map> tacticFieldMap = tactic.stream().collect(Collectors.toMap(row -> (String)row.get("chgfile"), row -> row));
        DataEntityPropertyCollection dataEntityPropertyCollection = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)chgObject)).getDataEntityType().getProperties();
        FlexPanelAp tacticAp = ChgStyleUtils.formatStrategyTacticAp(tacticNumber, tacticName);
        LabelAp labelAp = ((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)new HRLabelAp.Builder("label-" + tacticNumber).setFontSize(16).setMarginTop("18px")).setMarginBottom("10px")).setMarginLeft("7px")).setForeColor("#666666").setShrink(0).setName(tacticName).build();
        tacticAp.getItems().add(labelAp);
        HashSet<String> sysFields = new HashSet<String>(Arrays.asList(FIELDS_PROCESSED_BY_SYSTEM));
        HashSet chgSysFields = new HashSet();
        originFields.putAll(dataEntityPropertyCollection.stream().filter(property -> !sysFields.contains(property.getName()) && !chgSysFields.contains(property.getName()) && !property.getName().endsWith("_id")).collect(Collectors.toMap(property -> property.getName(), property -> property.getDisplayName() == null ? "" : property.getDisplayName().getLocaleValue())));
        originFields.forEach((name, displayName) -> {
            FlexPanelAp flexPanelAp = ChgStyleUtils.formatStrategyTacticFiledFlex(tacticNumber, name);
            ChgGuideBaseDrawControlService.getInstance().formatFieldText(flexPanelAp, (String)name, (String)displayName, allFields);
            if (tacticFieldMap.get(name) != null) {
                flexPanelAp.getItems().add(this.formatStrategyFiledFlex((Map)tacticFieldMap.get(name), allFields, baseFields, carrier));
            } else {
                HashMap<String, Object> configMap = new HashMap<String, Object>();
                configMap.put("required", false);
                configMap.put("chgfile", name);
                configMap.put("limittype", "");
                configMap.put("editable", Boolean.TRUE);
                configMap.put("chgtactic", tacticMap);
                flexPanelAp.getItems().add(this.formatOtherFieldFlex((Map<String, Object>)configMap, allFields, baseFields, (String)name, (String)displayName, carrier));
            }
            tacticAp.getItems().add(flexPanelAp);
        });
        return tacticAp;
    }

    private FlexPanelAp formatAllScheduleTable(String tacticNumber, String tacticName, List<DrawFormFieldDto> allFields, Map<String, String> originFields) {
        return ChgStyleUtils.formatStrategyTacticAp(tacticNumber, tacticName);
    }

    private FlexPanelAp formatOtherFieldFlex(Map<String, Object> configMap, List<DrawFormFieldDto> allFields, Map<String, String> baseFields, String name, String displayName, String carrier) {
        FlexPanelAp customAp = this.formatMappingSourceDraw(configMap, name, allFields, baseFields, "", displayName, Boolean.FALSE, carrier);
        customAp.getItems().add(this.getVectorAp(name, ""));
        return customAp;
    }

    private FlexPanelAp formatStrategyFiledFlex(Map<String, Object> configMap, List<DrawFormFieldDto> allFields, Map<String, String> baseFields, String carrier) {
        String tacticNumber = (String)((Map)configMap.get("chgtactic")).get("number");
        String fieldNumber = (String)configMap.get("chgfile");
        FlexPanelAp flexPanelAp = ChgStyleUtils.formatStrategyTacticFiledFlex(tacticNumber, fieldNumber);
        if (HRStringUtils.isEmpty((String)fieldNumber)) {
            return flexPanelAp;
        }
        String chgObject = (String)((Map)((Map)configMap.get("chgtactic")).get("chgobject")).get("id");
        boolean isMust = (Boolean)configMap.get("required");
        boolean editable = (Boolean)configMap.get("editable");
        String limitType = (String)configMap.get("limittype");
        String displayName = PageDrawerUtils.getChgObjectFieldName(fieldNumber, chgObject);
        switch (limitType) {
            case "": {
                FlexPanelAp customAp = this.formatMappingSourceDraw(configMap, fieldNumber, allFields, baseFields, limitType, displayName, isMust, carrier);
                customAp.getItems().add(this.getVectorAp(fieldNumber, ""));
                return customAp;
            }
            case "0": {
                FlexPanelAp fixedAp = new HRFlexPanelAp.Builder("fixedval" + fieldNumber).setName(CHINESE_FIELD_FLEX + fieldNumber).setWrap(false).setOverflow("auto").build();
                fixedAp.getItems().add(ChgGuideBaseDrawControlService.getInstance().formatFieldCombo(fieldNumber, configMap, allFields, limitType, displayName, isMust, carrier));
                fixedAp.getItems().addAll(ChgGuideBaseDrawControlService.getInstance().formatFixedVal(fieldNumber, configMap, allFields, new ArrayList<Map<String, Object>>(), baseFields, displayName, carrier));
                fixedAp.getItems().add(this.getVectorAp(fieldNumber, ""));
                return fixedAp;
            }
            case "1": {
                flexPanelAp.getItems().addAll(ChgGuideBaseDrawControlService.getInstance().formatChgType(fieldNumber, isMust, editable, allFields, configMap, new ArrayList<Map<String, Object>>(), baseFields, displayName));
                break;
            }
        }
        return flexPanelAp;
    }

    private VectorAp getVectorAp(String name, String fontClass) {
        return ((HRVectorAp.Builder)new HRVectorAp.Builder("matchicon-" + name).setfontClass(fontClass).setMarginTop("18px")).build();
    }

    private FlexPanelAp formatMappingSourceDraw(Map<String, Object> configMap, String name, List<DrawFormFieldDto> allFields, Map<String, String> baseFields, String limitType, String displayName, boolean isMust, String carrier) {
        FlexPanelAp customAp = new HRFlexPanelAp.Builder("appointed" + name).setName(CHINESE_FIELD_FLEX + name).setWrap(false).setOverflow("auto").build();
        customAp.getItems().add(ChgGuideBaseDrawControlService.getInstance().formatFieldCombo(name, configMap, allFields, limitType, displayName, isMust, carrier));
        customAp.getItems().addAll(ChgGuideBaseDrawControlService.getInstance().formatCustomSource(name, isMust, allFields, displayName));
        customAp.getItems().addAll(ChgGuideBaseDrawControlService.getInstance().formatFixedValV1(name, configMap, allFields, new ArrayList<Map<String, Object>>(), baseFields, displayName));
        return customAp;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        BasedataEdit basedataEdit = (BasedataEdit)beforeF7SelectEvent.getSource();
        String key = basedataEdit.getKey();
        Map baseFields = (Map)SerializationUtils.fromJsonString((String)((String)this.getView().getFormShowParameter().getCustomParam("baseFields")), Map.class);
        String valueRange = (String)baseFields.get(key);
        if (valueRange != null) {
            QFilter qFilter = QFilter.fromSerializedString((String)valueRange);
            beforeF7SelectEvent.setCustomQFilters(Arrays.asList(qFilter.toArray()));
            return;
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setControlStatus();
    }

    private void setControlStatus() {
        this.getAllFields().values().forEach(drawFormFieldDto -> {
            String field = drawFormFieldDto.getField();
            if (field.startsWith("text_")) {
                this.getView().setEnable(Boolean.FALSE, new String[]{field});
            }
        });
        String carrier = this.getView().getParentView().getPageCache().get("carrier");
        if (HRStringUtils.equals((String)carrier, (String)ChgCarrierEnum.CARRIER_BILL.getCode())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"batchprocess"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"match"});
        }
        String[] strs = (String[])this.getOriginFields().keySet().stream().map(row -> "matchicon-" + row).toArray(String[]::new);
        this.getView().setVisible(Boolean.FALSE, strs);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FlexPanelAp flexPanelAp = this.loadMetas(this.getView().getFormShowParameter());
        Container fldPanel = (Container)this.getView().getControl("containerflex");
        fldPanel.getItems().addAll(((Container)flexPanelAp.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(fldPanel.getItems());
        this.initValue();
    }

    private boolean isAddStatus() {
        int operateStatus = this.getView().getFormShowParameter().getStatus().getValue();
        return operateStatus == OperationStatus.ADDNEW.getValue();
    }

    private void initValue() {
        Map params = (Map)this.getView().getFormShowParameter().getCustomParam("params");
        Map tacticMap = (Map)params.get("tacticMap");
        this.getPageCache().put("tacticMap", SerializationUtils.toJsonString((Object)tacticMap));
        String chgRuleId = this.getView().getParentView().getPageCache().get("chgRuleId");
        if (this.isAddStatus() && HRStringUtils.isEmpty((String)chgRuleId)) {
            this.afterCreateNewData();
        } else {
            this.afterLoadData();
        }
    }

    private void afterCreateNewData() {
        Map params = (Map)this.getView().getFormShowParameter().getCustomParam("params");
        List tacticConfig = (List)params.get("tacticConfig");
        Map<String, Map> tacticFieldMap = tacticConfig.stream().collect(Collectors.toMap(tactic -> (String)tactic.get("chgfile"), tactic -> tactic));
        Map<String, DrawFormFieldDto> allFields = this.getAllFields();
        Map<String, String> originFields = this.getOriginFields();
        Map fieldsMap = (Map)params.get("fieldsValueCache");
        String carrier = this.getView().getParentView().getPageCache().get("carrier");
        originFields.forEach((name, displayName) -> {
            DrawFormFieldDto drawFormFieldText = (DrawFormFieldDto)allFields.get("text_" + name);
            if (drawFormFieldText == null) {
                return;
            }
            this.getModel().setValue(drawFormFieldText.getField(), (Object)drawFormFieldText.getName());
            Map field = (Map)tacticFieldMap.get(name);
            if (fieldsMap != null && fieldsMap.get(name) != null) {
                this.initValueByCache((Map)fieldsMap.get(name), (String)name);
            } else if (field != null) {
                this.initValueByLimitType(field, (String)name);
            } else {
                if (HRStringUtils.equals((String)carrier, (String)ChgCarrierEnum.CARRIER_BILL.getCode())) {
                    this.getModel().setValue("sourcecombo-" + name, (Object)"3");
                    this.getView().setEnable(Boolean.FALSE, new String[]{"sourcecombo-" + name});
                }
                this.setEnableBySourceType("3", (String)name);
            }
        });
    }

    private void initValueByLimitType(Map<String, Object> field, String name) {
        String limitType;
        switch (limitType = (String)field.get("limittype")) {
            case "": {
                this.getModel().setValue("sourcecombo-" + name, (Object)"3");
                this.getView().setEnable(Boolean.FALSE, new String[]{"sourcecombo-" + name});
                this.setEnableBySourceType("3", name);
                break;
            }
            case "0": {
                this.setValueByStrategy(field, name);
                break;
            }
            case "1": {
                this.setEnableByEqualsType("3", name);
                this.getModel().setValue("chgcombo" + name, field.get("chgtype"));
                break;
            }
        }
    }

    private void setValueByStrategy(Map<String, Object> field, String name) {
        String val = (String)field.get("val");
        String comboName = "sourcecombo-" + name;
        String valFixedField = "fixedval-" + name;
        if (HRStringUtils.isNotEmpty((String)val)) {
            String[] valArr = val.replace(",", " ").trim().split(" ");
            String valField = "val-" + name;
            this.getModel().setValue(valField, (Object)val);
            String sourceCombo = valArr.length == 1 ? "4" : "3";
            this.getModel().setValue(valFixedField, (Object)valArr[0]);
            this.getModel().setValue(comboName, (Object)sourceCombo);
            this.setEnableBySourceType(sourceCombo, name);
            return;
        }
        if (field.get("valuefixed") != null) {
            Long valueFixed = Long.parseLong(field.get("valuefixed") + "");
            this.setEnableBySourceType("4", name);
            this.getModel().setValue(comboName, (Object)"4");
            this.getModel().setValue(valFixedField, (Object)valueFixed);
            return;
        }
        String valRange = (String)field.get("valrange_tag");
        if (HRStringUtils.isNotEmpty((String)valRange)) {
            String sourceCombo;
            List value;
            QFilter qFilter = QFilter.fromSerializedString((String)valRange);
            DynamicObject[] dyns = this.getDataByQFilter(qFilter, field);
            List list = value = dyns == null ? Collections.emptyList() : Arrays.stream(dyns).map(row -> row.get("ID")).collect(Collectors.toList());
            if (value.size() == 1) {
                sourceCombo = "4";
                this.getModel().setValue(comboName, (Object)sourceCombo);
                this.getModel().setValue(valFixedField, value.get(0));
            } else {
                sourceCombo = "3";
                this.getModel().setValue(comboName, (Object)sourceCombo);
            }
            this.setEnableBySourceType(sourceCombo, name);
        }
    }

    private DynamicObject[] getDataByQFilter(QFilter qFilter, Map<String, Object> field) {
        String fieldNumber = (String)field.get("chgfile");
        String chgObject = (String)((Map)((Map)field.get("chgtactic")).get("chgobject")).get("id");
        String baseEntityId = ChgGuideBaseDrawControlService.getInstance().getChgObjectBaseEntityId(fieldNumber, chgObject);
        return new HRBaseServiceHelper(baseEntityId).query("id", new QFilter[]{qFilter});
    }

    private void afterLoadData() {
        Map params = (Map)this.getView().getFormShowParameter().getCustomParam("params");
        Map tacticMap = (Map)params.get("tacticMap");
        Map changeObject = (Map)tacticMap.get("chgobject");
        if (changeObject == null) {
            return;
        }
        String chgObject = (String)changeObject.get("id");
        List tacticConfigValueList = (List)params.get("tacticConfigValue");
        Map fileTacticValueMap = (Map)params.get("fileTacticValue");
        HashMap tacticConfigValueMap = tacticConfigValueList == null ? new HashMap(16) : tacticConfigValueList.stream().collect(Collectors.toMap(row -> ((String)row.get("chgfile")).toLowerCase(Locale.ROOT), row -> row));
        fileTacticValueMap.forEach(tacticConfigValueMap::putIfAbsent);
        DataEntityPropertyCollection dataEntityPropertyCollection = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)chgObject)).getDataEntityType().getProperties();
        HashSet<String> sysFields = new HashSet<String>(Arrays.asList(FIELDS_PROCESSED_BY_SYSTEM));
        HashSet chgSysFields = new HashSet();
        Map<String, DrawFormFieldDto> allFields = this.getAllFields();
        Map fieldsMap = (Map)params.get("fieldsValueCache");
        dataEntityPropertyCollection.stream().filter(property -> !sysFields.contains(property.getName()) && !chgSysFields.contains(property.getName()) && !property.getName().endsWith("_id")).forEach(property -> {
            String field = property.getName();
            DrawFormFieldDto drawFormFieldText = (DrawFormFieldDto)allFields.get("text_" + field);
            if (drawFormFieldText == null) {
                return;
            }
            this.getModel().setValue(drawFormFieldText.getField(), (Object)drawFormFieldText.getName());
            Map fieldValueMap = fieldsMap == null ? null : (Map)fieldsMap.get(field);
            Map tacticConfigValue = (Map)tacticConfigValueMap.get(field);
            if (fieldValueMap != null) {
                this.initValueByCache(fieldValueMap, field);
            } else if (tacticConfigValue != null) {
                this.initValueByCache(tacticConfigValue, field);
            } else {
                this.setEnableBySourceType("3", field);
            }
        });
    }

    private void initValueByCache(Map<String, Object> tacticConfigValue, String field) {
        String limitType = (String)tacticConfigValue.get("limittype");
        String valueFixed = (String)tacticConfigValue.get("valuefixed");
        String carrier = this.getView().getParentView().getPageCache().get("carrier");
        switch (limitType) {
            case "": {
                if (HRStringUtils.isNotEmpty((String)valueFixed)) {
                    this.setEnableBySourceType("4", field);
                    this.getModel().setValue("sourcecombo-" + field, (Object)"4");
                    this.getModel().setValue("fixedval-" + field, tacticConfigValue.get("valuefixed"));
                    break;
                }
                if (HRStringUtils.equals((String)carrier, (String)ChgCarrierEnum.CARRIER_ACTION.getCode()) && HRStringUtils.isNotEmpty((String)((String)tacticConfigValue.get("fieldsource")))) {
                    this.setEnableBySourceType("5", field);
                    this.getModel().setValue("sourcecombo-" + field, (Object)"5");
                    Object object = tacticConfigValue.get("entitysource");
                    if (Objects.isNull(object)) {
                        return;
                    }
                    String entitySource = object instanceof String ? (String)object : (String)((Map)object).get("number");
                    String entityField = (String)tacticConfigValue.get("fieldsource");
                    this.getModel().setValue("baseentityap-" + field, (Object)entitySource);
                    this.getModel().setValue("combo-" + field, (Object)entityField);
                    if (!HRStringUtils.isNotEmpty((String)entitySource)) break;
                    this.setFieldListByEntity(entitySource, "combo-" + field);
                    break;
                }
                this.setEnableBySourceType("3", field);
                this.getModel().setValue("sourcecombo-" + field, (Object)"3");
                this.setAppointedSource(field, tacticConfigValue, Boolean.FALSE);
                break;
            }
            case "0": {
                this.setValueRangeOrVal(field, tacticConfigValue);
                break;
            }
            case "1": {
                if (HRStringUtils.isNotEmpty((String)valueFixed)) {
                    this.setEnableByEqualsType("4", field);
                    this.getModel().setValue("chgcombo" + field, (Object)"4");
                    this.getModel().setValue("fixedval-" + field, (Object)valueFixed);
                    break;
                }
                this.setEnableByEqualsType("3", field);
                this.getModel().setValue("chgcombo" + field, tacticConfigValue.get("chgtype"));
                break;
            }
        }
    }

    private void setAppointedSource(String name, Map<String, Object> field, boolean invisible) {
        this.getModel().setValue("sourcecombo-" + name, (Object)"3");
        this.setEnableBySourceType("3", name);
        Object object = field.get("entitysource");
        if (Objects.isNull(object)) {
            return;
        }
        String carrier = this.getView().getParentView().getPageCache().get("carrier");
        if (HRStringUtils.equals((String)carrier, (String)ChgCarrierEnum.CARRIER_ACTION.getCode())) {
            this.getModel().setValue("sourcecombo-" + name, (Object)"5");
            this.setEnableBySourceType("5", name);
        }
        String entitySource = object instanceof String ? (String)object : (String)((Map)object).get("number");
        String entityField = (String)field.get("fieldsource");
        this.getModel().setValue("baseentityap-" + name, (Object)entitySource);
        this.getModel().setValue("combo-" + name, (Object)entityField);
        if (HRStringUtils.isNotEmpty((String)entitySource)) {
            this.setFieldListByEntity(entitySource, "combo-" + name);
        }
    }

    private void setFieldListByEntity(String entitySource, String comboNumber) {
        List list = MetadataServiceHelper.getDataEntityType((String)entitySource).getAllFields().entrySet().stream().filter(Objects::nonNull).map(arg -> new ComboItem(new LocaleString(((IDataEntityProperty)arg.getValue()).getDisplayName().getLocaleValue() + "(" + (String)arg.getKey() + ")"), (String)arg.getKey())).distinct().collect(Collectors.toList());
        ComboEdit comboEdit = (ComboEdit)this.getControl(comboNumber);
        comboEdit.setComboItems(list);
    }

    private void setValueRangeOrVal(String name, Map<String, Object> field) {
        String number = "val-" + name;
        String valueFixed = (String)field.get("valuefixed");
        if (HRStringUtils.isNotEmpty((String)valueFixed)) {
            this.getModel().setValue("sourcecombo-" + name, (Object)"4");
            this.setEnableBySourceType("4", name);
            this.getModel().setValue("fixedval-" + name, (Object)valueFixed);
        } else {
            this.setAppointedSource(name, field, Boolean.TRUE);
        }
        if (HRStringUtils.isNotEmpty((String)((String)field.get("valrange_tag")))) {
            DynamicObject[] dynamicObjects;
            DynamicObjectCollection collection = this.getModel().getEntryEntity(number);
            QFilter qFilter = QFilter.fromSerializedString((String)((String)field.get("valrange_tag")));
            String entityName = ((MulBasedataProp)this.getModel().getDataEntityType().getProperties().get((Object)number)).getBaseEntityId();
            for (DynamicObject row : dynamicObjects = new HRBaseServiceHelper(entityName).loadDynamicObjectArray(new QFilter[]{qFilter})) {
                DynamicObject dyNew = collection.addNew();
                dyNew.set("fbasedataid", (Object)row);
                dyNew.set("fbasedataid_id", (Object)row.getLong("id"));
            }
            this.getModel().setValue(number, (Object)collection);
        }
        if (HRStringUtils.isNotEmpty((String)((String)field.get("val")))) {
            this.getModel().setValue(number, field.get("val"));
        }
    }

    private void setEnableBySourceType(String res, String name) {
        String entitySource = "baseentityap-" + name;
        String label = "label-" + name;
        String label1 = "labelrange-" + name;
        String fieldSource = "combo-" + name;
        String val = "val-" + name;
        String fixedVal = "fixedval-" + name;
        String carrier = this.getView().getParentView().getPageCache().get("carrier");
        boolean isAction = HRStringUtils.equals((String)carrier, (String)ChgCarrierEnum.CARRIER_ACTION.getCode());
        if (HRStringUtils.equals((String)res, (String)"3")) {
            if (isAction) {
                this.getView().setVisible(Boolean.TRUE, new String[]{val, label1});
                this.setFieldHidden(Boolean.FALSE, Arrays.asList(val, label1));
                this.getView().setVisible(Boolean.FALSE, new String[]{fixedVal});
                this.setFieldHidden(Boolean.TRUE, Collections.singletonList(fixedVal));
                this.getView().setVisible(Boolean.FALSE, new String[]{entitySource, label, label1, fieldSource, val});
                this.setFieldHidden(Boolean.TRUE, Arrays.asList(entitySource, label, label1, fieldSource, val));
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{entitySource, fieldSource, label, val, label1});
                this.setFieldHidden(Boolean.FALSE, Arrays.asList(entitySource, fieldSource, label, val, label1));
                this.getView().setVisible(Boolean.FALSE, new String[]{fixedVal});
                this.setFieldHidden(Boolean.TRUE, Collections.singletonList(fixedVal));
            }
        } else if (isAction) {
            this.getView().setVisible(Boolean.FALSE, new String[]{label1, val});
            this.setFieldHidden(Boolean.TRUE, Arrays.asList(label1, val));
            if (HRStringUtils.equals((String)res, (String)"5")) {
                this.getView().setVisible(Boolean.TRUE, new String[]{entitySource, fieldSource, label, val, label1});
                this.setFieldHidden(Boolean.FALSE, Arrays.asList(entitySource, fieldSource, label, val, label1));
                this.getView().setVisible(Boolean.FALSE, new String[]{fixedVal});
                this.setFieldHidden(Boolean.TRUE, Collections.singletonList(fixedVal));
            } else if (HRStringUtils.equals((String)res, (String)"4")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{entitySource, label, label1, fieldSource, val});
                this.setFieldHidden(Boolean.TRUE, Arrays.asList(entitySource, label, label1, fieldSource, val));
                this.getView().setVisible(Boolean.TRUE, new String[]{fixedVal});
                this.setFieldHidden(Boolean.FALSE, Collections.singletonList(fixedVal));
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{entitySource, label, label1, fieldSource, val});
                this.setFieldHidden(Boolean.TRUE, Arrays.asList(entitySource, label, label1, fieldSource, val));
                this.getView().setVisible(Boolean.FALSE, new String[]{fixedVal});
                this.setFieldHidden(Boolean.TRUE, Collections.singletonList(fixedVal));
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{entitySource, label, label1, fieldSource, val});
            this.setFieldHidden(Boolean.TRUE, Arrays.asList(entitySource, label, label1, fieldSource, val));
            this.getView().setVisible(Boolean.TRUE, new String[]{fixedVal});
            this.setFieldHidden(Boolean.FALSE, Collections.singletonList(fixedVal));
        }
    }

    private void setEnableByEqualsType(String res, String name) {
        String fixedVal = "fixedval-" + name;
        if (HRStringUtils.equals((String)res, (String)"4")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{fixedVal});
            this.setFieldHidden(Boolean.FALSE, Collections.singletonList(fixedVal));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{fixedVal});
            this.setFieldHidden(Boolean.TRUE, Collections.singletonList(fixedVal));
        }
    }

    private void setFieldHidden(boolean hidden, List<String> fields) {
        ArrayList<DrawFormFieldDto> drawFormFieldDtoList = new ArrayList<DrawFormFieldDto>(this.getAllFields().values());
        drawFormFieldDtoList.stream().filter(row -> fields.contains(row.getField())).forEach(row -> row.setHidden(hidden));
        this.getPageCache().put("allFields", SerializationUtils.toJsonString(drawFormFieldDtoList));
    }

    private Map<String, DrawFormFieldDto> getAllFields() {
        String fieldList;
        if (this.getPageCache().get("allFields") == null) {
            fieldList = (String)this.getView().getFormShowParameter().getCustomParam("allFields");
            this.getPageCache().put("allFields", fieldList);
        } else {
            fieldList = this.getPageCache().get("allFields");
        }
        return ChgCommonUtils.formatAllFields(fieldList).stream().collect(Collectors.toMap(DrawFormFieldDto::getField, row -> row, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
    }

    private Map<String, String> getOriginFields() {
        String fieldList;
        if (this.getPageCache().get("originFields") == null) {
            fieldList = (String)this.getView().getFormShowParameter().getCustomParam("originFields");
            this.getPageCache().put("originFields", fieldList);
        } else {
            fieldList = this.getPageCache().get("originFields");
        }
        return (Map)SerializationUtils.fromJsonString((String)fieldList, Map.class);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        super.getEntityType(e);
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode(((Object)((Object)this)).getClass().getSimpleName(), exp.getMessage()), new Object[0]);
        }
        ArrayList<DrawFormFieldDto> drawFormFields = new ArrayList<DrawFormFieldDto>(this.getAllFields().values());
        DynamicPanelUtils.registDynamicProps(newMainType, drawFormFields);
        e.setNewEntityType(newMainType);
    }

    public void onGetControl(OnGetControlArgs onGetControlArgs) {
        super.onGetControl(onGetControlArgs);
        String key = onGetControlArgs.getKey();
        if (this.getAllFields().get(key) != null) {
            MulBasedataEdit basedataEdit;
            DrawFormFieldDto drawFormField = this.getAllFields().get(key);
            TemplateEditUtils.addGetControl(drawFormField, onGetControlArgs, this);
            if (HRStringUtils.equals((String)drawFormField.getClassSimpleName(), (String)MulBasedataProp.class.getSimpleName())) {
                basedataEdit = (MulBasedataEdit)onGetControlArgs.getControl();
                basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
            if (HRStringUtils.equals((String)drawFormField.getClassSimpleName(), (String)BasedataProp.class.getSimpleName())) {
                basedataEdit = (BasedataEdit)onGetControlArgs.getControl();
                basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (key = afterDoOperationEventArgs.getOperateKey()) {
            case "cacherecall": {
                this.cacheRecall(afterDoOperationEventArgs);
                break;
            }
            case "save": {
                this.save(afterDoOperationEventArgs);
                break;
            }
            case "match": {
                this.autoMatch();
                break;
            }
            case "batchprocess": {
                this.batchProcess();
                break;
            }
        }
    }

    private void autoMatch() {
        String chgObject = (String)this.getView().getFormShowParameter().getCustomParam("chgObject");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hpfs_chgguidematch");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "autoMatch"));
        formShowParameter.setSendToClient(true);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("targetEntity", (Object)chgObject);
        formShowParameter.setStatus(this.getView().getFormShowParameter().getStatus());
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        Object dataReturned = closedCallBackEvent.getReturnData();
        switch (key) {
            case "autoMatch": {
                this.autoMatchCallBack(dataReturned);
                break;
            }
            case "batchProcess": {
                this.batchProcessCallBack(dataReturned);
                break;
            }
        }
    }

    private void autoMatchCallBack(Object dataReturned) {
        String sourceEntity = (String)dataReturned;
        if (HRStringUtils.isEmpty((String)sourceEntity)) {
            return;
        }
        DataEntityPropertyCollection dataEntityPropertyCollection = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)sourceEntity)).getDataEntityType().getProperties();
        Map<String, String> originFields = this.getOriginFields();
        Map<String, DrawFormFieldDto> allFields = this.getAllFields();
        HashMap sourceNameValue = new HashMap();
        dataEntityPropertyCollection.forEach(row -> {
            if (row.getDisplayName() == null) {
                return;
            }
            String displayName = row.getDisplayName().getLocaleValue();
            sourceNameValue.computeIfAbsent(displayName, list -> new ArrayList()).add(row.getName());
        });
        ArrayList<String> passedList = new ArrayList<String>();
        ArrayList<String> failList = new ArrayList<String>();
        ArrayList<String> cautionList = new ArrayList<String>();
        originFields.forEach((field, name) -> {
            String baseEntityAp = "baseentityap-" + field;
            if (allFields.get(baseEntityAp) == null || ((DrawFormFieldDto)allFields.get(baseEntityAp)).isHidden()) {
                return;
            }
            List sourceFieldList = (List)sourceNameValue.get(name);
            if (CollectionUtils.isEmpty((Collection)sourceFieldList)) {
                failList.add((String)field);
            } else if (sourceFieldList.size() != 1) {
                cautionList.add((String)field);
                this.autoMatchSetValue((String)field, sourceEntity, (String)sourceFieldList.get(0));
            } else {
                passedList.add((String)field);
                this.autoMatchSetValue((String)field, sourceEntity, (String)sourceFieldList.get(0));
            }
        });
        this.reload(passedList, "kdfont kdfont-gouxuan", "");
        this.reload(failList, "kdfont kdfont-jianchabutongguo", ResManager.loadKDString((String)"\u5339\u914d\u5931\u8d25\uff0c\u672a\u627e\u5230\u76ee\u6807\u5b57\u6bb5\u3002", (String)"ChgGuideFieldEditPlugin_0", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
        this.reload(cautionList, "kdfont kdfont-zhuangtai_jingshi", ResManager.loadKDString((String)"\u5339\u914d\u5230\u591a\u4e2a\u5b57\u6bb5\u3002", (String)"ChgGuideFieldEditPlugin_1", (String)"hr-hpfs-formplugin", (Object[])new Object[0]));
    }

    private void reload(List<String> list, String fontClass, String tipText) {
        list.forEach(row -> {
            VectorAp vectorAp = this.getVectorAp((String)row, fontClass);
            Tips tips = new Tips();
            tips.setContent(new LocaleString(tipText));
            tips.setType("text");
            tips.setShowIcon(false);
            if (HRStringUtils.isNotEmpty((String)tipText)) {
                vectorAp.setCtlTips(tips);
            }
            this.getView().updateControlMetadata("matchicon-" + row, vectorAp.createControl());
            this.getView().setVisible(Boolean.TRUE, new String[]{"matchicon-" + row});
        });
    }

    private void autoMatchSetValue(String field, String entitySource, String fieldSource) {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        fieldMap.put("entitysource", entitySource);
        fieldMap.put("fieldsource", fieldSource);
        this.setAppointedSource(field, fieldMap, true);
    }

    private void batchProcess() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hpfs_chgguidebatchprocess");
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "batchProcess"));
        formShowParameter.setSendToClient(true);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("targetFields", this.getOriginFields());
        formShowParameter.setStatus(this.getView().getFormShowParameter().getStatus());
        this.getView().showForm(formShowParameter);
    }

    private void batchProcessCallBack(Object dataReturned) {
        if (dataReturned == null) {
            return;
        }
        String[] arr = ((String)dataReturned).split(",");
        Map<String, DrawFormFieldDto> allFields = this.getAllFields();
        for (String field : arr) {
            String sourceCombo = "sourcecombo-" + field;
            if (allFields.get(sourceCombo) == null) continue;
            this.getModel().setValue(sourceCombo, (Object)"3");
            this.setEnableBySourceType("3", field);
        }
    }

    private void save(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        LOGGER.info("ChgGuideFieldEditPlugin#save begin");
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (!result.isSuccess()) {
            LOGGER.info("ChgGuideFieldEditPlugin#save fail");
            this.getView().getParentView().sendFormAction(this.getView());
        }
        LOGGER.info("ChgGuideFieldEditPlugin#save end");
    }

    private void cacheRecall(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        LOGGER.info("ChgGuideFieldEditPlugin#cacheRecall begin");
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (!result.isSuccess()) {
            LOGGER.info("ChgGuideFieldEditPlugin#cacheRecall getOperatrionResult fail");
            this.getView().getParentView().sendFormAction(this.getView());
            this.getView().getParentView().showOperationResult(result);
            return;
        }
        LOGGER.info("ChgGuideFieldEditPlugin#cacheRecall getOperatrionResult success");
        if (this.getView().getParentView().getPageCache().get("save") != null) {
            LOGGER.info("ChgGuideFieldEditPlugin#cacheRecall get save cache is not null");
            Map customParam = (Map)this.getView().getFormShowParameter().getCustomParam("params");
            if (customParam.get("mustInputError") != null && HRStringUtils.isNotEmpty((String)((String)customParam.get("mustInputError")))) {
                LOGGER.info("ChgGuideFieldEditPlugin#cacheRecall mustInputError");
                result.setSuccess(false);
                this.getView().getParentView().showErrorNotification((String)customParam.get("mustInputError"));
                this.getView().getParentView().sendFormAction(this.getView());
                return;
            }
        }
        LOGGER.info("ChgGuideFieldEditPlugin#cacheRecall deal cacheRecall");
        Map<String, String> originFields = this.getOriginFields();
        HashMap fieldsMap = new HashMap(16);
        Map map = (Map)this.getView().getFormShowParameter().getCustomParam("params");
        List tacticConfig = (List)map.get("tacticConfig");
        Map<String, Map> tacticFieldMap = tacticConfig.stream().collect(Collectors.toMap(row -> (String)row.get("chgfile"), row -> row));
        originFields.keySet().forEach(field -> {
            String limitType;
            Map fieldMap = (Map)tacticFieldMap.get(field);
            if (fieldMap == null) {
                this.formatAppointedFieldMap(fieldsMap, (String)field);
                return;
            }
            switch (limitType = (String)fieldMap.get("limittype")) {
                case "": {
                    this.formatAppointedFieldMap(fieldsMap, (String)field);
                    break;
                }
                case "0": {
                    this.formatFixedValFieldMap(fieldsMap, (String)field, fieldMap);
                    break;
                }
                case "1": {
                    this.formatChgTypeFieldMap(fieldsMap, (String)field);
                    break;
                }
            }
        });
        this.getPageCache().put("fieldCache", SerializationUtils.toJsonString(fieldsMap));
        LOGGER.info("ChgGuideFieldEditPlugin#cacheRecall will close");
        this.getView().close();
    }

    private Map<String, Object> formatAppointedFieldMap(Map<String, Map<String, Object>> fieldsMap, String name) {
        String carrier = this.getView().getParentView().getPageCache().get("carrier");
        Map tacticMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("tacticMap"), Map.class);
        String sourceValue = (String)this.getModel().getValue("sourcecombo-" + name);
        if (HRStringUtils.isEmpty((String)sourceValue)) {
            return Collections.emptyMap();
        }
        String entitySource = "baseentityap-" + name;
        String fieldSource = "combo-" + name;
        DynamicObject entitySourceDyn = (DynamicObject)this.getModel().getValue(entitySource);
        String fieldSourceValue = (String)this.getModel().getValue(fieldSource);
        if (!(entitySourceDyn == null || !HRStringUtils.isNotEmpty((String)fieldSourceValue) || "4".equals(sourceValue) || HRStringUtils.equals((String)carrier, (String)ChgCarrierEnum.CARRIER_ACTION.getCode()) && "3".equals(sourceValue))) {
            Map<String, Object> map = this.formatFieldMap(name, "", "", "", entitySourceDyn.getString("number"), fieldSourceValue);
            map.put("chgtactic", tacticMap);
            fieldsMap.put(name, map);
            return map;
        }
        if ("4".equals(sourceValue)) {
            Map<String, Object> map = this.formatFieldMap(name, "", "", "", "", "");
            String valFixedName = "fixedval-" + name;
            Object fixedVal = this.getModel().getValue(valFixedName);
            if (fixedVal instanceof DynamicObject) {
                map.put("valuefixed", ((DynamicObject)fixedVal).getLong("id") + "");
            } else {
                map.put("valuefixed", fixedVal);
            }
            map.put("chgtactic", tacticMap);
            fieldsMap.put(name, map);
            return map;
        }
        if (HRStringUtils.equals((String)carrier, (String)ChgCarrierEnum.CARRIER_ACTION.getCode()) && "3".equals(sourceValue)) {
            Map<String, Object> map = this.formatFieldMap(name, "");
            fieldsMap.put(name, map);
            return map;
        }
        return Collections.emptyMap();
    }

    private void formatChgTypeFieldMap(Map<String, Map<String, Object>> fieldsMap, String name) {
        String chgTypeName = "chgcombo" + name;
        Object chgType = this.getModel().getValue(chgTypeName);
        if ("4".equals(chgType)) {
            Map<String, Object> map = this.formatFieldMap(name, "1", chgType, "", "", "");
            String valFixedName = "fixedval-" + name;
            Object fixedVal = this.getModel().getValue(valFixedName);
            if (fixedVal instanceof DynamicObject) {
                map.put("valuefixed", ((DynamicObject)fixedVal).getLong("id") + "");
            } else {
                map.put("valuefixed", fixedVal);
            }
            fieldsMap.put(name, map);
        } else {
            Map<String, Object> map = this.formatFieldMap(name, "1", chgType, "", "", "");
            fieldsMap.put(name, map);
        }
    }

    private void formatFixedValFieldMap(Map<String, Map<String, Object>> fieldsMap, String name, Map<String, Object> field) {
        String sourceTypeName = "sourcecombo-" + name;
        String sourceType = (String)this.getModel().getValue(sourceTypeName);
        String val = (String)field.get("val");
        String valRange = (String)field.get("valrange_tag");
        String carrier = this.getView().getParentView().getPageCache().get("carrier");
        if (HRStringUtils.equals((String)sourceType, (String)"3") || HRStringUtils.equals((String)sourceType, (String)"5") && HRStringUtils.equals((String)carrier, (String)ChgCarrierEnum.CARRIER_ACTION.getCode())) {
            Map<String, Object> map = this.formatAppointedFieldMap(fieldsMap, name);
            if (CollectionUtils.isEmpty(map)) {
                return;
            }
            map.put("limittype", "0");
            String valName = "val-" + name;
            if (HRStringUtils.isNotEmpty((String)val)) {
                map.put("val", this.getModel().getValue(valName));
            }
            if (HRStringUtils.isNotEmpty((String)valRange)) {
                MulBasedataDynamicObjectCollection collection = (MulBasedataDynamicObjectCollection)this.getModel().getValue(valName);
                List ids = collection.stream().map(row -> row.getLong("fbasedataid_id")).collect(Collectors.toList());
                QFilter qFilter = new QFilter("id", "in", ids);
                map.put("valrange_tag", qFilter.toSerializedString());
            }
            map.put("chgtactic", field.get("chgtactic"));
        } else if (HRStringUtils.equals((String)sourceType, (String)"4")) {
            Map<String, Object> map = this.formatFieldMap(name, "0", "", "", "", "");
            map.put("val", field.get("val"));
            String valFixedName = "fixedval-" + name;
            Object fixedVal = this.getModel().getValue(valFixedName);
            if (fixedVal instanceof DynamicObject) {
                map.put("valuefixed", ((DynamicObject)fixedVal).getLong("id") + "");
            } else {
                map.put("valuefixed", fixedVal);
            }
            map.put("chgtactic", field.get("chgtactic"));
            fieldsMap.put(name, map);
        } else if (HRStringUtils.equals((String)carrier, (String)ChgCarrierEnum.CARRIER_ACTION.getCode())) {
            Map<String, Object> map = this.formatFieldMap(name, "");
            fieldsMap.put(name, map);
        }
    }

    private Map<String, Object> formatFieldMap(String field, String limitType) {
        return this.formatFieldMap(field, limitType, "", "", "", "");
    }

    private Map<String, Object> formatFieldMap(String field, String limitType, Object chgType, Object val, String entityAppointed, String fieldAppointed) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("chgfile", field);
        map.put("limittype", limitType);
        map.put("chgtype", chgType);
        map.put("val", val);
        map.put("entitysource", entityAppointed);
        map.put("fieldsource", fieldAppointed);
        return map;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String newValue;
        super.propertyChanged(e);
        String field = e.getProperty().getName();
        if (field.replace("baseentityap", "").length() != field.length()) {
            DynamicObject dataNew = (DynamicObject)e.getChangeSet()[0].getNewValue();
            this.getModel().setValue(field, (Object)dataNew);
            if (dataNew != null) {
                this.setFieldListByEntity(dataNew.getString("id"), field.replace("baseentityap", "combo"));
            }
        }
        if (field.replace("sourcecombo-", "").length() != field.length()) {
            newValue = (String)e.getChangeSet()[0].getNewValue();
            this.setEnableBySourceType(newValue, field.replace("sourcecombo-", ""));
        }
        if (field.replace("chgcombo", "").length() != field.length()) {
            newValue = (String)e.getChangeSet()[0].getNewValue();
            this.setEnableByEqualsType(newValue, field.replace("chgcombo", ""));
        }
        this.getModel().updateCache();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getView().returnDataToParent((Object)this.getPageCache().get("fieldCache"));
    }
}

