/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.formplugin.privacy;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hpfs.business.service.config.IDevParamConfigService;
import kd.hr.hpfs.common.model.privacy.DesensitizeInfoGroup;
import kd.hr.hpfs.formplugin.privacy.AbstractDesensitizeFieldCommonPlugin;

public class AbstractDesensitizeFieldPlugin
extends AbstractDesensitizeFieldCommonPlugin {
    private static final Log LOGGER = LogFactory.getLog(AbstractDesensitizeFieldPlugin.class);
    private static final String EYE = "_eye";

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        Object[] entityIds = this.getView().getEntityId().split("_");
        Object appId = ArrayUtils.isEmpty((Object[])entityIds) ? this.getView().getFormShowParameter().getAppId() : entityIds[0];
        LOGGER.info("AbstractDesensitizeFieldPlugin appId== [{}]", appId);
        if (StringUtils.isBlank((CharSequence)appId)) {
            return;
        }
        String enable = IDevParamConfigService.getInstance().queryBusinessValueByBusinessKey("desensitize_enable");
        LOGGER.info("AbstractDesensitizeFieldPlugin desensitize_enable== [{}]", (Object)enable);
        if (!Boolean.parseBoolean(enable)) {
            return;
        }
        if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            LOGGER.info("AbstractDesensitizeFieldPlugin OperationStatus.ADDNEW ,showPageKey==[{}]", (Object)this.getModel().getDataEntityType().getName());
            return;
        }
        String configs = IDevParamConfigService.getInstance().queryLargeBusinessValueByBusinessKey((String)appId + "_desensitize_field");
        LOGGER.info("AbstractDesensitizeFieldPlugin configs== [{}]", (Object)configs);
        if (StringUtils.isBlank((CharSequence)configs)) {
            return;
        }
        List desensitizeInfoGroups = JSON.parseArray((String)configs, DesensitizeInfoGroup.class);
        String showPageKey = this.getModel().getDataEntityType().getName();
        Optional<DesensitizeInfoGroup> desensitizeInfoGroupOptional = desensitizeInfoGroups.stream().filter(desensitizeInfoGroup -> showPageKey.equals(desensitizeInfoGroup.getShowPageKey())).findFirst();
        if (!desensitizeInfoGroupOptional.isPresent()) {
            return;
        }
        DesensitizeInfoGroup desensitizeInfoGroup2 = desensitizeInfoGroupOptional.get();
        List desensitizeInfoGroupFields = desensitizeInfoGroup2.getDesensitizeInfoGroupFields();
        DataEntityPropertyCollection showProperties = this.getModel().getDataEntityType().getProperties();
        for (DesensitizeInfoGroup.DesensitizeInfoGroupField pageKeyDesensitizeInfoGroupField : desensitizeInfoGroupFields) {
            String showFieldKey = pageKeyDesensitizeInfoGroupField.getShowFieldKey();
            if (!showProperties.containsKey((Object)showFieldKey)) continue;
            this.dealDesensitizeField(pageKeyDesensitizeInfoGroupField, showFieldKey);
        }
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        String key = args.getKey();
        if (key.endsWith(EYE)) {
            Vector control = new Vector();
            control.setKey(key);
            control.setView(this.getView());
            control.addClickListener((ClickListener)this);
            args.setControl((Control)control);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (key.endsWith(EYE)) {
            String[] split = key.split("_");
            if (split.length != 2) {
                return;
            }
            this.setFieldProperty(split[0], this.getModel().getValue(split[0]));
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{key});
    }
}

