/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.formplugin.service;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class ChgNameValidateService {
    public static final ChgNameValidateService CHG_NAME_VALIDATE_SERVICE = new ChgNameValidateService();
    private static final Log LOGGER = LogFactory.getLog(ChgNameValidateService.class);
    private static final HRBaseServiceHelper CHG_ACTION_HELPER = new HRBaseServiceHelper("hpfs_chgaction");
    private static final HRBaseServiceHelper HBSS_ACTION_HELPER = new HRBaseServiceHelper("hbss_action");
    private static final HRBaseServiceHelper CHG_RULE_HELPER = new HRBaseServiceHelper("hpfs_chgrule");
    private static final HRBaseServiceHelper CHG_GUIDE_BASE_HELPER = new HRBaseServiceHelper("hpfs_chgguidebase");

    public static ChgNameValidateService getInstance() {
        return CHG_NAME_VALIDATE_SERVICE;
    }

    public String validateName(String name, Long chgActionId, Long hbssActionTypeId, Long ruleId, Long guideBaseId, String number) {
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append(this.validateNameWithChgAction(name, chgActionId));
        errorMsg.append(this.validateNameWithHBSSAction(name, hbssActionTypeId, number));
        errorMsg.append(this.validateNameWithChgRule(name, ruleId));
        errorMsg.append(this.validateNameWithChgGuideBase(name, guideBaseId));
        return errorMsg.toString();
    }

    public String validateNameWithChgAction(String name, Long chgActionId) {
        DynamicObject dyn = CHG_ACTION_HELPER.loadDynamicObject(new QFilter("name", "=", (Object)name));
        return dyn == null || chgActionId != null && chgActionId != 0L && dyn.getLong("id") == chgActionId.longValue() ? "" : ResManager.loadKDString((String)"\u540d\u79f0\u4e0e\u53d8\u52a8\u64cd\u4f5c\u540d\u79f0\u91cd\u590d\u3002", (String)"ChgNameValidateService_0", (String)"hr-hpfs-formplugin", (Object[])new Object[0]);
    }

    public String validateNameWithHBSSAction(String name, Long hbssActionTypeId, String number) {
        Long actionId = this.getHBSSActionId(name, hbssActionTypeId, number);
        return actionId == -1L ? ResManager.loadKDString((String)"\u540d\u79f0\u4e0e\u6d88\u606f\u534f\u540c\u6d3b\u52a8\u540d\u79f0\u91cd\u590d\u3002", (String)"ChgNameValidateService_1", (String)"hr-hpfs-formplugin", (Object[])new Object[0]) : "";
    }

    public Long getHBSSActionId(String name, Long hbssActionTypeId, String number) {
        DynamicObject actionByName = HBSS_ACTION_HELPER.loadDynamicObject(new QFilter("name", "=", (Object)name));
        DynamicObject actionByNumber = HBSS_ACTION_HELPER.loadDynamicObject(new QFilter("number", "=", (Object)number));
        if (actionByName == null && actionByNumber == null) {
            return 0L;
        }
        if (actionByName != null && actionByNumber != null && actionByName.getLong("id") == actionByNumber.getLong("id") && actionByName.getLong("actiontype_id") == actionByNumber.getLong("actiontype_id") && actionByName.getLong("actiontype_id") == hbssActionTypeId.longValue()) {
            return actionByName.getLong("id");
        }
        if (actionByName == null && actionByNumber.getLong("actiontype_id") == hbssActionTypeId.longValue()) {
            return actionByNumber.getLong("id");
        }
        if (actionByNumber == null && actionByName.getLong("actiontype_id") == hbssActionTypeId.longValue()) {
            return actionByName.getLong("id");
        }
        return -1L;
    }

    public String validateNameWithChgRule(String name, Long ruleId) {
        DynamicObject dyn = CHG_RULE_HELPER.loadDynamicObject(new QFilter("name", "=", (Object)name));
        return dyn == null || ruleId != null && ruleId != 0L && dyn.getLong("id") == ruleId.longValue() ? "" : ResManager.loadKDString((String)"\u540d\u79f0\u4e0e\u53d8\u52a8\u89c4\u5219\u540d\u79f0\u91cd\u590d\u3002", (String)"ChgNameValidateService_2", (String)"hr-hpfs-formplugin", (Object[])new Object[0]);
    }

    public String validateNameWithChgGuideBase(String name, Long guideBaseId) {
        DynamicObject dyn = CHG_GUIDE_BASE_HELPER.loadDynamicObject(new QFilter("name", "=", (Object)name));
        return dyn == null || guideBaseId != null && guideBaseId != 0L && dyn.getLong("id") == guideBaseId.longValue() ? "" : ResManager.loadKDString((String)"\u540d\u79f0\u4e0e\u4e8b\u52a1\u53d8\u52a8\u57fa\u7840\u914d\u7f6e\u540d\u79f0\u91cd\u590d\u3002", (String)"ChgNameValidateService_3", (String)"hr-hpfs-formplugin", (Object[])new Object[0]);
    }
}

