/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hpfs.mservice;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.bussiness.cert.HRCertCommonHelper;
import kd.hr.hbp.bussiness.cert.HRCertPromptInfoTypeEnum;
import kd.hr.hpfs.business.domain.repository.license.LicenseRepository;
import kd.hr.hpfs.business.service.cert.HRCertServiceHelper;
import kd.hr.hpfs.mservice.api.IHPFSLicenseService;
import org.apache.commons.lang3.StringUtils;

public class HPFSLicenseService
implements IHPFSLicenseService {
    private static final Log LOG = LogFactory.getLog(HPFSLicenseService.class);
    private static final String EXE_FLAG = "exeFlag";
    private static final String MESSAGE = "msg";
    String HR_EMP_CERT_GROUP_ID = "517";
    private static ThreadPool threadPool;

    public Map<String, Object> updateLicenseSign(String groupId) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)2);
        if (!this.HR_EMP_CERT_GROUP_ID.equals(groupId)) {
            resultMap.put(EXE_FLAG, Boolean.FALSE);
            resultMap.put(MESSAGE, "groupId error");
            return resultMap;
        }
        Map map = HRCertCommonHelper.verifyCertCount((String)groupId);
        if (null == map || StringUtils.equals((CharSequence)((CharSequence)map.get("infoType")), (CharSequence)HRCertPromptInfoTypeEnum.FORBIDDEN.getName())) {
            resultMap.put(EXE_FLAG, Boolean.FALSE);
            resultMap.put(MESSAGE, "check infotype is FORBIDDEN");
        } else {
            resultMap.put(EXE_FLAG, Boolean.TRUE);
            resultMap.put(MESSAGE, "success");
            threadPool.execute(() -> {
                int TOP = 2000;
                Long minId = 0L;
                while (true) {
                    DynamicObject[] details;
                    if ((details = LicenseRepository.queryLicenseDetail((Long)minId, (int)2000)).length != 0) {
                        HRCertServiceHelper.updateLicenseDetailSign((DynamicObject[])details);
                    }
                    if (details.length < 2000) break;
                    minId = (Long)details[details.length - 1].get("id");
                }
            });
        }
        return resultMap;
    }

    public Map<String, Object> addOrDelCertService(Map<String, Object> params) {
        return HRCertServiceHelper.licenseExcuteNew(params);
    }

    static {
        try {
            threadPool = ThreadPools.newFixedThreadPool((String)"HR_LICENSE_SERVICE_POOL", (int)1);
        }
        catch (Exception e) {
            LOG.error("HR_LICENSE_SERVICE_POOL create error", (Throwable)e);
        }
    }
}

