/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.common;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.print.core.data.DataRowSet;
import kd.bos.print.core.data.field.DateTimeField;
import kd.bos.print.core.data.field.Field;
import kd.bos.print.core.data.field.NullField;
import kd.bos.print.core.data.field.TextField;
import kd.sdk.hr.hspm.common.utils.CommonUtil;

public class PrintUtils {
    private static final Log LOGGER = LogFactory.getLog(PrintUtils.class);
    private static final String TIME = " 00:00:00";

    public static List<DataRowSet> getSortList(List<DataRowSet> dataRowSets, String[] name, String dyName) {
        if (CollectionUtils.isEmpty(dataRowSets)) {
            return new ArrayList<DataRowSet>();
        }
        LOGGER.info("PrintUtils_getSortList_name:{0}", (Object)dyName);
        try {
            return PrintUtils.dateSort(dataRowSets, name[0], name[1]);
        }
        catch (Exception ext) {
            LOGGER.error("PrintUtils_getSortList_error", (Throwable)ext);
            return dataRowSets;
        }
    }

    public static List<DataRowSet> getSortList(List<DataRowSet> dataRowSets, String propName, String name) {
        if (CollectionUtils.isEmpty(dataRowSets)) {
            return new ArrayList<DataRowSet>();
        }
        LOGGER.info("PrintUtils_getSortList_name:{0}", (Object)name);
        DataRowSet row = dataRowSets.get(0);
        try {
            if (row.getField(propName) instanceof NullField) {
                LOGGER.info("PrintUtils_getSortList_null");
                return dataRowSets;
            }
            if (row.getField(propName) instanceof TextField) {
                return dataRowSets.stream().sorted(Comparator.comparing(rowSet -> (String)((TextField)rowSet.getField(propName)).getValue(), Comparator.reverseOrder())).collect(Collectors.toList());
            }
            if (row.getField(propName) instanceof DateTimeField) {
                return dataRowSets.stream().sorted(Comparator.comparing(rowSet -> (Timestamp)((DateTimeField)rowSet.getField(propName)).getValue(), Comparator.reverseOrder())).collect(Collectors.toList());
            }
            return dataRowSets;
        }
        catch (Exception ext) {
            LOGGER.error("PrintUtils_getSortList_error", (Throwable)ext);
            return dataRowSets;
        }
    }

    private static List<DataRowSet> dateSort(List<DataRowSet> dataRowSets, final String startProp, final String endProp) {
        return dataRowSets.stream().sorted(new Comparator<DataRowSet>(){

            @Override
            public int compare(DataRowSet o1, DataRowSet o2) {
                int compare = this.compareGradution(o1, o2, startProp);
                if (compare == 0) {
                    return this.compareGradution(o1, o2, endProp);
                }
                return compare;
            }

            private int compareGradution(DataRowSet o1, DataRowSet o2, String prop) {
                long t2;
                Field date1 = o1.getField(prop);
                Field date2 = o2.getField(prop);
                if (date1 instanceof NullField || date2 instanceof NullField) {
                    return 1;
                }
                date1 = this.getDateTimeField(date1);
                date2 = this.getDateTimeField(date2);
                long t1 = ((Timestamp)((DateTimeField)date1).getValue()).getTime();
                return t1 < (t2 = ((Timestamp)((DateTimeField)date2).getValue()).getTime()) ? 1 : (t1 == t2 ? 0 : -1);
            }

            private Field getDateTimeField(Field field) {
                if (field instanceof TextField) {
                    return new DateTimeField(Timestamp.valueOf((String)field.getValue() + PrintUtils.TIME));
                }
                return field;
            }
        }).collect(Collectors.toList());
    }

    private static Date getDate(Field field) {
        if (field instanceof TextField) {
            return Timestamp.valueOf((String)field.getValue() + TIME);
        }
        return (Timestamp)field.getValue();
    }

    public static void replaceDate(DataRowSet row, String propName, String reStr) {
        try {
            Field field = row.getField(propName);
            if (Objects.isNull(field) || field instanceof NullField) {
                return;
            }
            boolean isDate = CommonUtil.getMaxDate((Date)PrintUtils.getDate(field));
            if (isDate) {
                row.put(propName, (Field)new TextField(reStr));
            }
        }
        catch (Exception exception) {
            LOGGER.error("PrintUtils_replaceDate_error", (Throwable)exception);
        }
    }

    public static void replaceDate(List<DataRowSet> rows, String propName, String reStr) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        rows.stream().forEach(row -> PrintUtils.replaceDate(row, propName, reStr));
    }
}

