/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.multiviewconfig;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hspm.business.infogroup.InfoGroupFieldHelper;
import kd.hr.hspm.business.infogroup.InfoGroupFilterFieldsHelper;
import kd.hr.hspm.business.task.InfoGroupFieldAnalysisTask;

public class InfoGroupRegPlugin
extends HRDynamicFormBasePlugin {
    public void beforeBindData(EventObject event) {
        super.beforeBindData(event);
        DynamicObject pageInfo = (DynamicObject)this.getModel().getValue("pageinfo");
        if (pageInfo != null) {
            this.createMulCombo(pageInfo.getString("number"));
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String key = args.getProperty().getName();
        if ("pageinfo".equals(key)) {
            this.createMulCombo(((DynamicObject)args.getChangeSet()[0].getNewValue()).getString("number"));
        }
    }

    private void createMulCombo(String pageNumber) {
        MulComboEdit filterFieldsCombo;
        MulComboEdit notEditableMulCombo = (MulComboEdit)this.getControl("notEditableFields");
        if (notEditableMulCombo != null) {
            List<ComboItem> items = this.analysisFieldsToMulCombo(pageNumber);
            ComboItem allGroupItem = new ComboItem();
            allGroupItem.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5168\u7ec4\u5b57\u6bb5", (String)"InfoGroupRegPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0])));
            allGroupItem.setValue("totalGroup");
            items.add(0, allGroupItem);
            notEditableMulCombo.setComboItems(items);
        }
        if ((filterFieldsCombo = (MulComboEdit)this.getControl("filterfields")) != null) {
            List<ComboItem> items = this.analysisFieldsToMulCombo(pageNumber);
            filterFieldsCombo.setComboItems(items);
        }
    }

    private List<ComboItem> analysisFieldsToMulCombo(String pageNumber) {
        Map fields = MetadataServiceHelper.getDataEntityType((String)pageNumber).getAllFields();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(fields.size());
        for (Map.Entry entry : fields.entrySet()) {
            String name = ((IDataEntityProperty)entry.getValue()).getName();
            if (InfoGroupFilterFieldsHelper.isSysFilterField((String)name)) continue;
            LocaleString displayName = ((IDataEntityProperty)entry.getValue()).getDisplayName();
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(displayName);
            comboItem.setValue(name);
            items.add(comboItem);
        }
        return items;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        OperationResult opResult;
        super.afterDoOperation(afterDoOperationEventArgs);
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operate = (FormOperate)afterDoOperationEventArgs.getSource();
        if ((HRStringUtils.equals((String)operate.getOperateKey(), (String)"save") || HRStringUtils.equals((String)operate.getOperateKey(), (String)"edit")) && (opResult = afterDoOperationEventArgs.getOperationResult()) != null && opResult.isSuccess()) {
            InfoGroupFieldHelper.handlePageMeta((Long)((Long)this.getModel().getValue("id")), (boolean)true);
            InfoGroupFieldAnalysisTask.removeMultiViewConfigCache();
        }
    }
}

