/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.multiviewconfig;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.form.IPageCache;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class MultiViewConfigExtListPlugin
extends HRDataBaseList {
    private static final String OPEN_SOURCE = "openSource";
    private static final String APP_HRBM = "hrbm";
    private static final String MODEL_ENTITY_NUMBER = "modelEntityNumber";
    private final Set<String> showFiledSet = Sets.newHashSet((Object[])new String[]{"number", "name", "erfiletype.name", "issyspreset", "createorg.name", "enable"});
    private static final String INIT_SELECT = "initSelect";
    private static final String INIT_SELECT_LIST = "initSelectList";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.isHRBM()) {
            this.getView().getPageCache().put(INIT_SELECT, "true");
            this.onlyShowTable();
        }
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        this.setSelect();
    }

    public void setFilter(SetFilterEvent e) {
        this.getSelectId(e);
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        List listColumns = args.getListColumns();
        if (this.isHRBM()) {
            listColumns.removeIf(listColumn -> !this.showFiledSet.contains(listColumn.getListFieldKey()));
        }
    }

    private boolean isHRBM() {
        return APP_HRBM.equals(this.getView().getFormShowParameter().getCustomParam(OPEN_SOURCE));
    }

    private void onlyShowTable() {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (!listShowParameter.isLookUp()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"filtercontainerap", "toolbarap"});
        }
    }

    private void setSelect() {
        IPageCache pageCache = this.getView().getPageCache();
        String idListStr = pageCache.get(INIT_SELECT_LIST);
        if (!HRStringUtils.isEmpty((String)idListStr)) {
            pageCache.remove(INIT_SELECT_LIST);
            BillList list = (BillList)this.getControl("billlistap");
            List idList = SerializationUtils.fromJsonStringToList((String)idListStr, Long.class);
            ListSelectedRowCollection selectedRowCol = new ListSelectedRowCollection();
            idList.forEach(id -> selectedRowCol.add((Object)new ListSelectedRow(id)));
            list.putSelectedRows(selectedRowCol);
        }
    }

    private void getSelectId(SetFilterEvent e) {
        IPageCache pageCache = this.getView().getPageCache();
        if (!"true".equals(pageCache.get(INIT_SELECT))) {
            return;
        }
        pageCache.remove(INIT_SELECT);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(MODEL_ENTITY_NUMBER);
        if (HRStringUtils.isEmpty((String)entityNumber)) {
            return;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(((ListView)this.getView()).getBillFormId());
        ArrayList qFilterList = Lists.newArrayListWithCapacity((int)16);
        if (!CollectionUtils.isEmpty((Collection)e.getQFilters())) {
            qFilterList.addAll(e.getQFilters());
        }
        qFilterList.add(new QFilter("groupentity.fieldentity.field.group.pageinfo", "=", (Object)entityNumber));
        DynamicObjectCollection multiCol = helper.queryOriginalCollection("id", qFilterList.toArray(new QFilter[0]));
        Set idSet = multiCol.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(idSet)) {
            return;
        }
        pageCache.put(INIT_SELECT_LIST, SerializationUtils.toJsonString(idSet));
    }
}

