/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.approval;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.ContainerAp;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.AdvConAp;
import kd.bos.metadata.form.container.AdvConChildPanelAp;
import kd.bos.metadata.form.container.AdvConSummaryPanelAp;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.control.HRAdvConAp;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.control.HRLabelAp;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hspm.business.approval.ApprovalMulLineTableOrderHelper;
import kd.sdk.hr.hspm.business.helper.ApprovalHelper;
import kd.sdk.hr.hspm.business.helper.InfoGroupHelper;
import kd.sdk.hr.hspm.business.helper.ValueConvertHelper;
import kd.sdk.hr.hspm.business.repository.ErmanFileRepository;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.business.service.PageRegConfigService;
import kd.sdk.hr.hspm.common.enums.ClientTypeEnum;
import kd.sdk.hr.hspm.common.enums.OrderEnum;
import kd.sdk.hr.hspm.common.utils.ComboItemUtil;
import kd.sdk.hr.hspm.common.utils.CommonUtil;
import kd.sdk.hr.hspm.common.utils.InfoGroupApprovalUtil;

public class InfoApprovalPlugin
extends HRDynamicFormBasePlugin {
    private static final Log LOGGER = LogFactory.getLog(InfoApprovalPlugin.class);
    private static final String WITHDRAW_CALLBACK = "withdrawCallBack";
    private static final HRBaseServiceHelper PEREDUEXPCERT_HELPER = new HRBaseServiceHelper("hrpi_pereduexpcert");
    private static final HRBaseServiceHelper INFOAPPROVAL_HELPER = new HRBaseServiceHelper("hspm_infoapproval");
    Map<Long, Long> eduAssociationMap = new HashMap<Long, Long>();
    Map<Long, String> eduAssociationTypeMap = new HashMap<Long, String>();
    Map<String, Long> singleRowCommonId = new HashMap<String, Long>();

    public void propertyChanged(PropertyChangedArgs args) {
        DynamicObjectCollection dynamicObjects = this.getView().getModel().getEntryEntity("entryentity");
        this.getModel().updateEntryCache(dynamicObjects);
        this.getView().updateView("entryentity");
    }

    public void beforeBindData(EventObject eventObject) {
        boolean isMy;
        super.beforeBindData(eventObject);
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            LOGGER.error("data excepiton(entryenetity is empty)");
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u627e\u4e0d\u5230\u9700\u8981\u5ba1\u6838\u7684\u5b57\u6bb5\u4fe1\u606f\u3002", (String)"InfoApprovalPlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        }
        List<DynamicObject> sortedDynList = this.sortMulLineTableByCreateTimeOrExt(dynamicObjects);
        if (this.isMyInfoapproval()) {
            DynamicObject dynamicObject = this.getModel().getDataEntity();
            this.getModel().setValue("modifymanshow", (Object)dynamicObject.getString("person.name"));
            if (!ApprovalHelper.isCanWithDraw((DynamicObject)dynamicObject)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"withdraw"});
            }
            if (!CommonUtil.hasPerm((String)this.getView().getEntityId(), (String)"80513207000000ac", (String)"hssc", (IFormView)this.getView()) && PermCommonUtil.isEnableNoPermBtnHide()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"withdraw"});
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"baseinfo", "headflex"});
            this.getModel().setDataChanged(false);
            String appId = this.getView().getFormShowParameter().getAppId();
            LOGGER.info(MessageFormat.format("open_app:{0}", appId));
            if ("wftask".equals(appId) || "wf".equals(appId)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"approvalrecordarea"});
            }
        } else {
            this.handleBaseInfoCard();
            this.loadHead();
            this.getView().setVisible(Boolean.FALSE, new String[]{"fs_baseinfo", "approvalrecordarea", "withdraw"});
        }
        boolean bl = isMy = this.getParentView(this.getView()) instanceof ListView && "hspm_infoapproval".equals(((ListView)this.getParentView(this.getView())).getBillFormId());
        if (!isMy) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"approvalrecordarea"});
        }
        FlexPanelAp containerFlex = this.getContainer();
        LinkedHashMap<String, Map> groupMap = new LinkedHashMap<String, Map>();
        for (DynamicObject dynamicObject : sortedDynList) {
            List dataList;
            if (HRStringUtils.isEmpty((String)dynamicObject.getString("firstgroup"))) continue;
            String groupName = this.getFullGroupName(dynamicObject);
            Long l = this.getDataId(dynamicObject, groupName);
            LOGGER.info(MessageFormat.format("entity_row: groupName:{0}", groupName));
            Map gMap = groupMap.computeIfAbsent(groupName, val -> new LinkedHashMap());
            Map dataMap = gMap.computeIfAbsent(l, val -> new HashMap(8));
            if (InfoGroupApprovalUtil.isText((DynamicObject)dynamicObject)) {
                dataList = dataMap.computeIfAbsent("text", val -> new ArrayList());
                dataList.add(this.createItem(dynamicObject, true));
                continue;
            }
            dataList = dataMap.computeIfAbsent("attachment", val -> new ArrayList());
            dataList.add(this.createItem(dynamicObject, false));
        }
        HashMap<String, ContainerAp> groupNameFlexMap = new HashMap<String, ContainerAp>(groupMap.size());
        HashMap<String, List<Map<String, Object>>> targetKeyMap = new HashMap<String, List<Map<String, Object>>>(groupMap.size());
        for (Map.Entry entry : groupMap.entrySet()) {
            this.drawInfoGroup(entry, containerFlex, groupNameFlexMap, targetKeyMap);
        }
        if (!CollectionUtils.isEmpty((Collection)containerFlex.getItems())) {
            Container container = (Container)this.getView().getControl("infogroupshow");
            container.getItems().addAll(((Container)containerFlex.buildRuntimeControl()).getItems());
            this.getView().createControlIndex(container.getItems());
            this.getView().updateControlMetadata("infogroupshow", containerFlex.createControl());
            this.showTargetGroup(targetKeyMap, this.isMyInfoapproval());
        }
    }

    private List<DynamicObject> sortMulLineTableByCreateTimeOrExt(DynamicObjectCollection dynamicObjects) {
        ArrayList sortedDynList = Lists.newArrayListWithExpectedSize((int)dynamicObjects.size());
        Map entityNameVsOrderStrMap = ApprovalMulLineTableOrderHelper.treatExtOrderParam();
        Map<String, List<DynamicObject>> entityNameVsDynListMap = dynamicObjects.stream().collect(Collectors.groupingBy(dyn -> dyn.getString("entityname")));
        Set<Map.Entry<String, List<DynamicObject>>> entries = entityNameVsDynListMap.entrySet();
        for (Map.Entry<String, List<DynamicObject>> entry : entries) {
            DynamicObject[] sortedDynArr;
            String entityName = entry.getKey();
            List<DynamicObject> dynList = entry.getValue();
            Map<Long, List<DynamicObject>> dataIdVsDynListMap = dynList.stream().collect(Collectors.groupingBy(dyn -> dyn.getLong("dataid")));
            List dataIdList = dynList.stream().map(dyn -> dyn.getLong("dataid")).collect(Collectors.toList());
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
            QFilter idFilter = new QFilter("id", "in", dataIdList);
            String defaultOrderStr = entityNameVsOrderStrMap.getOrDefault(entityName, OrderEnum.getEntityNameByCode((String)entityName));
            for (DynamicObject sortedDyn : sortedDynArr = serviceHelper.query("id", new QFilter[]{idFilter}, defaultOrderStr)) {
                long dataId = sortedDyn.getLong("id");
                sortedDynList.addAll((Collection)dataIdVsDynListMap.get(dataId));
            }
        }
        return sortedDynList;
    }

    private boolean isMyInfoapproval() {
        return false;
    }

    public void preOpenForm(PreOpenFormEventArgs eventArgs) {
        DynamicObject dynamicObject;
        super.preOpenForm(eventArgs);
        BillShowParameter baseShowParameter = (BillShowParameter)eventArgs.getSource();
        Long pkId = baseShowParameter.getPkId() instanceof String ? Long.valueOf(baseShowParameter.getPkId().toString()) : (Long)baseShowParameter.getPkId();
        String billName = "";
        if (pkId != null && pkId > 0L && (dynamicObject = INFOAPPROVAL_HELPER.queryOne("person.name", (Object)pkId)) != null && HRStringUtils.isNotEmpty((String)dynamicObject.getString("person.name"))) {
            billName = dynamicObject.getString("person.name");
        }
        baseShowParameter.setCaption(String.format(ResManager.loadKDString((String)"%s\u7684\u4eba\u5458\u6863\u6848\u4fe1\u606f\u53d8\u66f4\u7533\u8bf7", (String)"InfoApprovalPlugin_10", (String)"hr-hspm-formplugin", (Object[])new Object[0]), billName));
    }

    private Long getDataId(DynamicObject dynamicObject, String groupName) {
        Long id;
        Long dataId = dynamicObject.getLong("dataid");
        String entityName = dynamicObject.getString("entityname");
        if ("hrpi_pereduexpcert".equals(entityName) && (id = this.eduAssociationMap.get(dataId)) != null) {
            return id;
        }
        if (InfoGroupHelper.isSingleRowTpl((String)entityName)) {
            id = this.singleRowCommonId.get(groupName);
            if (id == null) {
                id = dataId;
                this.singleRowCommonId.put(groupName, id);
            }
            return id;
        }
        return dataId;
    }

    private String getFullGroupName(DynamicObject dynamicObject) {
        if ("0000".equals(dynamicObject.getString("firstgroupnum"))) {
            return dynamicObject.getString("firstgroup");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(dynamicObject.getString("firstgroup"));
        sb.append("!@#");
        String entityName = dynamicObject.getString("entityname");
        String secondName = dynamicObject.getString("secondgroup");
        if (("hrpi_pereduexp".equals(entityName) || "hrpi_pereduexpcert".equals(entityName)) && HRStringUtils.isNotEmpty((String)secondName)) {
            secondName = this.getEduexpGroupName();
        }
        sb.append(secondName);
        return sb.toString();
    }

    private String getEduexpGroupName() {
        String name = this.getPageCache().get("eduexpName");
        if (HRStringUtils.isNotEmpty((String)name)) {
            return name;
        }
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
        Optional<DynamicObject> optional = dynamicObjects.stream().filter(val -> "hrpi_pereduexp".equals(val.getString("entityname"))).findAny();
        if (optional.isPresent()) {
            name = optional.get().getString("secondgroup");
            this.findEduAssociation(dynamicObjects);
        } else {
            name = ResManager.loadKDString((String)"\u6559\u80b2\u7ecf\u5386", (String)"InfoApprovalPlugin_3", (String)"hr-hspm-formplugin", (Object[])new Object[0]);
        }
        this.getPageCache().put("eduexpName", name);
        return name;
    }

    private void findEduAssociation(DynamicObjectCollection dynamicObjects) {
        QFilter filter;
        DynamicObject[] datas;
        this.getModel().getEntryEntity("entryentity");
        Set set = dynamicObjects.stream().filter(val -> "hrpi_pereduexpcert".equals(val.getString("entityname"))).map(val -> val.getLong("dataid")).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(set) && (datas = PEREDUEXPCERT_HELPER.query("certtype.name,pereduexp", new QFilter[]{filter = new QFilter("id", "in", set)})) != null && datas.length > 0) {
            for (DynamicObject data : datas) {
                this.eduAssociationMap.put(data.getLong("id"), data.getLong("pereduexp.id"));
                ILocaleString localeString = data.getLocaleString("certtype.name");
                if (localeString == null) continue;
                this.eduAssociationTypeMap.put(data.getLong("id"), localeString.getLocaleValue());
            }
        }
    }

    private FlexPanelAp getContainer() {
        return new HRFlexPanelAp.Builder("infogroupshow").setName("infogroupshow").setWrap(true).setGrow(1).setShrink(1).setWidth("100%").build();
    }

    private void showTargetGroup(Map<String, List<Map<String, Object>>> targetKeyMap, boolean isMyInfoapproval) {
        String billStatus = (String)this.getModel().getValue("billstatus");
        boolean viewStatus = "G".equals(billStatus) || "C".equals(billStatus) || this.isMyInfoapproval();
        for (Map.Entry<String, List<Map<String, Object>>> entry : targetKeyMap.entrySet()) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.getOpenStyle().setTargetKey(entry.getKey());
            showParameter.setCustomParam("data", entry.getValue());
            showParameter.setCustomParam("isMyInfoapproval", (Object)isMyInfoapproval);
            showParameter.setCustomParam("billstatus", this.getModel().getValue("billstatus"));
            if (entry.getKey().startsWith("attachment")) {
                showParameter.setFormId("hspm_attachmentapproval");
            } else {
                showParameter.setFormId("hspm_groupfieldapproval");
            }
            if (viewStatus) {
                showParameter.setStatus(OperationStatus.VIEW);
            }
            this.getView().showForm(showParameter);
        }
    }

    private FlexPanelAp drawInfoGroup(Map.Entry<String, Map<Long, Map<String, List<Map<String, Object>>>>> group, FlexPanelAp containerFlex, Map<String, ContainerAp> groupNameFlexMap, Map<String, List<Map<String, Object>>> targetKeyMap) {
        String[] groups = group.getKey().split("!@#");
        String firstGroupName = groups[0];
        Map<Long, Map<String, List<Map<String, Object>>>> groupData = group.getValue();
        long simulateRandomNum = System.currentTimeMillis();
        int index = 1;
        boolean more = groupData.size() > 1;
        for (Map.Entry<Long, Map<String, List<Map<String, Object>>>> entry : groupData.entrySet()) {
            List<Map<String, Object>> attachmentData;
            Map<String, List<Map<String, Object>>> gData;
            List<Map<String, Object>> textData;
            FlexPanelAp firstGroupFlex;
            boolean isSingleRow = this.singleRowCommonId.containsValue(entry.getKey());
            if (isSingleRow) {
                firstGroupFlex = (FlexPanelAp)groupNameFlexMap.get(firstGroupName);
                if (firstGroupFlex == null) {
                    firstGroupFlex = InfoApprovalPlugin.createContainer(firstGroupName, firstGroupName);
                    AdvConAp advConAp = this.createAdContainer(firstGroupName, firstGroupName);
                    AdvConChildPanelAp childPanelAp = InfoApprovalPlugin.createAdChildContainer(firstGroupName);
                    advConAp.getItems().add(childPanelAp);
                    childPanelAp.getItems().add(firstGroupFlex);
                    groupNameFlexMap.put(firstGroupName, (ContainerAp)firstGroupFlex);
                    containerFlex.getItems().add(advConAp);
                }
            } else {
                String gName = groups.length > 1 && HRStringUtils.isNotEmpty((String)groups[1]) ? groups[1] : groups[0];
                String key = more ? gName + index : gName;
                firstGroupFlex = InfoApprovalPlugin.createContainer(key, key);
                AdvConAp advConAp = this.createAdContainer(key, key);
                AdvConChildPanelAp childPanelAp = InfoApprovalPlugin.createAdChildContainer(key);
                advConAp.getItems().add(childPanelAp);
                childPanelAp.getItems().add(firstGroupFlex);
                containerFlex.getItems().add(advConAp);
            }
            if (!CollectionUtils.isEmpty(textData = (gData = entry.getValue()).get("text"))) {
                if (isSingleRow && groups.length > 1 && HRStringUtils.isNotEmpty((String)groups[1])) {
                    String labelName = more ? groups[1] + index : groups[1];
                    LabelAp secondGroupLabel = this.createLabel(group.getKey() + simulateRandomNum++, labelName);
                    firstGroupFlex.getItems().add(secondGroupLabel);
                }
                String key = "text" + group.getKey() + simulateRandomNum++;
                FlexPanelAp showDataFlex = InfoApprovalPlugin.createContainer(key, key);
                firstGroupFlex.getItems().add(showDataFlex);
                targetKeyMap.put(key, textData);
            }
            if (!CollectionUtils.isEmpty(attachmentData = gData.get("attachment"))) {
                if (!"0000".equals(attachmentData.get(0).get("firstgroupnum"))) {
                    String labelName = this.getAttachmentLabelName(attachmentData);
                    if (more) {
                        labelName = labelName + index;
                    }
                    LabelAp secondGroupLabel = this.createLabel(group.getKey() + simulateRandomNum++, labelName);
                    firstGroupFlex.getItems().add(secondGroupLabel);
                }
                String key = "attachment" + group.getKey() + simulateRandomNum++;
                FlexPanelAp showDataFlex = InfoApprovalPlugin.createContainer(key, key);
                firstGroupFlex.getItems().add(showDataFlex);
                targetKeyMap.put(key, attachmentData);
            }
            if (!more) continue;
            ++index;
        }
        return containerFlex;
    }

    private String getAttachmentLabelName(List<Map<String, Object>> attachmentData) {
        String entityName = (String)attachmentData.get(0).get("entityname");
        String labelName = "hrpi_pereduexpcert".equals(entityName) ? ResManager.loadKDString((String)"\u6559\u80b2\u8bc1\u4ef6", (String)"InfoApprovalPlugin_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]) : ("hrpi_percre".equals(entityName) ? ResManager.loadKDString((String)"\u8bc1\u4ef6\u7167", (String)"InfoApprovalPlugin_5", (String)"hr-hspm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u9644\u4ef6\u4fe1\u606f", (String)"InfoApprovalPlugin_6", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        return labelName;
    }

    private Map<String, Object> createItem(DynamicObject dynamicObject, boolean isText) {
        String typeName;
        HashMap<String, Object> item = new HashMap<String, Object>(16);
        item.put("entryid", dynamicObject.get("id"));
        item.put("isnew", dynamicObject.getBoolean("isnew"));
        item.put("isdel", dynamicObject.getBoolean("isdel"));
        String entityName = dynamicObject.getString("entityname");
        String fieldName = dynamicObject.getString("fieldname");
        String fieldType = dynamicObject.getString("fieldtype");
        String extraInfo = dynamicObject.getString("extrainfo");
        item.put("fieldtype", fieldType);
        item.put("entityname", entityName);
        item.put("fieldname", fieldName);
        item.put("newvalue", ValueConvertHelper.showString((String)entityName, (String)fieldName, (String)fieldType, (String)extraInfo, (String)dynamicObject.getString("newvalue")));
        item.put("oldvalue", ValueConvertHelper.showString((String)entityName, (String)fieldName, (String)fieldType, (String)extraInfo, (String)dynamicObject.getString("oldvalue")));
        item.put("change", dynamicObject.get("change"));
        item.put("status", dynamicObject.get("status"));
        item.put("reason", dynamicObject.get("reason"));
        item.put("firstgroupnum", dynamicObject.get("firstgroupnum"));
        Long dataId = dynamicObject.getLong("dataid");
        item.put("dataid", dataId);
        item.put("id", dynamicObject.getPkValue());
        if (isText) {
            item.put("displayname", dynamicObject.get("displayname"));
        } else if ("hrpi_pereduexpcert".equals(entityName) && HRStringUtils.isNotEmpty((String)(typeName = this.eduAssociationTypeMap.get(dataId)))) {
            item.put("displayname", typeName);
        } else {
            item.put("displayname", dynamicObject.get("displayname"));
        }
        return item;
    }

    private LabelAp createLabel(String key, String name) {
        LabelAp labelAp = ((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)new HRLabelAp.Builder(key).setShrink(1).setGrow(0).setName(name).setForeColor("#212121").setBackColor("#F2F2F2").setFontSize(14).setPaddingTop("5px")).setPaddingBottom("5px")).setMarginTop("2px")).setMarginBottom("12px")).build();
        return labelAp;
    }

    public static FlexPanelAp createContainer(String key, String name) {
        return ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(key).setName(name).setGrow(1).setShrink(0).setDirection("column").setJustifyContent("flex-start").setMarginTop("3px")).setWidth("100%").build();
    }

    public AdvConAp createAdContainer(String key, String name) {
        AdvConAp advConAp = ((HRAdvConAp.Builder)new HRAdvConAp.Builder(key + "_ad").setName(name).setGrow(1).setShrink(1).setWidth("100%").setBorderTop("10px_solid_#ebeef2")).setCollapsible(true).setFontSize(16).setForeColor("#212121").build();
        advConAp.setFontWeight("400");
        if (!this.isMyInfoapproval()) {
            AdvConSummaryPanelAp advConSummaryPanelAp = new AdvConSummaryPanelAp();
            advConSummaryPanelAp.setId(key + "_summary");
            advConSummaryPanelAp.setKey(key + "_summary");
            LabelAp labelAp = ((HRLabelAp.Builder)new HRLabelAp.Builder(key).setName(ResManager.loadKDString((String)"\u8bf4\u660e\uff1a\u5217\u8868\u4e2d\u6807\u9ec4\u8272\u7684\u5b57\u4e3a\u7528\u6237\u91cd\u65b0\u4fee\u6539\u540e\u63d0\u4ea4\u7684\u4fe1\u606f\u3002", (String)"InfoApprovalPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0])).setMarginLeft("8px")).setWidth(new LocaleString("100%")).setForeColor("#666666").setFontSize(12).build();
            advConSummaryPanelAp.getItems().add(labelAp);
            advConAp.getItems().add(advConSummaryPanelAp);
        }
        return advConAp;
    }

    public static AdvConChildPanelAp createAdChildContainer(String key) {
        AdvConChildPanelAp childPanelAp = new AdvConChildPanelAp();
        childPanelAp.setId(key + "_child");
        childPanelAp.setKey(key + "_child");
        childPanelAp.setGrow(0);
        childPanelAp.setShrink(1);
        childPanelAp.setWidth(new LocaleString("100%"));
        childPanelAp.setWrap(false);
        return childPanelAp;
    }

    private void loadHead() {
        DynamicObject person = (DynamicObject)this.getModel().getValue("person");
        if (!HRObjectUtils.isEmpty((Object)person)) {
            DynamicObject erFileDy = ErmanFileRepository.getPrimaryErmanFile((Long)person.getLong("id"));
            if (HRObjectUtils.isEmpty((Object)erFileDy)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u4e0d\u5230\u7528\u6237\u7684\u4e3b\u6863\u6848\u3002", (String)"InfoApprovalPlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
                return;
            }
            String strId = "hspm_file" + ClientTypeEnum.PC.getCode();
            Tuple tuple = AttacheHandlerService.getInstance().handleRuleEngine(this.getView(), erFileDy.getLong("id"), erFileDy, strId, ClientTypeEnum.PC.getCode(), null, false);
            long cnfId = (Long)tuple.item2;
            Map infoGroupConfig = PageRegConfigService.getInstance().getInfoGroupConfig(cnfId, ClientTypeEnum.PC.getCode(), null);
            if (infoGroupConfig == null) {
                LOGGER.error("data excepiton(infoGroupConfig is empty)");
            } else {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.getOpenStyle().setShowType(ShowType.InContainer);
                showParameter.getOpenStyle().setTargetKey("headflex");
                showParameter.setFormId("hspm_approvalhead");
                showParameter.setCustomParam("person", (Object)person.getLong("id"));
                showParameter.setCustomParam("depemp", (Object)erFileDy.getLong("depemp.id"));
                DynamicObject depDy = erFileDy.getDynamicObject("depemp.adminorg");
                showParameter.setCustomParam("adminorgid", (Object)(depDy != null ? depDy.getLong("id") : 0L));
                showParameter.setCustomParam("employee", this.getModel().getValue("employee"));
                showParameter.setCustomParam("cmpemp", this.getModel().getValue("cmpemp"));
                showParameter.setCustomParam("params", (Object)SerializationUtils.toJsonString(infoGroupConfig.get("headentity")));
                this.getView().showForm(showParameter);
            }
        }
    }

    private void handleBaseInfoCard() {
        String formId;
        List items;
        String billStatus;
        Label sumbittime;
        DynamicObject dynamicObject;
        Label modifyman;
        Label label = (Label)this.getControl("billnolabel");
        if (label != null) {
            label.setText((String)this.getModel().getValue("billno"));
        }
        if ((modifyman = (Label)this.getControl("modifyman")) != null && (dynamicObject = (DynamicObject)this.getModel().getValue("modifier")) != null && dynamicObject.get("name") instanceof OrmLocaleValue) {
            modifyman.setText(((OrmLocaleValue)dynamicObject.get("name")).getLocaleValue());
        }
        if ((sumbittime = (Label)this.getControl("sumbittime")) != null && this.getModel().getValue("modifytime") instanceof Date) {
            Date date = (Date)this.getModel().getValue("modifytime");
            sumbittime.setText(HRDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        if (HRStringUtils.isNotEmpty((String)(billStatus = (String)this.getModel().getValue("billstatus"))) && !CollectionUtils.isEmpty((Collection)(items = ComboItemUtil.getComboItem((String)(formId = this.getView().getFormShowParameter().getFormId()), (String)"billstatus")))) {
            for (ComboItem comboItem : items) {
                if (!billStatus.equals(comboItem.getValue())) continue;
                Label status = (Label)this.getControl("billstatusshow");
                status.setText(comboItem.getCaption().getLocaleValue());
                this.auditStatusShowStyle("billstatusshow", billStatus);
            }
        }
    }

    private void auditStatusShowStyle(String labKey, String billStatus) {
        if ("G".equals(billStatus)) {
            LabelAp labelAp = new LabelAp();
            labelAp.setKey(labKey);
            Border border = new Border();
            border.setBottom("#FFCB78 solid 1px");
            border.setTop("#FFCB78 solid 1px");
            border.setLeft("#FFCB78 solid 1px");
            border.setRight("#FFCB78 solid 1px");
            Style style = new Style();
            style.setBorder(border);
            labelAp.setStyle(style);
            labelAp.setForeColor("#FF991C");
            labelAp.setBackColor("#FFFBF2");
            this.getView().updateControlMetadata(labKey, labelAp.createControl());
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
        } else if ("C".equals(billStatus)) {
            LabelAp labelAp = new LabelAp();
            labelAp.setKey(labKey);
            Border border = new Border();
            border.setBottom("#6DD18E solid 1px");
            border.setTop("#6DD18E solid 1px");
            border.setLeft("#6DD18E solid 1px");
            border.setRight("#6DD18E solid 1px");
            Style style = new Style();
            style.setBorder(border);
            labelAp.setStyle(style);
            labelAp.setForeColor("#1BA854");
            labelAp.setBackColor("#F2FFF5");
            this.getView().updateControlMetadata(labKey, labelAp.createControl());
        } else if ("F".equals(billStatus)) {
            LabelAp labelAp = new LabelAp();
            labelAp.setKey(labKey);
            Border border = new Border();
            border.setBottom("#CCCCCC solid 1px");
            border.setTop("#CCCCCC solid 1px");
            border.setLeft("#CCCCCC solid 1px");
            border.setRight("#CCCCCC solid 1px");
            Style style = new Style();
            style.setBorder(border);
            labelAp.setStyle(style);
            labelAp.setForeColor("#666666");
            labelAp.setBackColor("#F5F5F5");
            this.getView().updateControlMetadata(labKey, labelAp.createControl());
        }
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if ("withdraw".equals(evt.getItemKey()) && this.checkBeforeWithDraw(this.getModel().getDataEntity())) {
            ConfirmCallBackListener confirm = new ConfirmCallBackListener(WITHDRAW_CALLBACK, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u64a4\u9500\u540e\u5c06\u7ec8\u6b62\u6863\u6848\u4fe1\u606f\u53d8\u66f4\u6d41\u7a0b\u5e76\u5220\u9664\u5ba1\u6279\u5355\u636e\uff0c\u662f\u5426\u64a4\u9500\uff1f", (String)"InfoApprovalPlugin_7", (String)"hr-hspm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirm);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult messageBoxResult = messageBoxClosedEvent.getResult();
        if (!MessageBoxResult.Yes.equals((Object)messageBoxResult) && !MessageBoxResult.OK.equals((Object)messageBoxResult)) {
            return;
        }
        String key = messageBoxClosedEvent.getCallBackId();
        if (WITHDRAW_CALLBACK.equals(key)) {
            if (!this.checkBeforeWithDraw(this.getModel().getDataEntity())) {
                return;
            }
            Tuple result = ApprovalHelper.widthDraw((DynamicObject)this.getModel().getDataEntity(true));
            if (((Boolean)result.item1).booleanValue()) {
                IFormView parentView = this.getParentView(this.getView());
                if (parentView != null) {
                    parentView.showSuccessNotification((String)result.item2);
                    if (parentView instanceof ListView) {
                        ((ListView)parentView).refresh();
                    } else if (this.getParentView(parentView) instanceof ListView) {
                        ((ListView)this.getParentView(parentView)).refresh();
                    }
                    this.getView().sendFormAction(parentView);
                }
                this.getView().close();
            } else {
                this.getView().showErrorNotification((String)result.item2);
            }
        }
    }

    private boolean checkBeforeWithDraw(DynamicObject bill) {
        if (!CommonUtil.hasPerm((String)this.getView().getEntityId(), (String)"80513207000000ac", (String)"hssc", (IFormView)this.getView())) {
            this.getView().showErrorNotification(HRBaseUtils.getNoPermMsg());
            return false;
        }
        if ((bill = INFOAPPROVAL_HELPER.queryOne("billstatus,rejectrecord", bill.getPkValue())) == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64a4\u9500\u5931\u8d25\uff1a\u5355\u636e\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"InfoApprovalPlugin_8", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!ApprovalHelper.isCanWithDraw((DynamicObject)bill)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u64a4\u9500\u5931\u8d25\uff1a\u5f53\u524d\u5355\u636e\u4fe1\u606f\u5df2\u7ecf\u8fc7\u671f\u3002", (String)"InfoApprovalPlugin_9", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private IFormView getParentView(IFormView view) {
        return view.getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
    }
}

