/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.approval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.sdk.hr.hspm.common.ext.file.EmployeeBillParamsDTO;
import kd.sdk.hr.hspm.common.utils.InfoGroupApprovalUtil;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.ext.service.employee.MobileBillDetailExtUtil;

public class InfoGroupApprovalPlugin
extends HRDynamicFormBasePlugin {
    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        List list = (List)this.getView().getFormShowParameter().getCustomParam("data");
        Boolean isMyInfoapproval = (Boolean)this.getView().getFormShowParameter().getCustomParam("isMyInfoapproval");
        String billStatus = (String)this.getView().getFormShowParameter().getCustomParam("billstatus");
        if (!CollectionUtils.isEmpty((Collection)list)) {
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
            dynamicObjects.clear();
            List updateList = list.stream().filter(val -> !Boolean.TRUE.equals(val.get("isdel"))).collect(Collectors.toList());
            for (Map item : updateList) {
                this.modifyExtData(item);
                DynamicObject showDy = dynamicObjects.addNew();
                showDy.set("operatetype", (Object)(Boolean.TRUE.equals(item.get("isdel")) ? "2" : (Boolean.TRUE.equals(item.get("isnew")) ? "1" : "0")));
                showDy.set("fieldname", item.get("displayname"));
                showDy.set("newvalue", item.get("newvalue"));
                this.handleAuditResult(showDy, item, isMyInfoapproval, billStatus);
                if (!Boolean.TRUE.equals(isMyInfoapproval)) {
                    showDy.set("change", item.get("change"));
                }
                if (item.get("oldvalue") != null) {
                    showDy.set("oldvalue", item.get("oldvalue"));
                } else {
                    showDy.set("oldvalue", (Object)"-");
                }
                showDy.set("datarefid", item.get("entryid"));
            }
            Map<Long, List<Map>> deleteListMap = list.stream().filter(val -> Boolean.TRUE.equals(val.get("isdel"))).collect(Collectors.groupingBy(val -> (Long)val.get("dataid")));
            if (deleteListMap.size() > 0) {
                for (Map.Entry<Long, List<Map>> entry : deleteListMap.entrySet()) {
                    List<Map> newAddFields = entry.getValue();
                    DynamicObject showDy = dynamicObjects.addNew();
                    showDy.set("operatetype", (Object)"2");
                    StringBuilder displayNameSb = new StringBuilder();
                    StringBuilder newValueSb = new StringBuilder();
                    StringBuilder oldValueSb = new StringBuilder();
                    for (int idx = 0; idx < newAddFields.size(); ++idx) {
                        Map field = newAddFields.get(idx);
                        this.modifyExtData(field);
                        if (idx > 0) {
                            displayNameSb.append("\r\n");
                            newValueSb.append("\r\n");
                            oldValueSb.append("\r\n");
                        }
                        displayNameSb.append((String)field.get("displayname"));
                        oldValueSb.append(HRStringUtils.isEmpty((String)((String)field.get("oldvalue"))) ? "-" : (String)field.get("oldvalue"));
                        newValueSb.append("-");
                    }
                    showDy.set("fieldname", (Object)displayNameSb.toString());
                    showDy.set("newvalue", (Object)newValueSb.toString());
                    showDy.set("oldvalue", (Object)oldValueSb.toString());
                    Map item = newAddFields.get(0);
                    this.handleAuditResult(showDy, item, isMyInfoapproval, billStatus);
                    showDy.set("datarefid", item.get("entryid"));
                    if (!Boolean.TRUE.equals(isMyInfoapproval)) {
                        showDy.set("change", item.get("change"));
                    }
                    if (!newAddFields.stream().anyMatch(arg -> Boolean.TRUE.equals(arg.get("status")))) continue;
                    showDy.set("status", (Object)true);
                }
            }
        }
        if ("F".equals(billStatus)) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }

    private void modifyExtData(Map<String, Object> item) {
        EmployeeBillParamsDTO paramsDTO = new EmployeeBillParamsDTO((String)item.get("firstgroupnum"), ((Long)item.get("dataid")).longValue(), (String)item.get("entityname"), (String)item.get("fieldname"), (String)item.get("oldvalue"), (String)item.get("newvalue"), ((Long)item.get("id")).longValue());
        MobileBillDetailExtUtil.modifyEmployeeBillDetail((EmployeeBillParamsDTO)paramsDTO);
        item.put("oldvalue", paramsDTO.getBefore());
        item.put("newvalue", paramsDTO.getAfter());
    }

    private void handleAuditResult(DynamicObject showDy, Map<String, Object> item, Boolean isMyInfoapproval, String billStatus) {
        Boolean status = (Boolean)item.get("status");
        if ("G".equals(billStatus) || "C".equals(billStatus)) {
            showDy.set("result", (Object)InfoGroupApprovalUtil.getAuditResult((Boolean)status));
            this.getView().setVisible(Boolean.FALSE, new String[]{"status"});
            if ("G".equals(billStatus)) {
                showDy.set("reason", item.get("reason"));
            }
            return;
        }
        showDy.set("reason", item.get("reason"));
        showDy.set("status", (Object)status);
        this.getView().setVisible(Boolean.FALSE, new String[]{"result"});
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        DynamicObject[] dyArray = entryGrid.getEntryData().getDataEntitys();
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
        String notPassText = InfoGroupApprovalUtil.getAuditResult((Boolean)Boolean.TRUE);
        for (int index = 0; index < dyArray.length; ++index) {
            CellStyle cellStyle;
            if (dyArray[index].getBoolean("change")) {
                cellStyle = new CellStyle();
                cellStyle.setForeColor("#FF991C");
                cellStyle.setFieldKey("newvalue");
                cellStyle.setRow(index);
                cellStyles.add(cellStyle);
            }
            if (!notPassText.equals(dyArray[index].getString("result"))) continue;
            cellStyle = new CellStyle();
            cellStyle.setForeColor("#FF991C");
            cellStyle.setFieldKey("result");
            cellStyle.setRow(index);
            cellStyles.add(cellStyle);
        }
        if (cellStyles.size() > 0) {
            entryGrid.setCellStyle(cellStyles);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName;
        switch (propertyName = args.getProperty().getName()) {
            case "status": 
            case "reason": {
                this.updateValueToParent(propertyName, args.getChangeSet());
                break;
            }
        }
    }

    private void updateValueToParent(String propertyName, ChangeData[] changeData) {
        DynamicObjectCollection dynamicObjects;
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && !CollectionUtils.isEmpty((Collection)(dynamicObjects = parentView.getModel().getEntryEntity("entryentity")))) {
            List changeList = InfoGroupApprovalUtil.findDynamicObjects((DynamicObjectCollection)dynamicObjects, (long)changeData[0].getDataEntity().getLong("datarefid"));
            if ("status".equals(propertyName)) {
                for (DynamicObject dynamicObject : changeList) {
                    dynamicObject.set("status", changeData[0].getNewValue());
                }
            } else if ("reason".equals(propertyName)) {
                for (DynamicObject dynamicObject : changeList) {
                    LocaleDynamicObjectCollection value = (LocaleDynamicObjectCollection)changeData[0].getNewValue();
                    OrmLocaleValue localeValue = (OrmLocaleValue)dynamicObject.get("reason");
                    this.changeToOrmLocaleValue(value, localeValue);
                    dynamicObject.set("reason", (Object)localeValue);
                }
            }
            parentView.getModel().updateEntryCache(dynamicObjects);
        }
    }

    private void changeToOrmLocaleValue(LocaleDynamicObjectCollection localeDyCollection, OrmLocaleValue localeValue) {
        for (DynamicObject dy : localeDyCollection) {
            localeValue.setItem(dy.get(1).toString(), dy.get(2).toString());
        }
    }
}

