/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.approval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.sdk.hr.hspm.common.enums.FieldTypeEnum;
import kd.sdk.hr.hspm.common.utils.InfoGroupApprovalUtil;

public class InfoGroupAttachmentApprovalPlugin
extends HRDynamicFormBasePlugin
implements CellClickListener {
    private static final Log LOGGER = LogFactory.getLog(InfoGroupAttachmentApprovalPlugin.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addCellClickListener((CellClickListener)this);
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        this.showAttachment(cellClickEvent.getRow(), cellClickEvent.getFieldKey());
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        this.showAttachment(cellClickEvent.getRow(), cellClickEvent.getFieldKey());
    }

    private void showAttachment(int row, String fieldKey) {
        List list;
        if (("newvalue".equals(fieldKey) || "oldvalue".equals(fieldKey)) && !CollectionUtils.isEmpty((Collection)(list = (List)this.getView().getFormShowParameter().getCustomParam("data"))) && list.size() > row) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("hspm_approval_attachment");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCustomParam("data", list.get(row));
            formShowParameter.setCustomParam("key", (Object)fieldKey);
            this.getView().showForm(formShowParameter);
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        List list = (List)this.getView().getFormShowParameter().getCustomParam("data");
        Boolean isMyInfoapproval = (Boolean)this.getView().getFormShowParameter().getCustomParam("isMyInfoapproval");
        String billStatus = (String)this.getView().getFormShowParameter().getCustomParam("billstatus");
        if (!CollectionUtils.isEmpty((Collection)list)) {
            DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity("entryentity");
            dynamicObjects.clear();
            for (Map item : list) {
                DynamicObject showDy = dynamicObjects.addNew();
                showDy.set("oldvalue", (Object)this.getFileName(item, "oldvalue"));
                showDy.set("newvalue", (Object)this.getFileName(item, "newvalue"));
                showDy.set("fieldname", item.get("displayname"));
                Boolean status = (Boolean)item.get("status");
                if (Boolean.TRUE.equals(isMyInfoapproval)) {
                    if ("G".equals(billStatus) || "C".equals(billStatus)) {
                        showDy.set("result", (Object)InfoGroupApprovalUtil.getAuditResult((Boolean)status));
                    }
                    if ("G".equals(billStatus)) {
                        showDy.set("reason", item.get("reason"));
                    }
                    this.getView().setVisible(Boolean.FALSE, new String[]{"status"});
                } else {
                    showDy.set("reason", item.get("reason"));
                    showDy.set("status", (Object)status);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"result"});
                }
                if (!Boolean.TRUE.equals(isMyInfoapproval)) {
                    showDy.set("change", item.get("change"));
                }
                showDy.set("datarefid", item.get("entryid"));
            }
        }
        if ("F".equals(billStatus)) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }

    private String getFileName(Map<String, Object> item, String key) {
        String fieldName;
        String fromId;
        List attachmentDatas;
        String value = (String)item.get(key);
        if (HRStringUtils.isEmpty((String)value) || "0".equals(value)) {
            return "-";
        }
        String fieldType = (String)item.get("fieldtype");
        FieldTypeEnum fieldTypeEnum = FieldTypeEnum.geCodeByFieldType((String)fieldType);
        if (fieldTypeEnum == FieldTypeEnum.PICTURE) {
            return value.substring(value.lastIndexOf("/") + 1);
        }
        if (fieldTypeEnum == FieldTypeEnum.ATTACHMENT && !CollectionUtils.isEmpty((Collection)(attachmentDatas = AttachmentServiceHelper.getAttachments((String)(fromId = (String)item.get("entityname")), (Object)value, (String)(fieldName = (String)item.get("fieldname")))))) {
            StringBuilder sb = new StringBuilder();
            for (Map map : attachmentDatas) {
                if (sb.toString().length() > 0) {
                    sb.append(",");
                }
                sb.append(map.get("name"));
            }
            return sb.toString();
        }
        return "-";
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        DynamicObject[] dyArray = entryGrid.getEntryData().getDataEntitys();
        ArrayList<CellStyle> cellStyles = new ArrayList<CellStyle>();
        String notPassText = InfoGroupApprovalUtil.getAuditResult((Boolean)Boolean.TRUE);
        for (int index = 0; index < dyArray.length; ++index) {
            CellStyle cellStyle;
            if (dyArray[index].getBoolean("change")) {
                cellStyle = new CellStyle();
                cellStyle.setForeColor("#FF991C");
                cellStyle.setFieldKey("newvalue");
                cellStyle.setRow(index);
                cellStyles.add(cellStyle);
            }
            if (!notPassText.equals(dyArray[index].getString("result"))) continue;
            cellStyle = new CellStyle();
            cellStyle.setForeColor("#FF991C");
            cellStyle.setFieldKey("result");
            cellStyle.setRow(index);
            cellStyles.add(cellStyle);
        }
        if (cellStyles.size() > 0) {
            entryGrid.setCellStyle(cellStyles);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyName;
        switch (propertyName = args.getProperty().getName()) {
            case "status": 
            case "reason": {
                this.updateValueToParent(propertyName, args.getChangeSet());
                break;
            }
        }
    }

    private void updateValueToParent(String propertyName, ChangeData[] changeData) {
        DynamicObjectCollection dynamicObjects;
        IFormView parentView = this.getView().getParentView();
        if (parentView != null && !CollectionUtils.isEmpty((Collection)(dynamicObjects = parentView.getModel().getEntryEntity("entryentity")))) {
            List changeList = InfoGroupApprovalUtil.findDynamicObjects((DynamicObjectCollection)dynamicObjects, (long)changeData[0].getDataEntity().getLong("datarefid"));
            if ("status".equals(propertyName)) {
                for (DynamicObject dynamicObject : changeList) {
                    dynamicObject.set("status", changeData[0].getNewValue());
                }
            } else if ("reason".equals(propertyName)) {
                for (DynamicObject dynamicObject : changeList) {
                    LocaleDynamicObjectCollection value = (LocaleDynamicObjectCollection)changeData[0].getNewValue();
                    OrmLocaleValue localeValue = (OrmLocaleValue)dynamicObject.get("reason");
                    this.changeToOrmLocaleValue(value, localeValue);
                    dynamicObject.set("reason", (Object)localeValue);
                }
            }
            parentView.getModel().updateEntryCache(dynamicObjects);
        }
    }

    private void changeToOrmLocaleValue(LocaleDynamicObjectCollection localeDyCollection, OrmLocaleValue localeValue) {
        for (DynamicObject dy : localeDyCollection) {
            localeValue.setItem(dy.get(1).toString(), dy.get(2).toString());
        }
    }
}

