/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.employee;

import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.hr.hbp.common.control.HRLabelAp;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hpfs.business.file.MultiViewTemplateService;
import kd.hr.hspm.business.employee.MyErManFilePluginHelper;
import kd.hr.hspm.formplugin.multiviewconfig.MultiViewConfigPlugin;
import kd.sdk.hr.hspm.business.helper.ApprovalHelper;
import kd.sdk.hr.hspm.business.repository.ErmanFileRepository;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.business.service.PageRegConfigService;
import kd.sdk.hr.hspm.common.enums.ClientTypeEnum;
import kd.sdk.hr.hspm.common.utils.ApprovalEntityUtils;
import kd.sdk.hr.hspm.common.utils.CommonUtil;
import kd.sdk.hr.hspm.formplugin.web.file.ermanfile.ext.service.employee.IEmployeeFilePluginService;

public class MyErManFilePlugin
extends HRDynamicFormBasePlugin
implements ProgresssListener {
    private static final Log LOGGER = LogFactory.getLog(MultiViewConfigPlugin.class);
    private static String OPEN_TYPE = "opentype";

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        this.addClickListeners(new String[]{"auditRecord", "changeRecord", "submit"});
        ApprovalHelper.setSubmitButtonVisibleListener((IFormView)this.getView(), (ProgresssListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        Map<String, Object> infoGroupConfig = this.initParam();
        ApprovalEntityUtils.initCacheFromEntry((IFormView)this.getView(), infoGroupConfig);
        this.drawHeadArea();
        this.drawLeftMenu();
    }

    public void onGetControl(OnGetControlArgs args) {
        super.onGetControl(args);
        FormView formView = (FormView)args.getSource();
        MultiViewTemplateService.getInstance().setLabelEvent(args, formView, (AbstractFormPlugin)this, this.getTabList());
    }

    private List<Map<String, Object>> getTabList() {
        String mainEntry = this.getPageCache().get("mainentry");
        return HRStringUtils.isNotEmpty((String)mainEntry) ? SerializationUtils.fromJsonStringToList((String)mainEntry, Map.class) : null;
    }

    private long getLongFromCache(String key) {
        String value = this.getPageCache().get(key);
        return HRStringUtils.isNotEmpty((String)value) ? Long.parseLong(value) : 0L;
    }

    public void afterBindData(EventObject args) {
        super.afterBindData(args);
        IFormView view = this.getView();
        List<Map<String, Object>> tabList = this.getTabList();
        if (tabList == null || tabList.size() == 0) {
            return;
        }
        String regNumber = (String)tabList.get(0).get("targetkey");
        this.getPageCache().put(OPEN_TYPE, "1");
        this.showRightPageInContainer(regNumber, this.getLongFromCache("erfileId"));
        view.getFormShowParameter().setCustomParam("tabentryparam", (Object)SerializationUtils.toJsonString(tabList));
        this.getView().getPageCache().remove("lastlab");
        MyErManFilePluginHelper.setSelectStyle((String)regNumber, (IFormView)view);
        view.setVisible(Boolean.FALSE, new String[]{"submit"});
        if (!CommonUtil.hasPerm((String)"hspm_infoapproval", (String)"47150e89000000ac", (String)"hssc", (IFormView)view) && PermCommonUtil.isEnableNoPermBtnHide()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"auditRecord".toLowerCase(Locale.ROOT)});
        }
        if (!CommonUtil.hasPerm((String)"hspm_changerecord", (String)"47150e89000000ac", (String)"hssc", (IFormView)view) && PermCommonUtil.isEnableNoPermBtnHide()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"changeRecord".toLowerCase(Locale.ROOT)});
        }
        ApprovalHelper.setSubmitButtonVisibleListener((IFormView)this.getView(), (ProgresssListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Label) {
            Label curClickLabel = (Label)evt.getSource();
            String labelName = curClickLabel.getKey();
            this.showRightPageInContainer(labelName.toUpperCase(Locale.ENGLISH), this.getLongFromCache("erfileId"));
            List<Map<String, Object>> tabList = this.getTabList();
            this.getView().getFormShowParameter().setCustomParam("tabentryparam", (Object)SerializationUtils.toJsonString(tabList));
            MyErManFilePluginHelper.setSelectStyle((String)labelName.toUpperCase(Locale.ENGLISH), (IFormView)this.getView());
        } else if (evt.getSource() instanceof Button) {
            String key = ((Button)evt.getSource()).getKey();
            if ("auditRecord".equalsIgnoreCase(key)) {
                ApprovalHelper.viewAuditRecord((IFormView)this.getView());
            } else if ("changeRecord".equalsIgnoreCase(key)) {
                ApprovalHelper.viewChangeRecord((IFormView)this.getView());
            } else if ("submit".equalsIgnoreCase(key)) {
                ApprovalHelper.submitConfirm((IFormView)this.getView(), (IFormPlugin)this);
            }
        }
    }

    private void showRightPageInContainer(String relatedNumber, Long erFileId) {
        List<Map<String, Object>> tabList = this.getTabList();
        Map<String, Object> currentAssoci = null;
        for (Map<String, Object> tabMap : tabList) {
            String regNumber = (String)tabMap.get("targetkey");
            if (!relatedNumber.equalsIgnoreCase(regNumber)) continue;
            currentAssoci = tabMap;
            break;
        }
        if (currentAssoci == null || currentAssoci.get("pagenumber") == null) {
            return;
        }
        String formId = (String)currentAssoci.get("pagenumber");
        if (!CommonUtil.hasPerm((String)formId, (String)"47150e89000000ac", (String)"hssc", (IFormView)this.getView())) {
            String opentype = this.getPageCache().get(OPEN_TYPE);
            if (!HRStringUtils.equals((String)"1", (String)opentype)) {
                this.getView().showErrorNotification(HRBaseUtils.getNoPermMsg());
            }
            this.getPageCache().remove(OPEN_TYPE);
            formId = "hspm_notright";
        }
        FormShowParameter formType = MultiViewTemplateService.getInstance().showFormType("3");
        MultiViewTemplateService.getInstance().commonForm(formType, formId, "mainpagepanel", ShowType.InContainer);
        formType.setCaption((String)currentAssoci.get("groupname"));
        formType.setCustomParam("erfileid", (Object)erFileId);
        this.setCommonCustomParam(formType);
        formType.setCustomParam("params", (Object)SerializationUtils.toJsonString(currentAssoci));
        this.getView().showForm(formType);
    }

    public void setCommonCustomParam(FormShowParameter formShowParameter) {
        formShowParameter.setCustomParam("adminorgid", (Object)this.getLongFromCache("adminorgid"));
        formShowParameter.setCustomParam("person", (Object)this.getLongFromCache("person.id"));
        formShowParameter.setCustomParam("employee", (Object)this.getLongFromCache("employee.id"));
        formShowParameter.setCustomParam("depemp", (Object)this.getLongFromCache("depemp.id"));
        formShowParameter.setCustomParam("cmpemp", (Object)this.getLongFromCache("cmpemp.id"));
    }

    private void drawHeadArea() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey("baseinfopanel");
        showParameter.setFormId("hspm_myermanfilehead");
        showParameter.setCustomParam("person", (Object)this.getLongFromCache("person.id"));
        showParameter.setCustomParam("depemp", (Object)this.getLongFromCache("depemp.id"));
        showParameter.setCustomParam("adminorgid", (Object)this.getLongFromCache("adminorgid"));
        showParameter.setCustomParam("employee", (Object)this.getLongFromCache("employee.id"));
        showParameter.setCustomParam("cmpemp", (Object)this.getLongFromCache("cmpemp.id"));
        showParameter.setCustomParam("params", (Object)this.getPageCache().get("headentity"));
        showParameter.setCustomParam("erfileid", (Object)this.getLongFromCache("erfileId"));
        this.getView().showForm(showParameter);
    }

    private void drawLeftMenu() {
        List<Map<String, Object>> tabList = this.getTabList();
        FlexPanelAp relatePanelAp = new HRFlexPanelAp.Builder("flexpanelrelateinfo").setWrap(false).setDirection("column").build();
        for (Map<String, Object> manMap : tabList) {
            String pageKey = (String)manMap.get("targetkey");
            String formId = (String)manMap.get("pagenumber");
            if (formId == null || formId.isEmpty() || formId.trim().length() == 0) {
                LOGGER.info(MessageFormat.format("drawLeftMenu_data_ex:{0}", SerializationUtils.toJsonString(manMap)));
                continue;
            }
            if (!CommonUtil.hasPerm((String)formId, (String)"47150e89000000ac", (String)"hssc", (IFormView)this.getView())) {
                LOGGER.info(MessageFormat.format("drawLeftMenu_not_perm:{0}", formId));
                continue;
            }
            String groupName = (String)manMap.get("groupname");
            FlexPanelAp relateLabelPanelAp = new HRFlexPanelAp.Builder("itempanelap" + pageKey).setWrap(false).setDirection("row").setAlignContent("flex-start").setWidth("160px").setAlignItems("flex-start").setHeight("40px").build();
            LabelAp lblRelatePageAp = ((HRLabelAp.Builder)((HRLabelAp.Builder)new HRLabelAp.Builder(pageKey).setId(pageKey).setName(groupName).setFontSize(14).setClickable(true).setForeColor("#333333").setPaddingLeft("20px")).setMarginTop("10px")).build();
            relateLabelPanelAp.getItems().add(lblRelatePageAp);
            if (ApprovalHelper.isNotPasss((IFormView)this.getView(), (String)pageKey, (String)groupName)) {
                LabelAp notPassLab = ((HRLabelAp.Builder)((HRLabelAp.Builder)((HRLabelAp.Builder)new HRLabelAp.Builder(pageKey + "notPass").setId(pageKey + "notPass").setName(".").setFontSize(14).setClickable(true).setForeColor("#FB2323").setBackColor("#FB2323").setRadius("4px").setMarginLeft("6px")).setMarginRight("10px")).setMarginTop("18px")).setWidth(new LocaleString("6px")).setHeight(new LocaleString("6px")).setShrink(0).build();
                relateLabelPanelAp.getItems().add(notPassLab);
            }
            relatePanelAp.getItems().add(relateLabelPanelAp);
        }
        Container container = (Container)this.getView().getControl("flexpanelrelateinfo");
        container.getItems().addAll(((Container)relatePanelAp.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(container.getItems());
        this.getView().updateControlMetadata("flexpanelrelateinfo", relatePanelAp.createControl());
    }

    private Map<String, Object> initParam() {
        DynamicObject erFileDy;
        HashMap result = Maps.newHashMapWithExpectedSize((int)2);
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create(null, IEmployeeFilePluginService.class, (String)"kd.sdk.hr.hspm.formplugin.web.file.ermanfile.ext.service.employee.IEmployeeFilePluginService", null);
        hrPluginProxy.callReplace(hrPlugin -> {
            result.putAll(hrPlugin.openAssignMobileFile());
            return null;
        });
        long personId = 0L;
        long configId = 0L;
        if (!CollectionUtils.isEmpty((Map)result)) {
            personId = result.getOrDefault("personId", 0L);
            configId = result.getOrDefault("configId", 0L);
        }
        if (personId == 0L) {
            personId = this.getPersonId();
        }
        if (Objects.isNull(erFileDy = ErmanFileRepository.getPrimaryErmanFile((Long)personId))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u767b\u5f55\u7528\u6237\u83b7\u53d6\u7684\u4eba\u5458\u6863\u6848\u4e3a\u7a7a\u3002", (String)"MyErManFilePlugin_2", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        }
        Tuple tuple = configId != 0L ? Tuple.create((Object)Boolean.TRUE, (Object)configId) : AttacheHandlerService.getInstance().handleRuleEngine(this.getView(), erFileDy.getLong("id"), erFileDy, "hspm" + ClientTypeEnum.EMPLOYEE_MOBILE.getCode(), ClientTypeEnum.EMPLOYEE_MOBILE.getCode(), null, false);
        LOGGER.info(MessageFormat.format("handleRuleEngine_result:{0}", tuple));
        if (!((Boolean)tuple.item1).booleanValue()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u5339\u914d\u7684\u4e1a\u52a1\u89c4\u5219\uff0c\u5f53\u524d\u9875\u9762\u5c06\u4e3a\u60a8\u663e\u793a\u9ed8\u8ba4\u65b9\u6848\u3002\u82e5\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8c03\u6574\u4e1a\u52a1\u89c4\u5219\u3002", (String)"MultiViewTemplatePlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        }
        Map infoGroupConfig = PageRegConfigService.getInstance().getInfoGroupConfig(((Long)tuple.item2).longValue(), ClientTypeEnum.EMPLOYEE_PC.getCode(), null);
        LOGGER.info(MessageFormat.format("getInfoGroupConfig:{0}", infoGroupConfig));
        if (CollectionUtils.isEmpty((Map)infoGroupConfig)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e1a\u52a1\u89c4\u5219\u5339\u914d\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MyErManFilePlugin_6", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        }
        this.setPageCache(erFileDy, infoGroupConfig);
        return infoGroupConfig;
    }

    private Long getPersonId() {
        Map resultPerson = (Map)HRMServiceHelper.invokeHRMPService((String)"hrpi", (String)"IHRPIPersonService", (String)"getPersonModelId", (Object[])new Object[0]);
        LOGGER.info(MessageFormat.format("resultPerson:{0}", resultPerson));
        if (resultPerson == null || resultPerson.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u767b\u5f55\u7528\u6237\u83b7\u53d6\u7684\u4eba\u5458\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"MyErManFilePlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        }
        Map idData = (Map)resultPerson.get("data");
        if (Objects.isNull(idData) || !(idData.get("person") instanceof Long)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u767b\u5f55\u7528\u6237\u83b7\u53d6\u7684\u4eba\u5458ID\u4e3a\u7a7a\u3002", (String)"MyErManFilePlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        }
        return (Long)idData.get("person");
    }

    private void setPageCache(DynamicObject erFileDy, Map<String, Object> infoGroupConfig) {
        IPageCache pageCache = this.getPageCache();
        pageCache.put("erfileId", erFileDy.getString("id"));
        pageCache.put("personId", erFileDy.getString("person.id"));
        pageCache.put("person.id", erFileDy.getString("person.id"));
        pageCache.put("depemp.id", erFileDy.getString("depemp.id"));
        pageCache.put("employee.id", erFileDy.getString("employee.id"));
        pageCache.put("cmpemp.id", erFileDy.getString("cmpemp.id"));
        pageCache.put("adminorgid", String.valueOf(erFileDy.getLong("depemp.adminorg.id")));
        List tabList = (List)infoGroupConfig.get("mainentry");
        List headList = (List)infoGroupConfig.get("headentity");
        if (CollectionUtils.isEmpty((Collection)tabList) || CollectionUtils.isEmpty((Collection)headList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65b9\u6848\u6570\u636e\u5f02\u5e38", (String)"MyErManFilePlugin_4", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        }
        pageCache.put("cnfjson", SerializationUtils.toJsonString(infoGroupConfig));
        pageCache.put("mainentry", SerializationUtils.toJsonString((Object)tabList));
        pageCache.put("headentity", SerializationUtils.toJsonString((Object)headList));
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (!MessageBoxResult.Yes.equals((Object)result) && !MessageBoxResult.OK.equals((Object)result)) {
            return;
        }
        String key = messageBoxClosedEvent.getCallBackId();
        if ("ApprovalSubmitCallBack".equals(key)) {
            ApprovalHelper.submit((IFormView)this.getView());
        } else if ("HomePageCloseCallBack".equals(key)) {
            LOGGER.info("HomePageCloaseCallBack...");
            ApprovalHelper.delCacheData((IFormView)this.getView());
            IFormView view = this.getView();
            view.getPageCache().put("HomePageClose", "true");
            view.close();
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        ApprovalHelper.handleSubmitButtonVisible((IFormView)this.getView());
    }
}

