/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.employee.formview;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.hr.hbp.common.util.HRJSONUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.util.UniquenessCheckUtil;
import kd.sdk.hr.hspm.business.service.AttacheHandlerService;
import kd.sdk.hr.hspm.common.utils.PropertyHelper;
import kd.sdk.hr.hspm.formplugin.web.file.employee.base.AbstractPCFormDrawEdit;

public class PerContactDrawPCPlugin
extends AbstractPCFormDrawEdit {
    private static final Log logger = LogFactory.getLog(PerContactDrawPCPlugin.class);

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        FormShowParameter formShowParameter = (FormShowParameter)args.getSource();
        AttacheHandlerService.getInstance().buildUniqueParam(formShowParameter, "hrpi_percontact");
        super.loadCustomControlMetas(args);
    }

    protected void drawFormTitleFlex(int index, List<Map<String, Object>> groups, FlexPanelAp flexPanelAp, boolean isNeedTitle) {
        super.drawFormTitleFlex(index, groups, flexPanelAp, true);
    }

    protected Map<String, Object> diffDialogOrForm() {
        Map diffMap = super.diffDialogOrForm();
        diffMap.put("isdia", false);
        diffMap.put("across_entity", "across_entity");
        return diffMap;
    }

    protected Map<String, String> getPageParams() {
        Map pageParams = super.getPageParams();
        pageParams.put(PAGE_ID, "hrpi_percontact");
        pageParams.put(TYPE_CONSTANT, "person");
        return pageParams;
    }

    protected boolean validInputParams() {
        return this.checkPhone() && this.checkPerEmail();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String changeProperty = args.getProperty().getName();
        if ("hrpi_percontact-phone".equals(changeProperty)) {
            this.checkPhone();
        } else if ("hrpi_percontact-peremail".equals(changeProperty)) {
            this.checkPerEmail();
        }
    }

    private boolean checkPhone() {
        String phone;
        if (PropertyHelper.existProperty((DynamicObject)this.getModel().getDataEntity(), (String)"hrpi_percontact-phone") && HRStringUtils.isNotEmpty((String)(phone = (String)this.getModel().getValue("hrpi_percontact-phone")))) {
            Long personId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("person"));
            Tuple checkResult = UniquenessCheckUtil.checkPhone((long)personId, (String)phone, (boolean)false);
            if (!((Boolean)checkResult.item1).booleanValue()) {
                this.getView().showErrorNotification((String)checkResult.item2);
                return false;
            }
        }
        return true;
    }

    private boolean checkPerEmail() {
        String perEmail;
        if (PropertyHelper.existProperty((DynamicObject)this.getModel().getDataEntity(), (String)"hrpi_percontact-peremail") && HRStringUtils.isNotEmpty((String)(perEmail = (String)this.getModel().getValue("hrpi_percontact-peremail")))) {
            Long personId = HRJSONUtils.getLongValOfCustomParam((Object)this.getView().getFormShowParameter().getCustomParam("person"));
            Tuple checkResult = UniquenessCheckUtil.checkPerEmail((long)personId, (String)perEmail, (boolean)false);
            if (!((Boolean)checkResult.item1).booleanValue()) {
                this.getView().showErrorNotification((String)checkResult.item2);
                return false;
            }
        }
        return true;
    }
}

