/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.employee.updaterecord.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDynamicFormBasePlugin;
import kd.hr.hspm.business.changerecord.ChangeRecordHelper;
import kd.sdk.hr.hspm.business.helper.InfoGroupHelper;
import kd.sdk.hr.hspm.business.repository.ErmanFileRepository;
import kd.sdk.hr.hspm.common.utils.ParamAnalysisUtil;

public abstract class ChangeRecordBasePlugin
extends HRDynamicFormBasePlugin {
    protected List<Map<String, Object>> infoGroups = null;
    public static final String TABINFO_MAP = "tabInfoMap";
    public static final String TABPAGENAME_MAP = "tabPageNameMap";

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.analysisConfigParams();
        this.draw();
    }

    protected abstract void draw();

    private void analysisConfigParams() {
        Map infoGroupConfig;
        String cnfStr;
        if (this.getView().getParentView() != null && HRStringUtils.isNotEmpty((String)(cnfStr = this.getView().getParentView().getPageCache().get("cnfjson"))) && (infoGroupConfig = (Map)SerializationUtils.fromJsonString((String)cnfStr, Map.class)) != null) {
            this.infoGroups = (List)infoGroupConfig.get("mainentry");
            if (this.infoGroups != null) {
                this.handleConfigParams();
                return;
            }
        }
        throw new KDBizException("not infoGroupConfig param");
    }

    private void handleConfigParams() {
        LinkedHashMap<String, List<String>> tabInfoMap = new LinkedHashMap<String, List<String>>(this.infoGroups.size());
        LinkedHashMap<String, String> tabPageNameMap = new LinkedHashMap<String, String>(this.infoGroups.size());
        for (Map<String, Object> group : this.infoGroups) {
            List subGroups = ParamAnalysisUtil.getGroups(group);
            String mappingFromId = (String)group.get("mappingFormid");
            String groupName = (String)group.get("groupname");
            if ("hrpi_pereduexp".equals(mappingFromId) || "hrpi_pereduexpcert".equals(mappingFromId)) {
                tabInfoMap.put(groupName.toLowerCase(), Arrays.asList("hrpi_pereduexp", "hrpi_pereduexpcert"));
                tabPageNameMap.put(groupName.toLowerCase(), groupName);
                continue;
            }
            if (InfoGroupHelper.isSingleRowTpl((String)mappingFromId)) {
                HashSet<String> pageNumbers = new HashSet<String>();
                for (Map subGroup : subGroups) {
                    List fields = ParamAnalysisUtil.getFields((Map)subGroup);
                    if (CollectionUtils.isEmpty((Collection)fields)) continue;
                    for (Map field : fields) {
                        pageNumbers.add((String)field.get("pnumber"));
                    }
                }
                tabInfoMap.put(groupName.toLowerCase(), new ArrayList(pageNumbers));
                tabPageNameMap.put(groupName.toLowerCase(), groupName);
                continue;
            }
            for (Map subGroup : subGroups) {
                List fields = ParamAnalysisUtil.getFields((Map)subGroup);
                if (CollectionUtils.isEmpty((Collection)fields)) continue;
                String gName = (String)subGroup.get("gname");
                String key = groupName + "!@#" + gName;
                tabInfoMap.put(key.toLowerCase(), Collections.singletonList((String)((Map)fields.get(0)).get("pnumber")));
                tabPageNameMap.put(key.toLowerCase(), gName);
            }
        }
        this.getPageCache().put(TABINFO_MAP, SerializationUtils.toJsonString(tabInfoMap));
        this.getPageCache().put(TABPAGENAME_MAP, SerializationUtils.toJsonString(tabPageNameMap));
    }

    protected List<Map<String, Object>> getChangeRecord(List<String> entityName, boolean onlyCheck) {
        Map<String, Object> values = this.getUserInfo();
        return ChangeRecordHelper.getChangeRecord(entityName, values, (boolean)true, (boolean)onlyCheck);
    }

    protected Map<String, Object> getUserInfo() {
        HashMap<String, Object> values;
        if (HRStringUtils.isEmpty((String)this.getPageCache().get("userInfo"))) {
            values = new HashMap(4);
            String personId = this.getView().getParentView().getPageCache().get("personId");
            DynamicObject erFileDy = ErmanFileRepository.getPrimaryErmanFile((Long)Long.valueOf(personId));
            if (erFileDy != null) {
                values.put("person", erFileDy.getLong("person.id"));
                values.put("employee", erFileDy.getLong("employee.id"));
                values.put("depemp", erFileDy.getLong("depemp.id"));
                values.put("cmpemp", erFileDy.getLong("cmpemp.id"));
                this.getPageCache().put("userInfo", SerializationUtils.toJsonString(values));
            }
        } else {
            values = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("userInfo"), Map.class);
        }
        return values;
    }
}

