/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.ermanfile;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hspm.business.domian.repository.ERMFileRepository;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;

public class ERManFileIndexPlugin
extends AbstractFormPlugin {
    private static final String CLOSE_CONFIRM = "close_confirm";
    private static final String CONFIRM = "confirm";
    private final Date maxDate = HRBaseUtils.getMaxEndDate();
    private RoundingMode roundingMode;

    public void preOpenForm(PreOpenFormEventArgs args) {
        boolean hasPermission = this.hasPermission();
        if (!hasPermission) {
            args.setCancel(true);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addPackageDataListener();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getModel().beginInit();
        this.buildEntryEntity();
        this.getModel().endInit();
        this.getModel().setDataChanged(false);
    }

    private void buildEntryEntity() {
        List list = (List)this.getView().getFormShowParameter().getCustomParam("pkids");
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        List idList = list.stream().filter(Objects::nonNull).map(id -> {
            if (id instanceof Long) {
                return (Long)id;
            }
            return Long.valueOf(id.toString());
        }).collect(Collectors.toList());
        DynamicObjectCollection dataList = ERMFileRepository.queryOriginalByPks((String)"id,sort,empposrel,employee,empentrel,person.headsculpture,cmpemp.managingscope.name,employee.enddate", idList, (String)"sort,number");
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return;
        }
        Set employeeIdSet = dataList.stream().map(dy -> dy.getLong("employee")).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("employee", "in", employeeIdSet).and("iscurrentversion", "=", (Object)Boolean.TRUE).and("businessstatus", "=", (Object)"1");
        Map<Long, Long> map = new HRBaseServiceHelper("hrpi_empjobrel").queryOriginalCollection("id,employee", qFilter.toArray()).stream().collect(Collectors.toMap(dy -> dy.getLong("employee"), dy -> dy.getLong("id"), (o1, o2) -> o2));
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("ermanfile", new Object[0]);
        vs.addField("empposorgrel", new Object[0]);
        vs.addField("empjobrel", new Object[0]);
        vs.addField("empentrel", new Object[0]);
        vs.addField("sort", new Object[0]);
        vs.addField("headsculpture", new Object[0]);
        dataList.forEach(dy -> vs.addRow(new Object[]{dy.getLong("id"), dy.getLong("empposrel"), map.get(dy.getLong("employee")), dy.getLong("empentrel"), dy.getString("sort"), dy.get("person.headsculpture")}));
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", vs);
        this.addPackageDataListener();
    }

    private void addPackageDataListener() {
        EntryGrid entry = (EntryGrid)this.getControl("entryentity");
        entry.addPackageDataListener(packageDataEvent -> {
            String key = ((FieldEdit)packageDataEvent.getSource()).getKey();
            if (HRStringUtils.equals((String)key, (String)"enddate")) {
                Date date = this.getEndDate(packageDataEvent.getRowData().getDate(((FieldEdit)packageDataEvent.getSource()).getFieldKey() + "." + key));
                if (date == null) {
                    packageDataEvent.setFormatValue((Object)"");
                }
            } else if (HRStringUtils.equals((String)key, (String)"servicelength")) {
                BigDecimal value = packageDataEvent.getRowData().getBigDecimal(((FieldEdit)packageDataEvent.getSource()).getFieldKey() + "." + key);
                packageDataEvent.setFormatValue((Object)this.formatServiceLength(value));
            }
        });
    }

    private BigDecimal formatServiceLength(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return null;
        }
        if (this.roundingMode == null) {
            this.roundingMode = BusinessUtils.getBusiYearRoundingMode();
        }
        return bigDecimal.setScale(1, this.roundingMode);
    }

    private Date getEndDate(Date endDate) {
        if (endDate == null) {
            return null;
        }
        Date formatEndDate = HRDateTimeUtils.truncateDate((Date)endDate);
        if (this.maxDate.compareTo(formatEndDate) == 0) {
            return null;
        }
        return formatEndDate;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (!HRStringUtils.equals((String)operateKey, (String)CONFIRM)) {
            return;
        }
        boolean hasPermission = this.hasPermission();
        if (!hasPermission) {
            args.setCancel(true);
        }
    }

    private boolean hasPermission() {
        boolean hasPermission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"hspm", (String)"hspm_erfilelist", (String)"18WM2K7A2SO=");
        if (!hasPermission) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u4eba\u5458\u6863\u6848\u201d\u7684\u201c\u6392\u5e8f\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ERManFileIndexPlugin_0", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
        }
        return hasPermission;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        IFormView parentView;
        super.afterDoOperation(args);
        if (!args.getOperationResult().isSuccess()) {
            return;
        }
        String operateKey = args.getOperateKey();
        if ("listsort".equals(operateKey)) {
            String propertyName = "ermanfile.number";
            DynamicObjectCollection entryCol = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            entryCol.sort((o1, o2) -> {
                int compare = o1.getString("sort").compareTo(o2.getString("sort"));
                if (compare == 0) {
                    return o1.getString(propertyName).compareToIgnoreCase(o2.getString(propertyName));
                }
                return compare;
            });
            this.getView().updateView("entryentity");
        } else if (CONFIRM.equals(operateKey) && (parentView = this.getView().getParentView()) != null) {
            this.getModel().setDataChanged(false);
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if ("1".equals(this.getView().getPageCache().get(CLOSE_CONFIRM))) {
            this.getView().getPageCache().put(CLOSE_CONFIRM, null);
            return;
        }
        if (this.getModel().getDataChanged()) {
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(16);
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"AbstractFormDrawEdit_6", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"AbstractFormDrawEdit_7", (String)"hr-hspm-formplugin", (Object[])new Object[0]));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f%s\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"AbstractFormDrawEdit_9", (String)"hr-hspm-formplugin", (Object[])new Object[]{System.lineSeparator()}), this.getModel().getChangeDesc(), MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener(CLOSE_CONFIRM, (IFormPlugin)this), btnNameMaps);
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (CLOSE_CONFIRM.equals(event.getCallBackId()) && event.getResult() == MessageBoxResult.Yes) {
            this.getView().getPageCache().put(CLOSE_CONFIRM, "1");
            this.getView().close();
        }
    }
}

