/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.ermanfile;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.util.Tuple2;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hpfs.business.service.config.IDevParamConfigService;
import kd.sdk.hr.hspm.business.helper.ShowHisVersionEntityHelper;
import kd.sdk.hr.hspm.common.entity.ShowHisVersionEntity;
import kd.sdk.hr.hspm.common.utils.BusinessUtils;

public class ERManFileQueryHisListPlugin
extends AbstractListPlugin {
    private static final Log LOGGER = LogFactory.getLog(ERManFileQueryHisListPlugin.class);
    private static final String MERGE_INITBATCH_TAG = "hric$subTaskInitBatchMap";
    private static final String HSPM_ERMANFILE_QUERYHIS = "hspm_ermanfile_queryhis";
    private static final String LIST_SORT = "listsort";
    private static final List<ShowHisVersionEntity> SHOW_HIS_VERSION_ENTITY_LIST = new ArrayList<ShowHisVersionEntity>(16);

    public void initialize() {
        super.initialize();
        boolean isHisList = this.queryIsHisList();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map<String, List<QFilter>> reletionMap = (Map<String, List<QFilter>>)formShowParameter.getCustomParam("MultEntity_JoinOnRelationMap");
        if (!CollectionUtils.isEmpty((Map)reletionMap)) {
            reletionMap.putAll(this.reletionMapFilter(isHisList));
        } else {
            reletionMap = this.reletionMapFilter(isHisList);
        }
        formShowParameter.setCustomParam("MultEntity_JoinOnRelationMap", reletionMap);
        String customSelectedFields = (String)formShowParameter.getCustomParam("MultEntity_CustomSelectedFields");
        customSelectedFields = HRStringUtils.isNotEmpty((String)customSelectedFields) ? String.join((CharSequence)",", customSelectedFields, this.customSelectedFields(isHisList)) : this.customSelectedFields(isHisList);
        formShowParameter.setCustomParam("MultEntity_CustomSelectedFields", (Object)customSelectedFields);
    }

    public boolean queryIsHisList() {
        String isHisListStr = IDevParamConfigService.getInstance().queryBusinessValueByBusinessKey(HSPM_ERMANFILE_QUERYHIS);
        LOGGER.info("initialize,isHisList=={}", (Object)isHisListStr);
        return Boolean.parseBoolean(isHisListStr);
    }

    public Map<String, List<QFilter>> reletionMapFilter(boolean isHisList) {
        HashMap<String, List<QFilter>> reletionMap = new HashMap<String, List<QFilter>>(16);
        if (isHisList) {
            Date dateParam = this.getDateParam();
            reletionMap.put("hrpi_empjobrel", Lists.newArrayList((Object[])new QFilter[]{new QFilter("hrpi_empjobrel.startdate", "<=", (Object)dateParam).and(new QFilter("hrpi_empjobrel.enddate", ">=", (Object)dateParam))}));
        } else {
            reletionMap.put("hrpi_empjobrel", Lists.newArrayList((Object[])new QFilter[]{new QFilter("hrpi_empjobrel.businessstatus", "=", (Object)"1")}));
        }
        return reletionMap;
    }

    private String customSelectedFields(boolean isHisList) {
        if (isHisList) {
            ArrayList customSelectedFieldList = new ArrayList(16);
            customSelectedFieldList.addAll(SHOW_HIS_VERSION_ENTITY_LIST.stream().filter(showHisVersionEntity -> !showHisVersionEntity.isMainEntityField()).map(ShowHisVersionEntity::getListBoidName).collect(Collectors.toList()));
            customSelectedFieldList.addAll(SHOW_HIS_VERSION_ENTITY_LIST.stream().filter(showHisVersionEntity -> !showHisVersionEntity.isMainEntityField() && HRStringUtils.isNotEmpty((String)showHisVersionEntity.getParentEntityName())).map(ShowHisVersionEntity::getListParentIdName).collect(Collectors.toList()));
            return String.join((CharSequence)",", customSelectedFieldList);
        }
        return "";
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        boolean isHisList = this.queryIsHisList();
        if (isHisList) {
            Date dateParam = this.getDateParam();
            setFilterEvent.getQFilters().addAll(Lists.newArrayList((Object[])new QFilter[]{new QFilter("startdate", "<=", (Object)dateParam), new QFilter("enddate", ">=", (Object)dateParam)}));
        }
        if (this.isDefaultOrderBy()) {
            setFilterEvent.setOrderBy("sort,number");
        }
    }

    public void beforePackageData(BeforePackageDataEvent event) {
        boolean isHisList = this.queryIsHisList();
        if (!isHisList || !this.isQueryHisDate()) {
            return;
        }
        DynamicObjectCollection collection = event.getPageData();
        if (collection.isEmpty()) {
            LOGGER.info("beforePackageData,collection isEmpty");
            return;
        }
        ShowHisVersionEntityHelper showHisVersionEntityHelper = ShowHisVersionEntityHelper.getInstance();
        Map hisVersionIdListMap = showHisVersionEntityHelper.getShowHisVersionIdListMap(collection, SHOW_HIS_VERSION_ENTITY_LIST);
        Map hisVersionDysMap = showHisVersionEntityHelper.queryHisVersionDysMap(hisVersionIdListMap, SHOW_HIS_VERSION_ENTITY_LIST, this.getDataStatusAndBsedFilter());
        Map mainEntityMap = showHisVersionEntityHelper.getMainEntityFieldListByBoidName(SHOW_HIS_VERSION_ENTITY_LIST);
        for (DynamicObject dynamicObject : collection) {
            for (Map.Entry hisVersionDysEntry : hisVersionDysMap.entrySet()) {
                String listBoidName = (String)hisVersionDysEntry.getKey();
                Tuple2 hisVersionDysTuple = (Tuple2)hisVersionDysEntry.getValue();
                long boid = dynamicObject.getLong(listBoidName);
                ShowHisVersionEntity showHisVersionEntity = (ShowHisVersionEntity)mainEntityMap.get(listBoidName);
                if (showHisVersionEntity != null) {
                    if (dynamicObject.get(showHisVersionEntity.getRealMainEntityFieldName()) != null) {
                        dynamicObject.set((String)hisVersionDysTuple.t1, ((Map)hisVersionDysTuple.t2).get(boid));
                        continue;
                    }
                    LOGGER.info("beforePackageData, dynamicObject[{}] is null", (Object)showHisVersionEntity.getRealMainEntityFieldName());
                    continue;
                }
                dynamicObject.set((String)hisVersionDysTuple.t1, ((Map)hisVersionDysTuple.t2).get(boid));
            }
        }
    }

    private QFilter getDataStatusAndBsedFilter() {
        QFilter dataStatusFilter = new QFilter("datastatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"0", "1", "2"}));
        dataStatusFilter.and(new QFilter("iscurrentversion", "=", (Object)"0"));
        Date dateParam = this.getDateParam();
        dataStatusFilter.and(new QFilter("bsed", "<=", (Object)dateParam));
        dataStatusFilter.and(new QFilter("bsled", ">=", (Object)dateParam));
        Map mergeInitBatchMap = (Map)this.getView().getFormShowParameter().getCustomParam(MERGE_INITBATCH_TAG);
        LOGGER.info("ERManFileQueryHisListPlugin==>getDataStatusAndBsedFilter the mergeInitBarchMap is {}", (Object)mergeInitBatchMap);
        if (HRObjectUtils.isEmpty((Object)mergeInitBatchMap)) {
            dataStatusFilter.and(new QFilter("initstatus", "=", (Object)"2"));
        }
        return dataStatusFilter;
    }

    private Date getDateParam() {
        String searchDate = this.getPageCache().get("searchdate");
        if (HRStringUtils.isEmpty((String)searchDate)) {
            return new Date();
        }
        LocalDate localDate = (LocalDate)JSON.parseObject((String)searchDate, LocalDate.class);
        return HRDateTimeUtils.localDate2Date((LocalDate)localDate);
    }

    private boolean isQueryHisDate() {
        Date today;
        Date dateParam = this.getDateParam();
        return dateParam.compareTo(today = HRDateTimeUtils.dateFormatDate((Date)new Date())) < 0;
    }

    private boolean isDefaultOrderBy() {
        return "true".equals(BusinessUtils.getBusinessValueByKey((String)"hspm_ermanfile_opendefaultorder"));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean flag = this.isDefaultOrderBy();
        if (!flag) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{LIST_SORT});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String opKey = operate.getOperateKey();
        if (HRStringUtils.equals((String)LIST_SORT, (String)opKey)) {
            this.showIndexForm();
        }
    }

    private void showIndexForm() {
        ListSelectedRowCollection col = this.getSelectedRows();
        if (CollectionUtils.isEmpty((Collection)col)) {
            return;
        }
        List objList = col.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        int maxSize = 1000;
        if (objList.size() > maxSize) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5df2\u9009\u6570\u636e\u8d85\u51fa\u6700\u5927\u9650\u5236\uff08%s\uff09", (String)"ERManFileQueryHisListPlugin_1", (String)"hr-hspm-formplugin", (Object[])new Object[]{maxSize}));
            return;
        }
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(ShowType.Modal);
        param.setFormId("hspm_erfilelistsort");
        param.setCustomParam("pkids", objList);
        param.setHasRight(true);
        this.getView().showForm(param);
    }

    static {
        SHOW_HIS_VERSION_ENTITY_LIST.addAll(Lists.newArrayList((Object[])new ShowHisVersionEntity[]{new ShowHisVersionEntity("haos_adminorghr", "hrpi_empposorgrel.adminorg.boid", "hrpi_empposorgrel.adminorg.name"), new ShowHisVersionEntity("hbpm_positionhr", "hrpi_empposorgrel.position.boid", "hrpi_empposorgrel.position.name"), new ShowHisVersionEntity("hbpm_stposition", "hrpi_empposorgrel.stdposition.boid", "hrpi_empposorgrel.stdposition.name"), new ShowHisVersionEntity("hbjm_jobhr", "hrpi_empposorgrel.job.boid", "hrpi_empposorgrel.job.name"), new ShowHisVersionEntity("haos_adminorghr", "hrpi_empposorgrel.company.boid", "hrpi_empposorgrel.company.name"), new ShowHisVersionEntity("haos_adminorghr", "affiliateadminorg.boid", "affiliateadminorg.name").setMainEntityField(true).setRealMainEntityFieldName("affiliateadminorg"), new ShowHisVersionEntity("hbjm_joblevelhr", "hrpi_empjobrel.joblevel.entryboid", "hrpi_empjobrel.joblevel.name", "hbjm_joblevelscmhr", "hrpi_empjobrel.joblevel.joblevelscm", "entryboid", "joblevelscm"), new ShowHisVersionEntity("hbjm_jobgradehr", "hrpi_empjobrel.jobgrade.entryboid", "hrpi_empjobrel.jobgrade.name", "hbjm_jobgradescmhr", "hrpi_empjobrel.jobgrade.jobgradescm", "entryboid", "jobgradescm")}));
    }
}

