/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.ermanfile;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeBaseDataFilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.common.constants.org.OrgTreeDynEnum;
import kd.hr.hbp.common.util.org.model.OrgTreeModel;
import kd.hr.hbp.formplugin.web.org.template.AdminOrgTreeListTemplate;
import kd.hr.hspm.formplugin.web.schedule.service.PermissionService;

public class ErmanFileF7TreeListPlugin
extends AdminOrgTreeListTemplate {
    private static final String FIELDORGID = "adminorg.id";
    private static final String HSPM_ERFILETYPE = "hspm_erfiletype";
    private static final String FILETYPE_NAME = "filetype.name";
    private static final String FILETYPE_ID = "filetype.id";
    private static final Log LOGGER = LogFactory.getLog(ErmanFileF7TreeListPlugin.class);

    public ErmanFileF7TreeListPlugin() {
        super(new OrgTreeModel(OrgTreeDynEnum.ADMIN_STRUCT.getDynEntity(), OrgTreeDynEnum.ADMIN_MAIN_ENTITY.getDynEntity(), Boolean.TRUE, Boolean.TRUE, false));
    }

    protected QFilter buildNodeClickFilter(BuildTreeListFilterEvent filterEvent) {
        String focusNodeId = filterEvent.getNodeId().toString();
        QFilter nodeClicFilter = null;
        if (!this.getTreeModel().getRoot().getId().equals(focusNodeId)) {
            QFilter cFilter = new QFilter("iscurrentversion", "=", (Object)"1");
            QFilter iFilter = new QFilter("initstatus", "=", (Object)"2");
            ArrayList<String> dataStatusList = new ArrayList<String>();
            dataStatusList.add("1");
            dataStatusList.add("2");
            QFilter dFilter = new QFilter("datastatus", "in", dataStatusList);
            QFilter focusNodeFilter = new QFilter(FIELDORGID, "=", (Object)Long.valueOf(focusNodeId));
            DynamicObject focusNodeDy = HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryOne("structlongnumber", new QFilter[]{focusNodeFilter, cFilter, iFilter, dFilter});
            String focusNodeLongNumber = (String)focusNodeDy.get("structlongnumber");
            QFilter filter = new QFilter("structlongnumber", "like", (Object)(focusNodeLongNumber + "%"));
            DynamicObjectCollection dyColl = HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryColl("adminorg.id adminorg", new QFilter[]{filter, cFilter, iFilter, dFilter}, null);
            HashSet<Long> ids = new HashSet<Long>(dyColl.size());
            ids.add(Long.valueOf(focusNodeId));
            int size = dyColl.size();
            for (int idx = 0; idx < size; ++idx) {
                ids.add(((DynamicObject)dyColl.get(idx)).getLong("adminorg"));
            }
            nodeClicFilter = new QFilter("affiliateadminorg.id", "in", ids);
        }
        return nodeClicFilter;
    }

    protected String getListPermProKey() {
        return "affiliateadminorg";
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        ((FilterColumn)commonFilterColumns.get(0)).setDefaultValues(new Object[0]);
        FilterColumn filterColumn = args.getFilterColumn(FILETYPE_NAME);
        if (filterColumn != null) {
            LOGGER.info("filterContainerInitStart,field=={}", (Object)FILETYPE_NAME);
            DynamicObject[] baseDataDys = PermissionService.getBaseDataDys(HSPM_ERFILETYPE, true);
            if (baseDataDys != null) {
                LOGGER.info("baseDataDys,size=={}", (Object)baseDataDys.length);
                if (filterColumn instanceof SchemeBaseDataFilterColumn) {
                    ((SchemeBaseDataFilterColumn)filterColumn).setComboItems(ErmanFileF7TreeListPlugin.buildComboItems(baseDataDys));
                } else {
                    ((CommonBaseDataFilterColumn)filterColumn).setComboItems(ErmanFileF7TreeListPlugin.buildComboItems(baseDataDys));
                }
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        QFilter filter;
        super.filterContainerBeforeF7Select(args);
        if (FILETYPE_ID.equals(args.getFieldName()) && (filter = PermissionService.getBaseDataFilterByOrg(HSPM_ERFILETYPE, true)) != null) {
            LOGGER.info("filterValue=={}", filter.getValue());
            LOGGER.info("filterContainerBeforeF7SelectStart,field=={}", (Object)FILETYPE_ID);
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(2);
            QFilter enableFilter = new QFilter("status", "=", (Object)"C");
            qFilterList.add(filter);
            qFilterList.add(enableFilter);
            args.setQfilters(qFilterList);
        }
    }

    public static List<ComboItem> buildComboItems(DynamicObject[] dynamicObjects) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(100);
        Stream.of(dynamicObjects).anyMatch(dynamicObject -> {
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(dynamicObject.getPkValue()));
            ILocaleString localeString = dynamicObject.getLocaleString("name");
            if (localeString instanceof LocaleString) {
                item.setCaption((LocaleString)localeString);
            } else {
                String localeValueEn = localeString.getLocaleValue_en();
                String localeValueZhCn = localeString.getLocaleValue_zh_CN();
                String localeValueZhTw = localeString.getLocaleValue_zh_TW();
                LocaleString caption = new LocaleString();
                caption.setLocaleValue_en(localeValueEn);
                caption.setLocaleValue_zh_CN(localeValueZhCn);
                caption.setLocaleValue_zh_TW(localeValueZhTw);
                item.setCaption(caption);
            }
            item.setValue(String.valueOf(dynamicObject.getPkValue()));
            comboItems.add(item);
            return comboItems.size() >= 100;
        });
        return comboItems;
    }
}

