/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hspm.formplugin.web.ermanfile;

import com.alibaba.fastjson.JSON;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.SchemeBaseDataFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.constants.org.OrgTreeDynEnum;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.org.model.OrgTreeModel;
import kd.hr.hbp.formplugin.web.org.template.AdminOrgTreeListTemplate;
import kd.hr.hpfs.business.service.config.IDevParamConfigService;
import kd.hr.hspm.formplugin.web.schedule.service.PermissionService;

public class ErmanFileHisTreeListPlugin
extends AdminOrgTreeListTemplate {
    private static final Log LOGGER = LogFactory.getLog(ErmanFileHisTreeListPlugin.class);
    private static final String HSPM_ERFILETYPE = "hspm_erfiletype";
    private static final String FILETYPE_NAME = "filetype.name";
    private static final String FILETYPE_ID = "filetype.id";
    private static final String HSPM_ERMANFILE_QUERYHIS = "hspm_ermanfile_queryhis";

    public ErmanFileHisTreeListPlugin() {
        super(new OrgTreeModel(OrgTreeDynEnum.ADMIN_STRUCT.getDynEntity(), OrgTreeDynEnum.ADMIN_MAIN_ENTITY.getDynEntity(), null, Boolean.TRUE, false));
    }

    public void initialize() {
        super.initialize();
        this.orgTreeModel.setIncludeChild(this.getDefaultIsInCludeChild());
        this.orgTreeModel.setHisTree(this.getDateParam() != null);
    }

    public void initializeTree(EventObject e) {
        this.orgTreeModel.setIncludeChild(this.getDefaultIsInCludeChild());
        this.orgTreeModel.setHisTree(this.getDateParam() != null);
        super.initializeTree(e);
    }

    private boolean getDefaultIsInCludeChild() {
        MainEntityType metadata = MetadataServiceHelper.getDataEntityType((String)this.getView().getFormShowParameter().getFormId());
        DynamicProperty isInCludeChildProp = metadata.getProperty("chkincludechild");
        boolean isInCludeChild = (Boolean)isInCludeChildProp.getDefaultValue();
        LOGGER.info("initialize,isInCludeChild=={}", (Object)isInCludeChild);
        return isInCludeChild;
    }

    public boolean queryIsHisTree() {
        String isHisTree = IDevParamConfigService.getInstance().queryBusinessValueByBusinessKey(HSPM_ERMANFILE_QUERYHIS);
        LOGGER.info("initialize,isHisTree=={}", (Object)isHisTree);
        return Boolean.parseBoolean(isHisTree);
    }

    public boolean isInCludeChild() {
        return this.getModel().getDataEntity().getBoolean("chkincludechild");
    }

    protected Date getDateParam() {
        if (this.queryIsHisTree()) {
            String searchDate = this.getPageCache().get("searchdate");
            if (HRStringUtils.isEmpty((String)searchDate)) {
                return new Date();
            }
            LocalDate localDate = (LocalDate)JSON.parseObject((String)searchDate, LocalDate.class);
            return HRDateTimeUtils.localDate2Date((LocalDate)localDate);
        }
        return null;
    }

    protected boolean isShowDisableAndSearchDate() {
        return this.queryIsHisTree();
    }

    protected QFilter buildNodeClickFilter(BuildTreeListFilterEvent filterEvent) {
        List allOrgBoIdList = super.getAllOrgBoIdListFast();
        if (allOrgBoIdList == null) {
            LOGGER.info("buildNodeClickFilter,allOrgBoIdList is null.");
            return null;
        }
        return new QFilter("affiliateadminorg.id", "in", (Object)allOrgBoIdList);
    }

    public FormShowParameter showAdminOrgTreeFilterDialog() {
        FormShowParameter showParameter = super.showAdminOrgTreeFilterDialog();
        showParameter.setFormId("hspm_orgtreefiter");
        return showParameter;
    }

    protected String getListPermProKey() {
        return "affiliateadminorg";
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        ((FilterColumn)commonFilterColumns.get(0)).setDefaultValues(new Object[0]);
        FilterColumn filterColumn = args.getFilterColumn(FILETYPE_NAME);
        if (filterColumn != null) {
            LOGGER.info("filterContainerInitStart,field=={}", (Object)FILETYPE_NAME);
            DynamicObject[] baseDataDys = PermissionService.getBaseDataDys(HSPM_ERFILETYPE, true);
            if (baseDataDys != null) {
                LOGGER.info("baseDataDys,size=={}", (Object)baseDataDys.length);
                if (filterColumn instanceof SchemeBaseDataFilterColumn) {
                    ((SchemeBaseDataFilterColumn)filterColumn).setComboItems(ErmanFileHisTreeListPlugin.buildComboItems(baseDataDys));
                } else {
                    ((CommonBaseDataFilterColumn)filterColumn).setComboItems(ErmanFileHisTreeListPlugin.buildComboItems(baseDataDys));
                }
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        QFilter filter;
        super.filterContainerBeforeF7Select(args);
        if (FILETYPE_ID.equals(args.getFieldName()) && (filter = PermissionService.getBaseDataFilterByOrg(HSPM_ERFILETYPE, true)) != null) {
            LOGGER.info("filterValue=={}", filter.getValue());
            LOGGER.info("filterContainerBeforeF7SelectStart,field=={}", (Object)FILETYPE_ID);
            ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(2);
            QFilter enableFilter = new QFilter("status", "=", (Object)"C");
            qFilterList.add(filter);
            qFilterList.add(enableFilter);
            args.setQfilters(qFilterList);
        }
    }

    public static List<ComboItem> buildComboItems(DynamicObject[] dynamicObjects) {
        return Stream.of(dynamicObjects).map(dynamicObject -> {
            ComboItem item = new ComboItem();
            item.setId(String.valueOf(dynamicObject.getPkValue()));
            ILocaleString localeString = dynamicObject.getLocaleString("name");
            if (localeString instanceof LocaleString) {
                item.setCaption((LocaleString)localeString);
            } else {
                String localeValueEn = localeString.getLocaleValue_en();
                String localeValueZhCn = localeString.getLocaleValue_zh_CN();
                String localeValueZhTw = localeString.getLocaleValue_zh_TW();
                LocaleString caption = new LocaleString();
                caption.setLocaleValue_en(localeValueEn);
                caption.setLocaleValue_zh_CN(localeValueZhCn);
                caption.setLocaleValue_zh_TW(localeValueZhTw);
                item.setCaption(caption);
            }
            item.setValue(String.valueOf(dynamicObject.getPkValue()));
            return item;
        }).collect(Collectors.toList());
    }
}

